/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Vdb.Host;
import Vdb.RD_entry;
import Vdb.WD_entry;
import Vdb.WG_entry;
import Vdb.common;

public class HandleSkew {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";

    public static void spreadWdSkew(RD_entry rD_entry) {
        WD_entry wD_entry;
        int n;
        double d = 0.0;
        int n2 = 0;
        if (rD_entry.wds_for_rd.size() == 0) {
            common.failure("No wds_for_rd for rd=" + rD_entry.rd_name);
        }
        for (n = 0; n < rD_entry.wds_for_rd.size(); ++n) {
            wD_entry = rD_entry.wds_for_rd.elementAt(n);
            wD_entry.skew = rD_entry.doing_curve_point && wD_entry.valid_skew_obs ? wD_entry.skew_observed : wD_entry.skew_original;
            if (wD_entry.wd_iorate == 0.0 && wD_entry.skew != 0.0) {
                d += wD_entry.skew;
                continue;
            }
            if (wD_entry.wd_iorate != 0.0) continue;
            ++n2;
        }
        if (n2 > 0) {
            double d2 = (100.0 - d) / (double)n2;
            for (n = 0; n < rD_entry.wds_for_rd.size(); ++n) {
                wD_entry = rD_entry.wds_for_rd.elementAt(n);
                if (wD_entry.wd_iorate != 0.0 || wD_entry.skew != 0.0) continue;
                wD_entry.skew = d2;
                d += wD_entry.skew;
            }
        }
        n = 0;
        for (int i = 0; i < rD_entry.wds_for_rd.size(); ++i) {
            WD_entry wD_entry2 = rD_entry.wds_for_rd.elementAt(i);
            if (wD_entry2.wd_iorate != 0.0) continue;
            ++n;
        }
        if (n > 0 && (d < 99.9999 || d > 100.0001)) {
            common.failure("rd=%s: Total skew must add up to 100: %.2f", rD_entry.rd_name, d);
        }
    }

    public static void spreadWgSkew(RD_entry rD_entry) {
        for (int i = 0; i < rD_entry.wds_for_rd.size(); ++i) {
            WD_entry wD_entry = rD_entry.wds_for_rd.elementAt(i);
            int n = 0;
            for (WG_entry wG_entry : Host.getAllWorkloads()) {
                if (wG_entry.wd_used != wD_entry) continue;
                ++n;
            }
            if (n == 999990) {
                common.ptod("");
                common.ptod("Unexpected zero slave count for rd=" + rD_entry.rd_name + ",wd=" + wD_entry.wd_name);
                common.ptod("Could this have been the result of multiple sequential workloads requested against the same SD_entry for multiple target hosts?");
                common.failure("Unexpected zero slave count for rd=" + rD_entry.rd_name + ",wd=" + wD_entry.wd_name);
            }
            for (WG_entry wG_entry : Host.getAllWorkloads()) {
                if (wG_entry.wd_used != wD_entry) continue;
                wG_entry.skew = wD_entry.skew / (double)n;
                if (wG_entry.wg_iorate == 0.0) continue;
                wG_entry.wg_iorate = wD_entry.wd_iorate / (double)n;
            }
        }
    }

    public static void calcLeftoverWgSkew(RD_entry rD_entry) {
        double d = 0.0;
        int n = 0;
        for (WG_entry wG_entry : Host.getAllWorkloads()) {
            if (wG_entry.skew != 0.0) {
                d += wG_entry.skew;
                continue;
            }
            ++n;
        }
        if (n > 0) {
            double d2 = (100.0 - d) / (double)n;
            for (WG_entry wG_entry : Host.getAllWorkloads()) {
                if (wG_entry.skew != 0.0) continue;
                wG_entry.skew = d2;
                d += wG_entry.skew;
            }
        }
        if (Host.getAllWorkloads().size() != 0 && (d < 99.9999 || d > 100.0001)) {
            common.failure("rd=%s Total skew must add up to 100: %.2f", rD_entry.rd_name, d);
        }
    }
}

