/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Vdb.BoxPrint;
import Vdb.Cmd_entry;
import Vdb.ErrorLog;
import Vdb.HelpRequest;
import Vdb.KeyMap;
import Vdb.MiscParms;
import Vdb.Native;
import Vdb.common;
import java.util.HashMap;

public class HelpDebug {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";
    private static boolean checked = false;
    private static boolean anything = false;
    private static HashMap<String, HelpRequest> request_map = new HashMap(8);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void parseParameters() {
        HashMap<String, HelpRequest> hashMap = request_map;
        synchronized (hashMap) {
            if (checked) {
                return;
            }
            String[] stringArray = MiscParms.getKeyParameters("HelpDebug");
            if (stringArray == null) {
                return;
            }
            anything = true;
            for (int i = 1; i < stringArray.length; ++i) {
                String string = stringArray[i].trim().toLowerCase();
                String[] stringArray2 = string.split("=");
                HelpRequest helpRequest = new HelpRequest(stringArray2[0]);
                request_map.put(helpRequest.option, helpRequest);
                if (stringArray2.length <= 1) continue;
                helpRequest.after_count = Long.parseLong(stringArray2[1]);
            }
            checked = true;
        }
    }

    public static boolean anything() {
        if (!checked) {
            HelpDebug.parseParameters();
        }
        return anything;
    }

    public static synchronized boolean corruptBuffer(long l, long l2) {
        int[] nArray = new int[(int)l2 / 4];
        Native.buffer_to_array(nArray, l, (int)l2);
        nArray[2] = -1159864867;
        Native.arrayToBuffer(nArray, l);
        return true;
    }

    public static void abortAfterCount(String string) {
        if (!checked) {
            HelpDebug.parseParameters();
        }
        if (!anything) {
            return;
        }
        HelpRequest helpRequest = request_map.get(string.toLowerCase());
        if (helpRequest == null) {
            return;
        }
        if (++helpRequest.calls == helpRequest.after_count) {
            BoxPrint.printOne("HelpDebug '%s' abort issued after %,d calls to abortAfterCount", string, helpRequest.after_count);
            common.sleep_some(100L);
            common.failure("HelpDebug '%s' abort issued after %,d calls to abortAfterCount", string, helpRequest.after_count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean doAfterCount(String string) {
        if (!checked) {
            HelpDebug.parseParameters();
        }
        if (!anything) {
            return false;
        }
        HelpRequest helpRequest = request_map.get(string.toLowerCase());
        if (helpRequest == null) {
            return false;
        }
        if (helpRequest.after_count == 0L) {
            common.failure("HelpDebug specification error, need a count, as in %s=1000", string);
        }
        HashMap<String, HelpRequest> hashMap = request_map;
        synchronized (hashMap) {
            if (++helpRequest.calls == helpRequest.after_count) {
                ErrorLog.add("", new Object[0]);
                ErrorLog.add("HelpDebug.doAfterCount triggered for '%s=%,d'", string, helpRequest.after_count);
                ErrorLog.add("", new Object[0]);
                ErrorLog.flush();
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean doAfterModulo(String string) {
        if (!checked) {
            HelpDebug.parseParameters();
        }
        if (!anything) {
            return false;
        }
        HelpRequest helpRequest = request_map.get(string.toLowerCase());
        if (helpRequest == null) {
            return false;
        }
        if (helpRequest.after_count == 0L) {
            common.failure("HelpDebug specification error, need a count, as in %s=1000", string);
        }
        HashMap<String, HelpRequest> hashMap = request_map;
        synchronized (hashMap) {
            if (++helpRequest.calls % helpRequest.after_count == 0L) {
                ErrorLog.add("", new Object[0]);
                ErrorLog.add("HelpDebug.doAfterModulo triggered for '%s=%,d'", string, helpRequest.after_count);
                ErrorLog.add("", new Object[0]);
                ErrorLog.flush();
                return true;
            }
            return false;
        }
    }

    public static boolean doForLba(String string, long l, long l2) {
        if (!checked) {
            HelpDebug.parseParameters();
        }
        if (!anything) {
            return false;
        }
        HelpRequest helpRequest = request_map.get(string.toLowerCase());
        if (helpRequest == null) {
            return false;
        }
        if (helpRequest.after_count == 0L) {
            common.failure("HelpDebug specification error, need a count, as in %s=1000", string);
        }
        long l3 = helpRequest.after_count + l2;
        return l >= helpRequest.after_count && l < l3;
    }

    public static boolean hasRequest(String string) {
        if (!checked) {
            HelpDebug.parseParameters();
        }
        if (!anything) {
            return false;
        }
        return request_map.get(string.toLowerCase()) != null;
    }

    public static void forceSdCorruptions(Cmd_entry cmd_entry, int n, long l, long l2, KeyMap keyMap) {
        if (!HelpDebug.corruptBuffer(l, l2)) {
            return;
        }
        BoxPrint.printOne("forceSdCorruptions", new Object[0]);
        long l3 = Native.multiKeyReadAndValidateBlock(cmd_entry.sd_ptr.fhandle * -1L, n | cmd_entry.type_of_dv_read, 0L, cmd_entry.cmd_lba, (int)cmd_entry.cmd_xfersize, l, keyMap.getKeyCount(), keyMap.getKeys(), keyMap.getCompressions(), keyMap.getDedupsets(), cmd_entry.sd_ptr.sd_name8, cmd_entry.jni_index);
    }

    public static void forceFsdCorruptions(long l, int n, long l2, long l3, int n2, long l4, int n3, KeyMap keyMap, String string) {
        if (!HelpDebug.corruptBuffer(l4, n3)) {
            return;
        }
        BoxPrint.printOne("forceFsdCorruptions", new Object[0]);
        long l5 = Native.multiKeyReadAndValidateBlock(l * -1L, n, l2, l3, n2, l4, keyMap.getKeyCount(), keyMap.getKeys(), keyMap.getCompressions(), keyMap.getDedupsets(), string, -1);
    }

    public static void corruptBlock(long l, int n, long l2) {
        long l3 = Native.allocBuffer(n);
        int[] nArray = new int[n / 4];
        long l4 = Native.readFile(l, l2, n, l3);
        if (l4 != 0L) {
            common.failure("Read i/o error in HelpDebug");
        }
        HelpDebug.corruptBuffer(l3, n);
        l4 = Native.writeFile(l, l2, n, l3);
        if (l4 != 0L) {
            common.failure("Write i/o error in HelpDebug");
        }
        Native.freeBuffer(n, l3);
    }
}

