/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Vdb.BucketRange;
import Vdb.BucketRanges;
import Vdb.common;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;

public class Histogram
implements Serializable,
Cloneable {
    private static final String c = "Copyright (c) 2000, 2012, Oracle and/or its affiliates. All rights reserved.";
    private long[] counters = null;
    private BucketRanges ranges;
    private BucketRanges sorted_ranges;
    private boolean header_printed = false;
    private static DecimalFormat df = new DecimalFormat("#,###");
    private static String STARS = "--------------------------------------------------";
    private static String PLUS = "++++++++++++++++++++++++++++++++++++++++++++++++++";

    public Histogram(String string) {
        this.ranges = BucketRanges.getRangesFromType(string);
        this.counters = new long[this.ranges.getBucketCount()];
        this.sorted_ranges = (BucketRanges)this.ranges.clone();
    }

    public Object clone() {
        try {
            Histogram histogram = (Histogram)super.clone();
            histogram.counters = (long[])this.counters.clone();
            return histogram;
        }
        catch (Exception exception) {
            common.failure(exception);
            return null;
        }
    }

    public int findBucket(long l) {
        return this.sorted_ranges.findBucket(l);
    }

    public void addToBucket(long l) {
        int n;
        int n2 = n = this.sorted_ranges.findBucket(l);
        this.counters[n2] = this.counters[n2] + 1L;
    }

    public void deltaBuckets(Histogram histogram, Histogram histogram2) {
        for (int i = 0; i < this.counters.length; ++i) {
            this.counters[i] = histogram.counters[i] - histogram2.counters[i];
        }
    }

    public void accumBuckets(Histogram histogram) {
        if (histogram == null) {
            return;
        }
        if (this.counters.length != histogram.counters.length) {
            common.failure("Unmatch counter sizes: " + this.counters.length + "/" + histogram.counters.length);
        }
        for (int i = 0; i < this.counters.length; ++i) {
            int n = i;
            this.counters[n] = this.counters[n] + histogram.counters[i];
        }
    }

    public long[] getJniBucketArray() {
        return this.ranges.getJniBucketArray();
    }

    public void storeJniBucketArray(long[] lArray) {
        for (int i = 0; i < lArray.length / 3; ++i) {
            this.counters[i] = lArray[i * 3 + 2];
        }
    }

    public long[] getCounters() {
        return this.counters;
    }

    public long getTotals() {
        long l = 0L;
        for (int i = 0; i < this.counters.length; ++i) {
            l += this.counters[i];
        }
        return l;
    }

    public static void main(String[] stringArray) throws Exception {
        double d = Double.parseDouble(stringArray[0]);
        common.ptod("xx: ===>" + Histogram.getShort(d, 7) + "<===");
    }

    public ArrayList printHistogram(String string) {
        int n;
        ArrayList<String> arrayList = new ArrayList<String>(64);
        long l = this.getTotals();
        if (l == 0L) {
            return arrayList;
        }
        arrayList.add(string);
        String string2 = String.format(" %8s <  %10s   %11s %8s %8s  ", "min(ms)", "max(ms)", "count", "%%", "cum%%");
        arrayList.add(string2 + "'+': Individual%; '+-': Cumulative%");
        arrayList.add("");
        double d = 0.0;
        BucketRange[] bucketRangeArray = this.ranges.getRanges();
        for (int i = 0; i < bucketRangeArray.length; ++i) {
            d = Math.max((double)this.counters[i] * 100.0 / (double)l, d);
        }
        double d2 = 0.5;
        int n2 = bucketRangeArray.length - 1;
        if (this.ranges.suppress()) {
            for (n = 0; n < bucketRangeArray.length && this.counters[n] == 0L; ++n) {
            }
            while (n2 >= 0 && this.counters[n2] == 0L) {
                --n2;
            }
        }
        if (n > 0) {
            --n;
        }
        if (n2 < bucketRangeArray.length - 1) {
            ++n2;
        }
        long l2 = 0L;
        for (int i = n; i <= n2; ++i) {
            long l3 = this.counters[bucketRangeArray[i].which];
            double d3 = (double)l3 * 100.0 / (double)l;
            double d4 = (double)(l2 += l3) * 100.0 / (double)l;
            int n3 = (int)(d3 * d2);
            int n4 = (int)((d4 - d3) * d2);
            String string3 = n3 > 0 ? PLUS.substring(0, n3) : "";
            String string4 = n4 > 0 ? STARS.substring(0, n4) : "";
            String string5 = bucketRangeArray[i].max == Long.MAX_VALUE ? "max" : Histogram.getShort((double)bucketRangeArray[i].max / 1000.0, 8);
            string2 = String.format(" %8s < %11s %13s %8.4f %8.4f  %s%s", Histogram.getShort((double)bucketRangeArray[i].min / 1000.0, 8), string5, df.format(l3), d3, d4, string3, string4);
            arrayList.add(string2);
        }
        arrayList.add("");
        return arrayList;
    }

    private static String getShort(double d, int n) {
        String string = String.format("%.3f", d);
        while (string.length() > n && !string.endsWith(".")) {
            string = string.substring(0, string.length() - 1);
        }
        if (string.endsWith(".")) {
            return string.substring(0, string.length() - 1);
        }
        return string;
    }

    private String printHeader() {
        this.header_printed = true;
        String string = "All but one of the empty buckets at the beginning \n";
        string = string + "and all but one empty buckets at the end will will be skipped.\n";
        string = string + "Empty buckets in the middle though will be printed.\n";
        return string;
    }
}

