/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Utils.ClassPath;
import Utils.NfsV3;
import Utils.NfsV4;
import Utils.OS_cmd;
import Vdb.BoxPrint;
import Vdb.InfoFromHost;
import Vdb.InstancePointer;
import Vdb.Mount;
import Vdb.NfsStats;
import Vdb.Report;
import Vdb.Reporter;
import Vdb.SD_entry;
import Vdb.Slave;
import Vdb.ThreadMonData;
import Vdb.ThreadMonList;
import Vdb.ThreadMonitor;
import Vdb.WG_entry;
import Vdb.Work;
import Vdb.common;
import Vdb.reporting;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class Host
implements Cloneable,
Comparable {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";
    public String host_ip = "localhost";
    public String host_label = "localhost";
    public String host_vdbench = ClassPath.classPath();
    public int relative_hostno;
    public int client_count = 0;
    public Mount host_mount = null;
    public String master_ip = null;
    public String host_shell = "rsh";
    public String host_user = null;
    private int host_jvms = 1;
    private int last_created_jvm = 0;
    public boolean jvms_in_parm = false;
    private Vector<Slave> slaves = null;
    private InfoFromHost host_info = null;
    private HashMap<String, String> luns_used = new HashMap(16);
    private Report summary_report = null;
    private Report kstat_report = null;
    private HashMap host_report_map = null;
    private PrintWriter adm_msg_file;
    private reporting[] nfs3_rep = null;
    private reporting[] nfs4_rep = null;
    public static int jvmcount_override = 0;
    private String os_name;
    private String os_arch;
    private static Vector<Host> defined_hosts = new Vector(16, 0);
    public static int max_host_name = 0;

    public Object clone() {
        try {
            Host host = (Host)super.clone();
            host.luns_used = (HashMap)this.luns_used.clone();
            return host;
        }
        catch (Exception exception) {
            common.failure(exception);
            return null;
        }
    }

    public static void addHost(Host host) {
        host.relative_hostno = defined_hosts.size();
        defined_hosts.add(host);
        max_host_name = Math.max(max_host_name, host.getLabel().length());
        if (jvmcount_override != 0) {
            host.host_jvms = jvmcount_override;
            host.jvms_in_parm = true;
        }
    }

    public void addSlave(Slave slave) {
        if (this.slaves == null) {
            this.slaves = new Vector(8, 0);
        }
        this.slaves.add(slave);
    }

    public static Vector<Host> getDefinedHosts() {
        return defined_hosts;
    }

    public static String[] getHostNames() {
        HashMap<String, Host> hashMap = new HashMap<String, Host>(64);
        for (int i = 0; i < defined_hosts.size(); ++i) {
            Host host = defined_hosts.elementAt(i);
            hashMap.put(host.getLabel(), host);
        }
        return hashMap.keySet().toArray(new String[0]);
    }

    public boolean jvmsInParmfile() {
        return this.jvms_in_parm;
    }

    public int getJvmCount() {
        return this.host_jvms;
    }

    public void setJvmCount(int n) {
        this.host_jvms = n;
    }

    public void setHostInfo(InfoFromHost infoFromHost) {
        this.host_info = infoFromHost;
    }

    public InfoFromHost getHostInfo() {
        return this.host_info;
    }

    public InstancePointer getInstancePointer(int n) {
        return (InstancePointer)this.host_info.getInstancePointers().elementAt(n);
    }

    public void addReport(String string, Report report) {
        if (this.host_report_map == null) {
            this.host_report_map = new HashMap(8);
        }
        this.host_report_map.put(string, report);
    }

    public Report getReport(String string) {
        Report report = (Report)this.host_report_map.get(string);
        if (report == null) {
            String[] stringArray = this.host_report_map.keySet().toArray(new String[0]);
            for (int i = 0; i < stringArray.length; ++i) {
                common.ptod("Host reps: " + stringArray[i]);
            }
            common.failure("Requesting an unknown report file: " + string);
        }
        return report;
    }

    public String[] getReportedKstats() {
        return Report.filterSds(this.host_report_map, false);
    }

    public void setSummaryReport(Report report) {
        this.summary_report = report;
    }

    public void setKstatReport(Report report) {
        this.kstat_report = report;
    }

    public Report getKstatReport() {
        return this.kstat_report;
    }

    public Report getSummaryReport() {
        return this.summary_report;
    }

    public String getIP() {
        return this.host_ip;
    }

    public String getLabel() {
        return this.host_label;
    }

    public String getVdbench() {
        return this.host_vdbench;
    }

    public String getShell() {
        return this.host_shell;
    }

    public String getUser() {
        if (this.host_user == null) {
            common.failure("'user=' subparameter not specified for host " + this.host_label);
        }
        return this.host_user;
    }

    public Slave getFirstSlave() {
        return this.slaves.firstElement();
    }

    public Vector<Slave> getSlaves() {
        return this.slaves;
    }

    public static void dumpAll(String string) {
        for (int i = 0; i < defined_hosts.size(); ++i) {
            Host host = defined_hosts.elementAt(i);
            common.ptod("host.slaves.size(): " + host.slaves.size());
            for (int j = 0; j < host.slaves.size(); ++j) {
                common.ptod(j + " " + string + " host: " + host.getLabel() + " " + host.slaves.elementAt(j).getLabel());
            }
        }
    }

    public static boolean anyMountCommands() {
        for (int i = 0; i < defined_hosts.size(); ++i) {
            Host host = defined_hosts.elementAt(i);
            if (host.host_mount == null) continue;
            return true;
        }
        return false;
    }

    public static void noMultiJvmForFwdSkew() {
        for (Host host : defined_hosts) {
            if (host.host_jvms <= 1) continue;
            BoxPrint boxPrint = new BoxPrint();
            boxPrint.add("Use of FWD skew= currently not supported when running multi-JVM", new Object[0]);
            boxPrint.add("This can be resolved by specifying more Host Definitions (HD)", new Object[0]);
            boxPrint.add("For instance:", new Object[0]);
            boxPrint.add("", new Object[0]);
            boxPrint.add("hd=host1,system=localhost", new Object[0]);
            boxPrint.add("hd=host2,system=localhost", new Object[0]);
            boxPrint.add("", new Object[0]);
            boxPrint.add("or", new Object[0]);
            boxPrint.add("", new Object[0]);
            boxPrint.add("hd=host1,clients=2", new Object[0]);
            boxPrint.add("", new Object[0]);
            boxPrint.add("or", new Object[0]);
            boxPrint.add("", new Object[0]);
            boxPrint.add("hd=default,clients=2", new Object[0]);
            boxPrint.add("", new Object[0]);
            boxPrint.add("", new Object[0]);
            boxPrint.add("This is a workaround for a bug in a rarely used Vdbench option.", new Object[0]);
            boxPrint.print();
            common.failure("No multi-JVM supported for FWD skew");
        }
    }

    public static void createSlaves() {
        for (int i = 0; i < defined_hosts.size(); ++i) {
            Host host = defined_hosts.elementAt(i);
            for (int j = host.last_created_jvm; j < host.host_jvms; ++j) {
                Slave slave = new Slave(host, j);
                ++host.last_created_jvm;
            }
        }
    }

    public static void checkDuplicates() {
        for (int i = 0; i < defined_hosts.size(); ++i) {
            Host host = defined_hosts.elementAt(i);
            for (int j = i + 1; j < defined_hosts.size(); ++j) {
                Host host2 = defined_hosts.elementAt(j);
                if (!host.host_label.equalsIgnoreCase(host2.host_label)) continue;
                common.failure("Using duplicate host names: " + host.host_label);
            }
        }
    }

    public static Host findHost(String string) {
        for (int i = 0; i < defined_hosts.size(); ++i) {
            Host host = defined_hosts.elementAt(i);
            if (!host.host_label.equals(string)) continue;
            return host;
        }
        common.failure("Unable to locate host %s (No wildcards allowed)", string);
        return null;
    }

    public static boolean isHostKnown(String string) {
        for (int i = 0; i < defined_hosts.size(); ++i) {
            Host host = defined_hosts.elementAt(i);
            if (!host.host_label.equals(string)) continue;
            return true;
        }
        return false;
    }

    public static boolean doesHostExist(String string) {
        long l = System.currentTimeMillis();
        if (string.startsWith("localhost")) {
            return true;
        }
        try {
            InetAddress.getByName(string);
            long l2 = System.currentTimeMillis();
            if (l2 - l > 5000L) {
                common.ptod("Obtaining network information about host=" + string + " took more than 5 seconds: " + (l2 - l) + " milliseconds.");
            }
            return true;
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    public void createAdmMessagesFile() {
        String string = this.host_label + ".var_adm_msgs";
        this.adm_msg_file = Report.createHmtlFile(string);
        this.getSummaryReport().printHtmlLink("Link to /var/adm/messages", string, "messages");
        this.adm_msg_file.println("This file will contain the last 'nn' lines of files ");
        this.adm_msg_file.println("/var/adm/messages and /var/adm/messages.0 on the target host. ");
        this.adm_msg_file.println(" ");
        this.adm_msg_file.flush();
    }

    public void writeAdmMessagesFile(String string) {
        this.adm_msg_file.println(string);
        this.adm_msg_file.flush();
    }

    public static void closeAdmMessagesFiles() {
        for (int i = 0; i < defined_hosts.size(); ++i) {
            Host host = defined_hosts.elementAt(i);
            if (host.adm_msg_file != null) {
                host.adm_msg_file.close();
            }
            host.adm_msg_file = null;
        }
    }

    public static Vector findSelectedHosts(String[] stringArray) {
        Vector<String> vector = new Vector<String>(8, 0);
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            for (int j = 0; j < defined_hosts.size(); ++j) {
                Host host = defined_hosts.elementAt(j);
                if (!common.simple_wildcard(string, host.getLabel()) && !common.simple_wildcard(string, host.getIP())) continue;
                vector.add(host.getLabel());
            }
            if (vector.size() != 0) continue;
            common.failure("Could not find host=" + string);
        }
        return vector;
    }

    public void addLun(String string, String string2) {
        if (this.luns_used.put(string, string2) != null) {
            common.failure("An SD can only be defined once: sd=" + string);
        }
    }

    public boolean anyWork() {
        for (int i = 0; i < this.slaves.size(); ++i) {
            Slave slave = this.slaves.elementAt(i);
            Work work = slave.getCurrentWork();
            if (work == null) continue;
            return true;
        }
        return false;
    }

    public String getLunNameForSd(SD_entry sD_entry) {
        String string = this.luns_used.get(sD_entry.sd_name);
        if (string == null) {
            if (!sD_entry.concatenated_sd && sD_entry.lun == null) {
                common.failure("getLunNameForSd: null sd.lun for sd=%s", sD_entry.sd_name);
            }
            return sD_entry.lun;
        }
        return string;
    }

    public boolean doesHostHaveSd(SD_entry sD_entry) {
        String string = this.luns_used.get(sD_entry.sd_name);
        return string != null;
    }

    public void replaceLunForSd(String string, String string2) {
        if (this.luns_used.put(string, string2) == null) {
            common.failure("replaceLunForSd: unknown lun for sd=%s,host=%s,lun=%s", string, this.getLabel(), string2);
        }
    }

    public int getLunCount() {
        return this.luns_used.size();
    }

    public HashMap<String, String> getHostLunMap() {
        return this.luns_used;
    }

    public String[] getSdNamesForLun(String string) {
        String[] stringArray = this.luns_used.keySet().toArray(new String[0]);
        String[] stringArray2 = this.luns_used.values().toArray(new String[0]);
        Vector<String> vector = new Vector<String>(4, 0);
        for (int i = 0; i < stringArray2.length; ++i) {
            if (!stringArray2[i].equals(string)) continue;
            vector.add(stringArray[i]);
        }
        return vector.toArray(new String[0]);
    }

    public static int countHostsForSD(String string) {
        int n = 0;
        for (int i = 0; i < defined_hosts.size(); ++i) {
            Host host = defined_hosts.elementAt(i);
            if (host.luns_used.get(string) == null) continue;
            ++n;
        }
        return n;
    }

    public static boolean anyJvmOverrides() {
        for (int i = 0; i < defined_hosts.size(); ++i) {
            Host host = defined_hosts.elementAt(i);
            if (!host.jvmsInParmfile()) continue;
            return true;
        }
        return false;
    }

    public void setOS(String string, String string2) {
        this.os_name = string;
        this.os_arch = string2;
    }

    public boolean onWindows() {
        return this.os_name.toLowerCase().startsWith("windows");
    }

    public void createNfsReports() {
        String string;
        Report report;
        InfoFromHost infoFromHost = this.getHostInfo();
        int n = 0;
        NfsV3 nfsV3 = infoFromHost.getNfs3();
        NfsV4 nfsV4 = infoFromHost.getNfs4();
        if (nfsV3 != null || nfsV4 != null) {
            this.kstat_report.println("");
        }
        if (infoFromHost.getNfs3() != null) {
            report = new Report(this.getLabel() + ".nfsstat3", "Host nfs statistics report for host=" + this.getLabel());
            string = n++ == 0 ? "Host NFS statistics report" : null;
            this.kstat_report.printHtmlLink(string, report.getFileName(), "nfsv3");
            this.addReport("nfsstat3", report);
            this.nfs3_rep = NfsStats.nfsLayout(nfsV3, new NfsV3());
            report.println(NfsStats.warning);
        }
        if (infoFromHost.getNfs4() != null) {
            report = new Report(this.getLabel() + ".nfsstat4", "Host nfs statistics report for host=" + this.getLabel());
            string = n++ == 0 ? "Host NFS statistics report" : null;
            this.kstat_report.printHtmlLink(string, report.getFileName(), "nfsv4");
            this.addReport("nfsstat4", report);
            this.nfs4_rep = NfsStats.nfsLayout(nfsV4, new NfsV4());
            report.println(NfsStats.warning);
        }
    }

    public void PrintNfsstatInterval(String string) {
        InfoFromHost infoFromHost = this.getHostInfo();
        NfsV3 nfsV3 = infoFromHost.getNfs3();
        NfsV4 nfsV4 = infoFromHost.getNfs4();
        if (nfsV3 != null) {
            nfsV3 = (NfsV3)this.getReport("nfsstat3").getData().getIntervalNfsStats(new NfsV3());
        }
        if (nfsV4 != null) {
            nfsV4 = (NfsV4)this.getReport("nfsstat4").getData().getIntervalNfsStats(new NfsV4());
        }
        if (Reporter.needHeaders()) {
            if (nfsV3 != null) {
                reporting.report_header(this.getReport("nfsstat3").getWriter(), this.nfs3_rep);
            }
            if (nfsV4 != null) {
                reporting.report_header(this.getReport("nfsstat4").getWriter(), this.nfs4_rep);
            }
        }
        if (nfsV3 != null) {
            NfsStats.NfsPrint(this.getReport("nfsstat3"), nfsV3, this.nfs3_rep, string, new NfsV3());
        }
        if (nfsV4 != null) {
            NfsStats.NfsPrint(this.getReport("nfsstat4"), nfsV4, this.nfs4_rep, string, new NfsV4());
        }
    }

    public void PrintNfsstatTotals(String string) {
        InfoFromHost infoFromHost = this.getHostInfo();
        NfsV3 nfsV3 = infoFromHost.getNfs3();
        NfsV4 nfsV4 = infoFromHost.getNfs4();
        if (nfsV3 != null) {
            nfsV3 = (NfsV3)this.getReport("nfsstat3").getData().getTotalNfsStats(new NfsV3());
        }
        if (nfsV4 != null) {
            nfsV4 = (NfsV4)this.getReport("nfsstat4").getData().getTotalNfsStats(new NfsV4());
        }
        if (Reporter.needHeaders()) {
            if (nfsV3 != null) {
                reporting.report_header(this.getReport("nfsstat3").getWriter(), this.nfs3_rep);
            }
            if (nfsV4 != null) {
                reporting.report_header(this.getReport("nfsstat4").getWriter(), this.nfs4_rep);
            }
        }
        if (nfsV3 != null) {
            NfsStats.NfsPrint(this.getReport("nfsstat3"), nfsV3, this.nfs3_rep, string, new NfsV3());
        }
        if (nfsV4 != null) {
            NfsStats.NfsPrint(this.getReport("nfsstat4"), nfsV4, this.nfs4_rep, string, new NfsV4());
        }
        if (nfsV3 != null) {
            NfsStats.NfsPrintVertical(this.getReport("nfsstat3"), nfsV3);
        }
        if (nfsV4 != null) {
            NfsStats.NfsPrintVertical(this.getReport("nfsstat4"), nfsV4);
        }
    }

    public static ArrayList<WG_entry> getAllWorkloads() {
        ArrayList<WG_entry> arrayList = new ArrayList<WG_entry>(64);
        for (Host host : Host.getDefinedHosts()) {
            arrayList.addAll(host.getWorkloads());
        }
        WG_entry.sortWorkloads(arrayList, "sd");
        return arrayList;
    }

    public ArrayList<WG_entry> getWorkloads() {
        ArrayList<WG_entry> arrayList = new ArrayList<WG_entry>(64);
        for (Slave slave : this.getSlaves()) {
            arrayList.addAll(slave.getWorkloads());
        }
        return arrayList;
    }

    public SD_entry[] getSds() {
        HashMap<String, SD_entry> hashMap = new HashMap<String, SD_entry>(8);
        for (WG_entry sD_entryArray2 : this.getWorkloads()) {
            hashMap.put(sD_entryArray2.sd_used.sd_name, sD_entryArray2.sd_used);
        }
        Object[] objectArray = hashMap.keySet().toArray(new String[0]);
        Arrays.sort(objectArray);
        SD_entry[] sD_entryArray = new SD_entry[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            sD_entryArray[i] = (SD_entry)hashMap.get(objectArray[i]);
        }
        return sD_entryArray;
    }

    public String[] getSdNames() {
        HashMap<String, SD_entry> hashMap = new HashMap<String, SD_entry>(8);
        for (WG_entry wG_entry : this.getWorkloads()) {
            hashMap.put(wG_entry.sd_used.sd_name, wG_entry.sd_used);
        }
        Object[] objectArray = hashMap.keySet().toArray(new String[0]);
        Arrays.sort(objectArray);
        return objectArray;
    }

    public ArrayList<WG_entry> getWgsForSd(SD_entry sD_entry) {
        ArrayList<WG_entry> arrayList = new ArrayList<WG_entry>(16);
        for (WG_entry wG_entry : this.getWorkloads()) {
            if (wG_entry.sd_used != sD_entry) continue;
            arrayList.add(wG_entry);
        }
        return arrayList;
    }

    public int getSdCount() {
        HashMap<String, String> hashMap = new HashMap<String, String>(16);
        for (WG_entry wG_entry : this.getWorkloads()) {
            hashMap.put(wG_entry.sd_used.sd_name, wG_entry.sd_used.sd_name);
        }
        return hashMap.size();
    }

    public Slave getLeastBusySlave() {
        if (this.slaves.size() == 0) {
            common.failure("getLowBusySlave: no slaves available for host=%s", this.host_label);
        }
        Slave slave = this.slaves.get(0);
        for (Slave slave2 : this.slaves) {
            if (slave2.getWorkloads().size() >= slave.getWorkloads().size()) continue;
            slave = slave2;
        }
        return slave;
    }

    public Slave getSlaveUsingSd(SD_entry sD_entry) {
        for (Slave slave : this.getSlaves()) {
            for (WG_entry wG_entry : slave.getWorkloads()) {
                if (!wG_entry.sd_used.sd_name.equals(sD_entry.sd_name)) continue;
                return slave;
            }
        }
        return null;
    }

    public Slave getLeastBusyThreads(SD_entry sD_entry) {
        if (this.slaves.size() == 0) {
            common.failure("getLowBusyThreads: no slaves available for host=%s", this.host_label);
        }
        Slave slave = null;
        block0: for (Slave slave2 : this.slaves) {
            for (WG_entry object : slave2.getWorkloads()) {
                if (object.sd_used != sD_entry) continue;
                slave = slave2;
                break block0;
            }
        }
        if (slave == null) {
            common.failure("getLeastBusyThreads: unable to find available slave for sd=%s", sD_entry.sd_name);
        }
        for (Slave slave2 : this.slaves) {
            ArrayList<WG_entry> arrayList = slave2.getWorkloads();
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                WG_entry wG_entry = (WG_entry)iterator.next();
                if (wG_entry.sd_used != sD_entry || arrayList.size() <= 0 || slave2.threads_given_to_slave >= slave.threads_given_to_slave) continue;
                slave = slave2;
            }
        }
        return slave;
    }

    public static void reportMonTotals() {
        ThreadMonList threadMonList = new ThreadMonList();
        threadMonList.processors = 0;
        long l = 0L;
        boolean bl = false;
        for (Host host : defined_hosts) {
            Serializable serializable;
            ThreadMonList threadMonList2 = new ThreadMonList();
            for (Slave slave : host.slaves) {
                serializable = slave.reportThreadMonSlaveTotals();
                for (ThreadMonData threadMonData : ((ThreadMonList)serializable).list) {
                    ThreadMonData threadMonData2 = threadMonList2.map.get(threadMonData.label);
                    if (threadMonData2 == null) {
                        threadMonList2.map.put(threadMonData.label, threadMonData);
                    } else {
                        threadMonData2.accum(threadMonData);
                    }
                    threadMonList2.elapsed = ((ThreadMonList)serializable).elapsed;
                    threadMonList2.processors = ((ThreadMonList)serializable).processors;
                    if (l != 0L && (long)((ThreadMonList)serializable).processors != l) {
                        bl = true;
                        continue;
                    }
                    l = ((ThreadMonList)serializable).processors;
                }
            }
            threadMonList2.list = new ArrayList<ThreadMonData>(threadMonList2.map.values());
            ThreadMonitor.reportTotals(host.getLabel(), threadMonList2);
            threadMonList.elapsed = threadMonList2.elapsed;
            threadMonList.processors += threadMonList2.processors;
            for (ThreadMonData threadMonData : threadMonList2.list) {
                serializable = threadMonList.map.get(threadMonData.label);
                if (serializable == null) {
                    threadMonList.map.put(threadMonData.label, threadMonData);
                    continue;
                }
                ((ThreadMonData)serializable).accum(threadMonData);
            }
        }
        if (bl) {
            common.ptod("Reporting ThreadMonitor run totals not possible because of processor count mismatch.");
        } else {
            threadMonList.list = new ArrayList<ThreadMonData>(threadMonList.map.values());
            ThreadMonitor.reportTotals("Total", threadMonList);
        }
    }

    public int compareTo(Object object) {
        Host host = this;
        Host host2 = (Host)object;
        return host.relative_hostno - host2.relative_hostno;
    }

    public void runHostName() {
        if (this.master_ip == null) {
            return;
        }
        if (!this.master_ip.equals("hostname")) {
            return;
        }
        OS_cmd oS_cmd = OS_cmd.execute("hostname", false);
        if (!oS_cmd.getRC()) {
            oS_cmd.printStderr();
            oS_cmd.printStdout();
            common.failure("'master=hostname' 'hostname' command failure");
        }
        if (oS_cmd.getStdout().length == 0) {
            oS_cmd.printStderr();
            oS_cmd.printStdout();
            common.failure("'master=hostname' 'hostname' command failure, no data returned.");
        }
        this.master_ip = oS_cmd.getStdout()[0];
    }
}

