/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Vdb.common;
import java.text.DecimalFormat;
import java.util.Random;

public class HotBand {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";
    int next_ran = 0;
    long BandSizeInMB = 0L;
    static int DEBUG = 0;
    Random[] r = new Random[5];
    DecimalFormat df1 = new DecimalFormat("0000");
    DecimalFormat df2 = new DecimalFormat("###0.00");
    private static boolean add_one_pct_to_writes = true;
    static long startTime;
    static long Start_Time;
    static long[] CacheSizeMB;
    static double[] PBCurve;
    static double[] Slope;

    public static int pb_lookup(double d) {
        int n = 0;
        int n2 = PBCurve.length - 1;
        while (true) {
            int n3 = (n + n2) / 2;
            if (DEBUG == 1) {
                System.out.println("pb_lookup: z= " + d + " pb_low = " + n + " pb_mid = " + n3 + " pb_high = " + n2);
            }
            if (PBCurve[n3] <= d && d < PBCurve[n3 + 1]) {
                return n3;
            }
            if (PBCurve[n3] < d) {
                n = n3 + 1;
                continue;
            }
            n2 = n3 - 1;
        }
    }

    public HotBand(long l) {
        Start_Time = startTime = System.currentTimeMillis();
        this.df1 = new DecimalFormat("00000");
        this.df2 = new DecimalFormat("###0.00");
        for (int i = 0; i < this.r.length; ++i) {
            this.r[i] = common.get_debug(common.FIXED_HOTBAND_SEED) ? new Random(0L) : new Random();
        }
        this.BandSizeInMB = l / 1000000L;
        if (this.BandSizeInMB == 0L) {
            common.failure("Minimum hotband size of one megabyte is required. Size: %d bytes", l);
        }
    }

    public HotBand(long l, long l2) {
        long[] lArray = new long[]{0L, 313L, 667L, 757L, 827L, 907L, 977L, 997L};
        Start_Time = startTime = System.currentTimeMillis();
        this.df1 = new DecimalFormat("00000");
        this.df2 = new DecimalFormat("###0.00");
        for (int i = 0; i < this.r.length; ++i) {
            this.r[i] = new Random(l2 + lArray[i]);
        }
        this.BandSizeInMB = l / 1000000L;
        if (this.BandSizeInMB == 0L) {
            common.failure("Minimum hotband size of 1,000,000 bytes is required. Size: %d bytes", l);
        }
    }

    public static void doNotAddOnePct() {
        add_one_pct_to_writes = false;
    }

    public long get_rec_index(int n, boolean bl) {
        int n2;
        this.next_ran = (this.next_ran + 1) % this.r.length;
        double d = this.r[this.next_ran].nextDouble();
        if (d - PBCurve[n2 = HotBand.pb_lookup(d)] < 0.0) {
            System.err.println("get_rec_index: ** ran_double < PBCurve[" + n2 + "] ran_double = " + d + "  PBCurve[index] = " + PBCurve[n2]);
        }
        long l = (long)((d - PBCurve[n2]) * Slope[n2] + (double)CacheSizeMB[n2]) * 1000L;
        long l2 = l * 1000L * 1000L / (long)n / 1000000L;
        if (DEBUG == 1 && l2 < 0L) {
            System.out.println("get_rec_index: ** Out of range  rec= " + l2 + "  kb_offset = " + l);
        }
        long l3 = this.BandSizeInMB * 1000L * 1000L / (long)n;
        if (!bl && add_one_pct_to_writes) {
            l2 += l3 / 100L;
        }
        l2 %= l3;
        if (DEBUG == 1) {
            System.out.println("get_rec_index: rec= " + l2 + " ran_double = " + d + " Num_recs_in_band = " + l3);
        }
        return l2;
    }

    public static void main(String[] stringArray) {
        int n;
        HotBand hotBand;
        if (stringArray.length < 3) {
            System.out.println(" usage:    java HotBand size_mb xfersize number_of_loops  <seed>");
            System.out.println(" example : java HotBand 200 4096 250");
            System.exit(-1);
        }
        System.err.println("HotBand program to simulate cache hits Version 0.001");
        System.err.println("\nCreated by Steven.A.Johnson@Oracle.com \n");
        long l = Long.parseLong(stringArray[0]) * 1000000L;
        int n2 = Integer.parseInt(stringArray[1]);
        int n3 = Integer.parseInt(stringArray[2]);
        int n4 = (int)(l / (long)n2);
        if (stringArray.length == 4) {
            long l2 = Integer.parseInt(stringArray[3]);
            hotBand = new HotBand(l, l2);
        } else {
            hotBand = new HotBand(l);
        }
        int[] nArray = new int[n4];
        for (n = 0; n < n3; ++n) {
            long l3 = hotBand.get_rec_index(n2, false);
            int n5 = (int)l3;
            nArray[n5] = nArray[n5] + 1;
        }
        common.ptod("blocks: " + n4);
        for (n = 0; n < 50; ++n) {
            common.ptod("block: %4d %6d %5.2f", n, nArray[n], (double)nArray[n] * 100.0 / (double)n3);
        }
    }

    static {
        CacheSizeMB = new long[]{0L, 16L, 32L, 64L, 128L, 256L, 512L, 1024L, 2048L, 4096L, 8192L, 16384L, 32768L, 65536L, 131072L, 262144L, 524288L, 0x100000L, 0x200000L, 0x400000L, 0x800000L, 0x1000000L, 0x2000000L, 0x4000000L, 0x8000000L, 0x10000000L, 0x20000000L, 0x40000000L, 0x280000000L};
        PBCurve = new double[]{0.0, 0.087217, 0.10101, 0.132206, 0.159946, 0.201713, 0.262602, 0.32645, 0.366902, 0.386175, 0.436941, 0.482631, 0.523752, 0.56076, 0.594068, 0.624045, 0.651024, 0.675305, 0.697159, 0.716827, 0.734528, 0.750459, 0.764797, 0.777701, 0.789314, 0.799767, 0.809174, 0.81764, 1.0};
        Slope = new double[]{183.4511752, 1159.945628, 1025.778015, 2307.172362, 3064.644852, 4204.331611, 8019.055699, 25313.90019, 106263.1067, 80683.52498, 179296.7222, 398437.1604, 885415.912, 1967590.916, 4372424.257, 9716498.348, 2.159221855E7, 4.798270789E7, 1.066282398E8, 2.369516439E8, 5.265592087E8, 1.170131575E9, 2.600292389E9, 5.77842753E9, 1.2840950067E10, 2.8535444594E10, 6.3412099098E10, 1.31322063E9, 1.073741824E10};
    }
}

