/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Vdb.Devxlate;
import Vdb.Kstat_data;
import Vdb.Native;
import Vdb.common;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Vector;

public class InstancePointer
implements Serializable,
Comparable {
    private static final String c = "Copyright (c) 2000, 2013, Oracle and/or its affiliates. All rights reserved.";
    private String lun;
    private String instance;
    private String special;
    private long native_pointer;
    private static HashMap last_data = new HashMap(16);

    public InstancePointer(String string, String string2, String string3, long l) {
        this.lun = string;
        this.instance = string2;
        this.special = string3;
        this.native_pointer = l;
        if (l == 0L) {
            common.failure("No Kstat instance pointer found for device " + string);
        }
    }

    public static Vector createInstancePointers(Vector vector) {
        HashMap<String, InstancePointer> hashMap = new HashMap<String, InstancePointer>(16);
        for (int i = 0; i < vector.size(); ++i) {
            Devxlate devxlate = (Devxlate)vector.elementAt(i);
            InstancePointer instancePointer = new InstancePointer(devxlate.fullname, devxlate.instance, devxlate.special, devxlate.kstat_pointer);
            hashMap.put(devxlate.instance, instancePointer);
        }
        return new Vector(hashMap.values());
    }

    public long getNativePointer() {
        return this.native_pointer;
    }

    public String getLun() {
        return this.lun;
    }

    public String getID() {
        return InstancePointer.getKstatPrefix() + this.instance;
    }

    public static String getKstatPrefix() {
        return "ks.";
    }

    public String getInstance() {
        return this.instance;
    }

    public Kstat_data getDeltaKstatData(long l) {
        Long l2;
        Kstat_data kstat_data;
        Kstat_data kstat_data2 = new Kstat_data();
        Kstat_data kstat_data3 = new Kstat_data();
        kstat_data2.tod = l;
        if (Native.getKstatData(kstat_data2, this.native_pointer) < 0L) {
            common.failure("Error reading Kstat data");
        }
        if ((kstat_data = (Kstat_data)last_data.get(l2 = new Long(this.native_pointer))) != null) {
            kstat_data3.nread = kstat_data2.nread - kstat_data.nread;
            kstat_data3.nwritten = kstat_data2.nwritten - kstat_data.nwritten;
            kstat_data3.reads = kstat_data2.reads - kstat_data.reads;
            kstat_data3.writes = kstat_data2.writes - kstat_data.writes;
            kstat_data3.wlentime = kstat_data2.wlentime - kstat_data.wlentime;
            kstat_data3.rtime = kstat_data2.rtime - kstat_data.rtime;
            kstat_data3.rlentime = kstat_data2.rlentime - kstat_data.rlentime;
            kstat_data3.elapsed = kstat_data2.tod - kstat_data.tod;
            kstat_data3.totalio = kstat_data2.totalio - kstat_data.totalio;
        }
        last_data.put(l2, kstat_data2);
        return kstat_data3;
    }

    public int compareTo(Object object) {
        InstancePointer instancePointer = (InstancePointer)object;
        return this.lun.compareTo(instancePointer.lun);
    }

    public static void rebuildNativePointers(Vector vector) {
        Native.closeKstat();
        Native.openKstat();
        Devxlate.clearMnttab();
        for (int i = 0; i < vector.size(); ++i) {
            Object e;
            Vector vector2;
            InstancePointer instancePointer = (InstancePointer)vector.elementAt(i);
            if (instancePointer.instance.startsWith("nfs")) {
                Devxlate.removeFromInstanceList(instancePointer.lun);
            }
            if ((vector2 = Devxlate.get_device_info(instancePointer.lun)).size() != 1) {
                common.failure("Unexpected device translation return: " + vector2.size());
            }
            if ((e = vector2.firstElement()) instanceof String || e == null) {
                common.ptod("obj: " + e);
                common.failure("Error reading Kstat data for " + instancePointer.lun + " " + instancePointer.instance + " " + instancePointer.special);
                continue;
            }
            Devxlate devxlate = (Devxlate)e;
            instancePointer.native_pointer = Native.getKstatPointer(devxlate.instance);
            if (!instancePointer.instance.equals(devxlate.instance)) {
                common.ptod("Switching Kstat instance from " + instancePointer.instance + " to " + devxlate.instance);
            }
            instancePointer.instance = devxlate.instance;
        }
    }

    public String toString() {
        return String.format("InstancePointer: %s %s %s", this.lun, this.instance, this.special);
    }
}

