/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Utils.ClassPath;
import Utils.Fget;
import Utils.Format;
import Utils.Fput;
import Utils.OS_cmd;
import Vdb.common;
import java.util.Vector;

public class InstanceXlate {
    private static final String c = "Copyright (c) 2000, 2014, Oracle and/or its affiliates. All rights reserved.";
    private static String IO_STAT = "/usr/bin/iostat -xp";
    private static String[] left_lines = null;
    private static String[] right_lines = null;
    private static String noslice = "";
    private static String prefix = "";

    public static void main(String[] stringArray) {
        Vector vector = InstanceXlate.simulateLibdev();
        for (int i = 0; i < vector.size(); ++i) {
            String string = (String)vector.elementAt(i);
            if (stringArray.length == 0) {
                System.out.println(string);
                continue;
            }
            if (string.indexOf(stringArray[0]) == -1) continue;
            System.out.println(string);
        }
        InstanceXlate.printIostat();
    }

    public static void main2(String[] stringArray) {
        common.ptod("slice: " + InstanceXlate.translateSliceToNumber("c0t0d0s0"));
        common.ptod("slice: " + InstanceXlate.translateSliceToNumber("c0t0d0s1"));
        common.ptod("slice: " + InstanceXlate.translateSliceToNumber("c0t0d0s2"));
        common.ptod("slice: " + InstanceXlate.translateSliceToNumber("c0t0d0s3"));
        common.ptod("slice: " + InstanceXlate.translateSliceToNumber("c0t0d0s4"));
        common.ptod("slice: " + InstanceXlate.translateSliceToNumber("c0t0d0s5"));
        common.ptod("slice: " + InstanceXlate.translateSliceToNumber("c0t0d0s6"));
        common.ptod("slice: " + InstanceXlate.translateSliceToNumber("c0t0d0s7"));
        common.ptod("slice: " + InstanceXlate.translateSliceToNumber("c0t0d0s8"));
        common.ptod("slice: " + InstanceXlate.translateSliceToNumber("c0t0d0s9"));
        common.ptod("slice: " + InstanceXlate.translateSliceToNumber("c0t0d0sa"));
        common.ptod("slice: " + InstanceXlate.translateSliceToNumber("c0t0d0sb"));
        common.ptod("slice: " + InstanceXlate.translateSliceToNumber("c0t0d0sc"));
        common.ptod("slice: " + InstanceXlate.translateSliceToNumber("c0t0d0sd"));
        common.ptod("slice: " + InstanceXlate.translateSliceToNumber("c0t0d0se"));
        common.ptod("slice: " + InstanceXlate.translateSliceToNumber("c0t0d0sf"));
        common.ptod("slice: " + InstanceXlate.translateSliceToNumber("c0t0d0pg"));
        common.ptod("slice: " + InstanceXlate.translateSliceToNumber("c0t0d0ph"));
        common.ptod("slice: " + InstanceXlate.translateSliceToNumber("c0t0d0pi"));
        common.ptod("slice: " + InstanceXlate.translateSliceToNumber("c0t0d0pj"));
        common.ptod("slice: " + InstanceXlate.translateSliceToNumber("c0t0d0pk"));
        common.ptod("slice: " + InstanceXlate.translateSliceToNumber("c0t0d0pl"));
        common.ptod("slice: " + InstanceXlate.translateSliceToNumber("c0t0d0pm"));
        common.ptod("slice: " + InstanceXlate.translateSliceToNumber("c0t0d0pn"));
        common.ptod("slice: " + InstanceXlate.translateSliceToNumber("c0t0d0po"));
        common.ptod("slice: " + InstanceXlate.translateSliceToNumber("c0t0d0pp"));
        common.ptod("slice: " + InstanceXlate.translateSliceToNumber("c0t0d0pq"));
        common.ptod("slice: " + InstanceXlate.translateSliceToNumber("c0t0d0pr"));
        common.ptod("slice: " + InstanceXlate.translateSliceToNumber("c0t0d0ps"));
    }

    public static Vector simulateLibdev() {
        int n;
        long l = System.currentTimeMillis();
        int n2 = 0;
        Vector<String> vector = new Vector<String>(256, 0);
        do {
            left_lines = new String[0];
            right_lines = new String[0];
            if (n2++ > 5) {
                common.failure("failed to get a stable configuration listing");
            }
            if ((left_lines = InstanceXlate.getIostatData("")) != null && (right_lines = InstanceXlate.getIostatData("n")) != null) continue;
        } while (left_lines.length != right_lines.length);
        if (common.get_debug(common.FAKE_LIBDEV)) {
            left_lines = Fget.readFileToArray("iostat_left");
            right_lines = Fget.readFileToArray("iostat_right");
        }
        for (n = 2; n < right_lines.length; ++n) {
            String string = left_lines[n];
            String string2 = right_lines[n];
            String string3 = string.substring(0, string.indexOf(" "));
            String string4 = string2.substring(string2.lastIndexOf(" ") + 1);
            if (string4.trim().length() == 0 || !string3.startsWith("sd") && !string3.startsWith("ssd") && !string3.startsWith("blkdev") && !string3.startsWith("flmdisk") && !string3.startsWith("ramdisk") && !string3.startsWith("dad") && !string3.startsWith("st") && !string3.startsWith("vdc") && !string3.startsWith("xdf") && !string3.startsWith("xvf") && !string3.startsWith("zvblk") && !string3.startsWith("cmdk") && !string3.startsWith("nfs")) continue;
            if (string4.indexOf(".fp") != -1) {
                string4 = string4.substring(0, string4.indexOf(".fp"));
            }
            if (string3.startsWith("nfs")) {
                vector.addElement(string4 + " " + string3);
                continue;
            }
            vector.addElement("/dev/rdsk/" + string4 + " " + string3);
        }
        if (common.get_debug(common.FAKE_LIBDEV)) {
            for (n = 0; n < vector.size(); ++n) {
                common.ptod("output:" + vector.elementAt(n));
            }
        }
        return vector;
    }

    public static int translateSliceToNumber(String string) {
        char c;
        char c2;
        if (string.indexOf("/") != -1) {
            prefix = string.substring(0, string.lastIndexOf("/") + 1);
            string = string.substring(string.lastIndexOf("/") + 1);
        }
        if ((c2 = string.charAt(string.length() - 2)) != 's' && c2 != 'p') {
            return -1;
        }
        if (c2 == 's') {
            noslice = string.substring(0, string.length() - 3);
            if (string.indexOf("s") != string.length() - 2) {
                return -1;
            }
            noslice = string.substring(0, string.length() - 2);
            c = string.charAt(string.length() - 1);
            if (c >= '0' && c <= '9') {
                return c - 48;
            }
            if (c >= 'a' && c <= 'f') {
                return c - 97 + 10;
            }
        }
        if (c2 == 'p') {
            if (string.indexOf("p") != string.length() - 2) {
                return -1;
            }
            noslice = string.substring(0, string.length() - 2);
            c = string.charAt(string.length() - 1);
            if (c >= 'g' && c <= 'z') {
                return c - 97 + 10;
            }
        }
        return -1;
    }

    public static void printIostat() {
        common.ptod("");
        common.ptod("");
        common.ptod("The translation of a proper device name (/dev/rdsk/cxtxdxsx) to a Kstat        ");
        common.ptod("instance name is done by combining the outputs of '/usr/bin/ls -rlL /dev/rdsk',");
        common.ptod("'/usr/bin/iostat -xpX', and '/usr/bin/iostat -xpXn', extracting device         ");
        common.ptod("major and minor names and kstat instance names.                                ");
        common.ptod("It appears that one or more device names could not be translated this way.     ");
        common.ptod("If this device name indeed does not show in the iostat output then proper      ");
        common.ptod("kstat statistics for this device are not available. This could be considered  ");
        common.ptod("a Solaris bug.                                                                 ");
        common.ptod("");
        common.ptod("See file 'logfile.html' for a copy of the iostat output");
        common.ptod("");
        int n = 0;
        for (int i = 0; i < left_lines.length; ++i) {
            n = Math.max(n, left_lines[i].length());
        }
        String string = "%-" + n + "s";
        common.plog("");
        common.plog(Format.f(string, "Output of '" + IO_STAT + "'") + "  |  " + Format.f(string, "Output of '" + IO_STAT + "n'"));
        common.plog(Format.f(string, "") + "  |  " + Format.f(string, ""));
        for (int i = 0; i < left_lines.length; ++i) {
            common.plog(Format.f(string, left_lines[i]) + "  |  " + Format.f(string, right_lines[i]).trim());
        }
    }

    public static void printAll() {
        int n = 0;
        for (int i = 0; i < left_lines.length; ++i) {
            n = Math.max(n, left_lines[i].length());
        }
        String string = "%-" + n + "s";
        common.ptod("");
        common.ptod(Format.f(string, "Output of '" + IO_STAT + "'") + "  |  " + Format.f(string, "Output of '" + IO_STAT + "n'"));
        common.ptod(Format.f(string, "") + "  |  " + Format.f(string, ""));
        for (int i = 0; i < left_lines.length; ++i) {
            common.ptod(Format.f(string, left_lines[i]) + "  |  " + Format.f(string, right_lines[i]).trim());
        }
    }

    private static String[] getIostatData(String string) {
        if (!common.get_debug(common.REUSE_IOSTAT)) {
            OS_cmd oS_cmd = OS_cmd.execute(IO_STAT + string);
            if (!oS_cmd.getRC()) {
                return null;
            }
            return oS_cmd.getStdout();
        }
        String string2 = ClassPath.classPath("reuse_iostat" + string + ".txt");
        if (Fget.file_exists(string2)) {
            return Fget.readFileToArray(string2);
        }
        OS_cmd oS_cmd = OS_cmd.execute(IO_STAT + string);
        if (!oS_cmd.getRC()) {
            return null;
        }
        Fput fput = new Fput(string2);
        String[] stringArray = oS_cmd.getStdout();
        for (int i = 0; i < stringArray.length; ++i) {
            fput.println(stringArray[i]);
        }
        fput.close();
        return stringArray;
    }
}

