/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Utils.Getopt;
import Utils.OS_cmd;
import Vdb.JmapStuff;
import Vdb.common;
import java.io.File;
import java.util.HashMap;

public class Jmap {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";
    private static HashMap<String, JmapStuff> map = new HashMap(1024);
    private static long total_heap = 0L;

    public static void main(String[] stringArray) {
        int n;
        String string;
        long l = 5L;
        long l2 = 1L;
        long l3 = 0x100000L;
        map.clear();
        String[] stringArray2 = new String[stringArray.length - 1];
        System.arraycopy(stringArray, 1, stringArray2, 0, stringArray2.length);
        stringArray = stringArray2;
        Getopt getopt = new Getopt(stringArray, "fgpm:k:l:s:d:", 1);
        getopt.print("Jmap");
        if (!getopt.isOK() || stringArray.length == 0 || getopt.get_positionals().size() != 1) {
            common.ptod("Usage: ./vdbench jmap [-s nn] [-l nn] [-k nn] [-p] pid");
            common.ptod("       '-l nn' : loop nn times, default one");
            common.ptod("       '-s nn' : sleep nn seconds, default 5");
            common.ptod("       '-k nn' : minimum total kb for data type, default 1024k");
            common.ptod("       '-m nn' : minimum total mb for data type, default 1024k");
            common.ptod("       '-p'    : Create jmap dump");
            return;
        }
        long l4 = getopt.get_pos_long(0);
        if (getopt.check('s')) {
            l = getopt.get_long();
        }
        if (getopt.check('l')) {
            l2 = getopt.get_long();
        }
        if (getopt.check('k')) {
            l3 = getopt.get_long() * 1024L;
        }
        if (getopt.check('m')) {
            l3 = getopt.get_long() * 1024L * 1024L;
        }
        if ((string = System.getProperty("java.home")).endsWith("/jre") || string.endsWith("\\jre")) {
            string = string.substring(0, string.length() - 4);
        }
        OS_cmd oS_cmd = new OS_cmd();
        oS_cmd.addQuot(string + File.separator + "bin" + File.separator + "jmap");
        if (getopt.check('f')) {
            oS_cmd.addText("-F");
        }
        if (getopt.check('g')) {
            oS_cmd.addText("-histo:live " + l4);
        } else {
            oS_cmd.addText("-histo " + l4);
        }
        oS_cmd.execute(true);
        oS_cmd.printStderr();
        String[] stringArray3 = oS_cmd.getStdout();
        for (n = 0; n < stringArray3.length; ++n) {
            String string2 = stringArray3[n].trim();
            if (string2.length() == 0 || string2.indexOf(":") == -1) continue;
            JmapStuff jmapStuff = new JmapStuff(string2);
            map.put(jmapStuff.name, jmapStuff);
        }
        n = 0;
        while (true) {
            int n2 = 0;
            long l5 = 0L;
            if (l2 > 1L) {
                oS_cmd = new OS_cmd();
                oS_cmd.addQuot(string + File.separator + "bin" + File.separator + "jmap");
                oS_cmd.addText("-histo " + l4);
                oS_cmd.execute(false);
                oS_cmd.printStderr();
                if (!oS_cmd.getRC()) break;
            }
            stringArray3 = oS_cmd.getStdout();
            for (int i = 0; i < stringArray3.length; ++i) {
                String string3 = stringArray3[i].trim();
                if (string3.indexOf("Total") != -1) {
                    common.ptod("Total bytes: %d mb", l5 / 0x100000L);
                    common.ptod("");
                    total_heap = l5;
                    break;
                }
                if (string3.indexOf(":") == -1) continue;
                JmapStuff jmapStuff = new JmapStuff(string3);
                JmapStuff jmapStuff2 = map.get(jmapStuff.name);
                map.put(jmapStuff.name, jmapStuff);
                if (jmapStuff2 == null) continue;
                jmapStuff.max_bytes = Math.max(jmapStuff.bytes, jmapStuff2.max_bytes);
                jmapStuff.max_inst = Math.max(jmapStuff.instances, jmapStuff2.max_inst);
                l5 += jmapStuff.bytes;
                if (jmapStuff.bytes < l3) continue;
                if (n2++ == 0) {
                    common.ptod("");
                    common.ptod("%14s %8s %10s %11s %10s %8s %s\n", "bytes", "mb", "count", "new_count", "instance", "delta_mb", "");
                }
                common.ptod("%,14d %8d %,10d %,11d %,10d %8d %s", jmapStuff.bytes, jmapStuff.bytes / 0x100000L, jmapStuff.instances, jmapStuff.instances - jmapStuff2.instances, jmapStuff.bytes / jmapStuff.instances, (jmapStuff.bytes - jmapStuff2.bytes) / 0x100000L, jmapStuff.name);
            }
            if ((long)(++n) >= l2) break;
            common.sleep_some(l * 1000L);
        }
        if (getopt.check('p')) {
            String string4 = Jmap.getJmapFile();
            String string5 = String.format("-dump:format=b,file=%s %d", string4, l4);
            oS_cmd = new OS_cmd();
            oS_cmd.addQuot(string + File.separator + "bin" + File.separator + "jmap");
            oS_cmd.addText(string5);
            oS_cmd.execute();
            oS_cmd.printStderr();
            oS_cmd.printStdout();
            common.ptod("Run 'jhat %s', and then enter 'http://localhost:7000' in your browser.", string4);
        }
    }

    private static String getJmapFile() {
        String[] stringArray = new File(".").list();
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string.equals("jdump") || !string.startsWith("jdump")) continue;
            int n2 = Integer.parseInt(string.substring(5));
            n = Math.max(n, n2);
        }
        return String.format("jdump%03d", n + 1);
    }

    public static void runJmap() {
        String[] stringArray = new String[]{"xx", common.getProcessIdString(), "-m0"};
        Jmap.main(stringArray);
    }

    public static void runJmapDump() {
        String[] stringArray = new String[]{"xx", common.getProcessIdString(), "-p", "-m0"};
        for (int i = 0; i < 10; ++i) {
            System.gc();
        }
        Jmap.main(stringArray);
    }

    public static long getTotalHeap() {
        return total_heap;
    }
}

