/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Utils.Format;
import Vdb.DV_map;
import Vdb.Dedup;
import Vdb.Elapsed;
import Vdb.Errno;
import Vdb.ErrorLog;
import Vdb.FileAnchor;
import Vdb.File_handles;
import Vdb.FwdEntry;
import Vdb.HelpDebug;
import Vdb.JournalThread;
import Vdb.Native;
import Vdb.OpenFlags;
import Vdb.Operations;
import Vdb.RD_entry;
import Vdb.SD_entry;
import Vdb.SlaveJvm;
import Vdb.SlaveWorker;
import Vdb.SocketMessage;
import Vdb.Validate;
import Vdb.Vdbmain;
import Vdb.VerifyPending;
import Vdb.WD_entry;
import Vdb.common;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Vector;

public class Jnl_entry {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";
    private String jnl_name;
    private String sd_or_fsd;
    private DV_map current_map;
    private long jnl_handle;
    private long map_handle;
    private long jnl_offset;
    private String jnl_dir_name;
    private String map_file_name;
    public String jnl_file_name;
    private int[] jnl_array = new int[256];
    private int jnl_index = 0;
    private long jnl_native_buffer;
    private OpenFlags open_flags = new OpenFlags();
    public FileAnchor recovery_anchor = null;
    private long dump_journal_tod;
    public DV_map before_map = null;
    private long journal_max;
    private HashMap<Long, Integer> pending_writes = null;
    private static boolean JOURNAL_ADD_TIMESTAMP = false;
    private static int JNL_IO_SIZE = 512;
    private static int JNL_IO_SIZE_EOF = 1024;
    private static int JNL_ENTSIZE = 8;
    public static int JNL_ENT_INTS = JNL_ENTSIZE / 4;
    private static int MAP_HDR_SIZE = 32;
    public static int MAP_SKIP_HDR = MAP_HDR_SIZE / 4;
    public static int JNL_HDR_SIZE = 16;
    public static int JNL_SKIP_HDR = 4;
    public static int JNL_ENTRIES = (JNL_IO_SIZE - JNL_HDR_SIZE) / JNL_ENTSIZE;
    public static int MAP_EYE_CATCHER;
    public static int JNL_EYE_CATCHER;
    static String RECOVERY_RUN_NAME;

    Jnl_entry(String string, String string2, String string3) {
        this.sd_or_fsd = string3;
        this.jnl_name = string;
        this.jnl_dir_name = string2;
        this.journal_max = Validate.getMaxJournal();
        if (this.journal_max != Long.MAX_VALUE) {
            this.pending_writes = new HashMap(1024);
        }
        common.ptod("Allocating a new Journal file for %s=%s", this.sd_or_fsd, this.jnl_name);
        if (this.jnl_dir_name != null) {
            if (Jnl_entry.isRawJournal(this.jnl_dir_name)) {
                this.map_file_name = this.jnl_name + ".map";
                this.jnl_file_name = this.jnl_dir_name;
            } else {
                this.map_file_name = this.jnl_dir_name + File.separator + this.jnl_name + ".map";
                this.jnl_file_name = this.jnl_dir_name + File.separator + this.jnl_name + ".jnl";
            }
        } else {
            this.jnl_dir_name = ".";
            this.map_file_name = this.jnl_name + ".map";
            this.jnl_file_name = this.jnl_name + ".jnl";
        }
        this.map_file_name = new File(this.map_file_name).getAbsolutePath();
        this.jnl_file_name = new File(this.jnl_file_name).getAbsolutePath();
        this.jnl_native_buffer = Native.allocBuffer(JNL_IO_SIZE_EOF);
        if (!Validate.isJournalRecovery() || Validate.isJournalRecovered()) {
            new File(this.map_file_name).delete();
            if (!Jnl_entry.isRawJournal(this.jnl_file_name)) {
                new File(this.jnl_file_name).delete();
            }
        }
        Jnl_entry.plog("Creating journal file %s", this.jnl_file_name);
        this.openFiles(true);
    }

    public static void overrideConstants() {
        JOURNAL_ADD_TIMESTAMP = common.get_debug(common.JOURNAL_ADD_TIMESTAMP);
        if (!JOURNAL_ADD_TIMESTAMP) {
            return;
        }
        JNL_ENTSIZE = 16;
        JNL_ENT_INTS = JNL_ENTSIZE / 4;
        JNL_ENTRIES = (JNL_IO_SIZE - JNL_HDR_SIZE) / JNL_ENTSIZE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.jnl_handle != 0L) {
                File_handles.remove(this.jnl_handle);
                File_handles.remove(this.map_handle);
                Native.closeFile(this.jnl_handle);
                Native.closeFile(this.map_handle);
                Native.freeBuffer(JNL_IO_SIZE_EOF, this.jnl_native_buffer);
            }
        }
        finally {
            super.finalize();
        }
    }

    public static void closeAllMaps() {
        for (DV_map dV_map : DV_map.getAllMaps()) {
            Jnl_entry jnl_entry = dV_map.journal;
            if (jnl_entry == null) continue;
            File_handles.remove(jnl_entry.jnl_handle);
            File_handles.remove(jnl_entry.map_handle);
            Native.closeFile(jnl_entry.jnl_handle);
            Native.closeFile(jnl_entry.map_handle);
            Native.freeBuffer(JNL_IO_SIZE_EOF, jnl_entry.jnl_native_buffer);
        }
    }

    public void storeMap(DV_map dV_map) {
        this.current_map = dV_map;
    }

    public static void setupSDJournalRecoveryRun() {
        for (int i = 0; i < Vdbmain.sd_list.size(); ++i) {
            SD_entry sD_entry = Vdbmain.sd_list.elementAt(i);
            WD_entry wD_entry = new WD_entry();
            Vdbmain.wd_list.add(wD_entry);
            wD_entry.wd_name = RECOVERY_RUN_NAME + "_" + sD_entry.sd_name;
            wD_entry.wd_sd_name = sD_entry.sd_name;
            wD_entry.sd_names = new String[]{sD_entry.sd_name};
            wD_entry.setSkew(0.0);
            wD_entry.lowrange = -1.0;
            wD_entry.highrange = -1.0;
            wD_entry.seekpct = -1.0;
            wD_entry.rhpct = 0.0;
            wD_entry.whpct = 0.0;
            wD_entry.readpct = 100.0;
            wD_entry.xf_table = new double[0];
        }
        RD_entry rD_entry = new RD_entry();
        Vdbmain.rd_list.insertElementAt(rD_entry, 0);
        rD_entry.rd_name = RECOVERY_RUN_NAME;
        rD_entry.setNoElapsed();
        rD_entry.setInterval(1L);
        rD_entry.distribution = 2;
        rD_entry.iorate = RD_entry.MAX_RATE;
        rD_entry.iorate_req = RD_entry.MAX_RATE;
        rD_entry.wd_names = new String[1];
        rD_entry.wd_names[0] = RECOVERY_RUN_NAME + "*";
    }

    public static void setupFsdJournalRecoveryRun() {
        FwdEntry fwdEntry = new FwdEntry();
        FwdEntry.getFwdList().add(fwdEntry);
        fwdEntry.fwd_name = RECOVERY_RUN_NAME;
        fwdEntry.fsd_names = new String[]{"*"};
        fwdEntry.setOperation(Operations.READ);
        fwdEntry.sequential_io = true;
        fwdEntry.select_random = false;
        fwdEntry.xfersizes = new double[]{131072.0};
        fwdEntry.threads = 8;
        if (FwdEntry.recovery_fwd != null) {
            fwdEntry.xfersizes = FwdEntry.recovery_fwd.xfersizes;
            fwdEntry.threads = FwdEntry.recovery_fwd.threads;
        }
        RD_entry rD_entry = new RD_entry();
        Vdbmain.rd_list.insertElementAt(rD_entry, 0);
        rD_entry.rd_name = RECOVERY_RUN_NAME;
        rD_entry.setNoElapsed();
        rD_entry.setInterval(1L);
        rD_entry.distribution = 2;
        rD_entry.fwd_rate = RD_entry.MAX_RATE;
        if (RD_entry.recovery_rd != null) {
            rD_entry.setInterval(RD_entry.recovery_rd.getInterval());
            rD_entry.fwd_rate = RD_entry.recovery_rd.fwd_rate;
        }
        rD_entry.fwd_names = new String[]{RECOVERY_RUN_NAME};
    }

    private void openFiles(boolean bl) {
        OpenFlags openFlags = null;
        if (common.onSolaris()) {
            openFlags = new OpenFlags(new String[]{"o_sync"}, null);
        } else if (common.onLinux()) {
            openFlags = new OpenFlags(new String[]{"o_sync"}, null);
        } else if (common.onWindows()) {
            openFlags = new OpenFlags(new String[]{"directio"}, null);
        } else if (common.onAix()) {
            openFlags = new OpenFlags(new String[]{"directio"}, null);
        } else {
            common.failure("Synchronous i/o options needed for Journaling currently only known for Solaris, Linux, AIX, and Windows. Contact me at the Oracle Vdbench Forum.");
        }
        OpenFlags openFlags2 = openFlags;
        if (bl || !Validate.isJournalFlush()) {
            openFlags2 = new OpenFlags();
        }
        if (this.jnl_handle != 0L && this.open_flags.equals(openFlags2)) {
            return;
        }
        if (this.jnl_handle != 0L) {
            File_handles.remove(this.jnl_handle);
            File_handles.remove(this.map_handle);
            Native.closeFile(this.jnl_handle);
            Native.closeFile(this.map_handle);
        }
        this.open_flags = openFlags2;
        this.jnl_handle = Native.openFile(this.jnl_file_name, this.open_flags, 1);
        if (this.jnl_handle == -1L) {
            common.failure("Open failed for '" + this.jnl_file_name + "'");
        }
        if ((this.map_handle = Native.openFile(this.map_file_name, this.open_flags, 1)) == -1L) {
            common.failure("Open failed for '" + this.map_file_name + "'");
        }
        File_handles.addHandle(this.jnl_handle, this.jnl_file_name);
        File_handles.addHandle(this.map_handle, this.map_file_name);
    }

    public static void dumpAllMaps(boolean bl) {
        if (!Validate.isJournaling()) {
            return;
        }
        if (bl && common.get_debug(common.DONT_DUMP_MAPS)) {
            if (!SlaveWorker.work.format_run) {
                Jnl_entry.plog("dumpAllMaps(): request ignored due to 'DONT_DUMP_MAPS'", new Object[0]);
                return;
            }
            Jnl_entry.plog("dumpAllMaps(): 'DONT_DUMP_MAPS' request ignored because this is a format run", new Object[0]);
        }
        if (!SlaveWorker.work.format_run && bl && HelpDebug.hasRequest("dumpAllMaps")) {
            Jnl_entry.plog("dumpAllMaps(): request ignored due to 'HelpDebug request'", new Object[0]);
            return;
        }
        for (DV_map dV_map : DV_map.getAllMaps()) {
            if (dV_map.journal == null) continue;
            dV_map.journal.dumpOneMap(dV_map);
            dV_map.setAllUnBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpOneMap(DV_map dV_map) {
        DV_map dV_map2 = dV_map;
        synchronized (dV_map2) {
            this.dump_journal_tod = System.currentTimeMillis();
            this.openFiles(true);
            Jnl_entry.plog("Writing Data Validation map to " + File_handles.getFileName(this.jnl_handle), new Object[0]);
            this.jnl_dump_map(this.jnl_handle, dV_map, this.jnl_file_name);
            Jnl_entry.plog("Writing Data Validation map to " + File_handles.getFileName(this.map_handle), new Object[0]);
            this.jnl_dump_map(this.map_handle, dV_map, this.map_file_name);
            this.openFiles(false);
            this.jnl_index = 0;
        }
    }

    public static void jnl_read(long l, long l2, long l3, long l4, int[] nArray, int n) throws Exception {
        long l5 = Native.readFile(l, l2, l3, l4);
        if (l5 != 0L) {
            throw new Exception("Journal read failed: " + Errno.xlate_errno(l5));
        }
        Native.buffer_to_array(nArray, l4, 512);
        if (nArray[0] != n) {
            String string = File_handles.getFileName(l);
            common.ptod("Journal file lba: 0x%08x", l2);
            if (n == MAP_EYE_CATCHER && nArray[0] == JNL_EYE_CATCHER) {
                common.failure("Expecting MAP record but receiving JNL record from %s", string);
            }
            if (n == JNL_EYE_CATCHER && nArray[0] == MAP_EYE_CATCHER) {
                common.failure("Expecting JNL record but receiving MAP record from %s", string);
            }
            if (n == MAP_EYE_CATCHER) {
                common.failure("Expecting MAP record but receiving unknown 0x%08x record from %s", nArray[0], string);
            }
            if (n == JNL_EYE_CATCHER) {
                common.failure("Expecting JNL record but receiving unknown 0x%08x record from %s", nArray[0], string);
            }
            common.failure("Receiving unknown 0x%08x record", nArray[0]);
        }
    }

    public static void jnl_write(long l, long l2, long l3, long l4) {
        long l5 = Native.writeFile(l, l2, l3, l4);
        if (l5 != 0L) {
            common.failure("Journal write failed: " + Errno.xlate_errno(l5));
        }
    }

    private void writeJournalRecord() {
        this.jnl_array[0] = JNL_EYE_CATCHER;
        this.jnl_array[1] = this.jnl_index;
        this.jnl_array[2] = (int)this.jnl_offset / 512;
        this.jnl_array[3] = (int)this.dump_journal_tod;
        if (this.jnl_index < JNL_ENTRIES) {
            Native.arrayToBuffer(this.jnl_array, this.jnl_native_buffer);
            Jnl_entry.jnl_write(this.jnl_handle, this.jnl_offset, 512L, this.jnl_native_buffer);
        } else {
            this.jnl_array[128] = JNL_EYE_CATCHER;
            this.jnl_array[129] = 0;
            this.jnl_array[130] = (int)this.jnl_offset / 512;
            this.jnl_array[131] = (int)this.dump_journal_tod;
            Native.arrayToBuffer(this.jnl_array, this.jnl_native_buffer);
            Jnl_entry.jnl_write(this.jnl_handle, this.jnl_offset, 1024L, this.jnl_native_buffer);
            this.jnl_offset += 512L;
            this.jnl_index = 0;
            if (this.jnl_offset % 0x6400000L == 0L) {
                common.ptod("Journal file " + this.jnl_file_name + " is now " + this.jnl_offset / 0x100000L + "mb");
            }
        }
    }

    public synchronized void writeJournalEntry(int n, long l, boolean bl) {
        if (this.jnl_index == JNL_ENTRIES) {
            common.failure("Invalid jnl_index: " + this.jnl_index);
        }
        long l2 = (long)n << 56 | l;
        this.jnl_array[Jnl_entry.JNL_SKIP_HDR + this.jnl_index * Jnl_entry.JNL_ENT_INTS + 0] = Jnl_entry.left32(l2);
        this.jnl_array[Jnl_entry.JNL_SKIP_HDR + this.jnl_index * Jnl_entry.JNL_ENT_INTS + 1] = Jnl_entry.right32(l2);
        if (JOURNAL_ADD_TIMESTAMP) {
            long l3 = System.currentTimeMillis();
            this.jnl_array[Jnl_entry.JNL_SKIP_HDR + this.jnl_index * Jnl_entry.JNL_ENT_INTS + 2] = Jnl_entry.left32(l3);
            this.jnl_array[Jnl_entry.JNL_SKIP_HDR + this.jnl_index * Jnl_entry.JNL_ENT_INTS + 3] = Jnl_entry.right32(l3);
        }
        ++this.jnl_index;
        if (bl || this.jnl_index >= JNL_ENTRIES) {
            this.writeJournalRecord();
        }
        if (this.pending_writes == null || (n & Integer.MIN_VALUE) != 0) {
            return;
        }
        if (n != 0) {
            if (this.pending_writes.put(l, n) != null) {
                common.failure("Received duplicate 'i/o pending' status for block: %,d key: %d", l, n);
            }
        } else if (this.pending_writes.remove(l) == null) {
            common.failure("Pending write removing unknown block: %,d", l);
        }
        if (this.jnl_offset < this.journal_max) {
            return;
        }
        Jnl_entry.plog("'journal_max' reached. Clearing journal file for %s", this.sd_or_fsd);
        this.dumpOneMap(this.current_map);
        Long[] longArray = this.pending_writes.keySet().toArray(new Long[0]);
        for (int i = 0; i < longArray.length; ++i) {
            long l4 = longArray[i];
            boolean bl2 = i == longArray.length - 1;
            this.writeJournalEntry((int)(this.pending_writes.get(l4) | Integer.MIN_VALUE), l4, bl2);
        }
    }

    public void jnl_dump_map(long l, DV_map dV_map, String string) {
        Elapsed elapsed = new Elapsed("jnl_dump_map of " + string, 500000L);
        this.jnl_array[0] = MAP_EYE_CATCHER;
        this.jnl_array[1] = -1;
        this.jnl_array[2] = Jnl_entry.left32(dV_map.key_blocks);
        this.jnl_array[3] = Jnl_entry.right32(dV_map.key_blocks);
        this.jnl_array[4] = dV_map.getKeyBlockSize();
        this.jnl_array[5] = Jnl_entry.left32(this.dump_journal_tod);
        this.jnl_array[6] = Jnl_entry.right32(this.dump_journal_tod);
        this.jnl_array[7] = JOURNAL_ADD_TIMESTAMP ? 1 : 0;
        this.jnl_array[8] = SlaveJvm.getOwnerId();
        Native.arrayToBuffer(this.jnl_array, this.jnl_native_buffer);
        Jnl_entry.jnl_write(l, 0L, 512L, this.jnl_native_buffer);
        ArrayList<Thread> arrayList = new ArrayList<Thread>(8);
        long l2 = 1073741760L;
        for (long i = 0L; i < dV_map.key_blocks; i += l2) {
            long l3 = Math.min(l2, dV_map.key_blocks - i);
            common.ptod("Starting JournalThread for key block %,16d to %,16d", i, i + l3);
            JournalThread journalThread = new JournalThread(this, dV_map, l, i, l3, dV_map.getKeyBlockSize(), false);
            journalThread.start();
            arrayList.add(journalThread);
        }
        JournalThread.waitForList(arrayList);
        this.jnl_offset = 512L;
        this.jnl_offset += (dV_map.key_blocks + 511L) / 480L * 512L;
        this.jnl_array[0] = JNL_EYE_CATCHER;
        this.jnl_array[1] = 0;
        this.jnl_array[2] = (int)this.jnl_offset / 512;
        this.jnl_array[3] = Jnl_entry.right32(this.dump_journal_tod);
        Native.arrayToBuffer(this.jnl_array, this.jnl_native_buffer);
        Jnl_entry.jnl_write(l, this.jnl_offset, 512L, this.jnl_native_buffer);
        this.jnl_array[0] = MAP_EYE_CATCHER;
        this.jnl_array[1] = MAP_EYE_CATCHER;
        this.jnl_array[2] = Jnl_entry.left32(dV_map.key_blocks);
        this.jnl_array[3] = Jnl_entry.right32(dV_map.key_blocks);
        this.jnl_array[4] = dV_map.getKeyBlockSize();
        this.jnl_array[5] = Jnl_entry.left32(this.dump_journal_tod);
        this.jnl_array[6] = Jnl_entry.right32(this.dump_journal_tod);
        this.jnl_array[7] = JOURNAL_ADD_TIMESTAMP ? 1 : 0;
        this.jnl_array[8] = SlaveJvm.getOwnerId();
        Native.arrayToBuffer(this.jnl_array, this.jnl_native_buffer);
        Jnl_entry.jnl_write(l, 0L, 512L, this.jnl_native_buffer);
        elapsed.end(5);
    }

    private static int left32(long l) {
        return (int)(l >>> 32);
    }

    private static int right32(long l) {
        return (int)l;
    }

    private static long not_used_make64Key(long l, int n, int n2) {
        return Jnl_entry.make64(n, n2) | l << 56;
    }

    public static long make64(int n, int n2) {
        long l = (long)n << 32;
        return l |= (long)n2 & 0xFFFFFFFFL;
    }

    public static int getKey(long l) {
        return (int)(l >> 56 & 0xFFL);
    }

    public static long getBlock(long l) {
        return l & 0xFFFFFFFFFFFFL;
    }

    private DV_map restoreMap(String string, long l, String string2, long l2, String string3) {
        Elapsed elapsed = new Elapsed("DV_map.restoreMap of " + string2, 500000L);
        try {
            Jnl_entry.jnl_read(l, 0L, 512L, this.jnl_native_buffer, this.jnl_array, MAP_EYE_CATCHER);
        }
        catch (Exception exception) {
            common.ptod("Error while restoring the journal map. Journal likely is corrupted");
            common.ptod(exception);
            common.failure(exception);
        }
        long l3 = Jnl_entry.make64(this.jnl_array[2], this.jnl_array[3]);
        int n = this.jnl_array[4];
        if (this.jnl_array[0] != MAP_EYE_CATCHER) {
            for (int i = 0; i < 8; ++i) {
                common.ptod(Format.f("block: %08x", this.jnl_array[i]));
            }
            common.failure("Invalid contents on journal or map file: " + Format.f("%08x", this.jnl_array[0]));
        }
        if (this.jnl_array[1] != MAP_EYE_CATCHER) {
            return null;
        }
        if (this.jnl_array[7] == 1) {
            common.set_debug(common.JOURNAL_ADD_TIMESTAMP);
            Jnl_entry.overrideConstants();
        }
        SlaveJvm.setOwnerId(this.jnl_array[8]);
        if (l2 / (long)n != l3) {
            String string4 = string2 + " Journal recovery failed. \nJournal contains xfersize " + n + " and contains " + l3 + " blocks, " + "for a total size of " + l3 * (long)n + " bytes." + "\nThis does not match the size of " + string3 + " which is " + l2 + " bytes";
            ErrorLog.ptod(string4, new Object[0]);
            common.failure("Journal recovery failed");
        }
        DV_map dV_map = DV_map.allocateMap(string, string2, l2, n);
        this.storeMap(dV_map);
        dV_map.journal = this;
        ArrayList<Thread> arrayList = new ArrayList<Thread>(8);
        long l4 = 1073741760L;
        for (long i = 0L; i < l3; i += l4) {
            long l5 = Math.min(l4, l3 - i);
            common.ptod("Starting JournalThread for key block %,16d to %,16d", i, i + l5);
            JournalThread journalThread = new JournalThread(this, dV_map, l, i, l5, n, true);
            journalThread.start();
            arrayList.add(journalThread);
        }
        JournalThread.waitForList(arrayList);
        this.jnl_offset = 512L;
        this.jnl_offset += (l3 + 511L) / 480L * 512L;
        return dV_map;
    }

    public static void recoverSDJournalsIfNeeded(Vector vector) {
        if (!Validate.isJournalRecovery() || Validate.isJournalRecovered()) {
            SlaveJvm.sendMessageToMaster(SocketMessage.ONE_TIME_STATUS, "Data Validation Owner ID: " + SlaveJvm.getOwnerId());
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            SD_entry sD_entry = (SD_entry)vector.elementAt(i);
            if (sD_entry.journal_recovery_complete) continue;
            Jnl_entry jnl_entry = new Jnl_entry(sD_entry.sd_name, sD_entry.jnl_dir_name, "sd");
            DV_map dV_map = jnl_entry.recoverOneMap(sD_entry.jnl_dir_name, sD_entry.sd_name, sD_entry.end_lba, sD_entry.lun);
            int n = dV_map.determineJnlRecoveryXfersize(sD_entry.getMaxSdXfersize());
            sD_entry.trackSdXfersizes(new double[]{n});
            sD_entry.wg_for_sd.setXfersizes(new double[]{n});
            sD_entry.wg_for_sd.mcontext.next_seq = -1L;
            sD_entry.wg_for_sd.mcontext.seek_low = sD_entry.canWeUseBlockZero() ? 0L : (long)dV_map.getKeyBlockSize();
        }
    }

    public DV_map recoverOneMap(String string, String string2, long l, String string3) {
        Object object;
        ErrorLog.ptod("Starting journal recovery for " + string2, new Object[0]);
        if (!Jnl_entry.isRawJournal(this.jnl_file_name)) {
            object = new File(this.jnl_file_name);
            if (!((File)object).exists()) {
                common.failure("Journal recovery file does not exist: " + this.jnl_file_name);
            }
            if (!((File)(object = new File(this.map_file_name))).exists()) {
                common.failure("Journal map file does not exist: " + this.map_file_name);
            }
        }
        Jnl_entry.plog("Restoring Data Validation map from: " + this.jnl_file_name, new Object[0]);
        object = this.restoreMap(string, this.jnl_handle, string2, l, string3);
        if (object == null) {
            Jnl_entry.plog("The last map dump to %s failed. Falling back to backup ", this.jnl_file_name);
            Jnl_entry.plog("Restoring Data Validation map from: " + this.map_file_name, new Object[0]);
            object = this.restoreMap(string, this.map_handle, string2, l, string3);
            if (object == null) {
                common.failure("Invalid journal map file ");
            }
        }
        this.applyJournal(string);
        ErrorLog.ptod("Completed journal recovery for %s. Starting data validation.", string2);
        return object;
    }

    public static boolean isRawJournal(String string) {
        if (string == null) {
            return false;
        }
        return string.startsWith("/dev/") || string.startsWith("\\\\");
    }

    private void applyJournal(String string) {
        int n;
        boolean bl = false;
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        Elapsed elapsed = new Elapsed("applyJournal", 100000000L);
        this.before_map = new DV_map(string, this.current_map.map_name + ".before", this.current_map.key_blocks, this.current_map.getKeyBlockSize());
        this.before_map.recovery_anchor = this.recovery_anchor;
        ErrorLog.plog("Applying journal records from " + this.jnl_file_name, new Object[0]);
        do {
            if (bl) {
                common.ptod("jnl_offset: %,16d", this.jnl_offset);
            }
            this.jnl_read_next_record(this.jnl_offset);
            this.jnl_offset += 512L;
            elapsed.track(480L);
            n = this.jnl_array[1];
            if (bl) {
                common.ptod("blocks_in_record: " + n);
            }
            for (int i = 0; i < n; ++i) {
                long l4 = Jnl_entry.make64(this.jnl_array[JNL_SKIP_HDR + i * JNL_ENT_INTS + 0], this.jnl_array[JNL_SKIP_HDR + i * JNL_ENT_INTS + 1]);
                int n2 = Jnl_entry.getKey(l4);
                long l5 = Jnl_entry.getBlock(l4) * (long)this.current_map.getKeyBlockSize();
                if (bl) {
                    common.ptod("newkey: %02x", n2);
                }
                if (bl && n2 != 0) {
                    common.ptod("before: lba %08x key %02x", l5, n2);
                }
                if (bl && n2 == 0) {
                    common.ptod("after:  lba %08x key %02x", l5, n2);
                }
                if (n2 == 127) {
                    ++l3;
                    this.before_map.dv_set_nolock(l5, 127);
                    continue;
                }
                if (n2 != 0) {
                    ++l;
                    if (this.before_map.dv_get_nolock(l5) != 0) {
                        common.ptod("lba:                    %08x", l5);
                        common.ptod("before_map.dv_get(lba): " + this.before_map.dv_get(l5));
                        common.ptod("newkey:                 " + n2);
                        common.failure("Journal recovery: unmatched pending 'before' record found.");
                    }
                    if (this.current_map.dv_get_nolock(l5) == 0) {
                        if (bl) {
                            common.ptod("old key 0, before_map set to pending. lba: %08x", l5);
                        }
                        this.before_map.dv_set_nolock(l5, 128);
                    } else if (this.current_map.dv_get_nolock(l5) == 126) {
                        if (bl) {
                            common.ptod("old key 0, before_map set to pending. lba: %08x", l5);
                        }
                        this.before_map.dv_set_nolock(l5, 130);
                        if (n2 != 1) {
                            common.failure("Expecting DV key 1 for lba %08x", l5);
                        }
                    } else if (this.current_map.dv_get_nolock(l5) > n2) {
                        if (!Dedup.isDedup()) {
                            common.failure("Out of sync data validation key %02x/%02x found in journal for lba 0x%08x", this.current_map.dv_get_nolock(l5), n2, l5);
                        }
                        if (bl) {
                            common.ptod("old key 0, before_map set to pending. lba: %08x", l5);
                        }
                        this.before_map.dv_set_nolock(l5, 131);
                    } else {
                        if (bl) {
                            common.ptod("old key 0x%02x lba: %08x", this.current_map.dv_get_nolock(l5), l5);
                        }
                        this.before_map.dv_set_nolock(l5, 129);
                    }
                    this.current_map.dv_set_nolock(l5, n2);
                    if (!bl) continue;
                    common.ptod("set current key 0x%02x lba: %08x", n2, l5);
                    continue;
                }
                ++l2;
                this.before_map.dv_set_nolock(l5, 0);
                if (!bl) continue;
                common.ptod("Reset before map lba: %08x", l5);
            }
        } while (n >= JNL_ENTRIES);
        elapsed.end(5);
        Jnl_entry.plog("Completed apply of journal records (before/after): " + l + "/" + l2, new Object[0]);
        if (l2 > l) {
            common.failure("Unexpected before/after count. 'After' may not be greater than 'before'");
        }
        if (l + l2 > 0L) {
            if (this.sd_or_fsd.equals("sd")) {
                VerifyPending.findPendingBlocks(this.before_map, this.current_map, this.sd_or_fsd, this.jnl_name);
            } else {
                VerifyPending.findPendingBlocks(this.before_map, this.current_map, this.sd_or_fsd, this.jnl_name);
                VerifyPending.checkFsdPendingBlocks(this.recovery_anchor, this.before_map);
            }
        }
    }

    private void jnl_read_next_record(long l) {
        try {
            Jnl_entry.jnl_read(this.jnl_handle, l, 512L, this.jnl_native_buffer, this.jnl_array, JNL_EYE_CATCHER);
        }
        catch (Exception exception) {
            common.ptod("Error while reading journal records.");
            common.ptod("This very likely means that the storage or file system where ");
            common.ptod("you wrote the journal was corrupted due to the writes of the ");
            common.ptod("journal records NOT being done synchronously");
            common.ptod(exception);
            common.failure(exception);
        }
    }

    public static void plog(String string, Object ... objectArray) {
        ErrorLog.plog(String.format(string, objectArray), new Object[0]);
    }

    public static void main(String[] stringArray) {
        long l = 0L;
        boolean bl = false;
        long l2 = 0L;
        long l3 = 0L;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss.SSS zzz");
        for (int i = 0; i < stringArray.length; ++i) {
            long l4 = Native.allocBuffer(512);
            int[] nArray = new int[128];
            common.ptod("args[x]: " + stringArray[i]);
            long l5 = Native.openFile(stringArray[i], 0);
            long l6 = new File(stringArray[i]).length();
            long l7 = -1L;
            long l8 = 0L;
            boolean bl2 = false;
            int n = 0;
            int n2 = 0;
            boolean bl3 = false;
            for (long j = 0L; j < Long.MAX_VALUE; ++j) {
                int n3;
                if (l8 >= l6) {
                    common.ptod("Trying to go beyond journal file size");
                    break;
                }
                if (Native.readFile(l5, l8, 512L, l4) != 0L) {
                    common.ptod("read error");
                    break;
                }
                Native.buffer_to_array(nArray, l4, 512);
                if (nArray[0] == MAP_EYE_CATCHER) {
                    if (nArray[7] == 1) {
                        common.set_debug(common.JOURNAL_ADD_TIMESTAMP);
                        Jnl_entry.overrideConstants();
                    }
                    if (j == 0L) {
                        long l9 = (long)nArray[4] << 32;
                        l = nArray[5];
                        common.ptod("dump_journal_tod:  %016x %s", l9 += (long)nArray[5], new Date(l9));
                        common.ptod("saved_journal_tod: %08x", l);
                        common.ptod("Owner ID:              " + nArray[8]);
                    }
                    if (l7 < 0L) {
                        l7 = nArray[4];
                    }
                    l8 += 512L;
                    continue;
                }
                if (nArray[0] == JNL_EYE_CATCHER && !bl) {
                    bl = true;
                    common.ptod("Start of JNL records: %012x", l8);
                }
                if ((n3 = nArray[1]) == 0) break;
                for (int k = 0; k < n3; ++k) {
                    int n4 = nArray[JNL_SKIP_HDR + k * JNL_ENT_INTS + 0] >>> 56;
                    long l10 = (long)nArray[JNL_SKIP_HDR + k * JNL_ENT_INTS + 1] * l7;
                    if (JOURNAL_ADD_TIMESTAMP) {
                        long l11 = Jnl_entry.make64(nArray[JNL_SKIP_HDR + k * JNL_ENT_INTS + 2], nArray[JNL_SKIP_HDR + k * JNL_ENT_INTS + 3]);
                        String string = simpleDateFormat.format(new Date(l11));
                        if (n4 != 0) {
                            common.ptod("before: key: 0x%02x lba: %012x tod: %s", n4, l10, string);
                        } else {
                            common.ptod("after:            lba: %012x tod: %s", l10, string);
                        }
                    }
                    ++n;
                    if (!bl3) continue;
                    ++n2;
                }
                if (n3 != JNL_ENTRIES) {
                    if (n != 0) {
                        common.ptod("Found EOF after %6d journal records at seek: %08x ", n, l8);
                    }
                    n = 0;
                    bl3 = true;
                    common.ptod("Found EOF after %6d journal records at seek: %08x ", n, l8);
                }
                l8 += 512L;
            }
            common.ptod("after_eof: " + n2);
            common.ptod("map_lba: " + l2);
            common.ptod("map_lba: " + l2 * 4096L);
            Native.closeFile(l5);
        }
    }

    static {
        Jnl_entry.overrideConstants();
        MAP_EYE_CATCHER = 1296125998;
        JNL_EYE_CATCHER = 1246645294;
        RECOVERY_RUN_NAME = "journal_recovery";
    }
}

