/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Utils.Fget;
import Utils.Fput;
import Utils.Getopt;
import Utils.OS_cmd;
import Vdb.common;
import java.io.File;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.Vector;

public class Jstack {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";
    String pid;
    String program;
    static Vector programs = new Vector(64, 0);
    static String jstack = null;
    private static Fput fp = null;
    private static boolean skip_streams = false;
    static int count = 1;
    static String[] lines;
    static int index;

    public Jstack(String string, String string2) {
        this.pid = string;
        this.program = string2;
    }

    private static void getPrograms() {
        if (common.onSolaris()) {
            Jstack.runSolaris();
        } else if (common.onLinux()) {
            Jstack.runSolaris();
        } else if (common.onWindows()) {
            Jstack.runWindows();
        } else {
            common.failure("Vdbench jstack: Current platform not supported (yet?)");
        }
    }

    private static void runSolaris() {
        OS_cmd oS_cmd = new OS_cmd();
        oS_cmd.addText("ps -ef");
        oS_cmd.setStdout();
        oS_cmd.execute();
        if (!oS_cmd.getRC()) {
            common.failure("Error executing 'ps -ef'");
        }
        String[] stringArray = oS_cmd.getStdout();
        for (int i = 0; i < stringArray.length; ++i) {
            StringTokenizer stringTokenizer;
            String string = stringArray[i].toLowerCase();
            if (string.indexOf("java") == -1 || string.indexOf("jstack") != -1 || (stringTokenizer = new StringTokenizer(string)).countTokens() < 8) continue;
            stringTokenizer.nextToken();
            String string2 = stringTokenizer.nextToken();
            stringTokenizer.nextToken();
            stringTokenizer.nextToken();
            stringTokenizer.nextToken();
            stringTokenizer.nextToken();
            stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            String string4 = string.substring(string.indexOf(string3));
            Jstack.print("program: pid=" + string2 + " " + string4);
            if (Integer.parseInt(string2) == common.getProcessId()) {
                common.ptod("Skipping myself 1");
                continue;
            }
            Jstack jstack = new Jstack(string2, string4);
            programs.add(jstack);
        }
    }

    private static void runWindows() {
        OS_cmd oS_cmd = new OS_cmd();
        oS_cmd.addText("xps -ef");
        oS_cmd.setStdout();
        oS_cmd.execute();
        if (oS_cmd.getRC()) {
            String[] stringArray = oS_cmd.getStdout();
            for (int i = 0; i < stringArray.length; ++i) {
                String string;
                String string2 = stringArray[i];
                if (string2.indexOf("java") == -1 || string2.indexOf("jstack") != -1 || string2.indexOf("javaw") != -1) continue;
                String[] stringArray2 = string2.trim().split(" +");
                if (stringArray2.length == 8) {
                    string = stringArray2[7];
                } else {
                    if (stringArray2.length != 9) continue;
                    string = stringArray2[8];
                }
                String string3 = stringArray2[1];
                Jstack.print("program: " + string);
                common.ptod("pidx: " + string3);
                common.ptod("common.getProcessId(): " + common.getProcessId());
                System.exit(777);
                if (Integer.parseInt(string3) == common.getProcessId()) {
                    common.ptod("Skipping myself 2");
                    continue;
                }
                Jstack jstack = new Jstack(string3, string);
                programs.add(jstack);
            }
        } else {
            oS_cmd = new OS_cmd();
            oS_cmd.addText("tasklist");
            oS_cmd.setStdout();
            oS_cmd.execute();
            if (oS_cmd.getRC()) {
                String[] stringArray = oS_cmd.getStdout();
                for (int i = 0; i < stringArray.length; ++i) {
                    String string = stringArray[i].trim().toLowerCase();
                    if (string.indexOf("java.exe") == -1) continue;
                    String[] stringArray3 = string.split(" +");
                    Jstack jstack = new Jstack(stringArray3[1], stringArray3[0]);
                    String string4 = stringArray3[1];
                    if (Integer.parseInt(string4) == common.getProcessId()) {
                        common.ptod("Skipping myself 3");
                        continue;
                    }
                    programs.add(jstack);
                    Jstack.print("program: " + string);
                }
            } else {
                Jstack.print("Both 'ps -ef' and 'tasklist.exe' failed");
            }
        }
    }

    private static void doJstack() {
        for (int i = 0; i < programs.size(); ++i) {
            String string;
            int n;
            Jstack jstack = (Jstack)programs.elementAt(i);
            Jstack.print("");
            OS_cmd oS_cmd = new OS_cmd();
            oS_cmd.addQuot(Jstack.jstack);
            oS_cmd.addText(jstack.pid);
            oS_cmd.setStdout();
            oS_cmd.setStderr();
            oS_cmd.execute();
            lines = oS_cmd.getStdout();
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            for (int j = 0; j < lines.length; ++j) {
                if (lines[j].indexOf("Vdb.Vdbmain") != -1) {
                    bl = true;
                }
                if (lines[j].indexOf("Vdb.SlaveJvm") != -1) {
                    bl2 = true;
                }
                if (lines[j].indexOf("Get_cmd_stream") == -1) continue;
                bl3 = true;
            }
            if (bl3 && skip_streams) {
                Jstack.print("Skipping Get_cmd_stream");
                continue;
            }
            if (bl) {
                Jstack.print("Jstatus for VdbMain " + jstack.pid + " " + jstack.program);
            } else if (bl2) {
                Jstack.print("Jstatus for SlaveJvm " + jstack.pid + " " + jstack.program);
            } else {
                Jstack.print("Jstatus for 'other' " + jstack.pid + " " + jstack.program);
            }
            String[] stringArray = oS_cmd.getStderr();
            for (n = 0; n < stringArray.length; ++n) {
                string = stringArray[n];
                Jstack.print("stderr: " + string);
            }
            stringArray = oS_cmd.getStdout();
            for (n = 0; n < stringArray.length; ++n) {
                string = stringArray[n];
                Jstack.print("stdout: " + string);
            }
        }
        Jstack.print("Jstack completed successfully");
    }

    private static void print(String string) {
        common.ptod(string);
        fp.println(string);
    }

    private static Vector getBlock() {
        String string;
        String[] stringArray;
        Vector<String> vector = new Vector<String>(32, 0);
        ++index;
        while (index < lines.length && (stringArray = (string = lines[index]).trim().split(" +")).length > 2) {
            vector.add(string.substring(8));
            ++index;
        }
        ++count;
        --index;
        return vector;
    }

    private static void parseExistingJstackOutput(String string) {
        int n = 0;
        lines = Fget.readFileToArray(string);
        String string2 = null;
        fp = new Fput("jstack2.txt");
        block0: for (index = 0; index < lines.length; ++index) {
            int n2;
            string2 = lines[index];
            if (string2.indexOf("Jstack for") != -1) {
                fp.println(string2);
                continue;
            }
            if (string2.indexOf("stdout:") == -1) continue;
            String[] stringArray = string2.trim().split(" +");
            Vector vector = Jstack.getBlock();
            if (vector.size() == 0 || (string2 = (String)vector.firstElement()).indexOf("Attach Listener") != -1) continue;
            if (string2.contains("GC task thread#")) {
                ++n;
                continue;
            }
            String[] stringArray2 = new String[]{"Low Memory", "Signal Dispatcher", "Low Memory", "Signal Dispatcher", "Compiler", "Finalizer", "Reference Handler", "VM Thread", "VM Periodic Task Thread", "JNI global references", "jstack", "process reaper", "JNI global references"};
            for (n2 = 0; n2 < stringArray2.length; ++n2) {
                if (string2.indexOf(stringArray2[n2]) != -1) continue block0;
            }
            fp.print(String.format("block %4d: ", count), new Object[0]);
            for (n2 = 0; n2 < vector.size(); ++n2) {
                fp.print(((String)vector.elementAt(n2)).trim() + " ", new Object[0]);
            }
            fp.println("");
        }
        fp.println("Skipped %d 'GC task threads'", n);
        fp.close();
    }

    public static void main(String[] stringArray) {
        Getopt getopt = new Getopt(stringArray, "j:d:s", 99);
        getopt.print("Jstack");
        if (!getopt.isOK()) {
            common.failure("Parameter scan error");
        }
        if (stringArray.length == 3 && stringArray[1].equals("-")) {
            Jstack.parseExistingJstackOutput(stringArray[2]);
            return;
        }
        fp = new Fput("jstack.txt");
        String string = System.getProperty("java.home");
        Jstack.print("home: " + string);
        if (string.endsWith("/jre") || string.endsWith("\\jre")) {
            string = string.substring(0, string.length() - 4);
        }
        Jstack.print("home: " + string);
        if (getopt.check('j')) {
            jstack = getopt.get_string();
        } else if (common.onWindows() && new File(string + "\\bin\\jstack.exe").exists()) {
            jstack = string + "\\bin\\jstack.exe";
        } else if (new File(string + "/bin/jstack").exists()) {
            jstack = string + "/bin/jstack";
        } else {
            if (common.onWindows()) {
                common.failure("Unable to find java/bin/jstack.exe. Rerun using '-j /java/bin/jstack/exe'");
                jstack = "C:\\Program Files\\Java\\jdk1.6.0_10\\bin\\jstack.exe";
            }
            common.where();
            if (common.onSolaris()) {
                jstack = "/usr/java/bin/jstack";
            }
        }
        Jstack.print("jstack: " + jstack);
        if (stringArray.length == 2) {
            jstack = stringArray[1];
        }
        Jstack.print("jstack: " + jstack);
        Jstack.getPrograms();
        Jstack.doJstack();
        fp.println("Jstack ended at %s", new Date());
        fp.close();
        Jstack.parseExistingJstackOutput("jstack.txt");
    }

    static {
        index = 0;
    }
}

