/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Utils.Fput;
import Vdb.ActiveFile;
import Vdb.DV_map;
import Vdb.Dedup;
import Vdb.FileEntry;
import Vdb.HelpDebug;
import Vdb.Jnl_entry;
import Vdb.SD_entry;
import Vdb.SlaveJvm;
import Vdb.Validate;
import Vdb.common;
import java.text.SimpleDateFormat;
import java.util.Date;

public class KeyMap {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";
    private DV_map dv_map = null;
    private int key_block_size = 0;
    private int sum_of_keys = 0;
    private boolean block_in_error = false;
    private int[] key_map = null;
    private int key_count = 0;
    private long[] compressions = null;
    private long[] dedup_sets = null;
    private boolean for_compression_only = false;
    public long file_start_lba = 0L;
    public long file_lba = 0L;
    public long pattern_lba = 0L;
    public int pattern_length = 0;
    public long xfersize = 0L;
    private static Object counter_lock = new Object();
    private SimpleDateFormat df_log = new SimpleDateFormat("MMddyy-HH:mm:ss.SSS");
    private static boolean do_rw_log = common.get_debug(common.CREATE_READ_WRITE_LOG);

    public KeyMap(long l, int n, int n2) {
        int n3;
        this.file_start_lba = l;
        this.key_block_size = n;
        if (n2 == 0) {
            common.failure("No max_xfersize established yet");
        }
        int n4 = (n2 + this.key_block_size * 2) / this.key_block_size;
        this.key_map = new int[n4];
        this.compressions = new long[n4];
        this.dedup_sets = new long[n4];
        for (n3 = 0; n3 < this.compressions.length; ++n3) {
            this.compressions[n3] = 0L;
        }
        for (n3 = 0; n3 < this.dedup_sets.length; ++n3) {
            this.dedup_sets[n3] = Dedup.DEDUP_NO_DEDUP;
        }
        this.setKeyCount(1);
    }

    public KeyMap() {
        this.for_compression_only = true;
        this.setKeyCount(1);
        this.key_map = new int[this.key_count];
        this.compressions = new long[this.key_count];
        this.dedup_sets = new long[this.key_count];
        for (int i = 0; i < this.dedup_sets.length; ++i) {
            this.dedup_sets[i] = Dedup.DEDUP_NO_DEDUP;
        }
    }

    public void clearMapForFile(long l, DV_map dV_map) {
        for (long i = 0L; i < l; i += (long)this.key_block_size) {
            dV_map.dv_set(this.file_start_lba + i, 0);
        }
    }

    public boolean storeDataBlockInfo(long l, long l2, DV_map dV_map) {
        long l3;
        this.dv_map = dV_map;
        this.file_lba = l;
        this.xfersize = l2;
        if (this.for_compression_only) {
            this.pattern_lba = this.file_lba + this.file_start_lba;
            this.pattern_length = this.key_block_size = (int)this.xfersize;
        } else {
            this.pattern_lba = this.file_lba + this.file_start_lba;
            this.pattern_length = (int)this.xfersize;
            l3 = this.pattern_lba % (long)this.key_block_size;
            if (l3 != 0L) {
                this.pattern_lba -= l3;
                this.pattern_length = (int)((long)this.pattern_length + l3);
            }
            if ((l3 = (long)(this.pattern_length % this.key_block_size)) != 0L) {
                this.pattern_length = (int)((long)this.pattern_length + ((long)this.key_block_size - l3));
            }
            this.setKeyCount(this.pattern_length / this.key_block_size);
            if (this.pattern_lba % (long)this.key_block_size != 0L) {
                common.failure("Unexpected pattern_lba: %d/%d/%d/%d", this.file_lba, this.file_start_lba, this.key_block_size, this.pattern_lba);
            }
            if (this.pattern_length % this.key_block_size != 0) {
                common.failure("Unexpected pattern_length: %d/%d/%d/%d/%d", this.file_lba, this.file_start_lba, this.key_block_size, this.pattern_lba, this.pattern_length);
            }
        }
        if (this.key_count > this.key_map.length + 1) {
            common.ptod("pattern_length: " + this.pattern_length);
            common.ptod("key_block_size: " + this.key_block_size);
            common.ptod("key_map.length: " + this.key_map.length);
            common.ptod("key_count:      " + this.key_count);
            common.ptod("xfersize:       " + this.xfersize);
            common.failure("Invalid key count");
        }
        l3 = this.file_start_lba + this.file_lba;
        this.sum_of_keys = 0;
        this.block_in_error = false;
        if (!Validate.isRealValidate() && !Validate.isValidateForDedup()) {
            return false;
        }
        for (int i = 0; i < this.key_count; ++i) {
            int n = this.dv_map.dv_get(l3 + (long)(i * this.key_block_size));
            this.sum_of_keys += (n &= 0x7F);
            if (n == 127) {
                this.block_in_error = true;
            }
            this.key_map[i] = n;
        }
        return this.block_in_error;
    }

    public boolean badDataBlock() {
        return this.block_in_error;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getKeysFromMapAndSetBusy(long l, long l2) {
        try {
            this.file_lba = l;
            if (this.file_lba % (long)this.key_block_size != 0L) {
                common.failure("Unexpected lba: %d / %d / %d", this.file_lba, this.key_block_size, this.file_lba % (long)this.key_block_size);
            }
            if (l2 % (long)this.key_block_size != 0L) {
                common.failure("Unexpected xfersize: " + l2 + ", key block size: " + this.key_block_size);
            }
            this.setKeyCount((int)(l2 / (long)this.key_block_size));
            this.sum_of_keys = 0;
            DV_map dV_map = this.dv_map;
            synchronized (dV_map) {
                for (int i = 0; i < this.key_count; ++i) {
                    long l3 = this.file_start_lba + this.file_lba + (long)(i * this.key_block_size);
                    int n = this.dv_map.getKeyAndSetBusy(l3);
                    this.key_map[i] = n & 0x7F;
                    this.sum_of_keys += n & 0x7F;
                    if (n >= 0) continue;
                    for (int j = 0; j < i; ++j) {
                        try {
                            this.dv_map.setUnbusy(this.file_start_lba + this.file_lba + (long)(j * this.key_block_size));
                            continue;
                        }
                        catch (Exception exception) {
                            long l4 = this.file_start_lba + this.file_lba + (long)(j * this.key_block_size);
                            common.ptod(exception);
                            common.ptod("keylba:         " + l4);
                            common.ptod("file_start_lba: " + this.file_start_lba);
                            common.ptod("file_lba:       " + this.file_lba);
                            common.ptod("i:              " + i);
                            common.ptod("j:              " + j);
                            common.failure(exception);
                        }
                    }
                    return false;
                }
            }
        }
        catch (Exception exception) {
            common.ptod("file_lba: " + this.file_lba);
            common.ptod("xfersize: " + l2);
            common.ptod("sum_of_keys: " + this.sum_of_keys);
            common.failure(exception);
        }
        return true;
    }

    public int[] getKeys() {
        return this.key_map;
    }

    public void setKeyCount(int n) {
        this.key_count = n;
    }

    public int getKeyCount() {
        if (this.key_count == 0) {
            common.failure("zero key_count");
        }
        return this.key_count;
    }

    public int getKeyBlockSize() {
        return this.key_block_size;
    }

    public long[] getCompressions() {
        if (this.compressions == null) {
            common.failure("NULL compression values");
        }
        return this.compressions;
    }

    public long[] getDedupsets() {
        return this.dedup_sets;
    }

    public boolean anyDataToCompare() {
        if (!Validate.isRealValidate() && Validate.isValidateForDedup()) {
            return false;
        }
        return this.sum_of_keys != 0;
    }

    public boolean incrementKeys() {
        this.sum_of_keys = 0;
        for (int i = 0; i < this.key_count; ++i) {
            long l = this.file_start_lba + this.file_lba + (long)(i * this.key_block_size);
            long l2 = l / (long)this.key_block_size;
            long l3 = this.dedup_sets[i];
            if (Dedup.isDedup() && l3 == Dedup.DEDUP_NO_DEDUP) {
                common.failure("not expected: %d", i);
            }
            if (this.dv_map.dv_get(l) == 127) {
                return false;
            }
            if (!Validate.isDedup()) {
                this.key_map[i] = this.dv_map.dv_increment(this.key_map[i], l3);
            } else if (Dedup.isUnique(l3)) {
                if (Validate.isRealValidate()) {
                    this.key_map[i] = this.dv_map.dv_increment(this.key_map[i], l3);
                    if (this.key_map[i] == 0) {
                        common.failure("Increment keys results in a zero key");
                    }
                }
            } else {
                if (!this.dv_map.getDedup().isFlipFlop()) continue;
                if (this.dv_map.getDedup().isHotFlop()) {
                    if (!this.dv_map.getDedup().isHotSet(l3)) continue;
                    this.key_map[i] = this.dv_map.flipflop(this.key_map[i]);
                    if (this.key_map[i] == 0) {
                        common.failure("Increment keys results in a zero key");
                    }
                } else {
                    this.key_map[i] = this.dv_map.flipflop(this.key_map[i]);
                    if (this.key_map[i] == 0) {
                        common.failure("Increment keys results in a zero key");
                    }
                }
            }
            l3 &= Dedup.UNIQUE_KEY_MASK ^ 0xFFFFFFFFFFFFFFFFL;
            this.dedup_sets[i] = l3 |= (long)this.key_map[i] << 56;
            if (Validate.isRealValidate() && this.key_map[i] == 0) {
                common.failure("Increment keys results in a zero key");
            }
            this.sum_of_keys += this.key_map[i];
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeKeys() {
        if (!Validate.isRealValidate() && !Validate.isValidateForDedup()) {
            common.failure("Invalid call for Key manipulation");
        }
        DV_map dV_map = this.dv_map;
        synchronized (dV_map) {
            boolean bl = this.dv_map.dv_get(this.file_start_lba + this.file_lba) == 127;
            for (int i = 0; i < this.key_count; ++i) {
                long l = this.file_start_lba + this.file_lba + (long)(i * this.key_block_size);
                int n = this.dv_map.dv_get(l);
                if (n != 127) {
                    if (!Validate.isValidateForDedup() && SlaveJvm.isWdWorkload() && (n & 0x80) == 0) {
                        common.failure("storeKeys(): lba 0x%08x should be busy %02x", l, n);
                    }
                    this.dv_map.dv_set(l, this.key_map[i]);
                    this.sum_of_keys = this.sum_of_keys - (n &= 0x7F) + this.key_map[i];
                }
                if (!bl) continue;
                this.dv_map.dv_set(l, 127);
            }
        }
    }

    public void markDataBlockBad(DV_map dV_map, long l) {
        this.dv_map = dV_map;
        for (int i = 0; i < this.key_count; ++i) {
            long l2 = this.file_start_lba + l + (long)(i * this.key_block_size);
            this.dv_map.dv_set(l2, 127);
        }
        this.block_in_error = true;
    }

    public void saveCurrentTod(long l) {
        this.saveTimestamp(l, System.currentTimeMillis());
    }

    public void saveTimestamp(long l, long l2) {
        if (!Validate.isStoreTime()) {
            return;
        }
        long l3 = this.file_start_lba + this.file_lba;
        for (int i = 0; i < this.key_count; ++i) {
            this.dv_map.save_timestamp(l3 + (long)(i * this.key_block_size), l, l2, this.key_map[i]);
        }
    }

    public void saveWriteXfer(int n) {
        if (!Validate.isXferHistory()) {
            return;
        }
        long l = this.file_start_lba + this.file_lba;
        for (int i = 0; i < this.key_count; ++i) {
            this.dv_map.storeWriteXfer(l + (long)(i * this.key_block_size), n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void countRawReadAndValidates(SD_entry sD_entry, long l) {
        Object object = counter_lock;
        synchronized (object) {
            for (int i = 0; i < this.key_count; ++i) {
                if (this.key_map[i] == 0) continue;
                int n = this.key_map[i] & 0xFF;
                DV_map.key_reads[n] = DV_map.key_reads[n] + 1L;
            }
        }
        if (do_rw_log) {
            object = sD_entry.rw_log;
            String string = this.df_log.format(new Date());
            Object object2 = object;
            synchronized (object2) {
                for (int i = 0; i < this.key_count; ++i) {
                    ((Fput)object).println("%s r %02d %d ", string, this.key_map[i], l + (long)(this.key_block_size * i));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void countFileReadAndValidates(FileEntry fileEntry, long l) {
        Object object = counter_lock;
        synchronized (object) {
            for (int i = 0; i < this.key_count; ++i) {
                if (this.key_map[i] == 0) continue;
                int n = this.key_map[i] & 0xFF;
                DV_map.key_reads[n] = DV_map.key_reads[n] + 1L;
            }
            Fput fput = fileEntry.getAnchor().rw_log;
            if (fput != null) {
                String string = this.df_log.format(new Date());
                for (int i = 0; i < this.key_count; ++i) {
                    fput.println("%s r %02d %d %d %d ", string, this.key_map[i], fileEntry.getFileNoInList(), l + (long)(this.key_block_size * i), this.file_start_lba + l + (long)(this.key_block_size * i));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void countRawWrites(SD_entry sD_entry, long l) {
        Object object = counter_lock;
        synchronized (object) {
            for (int i = 0; i < this.key_count; ++i) {
                if (this.key_map[i] == 0) continue;
                int n = this.key_map[i] & 0xFF;
                DV_map.key_writes[n] = DV_map.key_writes[n] + 1L;
            }
        }
        if (do_rw_log) {
            object = sD_entry.rw_log;
            String string = this.df_log.format(new Date());
            Object object2 = object;
            synchronized (object2) {
                for (int i = 0; i < this.key_count; ++i) {
                    ((Fput)object).println("%s w %02d %d ", string, this.key_map[i], l + (long)(this.key_block_size * i));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void countFileWrites(FileEntry fileEntry, long l) {
        Object object = counter_lock;
        synchronized (object) {
            for (int i = 0; i < this.key_count; ++i) {
                if (this.key_map[i] == 0) continue;
                int n = this.key_map[i] & 0xFF;
                DV_map.key_writes[n] = DV_map.key_writes[n] + 1L;
            }
        }
        object = fileEntry.getAnchor().rw_log;
        if (object != null) {
            String string = this.df_log.format(new Date());
            Object object2 = object;
            synchronized (object2) {
                for (int i = 0; i < this.key_count; ++i) {
                    ((Fput)object).println("%s w %02d %d %d %d ", string, this.key_map[i], fileEntry.getFileNoInList(), l + (long)(this.key_block_size * i), this.file_start_lba + l + (long)(this.key_block_size * i));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeBeforeJournalImage() {
        if (Validate.isMapOnly()) {
            return;
        }
        Jnl_entry jnl_entry = this.dv_map.journal;
        synchronized (jnl_entry) {
            for (int i = 0; i < this.key_count; ++i) {
                long l = this.file_start_lba + this.file_lba;
                long l2 = l / (long)this.key_block_size + (long)i;
                if (this.key_map[i] == 0) {
                    common.failure("writeBeforeJournalImage trying to write a zero key");
                }
                this.dv_map.journal.writeJournalEntry(this.key_map[i], l2, i + 1 == this.key_count);
            }
        }
        HelpDebug.abortAfterCount("writeBeforeJournalImage");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeAfterJournalImage() {
        if (Validate.isMapOnly()) {
            return;
        }
        boolean bl = this.dv_map.dv_get(this.file_start_lba + this.file_lba) == 127;
        HelpDebug.abortAfterCount("writeAfterJournalImage");
        Jnl_entry jnl_entry = this.dv_map.journal;
        synchronized (jnl_entry) {
            for (int i = 0; i < this.key_count; ++i) {
                long l = this.file_start_lba + this.file_lba;
                long l2 = l / (long)this.key_block_size + (long)i;
                if (bl) {
                    this.dv_map.journal.writeJournalEntry(127, l2, i + 1 == this.key_count);
                    continue;
                }
                this.dv_map.journal.writeJournalEntry(0, l2, i + 1 == this.key_count);
            }
        }
    }

    public void setFsdCompressionOnlyOffset(ActiveFile activeFile) {
        for (int i = 0; i < this.getKeyCount(); ++i) {
            long l = activeFile.getFileEntry().getFileStartLba() + activeFile.next_lba + (long)(this.getKeyBlockSize() * i);
            this.compressions[i] = Dedup.getUniqueCompressionOffset(l);
        }
    }

    public void setSdCompressionOnlyOffset(long l) {
        for (int i = 0; i < this.key_count; ++i) {
            long l2 = l + (long)(this.getKeyBlockSize() * i);
            this.compressions[i] = Dedup.getUniqueCompressionOffset(l2);
        }
    }

    public static void main(String[] stringArray) {
    }
}

