/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Vdb.LS;
import Vdb.common;
import java.io.File;
import java.io.Serializable;

class LsData
implements Comparable,
Serializable {
    String dirname;
    String fname;
    String file_stuff;
    long ls_size;

    public LsData(String string, String string2, String string3, String string4) {
        this.dirname = string2;
        this.fname = string3;
        String[] stringArray = string.split(" +");
        try {
            if (stringArray.length < 5) {
                common.ptod("Invalid data: " + string);
                return;
            }
            this.ls_size = Long.parseLong(stringArray[4]);
            String string5 = LS.xlateSize(this.ls_size);
            this.file_stuff = !common.onWindows() ? String.format("%-12s %3s %-8s %-8s %,16d %6s %3s %2s %5s ", stringArray[0], stringArray[1], stringArray[2], stringArray[3], this.ls_size, string5, stringArray[5], stringArray[6], stringArray[7]) : String.format("%10s %3s %-4s %-4s %,12d %6s %3s %2s %5s ", stringArray[0], stringArray[1], stringArray[2], stringArray[3], this.ls_size, string5, stringArray[5], stringArray[6], stringArray[7]);
        }
        catch (Exception exception) {
            common.ptod("dirname:    " + this.dirname);
            common.ptod("fname:      " + this.fname);
            common.ptod("file_stuff: " + this.file_stuff);
            common.ptod("ls_output:  " + string);
            common.ptod("line:       " + string4);
            common.failure(exception);
        }
    }

    public String getDetail() {
        return this.file_stuff + this.dirname + File.separator + this.fname;
    }

    public int compareTo(Object object) {
        LsData lsData = (LsData)object;
        if (!LS.sort_size) {
            String string = this.dirname + File.separator + this.fname;
            String string2 = lsData.dirname + File.separator + lsData.fname;
            return string.compareToIgnoreCase(string2);
        }
        long l = lsData.ls_size - this.ls_size;
        if (l > 0L) {
            return 1;
        }
        if (l < 0L) {
            return -1;
        }
        return 0;
    }
}

