/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Utils.OS_cmd;
import Vdb.Linux;
import Vdb.Native;
import Vdb.SD_entry;
import Vdb.common;
import java.io.File;
import java.io.Serializable;
import java.util.Vector;

public class LunInfoFromHost
implements Serializable {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";
    protected String lun;
    protected String original_lun;
    protected String sd_instance;
    protected String host_name;
    protected boolean lun_exists = false;
    protected boolean parent_exists = false;
    protected boolean open_for_write = false;
    protected long lun_size;
    protected long end_lba;
    protected boolean read_allowed = false;
    protected boolean write_allowed = false;
    protected boolean error_opening = false;
    protected String kstat_instance;
    protected Vector kstat_error_messages = new Vector(0, 0);
    protected String soft_link = null;
    protected boolean marker_needed = false;
    protected boolean marker_found = false;
    protected long marker_tod = 0L;
    protected long marker_sd_num = 0L;

    protected void mismatch(SD_entry sD_entry) {
        common.ptod("sd=" + sD_entry.sd_name + ",host=" + this.host_name + ",lun=" + this.lun);
        common.ptod("Lun exists:     " + this.lun_exists);
        common.ptod("Lun size:       " + this.lun_size);
        common.ptod("Read  access:   " + this.read_allowed);
        common.ptod("Write access:   " + this.write_allowed);
        common.ptod("Open for write: " + this.open_for_write);
    }

    public void getRawInfo() {
        long l = Native.openFile(this.lun);
        if (l == -1L) {
            this.lun_exists = false;
            this.read_allowed = false;
            this.write_allowed = false;
            this.error_opening = true;
        } else {
            this.lun_exists = true;
            this.parent_exists = true;
            this.read_allowed = true;
            this.error_opening = false;
            this.lun_size = common.onLinux() ? Linux.getLinuxSize(this.lun) : Native.getSize(l, this.lun);
            Native.closeFile(l);
            if (this.open_for_write) {
                l = Native.openFile(this.lun, 1);
                if (l == -1L) {
                    this.write_allowed = false;
                } else {
                    this.write_allowed = true;
                    Native.closeFile(l);
                }
            }
        }
    }

    public void getFileInfo() {
        OS_cmd oS_cmd;
        String[] stringArray;
        File file = new File(this.lun);
        File file2 = file.getParentFile();
        if (file2 == null || !file2.exists()) {
            this.lun_exists = false;
            this.parent_exists = false;
        } else {
            this.parent_exists = true;
            this.lun_exists = file.exists();
        }
        boolean bl = file.isFile();
        if (!bl && !common.onWindows() && (stringArray = (oS_cmd = OS_cmd.execute("ls -l " + this.lun)).getStdout()) != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].startsWith("l")) continue;
                String[] stringArray2 = stringArray[i].split(" +");
                this.soft_link = stringArray2[stringArray2.length - 1];
                bl = true;
            }
        }
        if (this.lun_exists && bl) {
            this.read_allowed = file.canRead();
            this.write_allowed = file.canWrite();
            this.lun_size = file.length();
            long l = Native.openFile(this.lun);
            if (l == -1L) {
                this.error_opening = true;
            } else {
                Native.closeFile(l);
            }
        }
    }

    public static void main(String[] stringArray) {
        Native.allocSharedMemory();
        String string = stringArray[0];
        if (string.startsWith("/dev/") || string.startsWith("\\\\.\\")) {
            LunInfoFromHost lunInfoFromHost = new LunInfoFromHost();
            lunInfoFromHost.lun = string;
            lunInfoFromHost.getRawInfo();
            common.ptod("linfo.lun_size: " + lunInfoFromHost.lun_size);
        } else {
            LunInfoFromHost lunInfoFromHost = new LunInfoFromHost();
            lunInfoFromHost.lun = string;
            lunInfoFromHost.getFileInfo();
            common.ptod("linfo.lun_size: " + lunInfoFromHost.lun_size);
        }
    }
}

