/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Utils.Fget;
import Utils.OS_cmd;
import Vdb.SlaveJvm;
import Vdb.common;
import java.io.File;
import java.io.Serializable;

public class Mount
implements Serializable {
    private static final String c = "Copyright (c) 2000, 2012, Oracle and/or its affiliates. All rights reserved.";
    private String[] requests;

    public Mount(String[] stringArray) {
        this.requests = stringArray;
        for (int i = 0; i < this.requests.length; ++i) {
            String string = this.requests[i];
            String[] stringArray2 = string.trim().split(" +");
            if (stringArray2.length >= 2) continue;
            common.failure("'hd=xxx,mount=\"special [options[ mountpoint\" must contain a minimum of two blank separated fields: " + string);
        }
    }

    public void initialHostMount() {
        this.mountIfNeeded(null);
    }

    public void mountIfNeeded(String string) {
        if (common.onWindows()) {
            common.failure("Running on Windows. No 'mount' command available.");
            return;
        }
        for (int i = 0; i < this.requests.length; ++i) {
            String[] stringArray = this.requests[i].trim().split(" +");
            String string2 = stringArray[stringArray.length - 1];
            String string3 = stringArray[stringArray.length - 2];
            String string4 = stringArray[0];
            String string5 = "";
            for (int j = 1; j < stringArray.length - 2; ++j) {
                string5 = string5 + stringArray[j] + " ";
            }
            this.createMountpoint(string2);
            if (this.isMountpointActive(string3, string2)) {
                this.doUnMount(string2, string);
            }
            if (string == null || string.equals("reset")) {
                this.doMount(string4 + " " + string5 + " " + string3 + " " + string2);
                continue;
            }
            this.doMount(string4 + " " + string + " " + string3 + " " + string2);
        }
    }

    private void createMountpoint(String string) {
        File file = new File(string);
        if (file.exists() && file.isFile()) {
            common.failure("Mountpoint exists, but is a file, not a directory: " + string);
        }
        if (file.exists()) {
            return;
        }
        if (!file.mkdirs()) {
            common.failure("Unable to create mountpoint: " + string);
        }
        SlaveJvm.sendMessageToConsole("Created mountpoint: " + string);
    }

    private boolean isMountpointActive(String string, String string2) {
        String[] stringArray = null;
        if (common.onSolaris()) {
            stringArray = Fget.readFileToArray("/etc/mnttab");
        } else if (common.onLinux()) {
            stringArray = Fget.readFileToArray("/etc/mtab");
        } else {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = stringArray[i];
            String[] stringArray2 = (string3 = common.replace(string3, "\t", " ")).split(" +");
            if (stringArray2.length < 4) {
                for (int j = 0; j < stringArray2.length; ++j) {
                    common.ptod("split: " + j + " " + stringArray2[j]);
                }
                common.failure("Expecting at least 4 substrings in /etc/mnttab file: " + string3);
            }
            if (!stringArray2[0].equalsIgnoreCase(string) || !stringArray2[1].equals(string2)) continue;
            return true;
        }
        return false;
    }

    private void doUnMount(String string, String string2) {
        OS_cmd oS_cmd = new OS_cmd();
        if (string2 == null) {
            oS_cmd.addText("umount -f " + string);
        } else {
            oS_cmd.addText("umount    " + string);
        }
        oS_cmd.execute();
        boolean bl = oS_cmd.getRC();
        String[] stringArray = oS_cmd.getStdout();
        String[] stringArray2 = oS_cmd.getStderr();
        if (stringArray.length + stringArray2.length > 0) {
            int n;
            common.plog("Unmount command output for " + string + ":");
            for (n = 0; n < stringArray.length; ++n) {
                common.plog("stdout: " + stringArray[n]);
            }
            for (n = 0; n < stringArray2.length; ++n) {
                common.plog("stderr: " + stringArray2[n]);
            }
        }
        if (!bl) {
            common.failure("Unmount of file system failed. See above messages. ");
        }
    }

    private void doMount(String string) {
        OS_cmd oS_cmd = new OS_cmd();
        oS_cmd.addText(string);
        oS_cmd.execute();
        boolean bl = oS_cmd.getRC();
        String[] stringArray = oS_cmd.getStdout();
        String[] stringArray2 = oS_cmd.getStderr();
        if (stringArray.length + stringArray2.length > 0) {
            int n;
            common.plog("Mount command output for " + string + ":");
            for (n = 0; n < stringArray.length; ++n) {
                common.plog("stdout: " + stringArray[n]);
            }
            for (n = 0; n < stringArray2.length; ++n) {
                common.plog("stderr: " + stringArray2[n]);
            }
        }
        if (!bl) {
            common.failure("Mount of file system failed. See above (" + (stringArray.length + stringArray2.length) + ") messages. ");
        }
        String[] stringArray3 = string.trim().split(" +");
        String string2 = stringArray3[stringArray3.length - 1];
        oS_cmd = new OS_cmd();
        oS_cmd.addText("mount | grep " + string2);
        oS_cmd.execute();
        bl = oS_cmd.getRC();
        stringArray = oS_cmd.getStdout();
        stringArray2 = oS_cmd.getStderr();
        if (stringArray.length + stringArray2.length > 0) {
            int n;
            common.plog("Mount command output for " + string + ":");
            for (n = 0; n < stringArray.length; ++n) {
                common.plog("stdout: " + stringArray[n]);
            }
            for (n = 0; n < stringArray2.length; ++n) {
                common.plog("stderr: " + stringArray2[n]);
            }
        }
    }
}

