/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Vdb.Blocked;
import Vdb.FileEntry;
import Vdb.FwgEntry;
import Vdb.FwgThread;
import Vdb.SlaveJvm;
import Vdb.Task_num;

class OpDelete
extends FwgThread {
    private static final String c = "Copyright (c) 2000, 2015, Oracle and/or its affiliates. All rights reserved.";
    private String[] msg;

    public OpDelete(Task_num task_num, FwgEntry fwgEntry) {
        super(task_num, fwgEntry);
        this.msg = new String[]{"Anchor: " + this.fwg.anchor.getAnchorName(), "Vdbench is trying to delete a file, but no files are available, and no", "threads are currently active creating new files."};
    }

    @Override
    protected boolean doOperation() {
        while (!SlaveJvm.isWorkloadDone()) {
            FileEntry fileEntry = this.fwg.anchor.getFile(this.fwg);
            if (fileEntry == null) {
                return false;
            }
            if (!fileEntry.setFileBusyExc()) {
                this.block(Blocked.FILE_BUSY);
                continue;
            }
            if (fileEntry.isBadFile()) {
                this.block(Blocked.BAD_FILE_SKIPPED);
                fileEntry.setUnBusy();
                continue;
            }
            if (!fileEntry.exists()) {
                fileEntry.cleanup();
                this.block(Blocked.FILE_MUST_EXIST);
                if (this.canWeGetMoreFiles(this.msg)) continue;
                return false;
            }
            fileEntry.deleteFile(this.fwg);
            fileEntry.cleanup();
            return true;
        }
        return false;
    }
}

