/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Vdb.Blocked;
import Vdb.Directory;
import Vdb.FwgEntry;
import Vdb.FwgThread;
import Vdb.RD_entry;
import Vdb.SlaveJvm;
import Vdb.SlaveWorker;
import Vdb.Task_num;
import Vdb.common;

class OpMkdir
extends FwgThread {
    private static final String c = "Copyright (c) 2000, 2015, Oracle and/or its affiliates. All rights reserved.";
    private boolean mkdir_max;
    private String[] msg;

    public OpMkdir(Task_num task_num, FwgEntry fwgEntry) {
        super(task_num, fwgEntry);
        this.mkdir_max = SlaveWorker.work.fwd_rate == (double)RD_entry.MAX_RATE;
        this.msg = new String[]{"Anchor: " + this.fwg.anchor.getAnchorName(), "Vdbench is trying to create a new directory, but all directories", "already exist and no threads are currently active deleting directories."};
    }

    @Override
    protected boolean doOperation() {
        Directory directory = null;
        while (true) {
            if (SlaveJvm.isWorkloadDone()) {
                return false;
            }
            directory = this.fwg.anchor.getDir(this.fwg.select_random, this.format || this.mkdir_max);
            if (directory == null) {
                return false;
            }
            if ((this.format || this.mkdir_max) && directory.exist()) {
                this.block(Blocked.DIR_EXISTS);
                if (directory.getDepth() == 1) {
                    return false;
                }
                if (this.canWeGetMoreDirectories(this.msg)) continue;
                return false;
            }
            if (!directory.setBusy(true)) {
                this.block(Blocked.DIR_BUSY_MKDIR);
                continue;
            }
            if (directory.exist()) {
                directory.setBusy(false);
                this.block(Blocked.DIR_EXISTS);
                if (this.canWeGetMoreDirectories(this.msg)) continue;
                return false;
            }
            if (!directory.getParent().setBusy(true)) {
                this.block(Blocked.PARENT_DIR_BUSY, directory.getFullName());
                directory.setBusy(false);
                continue;
            }
            if (directory.getParent().exist()) break;
            directory.getParent().setBusy(false);
            directory.setBusy(false);
            this.block(Blocked.MISSING_PARENT, directory.getFullName());
            if (!this.format && !this.mkdir_max) continue;
            common.sleep_some_usecs(200L);
        }
        if (directory.createDir()) {
            this.fwg.blocked.count(Blocked.DIRECTORY_CREATES);
        }
        if (this.format || this.mkdir_max) {
            this.createChildren(directory.getChildren());
        }
        directory.getParent().setBusy(false);
        directory.setBusy(false);
        return true;
    }

    private void createChildren(Directory[] directoryArray) {
        if (directoryArray == null) {
            return;
        }
        for (int i = 0; i < directoryArray.length; ++i) {
            while (!directoryArray[i].setBusy(true)) {
            }
            if (directoryArray[i].createDir()) {
                this.fwg.blocked.count(Blocked.DIRECTORY_CREATES);
            }
            this.createChildren(directoryArray[i].getChildren());
            directoryArray[i].setBusy(false);
        }
    }
}

