/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Vdb.FileEntry;
import Vdb.FwgEntry;
import Vdb.FwgThread;
import Vdb.Task_num;
import Vdb.common;

class OpRead
extends FwgThread {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";
    private boolean this_is_OpReadWrite = false;
    private boolean debug_timeout = common.get_debug(common.OPREAD_SLEEP);

    public OpRead(Task_num task_num, FwgEntry fwgEntry) {
        super(task_num, fwgEntry);
    }

    public void usingOpReadWrite() {
        this.this_is_OpReadWrite = true;
    }

    @Override
    protected boolean doOperation() {
        if (this.debug_timeout) {
            common.ptod("Sleeping for a bit, debugging");
            common.sleep_some(5000L);
        }
        if (this.afe == null) {
            FileEntry fileEntry = this.findFileToRead();
            if (fileEntry == null) {
                return false;
            }
            this.afe = this.this_is_OpReadWrite ? this.openForWrite(fileEntry) : this.openForRead(fileEntry);
        }
        if (this.fwg.sequential_io) {
            return this.doSequentialRead();
        }
        return this.doRandomRead();
    }

    protected boolean doSequentialRead() {
        this.afe.xfersize = this.fwg.getXferSize();
        if (!this.afe.setNextSequentialRead() || this.afe.done_enough) {
            this.afe = this.afe.closeFile();
            FileEntry fileEntry = this.findFileToRead();
            if (fileEntry == null) {
                return false;
            }
            this.afe = this.this_is_OpReadWrite ? this.openForWrite(fileEntry) : this.openForRead(fileEntry);
            this.afe.xfersize = this.fwg.getXferSize();
            boolean bl = this.afe.setNextSequentialRead();
            if (!bl) {
                fileEntry = this.afe.getFileEntry();
                common.ptod(fileEntry);
                common.failure("Unexpected return code: " + fileEntry.getCurrentSize() + " " + fileEntry.getReqSize() + " " + fileEntry.getLastLba() + " " + this.afe.next_lba + " " + fileEntry + " xf: " + this.afe.xfersize);
            }
        }
        if (this.afe.xfersize == 0) {
            common.ptod("fwg: " + this.fwg.getName());
            common.ptod("afe: " + this.afe.getFileEntry());
            common.failure("Unexpected xfersize=0");
        }
        this.afe.readBlock();
        this.afe.checkEnough();
        return true;
    }

    protected boolean doRandomRead() {
        this.afe.xfersize = this.fwg.getXferSize();
        if (this.afe.done_enough) {
            this.afe = this.afe.closeFile();
            FileEntry fileEntry = this.findFileToRead();
            if (fileEntry == null) {
                return false;
            }
            this.afe = this.this_is_OpReadWrite ? this.openForWrite(fileEntry) : this.openForRead(fileEntry);
            this.afe.xfersize = this.fwg.getXferSize();
        }
        if (!this.afe.setNextRandomLba()) {
            this.afe.done_enough = true;
            return true;
        }
        this.afe.readBlock();
        this.afe.checkEnough();
        return true;
    }
}

