/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Vdb.Blocked;
import Vdb.Directory;
import Vdb.FwgEntry;
import Vdb.FwgThread;
import Vdb.RD_entry;
import Vdb.SlaveJvm;
import Vdb.SlaveWorker;
import Vdb.Task_num;
import Vdb.common;

class OpRmdir
extends FwgThread {
    private static final String c = "Copyright (c) 2000, 2012, Oracle and/or its affiliates. All rights reserved.";
    private boolean rmdir_max;
    private String[] msg;
    private String[] msg2;

    public OpRmdir(Task_num task_num, FwgEntry fwgEntry) {
        super(task_num, fwgEntry);
        this.rmdir_max = SlaveWorker.work.fwd_rate == (double)RD_entry.MAX_RATE;
        this.msg = new String[]{"Anchor: " + this.fwg.anchor.getAnchorName(), "Vdbench is trying to delete a directory, but the directory that we are", "trying to delete is not empty, and there are no threads currently", "active that can delete those files."};
        this.msg2 = new String[]{"Anchor: " + this.fwg.anchor.getAnchorName(), "Vdbench is trying to delete a directory, but the directory that we are", "trying to delete does not exist, and there are no threads currently", "active that create new directories."};
    }

    @Override
    protected boolean doOperation() {
        Directory directory;
        block9: {
            directory = null;
            while (true) {
                if (SlaveJvm.isWorkloadDone()) {
                    return false;
                }
                directory = this.fwg.anchor.getDir(this.fwg.select_random, this.format || this.rmdir_max);
                if (directory == null) {
                    return false;
                }
                if (!directory.setBusy(true)) {
                    this.block(Blocked.DIR_BUSY_RMDIR);
                    continue;
                }
                if (!directory.exist()) {
                    directory.setBusy(false);
                    if (!this.canWeGetMoreDirectories(this.msg2)) {
                        return false;
                    }
                    this.block(Blocked.DIR_DOES_NOT_EXIST, directory.getFullName());
                    continue;
                }
                if (this.rmdir_max) {
                    this.deleteChildren(directory.getChildren());
                }
                if (directory.anyExistingChildren()) {
                    directory.setBusy(false);
                    this.block(Blocked.DIR_STILL_HAS_CHILD, directory.getFullName());
                    continue;
                }
                if (directory.countFiles(0, null) == 0) break block9;
                directory.setBusy(false);
                this.block(Blocked.DIR_STILL_HAS_FILES, directory.getFullName());
                if (!this.canWeGetMoreFiles(this.msg)) {
                    common.where();
                    return false;
                }
                if (!this.canWeExpectFileDeletes(this.msg)) break;
            }
            common.where();
            return false;
        }
        directory.deleteDir(this.fwg);
        directory.setBusy(false);
        return true;
    }

    private void deleteChildren(Directory[] directoryArray) {
        if (directoryArray == null) {
            return;
        }
        for (Directory directory : directoryArray) {
            while (!directory.setBusy(true)) {
            }
            if (!directory.exist()) {
                directory.setBusy(false);
                continue;
            }
            this.deleteChildren(directory.getChildren());
            if (directory.countFiles(0, null) != 0) {
                this.block(Blocked.DIR_STILL_HAS_FILES, directory.getFullName());
                directory.setBusy(false);
                continue;
            }
            directory.deleteDir(this.fwg);
            directory.setBusy(false);
        }
    }
}

