/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Vdb.Blocked;
import Vdb.FileEntry;
import Vdb.FwdStats;
import Vdb.FwgEntry;
import Vdb.FwgThread;
import Vdb.Native;
import Vdb.Operations;
import Vdb.SlaveJvm;
import Vdb.Task_num;
import Vdb.common;
import java.io.File;

class OpSetAttr
extends FwgThread {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";
    private String[] msg;

    public OpSetAttr(Task_num task_num, FwgEntry fwgEntry) {
        super(task_num, fwgEntry);
        this.msg = new String[]{"Anchor: " + this.fwg.anchor.getAnchorName(), "Vdbench is trying to change attributes for a file, but there are no files", "available, and there are no threads currently active that can create new files."};
    }

    @Override
    protected boolean doOperation() {
        while (!SlaveJvm.isWorkloadDone()) {
            FileEntry fileEntry = this.fwg.anchor.getFile(this.fwg);
            if (!fileEntry.setFileBusy()) {
                this.block(Blocked.FILE_BUSY);
                continue;
            }
            if (fileEntry.isBadFile()) {
                this.block(Blocked.BAD_FILE_SKIPPED);
                fileEntry.setUnBusy();
                continue;
            }
            if (!fileEntry.exists()) {
                fileEntry.setUnBusy();
                this.block(Blocked.FILE_MUST_EXIST);
                if (this.canWeGetMoreFiles(this.msg)) continue;
                return false;
            }
            long l = System.currentTimeMillis();
            long l2 = Native.get_simple_tod();
            File file = new File(fileEntry.getFullName());
            if (!file.setLastModified(l + YEAR)) {
                common.ptod("getFullName(): " + fileEntry.getFullName());
                common.ptod("canRead:       " + file.canRead());
                common.ptod("canWrite:      " + file.canWrite());
                common.ptod("canExecute:    " + file.canExecute());
                common.failure("Unable to do a setattr request for file: " + fileEntry.getFullName());
            }
            FwdStats.count(Operations.SETATTR, l2);
            this.fwg.blocked.count(Blocked.SET_ATTR);
            fileEntry.setUnBusy();
            return true;
        }
        return false;
    }
}

