/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Vdb.common;
import java.io.Serializable;
import java.util.ArrayList;

public class OpenFlags
implements Serializable,
Cloneable {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";
    private String[] parm_list = new String[0];
    private boolean flags_translated = false;
    private int openflags = 0;
    public static int WINDOWS_DIRECTIO = 1;
    private int otherflags = 0;
    public static int FSYNC_ON_CLOSE = 1;
    public static int SOL_DIRECTIO = 2;
    public static int SOL_DIRECTIO_OFF = 4;
    public static int SOL_CLEAR_CACHE = 8;

    public OpenFlags() {
    }

    public OpenFlags(String[] stringArray, double[] dArray) {
        ArrayList<String> arrayList = new ArrayList<String>(8);
        for (String string : stringArray) {
            arrayList.add(string);
        }
        if (dArray != null) {
            for (double d : dArray) {
                arrayList.add("" + (int)d);
            }
        }
        this.parm_list = arrayList.toArray(new String[0]);
    }

    public Object clone() {
        try {
            OpenFlags openFlags = (OpenFlags)super.clone();
            openFlags.parm_list = (String[])this.parm_list.clone();
            return openFlags;
        }
        catch (Exception exception) {
            common.failure(exception);
            return null;
        }
    }

    public int getOpenFlags() {
        if (!this.flags_translated) {
            this.translateFlags();
        }
        return this.openflags;
    }

    public boolean isOther(int n) {
        if (!this.flags_translated) {
            this.translateFlags();
        }
        return (this.otherflags & n) != 0;
    }

    private synchronized void translateFlags() {
        int n = 0;
        int n2 = 0;
        String string = System.getProperty("os.arch");
        if (common.onSolaris()) {
            for (int i = 0; i < this.parm_list.length; ++i) {
                String string2 = this.parm_list[i];
                String string3 = string2.toLowerCase();
                if (string3.equals("o_dsync")) {
                    n |= 0x40;
                    continue;
                }
                if (string3.equals("o_rsync")) {
                    n |= 0x8000;
                    continue;
                }
                if (string3.equals("o_sync")) {
                    n |= 0x10;
                    continue;
                }
                if (string3.startsWith("0x")) {
                    n |= OpenFlags.hexFlags(string3);
                    continue;
                }
                if (string3.equals("fsync")) {
                    n2 |= FSYNC_ON_CLOSE;
                    continue;
                }
                if (string3.equals("directio")) {
                    n2 |= SOL_DIRECTIO;
                    continue;
                }
                if (string3.equals("directio_off")) {
                    n2 |= SOL_DIRECTIO_OFF;
                    continue;
                }
                if (string3.equals("clear_cache")) {
                    n2 |= SOL_CLEAR_CACHE;
                    continue;
                }
                if (string3.equals("clearcache")) {
                    n2 |= SOL_CLEAR_CACHE;
                    continue;
                }
                common.failure("Invalid 'openflags=' parameter for Solaris: " + string2);
            }
        } else if (common.onWindows()) {
            for (String string4 : this.parm_list) {
                String string5 = string4.toLowerCase();
                if (string5.equals("o_dsync") || string5.equals("o_rsync") || string5.equals("o_sync")) {
                    common.ptod("Windows: changing openflags=%s to openflags=directio", string5);
                    string5 = "directio";
                }
                if (string5.equals("directio")) {
                    n |= WINDOWS_DIRECTIO;
                    continue;
                }
                common.failure("Invalid 'openflags=' parameter for Windows: " + string4);
            }
        } else if (common.onMac()) {
            if (this.parm_list.length > 1) {
                common.failure("Currently only ONE openflag accepted for MAC. #flags: " + this.parm_list.length);
            }
            for (int i = 0; i < this.parm_list.length; ++i) {
                String string6 = this.parm_list[i].toLowerCase();
                if (string6.equals("f_nocache")) {
                    n = 48;
                    continue;
                }
                if (string6.equals("directio")) {
                    n = 48;
                    continue;
                }
                if (common.isNumeric(string6)) {
                    n = Integer.parseInt(string6);
                    continue;
                }
                common.failure("Invalid 'openflags=' parameter for MAC: " + string6);
            }
        } else if (common.onLinux()) {
            for (int i = 0; i < this.parm_list.length; ++i) {
                String string7 = this.parm_list[i];
                String string8 = string7.toLowerCase();
                if (string.equals("aarch64")) {
                    if (string8.equals("o_dsync")) {
                        n |= 0x1000;
                        continue;
                    }
                    if (string8.equals("o_rsync")) {
                        n |= 0x1000;
                        continue;
                    }
                    if (string8.equals("o_sync")) {
                        n |= 0x1000;
                        continue;
                    }
                    if (string8.equals("o_direct")) {
                        n |= 0x10000;
                        continue;
                    }
                    if (string8.equals("directio")) {
                        n |= 0x10000;
                        continue;
                    }
                    if (string8.startsWith("0x")) {
                        n |= OpenFlags.hexFlags(string8);
                        continue;
                    }
                    if (string8.equals("fsync")) {
                        n2 |= FSYNC_ON_CLOSE;
                        continue;
                    }
                    common.failure("Invalid 'openflags=' parameter for Linux: " + string7);
                    continue;
                }
                if (string.equals("ppc64")) {
                    if (string8.equals("o_dsync")) {
                        n |= 0x101000;
                        continue;
                    }
                    if (string8.equals("o_rsync")) {
                        n |= 0x101000;
                        continue;
                    }
                    if (string8.equals("o_sync")) {
                        n |= 0x101000;
                        continue;
                    }
                    if (string8.equals("o_direct")) {
                        n |= 0x20000;
                        continue;
                    }
                    if (string8.equals("directio")) {
                        n |= 0x20000;
                        continue;
                    }
                    if (string8.startsWith("0x")) {
                        n |= OpenFlags.hexFlags(string8);
                        continue;
                    }
                    if (string8.equals("fsync")) {
                        n2 |= FSYNC_ON_CLOSE;
                        continue;
                    }
                    common.failure("Invalid 'openflags=' parameter for Linux: " + string7);
                    continue;
                }
                if (string.equals("sparcv9")) {
                    if (string8.equals("o_dsync")) {
                        n |= 0x2000;
                        continue;
                    }
                    if (string8.equals("o_rsync")) {
                        n |= 0x802000;
                        continue;
                    }
                    if (string8.equals("o_sync")) {
                        n |= 0x802000;
                        continue;
                    }
                    if (string8.equals("o_direct")) {
                        n |= 0x100000;
                        continue;
                    }
                    if (string8.equals("directio")) {
                        n |= 0x100000;
                        continue;
                    }
                    if (string8.startsWith("0x")) {
                        n |= OpenFlags.hexFlags(string8);
                        continue;
                    }
                    if (string8.equals("fsync")) {
                        n2 |= FSYNC_ON_CLOSE;
                        continue;
                    }
                    common.failure("Invalid 'openflags=' parameter for Linux: " + string7);
                    continue;
                }
                if (string8.equals("o_dsync")) {
                    n |= 0x1000;
                    continue;
                }
                if (string8.equals("o_rsync")) {
                    n |= 0x1000;
                    continue;
                }
                if (string8.equals("o_sync")) {
                    n |= 0x1000;
                    continue;
                }
                if (string8.equals("o_direct")) {
                    n |= 0x4000;
                    continue;
                }
                if (string8.equals("directio")) {
                    n |= 0x4000;
                    continue;
                }
                if (string8.startsWith("0x")) {
                    n |= OpenFlags.hexFlags(string8);
                    continue;
                }
                if (string8.equals("fsync")) {
                    n2 |= FSYNC_ON_CLOSE;
                    continue;
                }
                common.failure("Invalid 'openflags=' parameter for Linux: " + string7);
            }
        } else if (common.onAix()) {
            for (int i = 0; i < this.parm_list.length; ++i) {
                String string9 = this.parm_list[i];
                String string10 = string9.toLowerCase();
                if (string10.equals("o_dsync")) {
                    n |= 0x400000;
                    continue;
                }
                if (string10.equals("o_rsync")) {
                    n |= 0x200000;
                    continue;
                }
                if (string10.equals("o_sync")) {
                    n |= 0x10;
                    continue;
                }
                if (string10.equals("o_direct")) {
                    n |= 0x8000000;
                    continue;
                }
                if (string10.equals("directio")) {
                    n |= 0x8000000;
                    continue;
                }
                if (string10.startsWith("0x")) {
                    n |= OpenFlags.hexFlags(string10);
                    continue;
                }
                common.failure("Invalid 'openflags=' parameter for AIX: " + string9);
            }
        } else if (this.parm_list.length > 0) {
            common.failure("'openflags=' parameter is only valid when the target system is Solaris, Linux, Windows, MAC or AIX. ");
        }
        if ((n2 & SOL_DIRECTIO) != 0 && (n2 & SOL_DIRECTIO_OFF) != 0) {
            common.failure("'openflags=directio' and 'openflags=directio_off' are mutually exclusive");
        }
        this.otherflags = n2;
        this.openflags = n;
        this.flags_translated = true;
        if (common.get_debug(common.PRINT_OPEN_FLAGS)) {
            common.ptod(this);
        }
    }

    private static int hexFlags(String string) {
        try {
            return Integer.parseInt(string.substring(2), 16);
        }
        catch (Exception exception) {
            common.ptod("Exception parsing openflags=" + string);
            common.failure(exception);
            return 0;
        }
    }

    public boolean equals(Object object) {
        OpenFlags openFlags = (OpenFlags)object;
        if (!this.flags_translated) {
            this.translateFlags();
        }
        if (!openFlags.flags_translated) {
            openFlags.translateFlags();
        }
        return this.openflags == openFlags.openflags && this.otherflags == openFlags.otherflags;
    }

    public String toString() {
        if (!this.flags_translated) {
            this.translateFlags();
        }
        return String.format("OpenFlags: 0x%08x OtherFlags: 0x%08x", this.openflags, this.otherflags);
    }
}

