/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import java.util.HashMap;

class Operations {
    private static final String c = "Copyright (c) 2000, 2015, Oracle and/or its affiliates. All rights reserved.";
    private static String[] operations = new String[]{"read", "write", "mkdir", "rmdir", "copy", "move", "create", "delete", "getattr", "setattr", "access", "open", "close", "put", "get"};
    private static HashMap<String, Integer> operations_map = new HashMap(32);
    private static boolean[] operations_used = new boolean[64];
    public static final int READ = Operations.addOperation("Read");
    public static final int WRITE = Operations.addOperation("Write");
    public static final int MKDIR = Operations.addOperation("Mkdir");
    public static final int RMDIR = Operations.addOperation("Rmdir");
    public static final int COPY = Operations.addOperation("Copy");
    public static final int MOVE = Operations.addOperation("Move");
    public static final int CREATE = Operations.addOperation("Create");
    public static final int DELETE = Operations.addOperation("Delete");
    public static final int GETATTR = Operations.addOperation("Getattr");
    public static final int SETATTR = Operations.addOperation("Setattr");
    public static final int ACCESS = Operations.addOperation("Access");
    public static final int OPEN = Operations.addOperation("Open");
    public static final int CLOSE = Operations.addOperation("Close");
    public static final int PUT = Operations.addOperation("Put");
    public static final int GET = Operations.addOperation("Get");

    Operations() {
    }

    private static int addOperation(String string) {
        int n = operations_map.size();
        string = string.toLowerCase();
        operations_map.put(string, n);
        return n;
    }

    public static int getOperationIdentifier(String string) {
        Integer n = operations_map.get(string = string.toLowerCase());
        if (n == null) {
            return -1;
        }
        Operations.operations_used[n.intValue()] = true;
        return n;
    }

    public static String getOperationText(int n) {
        if (n == -1) {
            return "n/a";
        }
        return operations[n];
    }

    public static boolean isOperationUsed(int n) {
        return operations_used[n];
    }

    public static int getOperationCount() {
        return operations.length;
    }
}

