/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Vdb.Dedup;
import Vdb.Native;
import Vdb.Validate;
import Vdb.common;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Random;

public class Patterns
implements Serializable {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";
    private String pattern_file = null;
    private int[] pattern_array = null;
    private boolean pattern_coded = false;
    private static int print_once = 0;
    private static Patterns options = new Patterns();
    private static int buffer_size;
    private static int buffer_size_times2;
    static double[] randomizer_value;
    private static double default_compression;

    public static double getDefaultCompressionRatio() {
        return default_compression;
    }

    public static void setDefaultCompressionRatio(double d) {
        default_compression = d;
        if (default_compression < 1.0) {
            common.failure("Minimum value for compratio=%.0f is compratio=1", default_compression);
        }
    }

    public static Patterns getOptions() {
        return options;
    }

    public static void storeOptions(Patterns patterns) {
        options = patterns;
    }

    public static boolean usePatternFile() {
        return Patterns.options.pattern_file != null;
    }

    public static int[] getPattern() {
        return Patterns.options.pattern_array;
    }

    public static void createPattern(int n) {
        if (Patterns.options.pattern_array != null) {
            common.failure("createPattern(): unexpected call");
        }
        buffer_size = Patterns.calculatePatternBufferSize(n);
        buffer_size_times2 = buffer_size * 2;
        if (Validate.isDedup()) {
            buffer_size_times2 += Validate.getDedupUnit() * 2;
        }
        Patterns.options.pattern_array = new int[buffer_size_times2 / 4];
        if (Validate.isCompression()) {
            Patterns.createCompressionPattern(Patterns.options.pattern_array, Validate.getCompressionRatio());
        } else {
            Patterns.createCompressionPattern(Patterns.options.pattern_array, 1.0);
        }
        if (Patterns.options.pattern_file != null) {
            Patterns.options.pattern_array = Patterns.readPattern(buffer_size_times2);
        }
        Native.store_pattern(Patterns.options.pattern_array);
    }

    private static int calculatePatternBufferSize(int n) {
        int n2 = 0x100000;
        int n3 = n2 * Validate.getPatternMB();
        if (n <= n3) {
            return n3;
        }
        return (n + n2 - 1) / n2 * n2;
    }

    public static int getBufferSize() {
        return buffer_size;
    }

    public static void main(String[] stringArray) {
        String string = stringArray[0];
        int n = string.endsWith("k") ? Integer.parseInt(string.substring(0, string.length() - 1)) * 1024 : (string.endsWith("m") ? Integer.parseInt(string.substring(0, string.length() - 1)) * 1024 * 1024 : Integer.parseInt(string));
        common.ptod("calculatePatternBufferSize(kb): %,12d %,12d", n, Patterns.calculatePatternBufferSize(n));
    }

    private static void createCompressionPattern(int[] nArray, double d) {
        int n;
        int n2;
        long l = Validate.getCompSeed();
        Random random = new Random(l);
        double d2 = 0.0;
        if (!common.get_debug(common.DEBUG_COMPRESSION) && d > 25.0) {
            common.failure("'compratio=25' is the largest value Vdbench supports. Are you sure your request is valid, asking for compratio=%.2f? ", d);
            d = 25.0;
        }
        d2 = 0.0;
        for (n2 = 0; n2 < randomizer_value.length; n2 += 2) {
            d2 = randomizer_value[n2 + 1];
            if (randomizer_value[n2] >= d) break;
        }
        for (n2 = 0; n2 < nArray.length; ++n2) {
            nArray[n2] = (int)(random.nextDouble() * 2.147483647E9);
        }
        if (common.get_debug(common.DEBUG_COMPRESSION)) {
            common.ptod("comp_ratio: " + d);
            d2 = d;
        }
        n2 = 0;
        for (n = 0; n < nArray.length; ++n) {
            if (!(random.nextDouble() * 100.0 < d2 / 100.0)) continue;
            ++n2;
            nArray[n] = 0;
        }
        if (print_once++ == 999999999) {
            n = 0;
            while (n < nArray.length) {
                String string = String.format("0x%08x ", n * 4);
                int n3 = 0;
                while (n3 < 8) {
                    string = string + String.format("%08x ", nArray[n]);
                    ++n3;
                    ++n;
                }
                common.ptod(string);
            }
        }
    }

    private static int[] readPattern(int n) {
        File file = new File(Patterns.options.pattern_file);
        if (!file.exists()) {
            common.failure("readPattern() pattern file does not exist: " + new File(Patterns.options.pattern_file).getAbsolutePath());
        }
        int[] nArray = new int[n / 4];
        int[] nArray2 = new int[n];
        int n2 = 0;
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            DataInputStream dataInputStream = new DataInputStream(fileInputStream);
            while (n2 < n) {
                try {
                    int n3 = dataInputStream.readUnsignedByte();
                    nArray2[n2++] = n3;
                }
                catch (IOException iOException) {
                    // empty catch block
                    break;
                }
            }
            if (n2 == 0) {
                common.failure("Pattern file empty: " + file.getAbsolutePath());
            }
            dataInputStream.close();
            if (n2 % 4 != 0) {
                common.ptod("Data pattern length for file '" + file.getAbsolutePath() + "' must be a multiple of 4. Input length of " + n2 + " truncated. Possible cr/lf? ");
                n2 -= n2 % 4;
            }
            if (n2 == 0) {
                common.failure("Data pattern length for file '" + file.getAbsolutePath() + "' must be a minimum of 4 bytes ");
            }
            for (int i = 0; i < n; i += 4) {
                long l = 0L;
                l += (long)(nArray2[(i + 0) % n2] << 24);
                l += (long)(nArray2[(i + 1) % n2] << 16);
                l += (long)(nArray2[(i + 2) % n2] << 8);
                nArray[i / 4] = (int)(l += (long)nArray2[(i + 3) % n2]);
            }
            common.ptod("Successfully loaded data pattern from " + file.getAbsolutePath());
        }
        catch (Exception exception) {
            common.failure(exception);
        }
        return nArray;
    }

    public static void copyPatternToBuffer(long l, int n) {
        Native.arrayToBuffer(Patterns.getPattern(), l, n);
    }

    public static void storeStartingSdPattern(long l, int n) {
        if (Validate.isCompression() || Patterns.options.pattern_file != null) {
            Native.arrayToBuffer(Patterns.getPattern(), l, n);
        } else {
            Patterns.copyPatternToBuffer(l, n);
        }
    }

    public static void storeStartingFsdPattern(long l, int n) {
        if (Validate.isCompression() || Patterns.options.pattern_file != null) {
            Native.arrayToBuffer(Patterns.getPattern(), l, n);
        } else {
            Patterns.copyPatternToBuffer(l, n);
        }
    }

    public static void parsePattern(String[] stringArray) {
        if (stringArray.length > 1) {
            common.failure("Only ONE pattern= parameter value may be coded. ");
        }
        String string = stringArray[0];
        if (Patterns.options.pattern_coded) {
            common.failure("'pattern=' may be used only once.");
        }
        Patterns.options.pattern_coded = true;
        Patterns.options.pattern_file = string;
    }

    public static void checkPattern() {
        if (Dedup.isDedup() && Patterns.options.pattern_coded) {
            common.failure("parsePatterns(): dedupratio= and pattern= are mutually exclusive");
        }
        if (!common.get_debug(common.DV_ALLOW_PATTERN)) {
            if (Validate.isValidate() && Patterns.options.pattern_coded) {
                common.failure("parsePatterns(): validate=yes and pattern= are mutually exclusive");
            }
            if (Validate.isCompressionRequested() && Patterns.options.pattern_coded) {
                common.failure("parsePatterns(): compratio= and pattern= are mutually exclusive");
            }
        } else {
            common.ptod("User requested the use of patterns=/file/name");
            common.ptod("This by default is not allowed when Data Validation is active.");
            common.ptod("This check is now bypassed.");
            Patterns.setDefaultCompressionRatio(2.0);
        }
    }

    private static double[] set7000Numbers() {
        double[] dArray = new double[]{1.0, 0.0, 1.1, 3500.0, 1.15, 3600.0, 1.16, 3700.0, 1.17, 3800.0, 1.19, 3900.0, 1.2, 4000.0, 1.21, 4100.0, 1.23, 4200.0, 1.24, 4300.0, 1.26, 4400.0, 1.27, 4500.0, 1.29, 4600.0, 1.31, 4700.0, 1.32, 4800.0, 1.34, 4900.0, 1.36, 5000.0, 1.38, 5100.0, 1.4, 5200.0, 1.42, 5300.0, 1.45, 5400.0, 1.47, 5500.0, 1.49, 5600.0, 1.52, 5700.0, 1.55, 5800.0, 1.57, 5900.0, 1.6, 6000.0, 1.64, 6100.0, 1.67, 6200.0, 1.7, 6300.0, 1.74, 6400.0, 1.78, 6500.0, 1.82, 6600.0, 1.87, 6700.0, 1.92, 6800.0, 1.97, 6900.0, 2.02, 7000.0, 2.08, 7100.0, 2.13, 7200.0, 2.2, 7300.0, 2.27, 7400.0, 2.34, 7500.0, 2.43, 7600.0, 2.52, 7700.0, 2.62, 7800.0, 2.72, 7900.0, 2.84, 8000.0, 2.96, 8100.0, 3.1, 8200.0, 3.25, 8300.0, 3.42, 8400.0, 3.62, 8500.0, 3.83, 8600.0, 4.06, 8700.0, 4.33, 8800.0, 4.66, 8900.0, 5.04, 9000.0, 5.08, 9010.0, 5.12, 9020.0, 5.18, 9030.0, 5.21, 9040.0, 5.26, 9050.0, 5.29, 9060.0, 5.35, 9070.0, 5.4, 9080.0, 5.45, 9090.0, 5.49, 9100.0, 5.55, 9110.0, 5.6, 9120.0, 5.67, 9130.0, 5.71, 9140.0, 5.74, 9150.0, 5.84, 9160.0, 5.87, 9170.0, 5.9, 9180.0, 5.97, 9190.0, 6.03, 9200.0, 6.12, 9210.0, 6.19, 9220.0, 6.19, 9230.0, 6.3, 9240.0, 6.34, 9250.0, 6.38, 9260.0, 6.5, 9270.0, 6.55, 9280.0, 6.63, 9290.0, 6.67, 9300.0, 6.76, 9310.0, 6.81, 9320.0, 6.9, 9330.0, 6.99, 9340.0, 7.04, 9350.0, 7.16, 9360.0, 7.24, 9370.0, 7.34, 9380.0, 7.4, 9390.0, 7.56, 9400.0, 7.59, 9410.0, 7.68, 9420.0, 7.82, 9430.0, 7.85, 9440.0, 7.97, 9450.0, 8.07, 9460.0, 8.23, 9470.0, 8.33, 9480.0, 8.4, 9490.0, 8.61, 9500.0, 8.65, 9510.0, 8.8, 9520.0, 8.91, 9530.0, 9.07, 9540.0, 9.23, 9550.0, 9.4, 9560.0, 9.49, 9570.0, 9.62, 9580.0, 9.76, 9590.0, 9.95, 9600.0, 10.15, 9610.0, 10.25, 9620.0, 10.46, 9630.0, 10.62, 9640.0, 10.85, 9650.0, 11.02, 9660.0, 11.21, 9670.0, 11.39, 9680.0, 11.65, 9690.0, 11.79, 9700.0, 12.21, 9710.0, 12.23, 9720.0, 12.44, 9730.0, 12.82, 9740.0, 12.98, 9750.0, 13.5, 9760.0, 13.5, 9770.0, 13.95, 9780.0, 14.25, 9790.0, 14.55, 9800.0, 14.98, 9810.0, 15.2, 9820.0, 15.78, 9830.0, 16.03, 9840.0, 16.55, 9850.0, 16.97, 9860.0, 17.25, 9870.0, 18.0, 9880.0, 18.17, 9890.0, 19.37, 9900.0, 19.56, 9910.0, 20.54, 9920.0, 21.18, 9930.0, 21.62, 9940.0, 23.09, 9950.0, 23.09, 9960.0, 24.76, 9970.0, 25.38, 9980.0, 25.69, 9990.0};
        return dArray;
    }

    static {
        randomizer_value = Patterns.set7000Numbers();
        default_compression = 1.0;
    }
}

