/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import User.UserClass;
import User.UserCmd;
import User.UserDeviceInfo;
import User.WorkloadInfo;
import Utils.Bin;
import Utils.Flat_record;
import Vdb.ReplayDevice;
import Vdb.ReplayInfo;
import Vdb.SD_entry;
import Vdb.common;

public class ReplayGen
extends UserClass {
    private static final String c = "Copyright (c) 2000, 2014, Oracle and/or its affiliates. All rights reserved.";
    private SD_entry sd_used;
    private UserDeviceInfo dev_info;
    private WorkloadInfo work_info;
    private Bin[] split_bin_files;
    private Flat_record[] split_records;
    private int lowest_index;
    private long begin_offset;
    private long last_start_time = 0L;
    private int repeat_count = 0;
    private long repeat_tod_adjust = 0L;

    @Override
    public UserDeviceInfo initialize(WorkloadInfo workloadInfo) {
        this.work_info = workloadInfo;
        this.dev_info = super.initialize(workloadInfo);
        this.sd_used = workloadInfo.getSd();
        this.openSplitInputFiles();
        this.begin_offset = ReplayDevice.getAllDevicesFirstTod() / 1000000L * 1000000L;
        return this.dev_info;
    }

    @Override
    public boolean generate() {
        long l = Long.MAX_VALUE;
        ReplayDevice replayDevice = null;
        double d = ReplayInfo.getAdjustValue();
        this.work_info.setFirstStartDelta(0L);
        long l2 = 0L;
        boolean bl = false;
        long l3 = 0L;
        while (!this.isWorkloadDone()) {
            if (bl && l3++ > 20L) {
                System.exit(777);
            }
            Flat_record flat_record = this.split_records[this.lowest_index];
            flat_record.start -= this.begin_offset;
            if (ReplayInfo.duplicationNeeded()) {
                flat_record.device = ReplayDevice.addDupToDevnum(flat_record.device, this.sd_used.duplicate_number);
            }
            if (l != flat_record.device) {
                replayDevice = ReplayDevice.findExistingDevice(flat_record.device);
                l = flat_record.device;
            }
            if (bl) {
                common.where();
            }
            if (replayDevice.findExtentForLbaFlat(this.sd_used, flat_record) != this.sd_used) {
                if (bl) {
                    common.where();
                }
                if (this.getNextReplayRecord()) continue;
                break;
            }
            if (bl) {
                common.where();
            }
            if (flat_record.lba == 0L) {
                flat_record.xfersize = 4096;
                flat_record.lba = 4096;
            }
            flat_record.start = (long)((double)flat_record.start * d);
            flat_record.start += this.repeat_tod_adjust;
            long l4 = flat_record.start - this.last_start_time;
            if (!this.work_info.scheduleIO(l4, flat_record.lba, flat_record.xfersize, flat_record.flag == 1)) break;
            ++l2;
            this.last_start_time = flat_record.start;
            if (this.getNextReplayRecord()) continue;
            break;
        }
        this.work_info.setEOF(l2);
        this.closeSplitInputFiles();
        return l2 != 0L;
    }

    @Override
    public boolean preIO(UserCmd userCmd) {
        return true;
    }

    @Override
    public boolean postIO(UserCmd userCmd) {
        return true;
    }

    private void openSplitInputFiles() {
        int n;
        long[] lArray = ReplayDevice.getDeviceNumbersForSd(this.sd_used.sd_name);
        this.split_bin_files = new Bin[lArray.length];
        this.split_records = new Flat_record[lArray.length];
        for (n = 0; n < lArray.length; ++n) {
            ReplayDevice replayDevice = ReplayDevice.findDeviceAndCreate(lArray[n]);
            common.ptod("rdev.getSplitFileName(): " + replayDevice.getSplitFileName());
            this.split_bin_files[n] = new Bin(replayDevice.getSplitFileName());
            this.split_bin_files[n].input();
            this.split_bin_files[n].read_record();
            this.split_records[n] = new Flat_record();
            this.emportBinRecord(n);
        }
        this.lowest_index = 0;
        for (n = 1; n < lArray.length; ++n) {
            if (this.split_records[n].start >= this.split_records[this.lowest_index].start) continue;
            this.lowest_index = n;
        }
    }

    private void closeSplitInputFiles() {
        long[] lArray = ReplayDevice.getDeviceNumbersForSd(this.sd_used.sd_name);
        for (int i = 0; i < this.split_bin_files.length; ++i) {
            this.split_bin_files[i].close();
        }
    }

    private boolean getNextReplayRecord() {
        if (!this.split_bin_files[this.lowest_index].read_record()) {
            this.split_records[this.lowest_index].start = Long.MAX_VALUE;
        } else {
            this.emportBinRecord(this.lowest_index);
        }
        this.lowest_index = 0;
        for (int i = 1; i < this.split_records.length; ++i) {
            if (this.split_records[i].start >= this.split_records[this.lowest_index].start) continue;
            this.lowest_index = i;
        }
        if (this.split_records[this.lowest_index].start != Long.MAX_VALUE) {
            return true;
        }
        ++this.repeat_count;
        if (ReplayInfo.getRepeatCount() == this.repeat_count) {
            return false;
        }
        this.closeSplitInputFiles();
        this.openSplitInputFiles();
        this.repeat_tod_adjust = this.last_start_time;
        this.repeat_tod_adjust = this.repeat_tod_adjust / 1000000L * 1000000L + 1000000L;
        return true;
    }

    private void emportBinRecord(int n) {
        this.split_records[n].emport(this.split_bin_files[n]);
        long l = (this.sd_used.duplicate_number - 1L) * ReplayInfo.getStagger();
        this.split_records[n].start += l;
    }
}

