/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Utils.printf;
import Vdb.ReplayDevice;
import Vdb.ReplayInfo;
import Vdb.SD_entry;
import Vdb.common;
import java.io.Serializable;
import java.util.Vector;

class ReplayGroup
implements Serializable {
    private static final String c = "Copyright (c) 2000, 2014, Oracle and/or its affiliates. All rights reserved.";
    private String group_name;
    private Vector device_list = new Vector(8, 0);
    private double total_group_bytes = 0.0;
    private boolean reporting_only = false;
    private long bytes_needed;
    private transient Vector sds_in_this_group = new Vector(8, 0);
    private static ReplayGroup reporting_group = new ReplayGroup();
    static double GB = 1.073741824E9;

    public ReplayGroup() {
        this.group_name = "reporting_only";
        this.reporting_only = true;
    }

    public ReplayGroup(String string) {
        Vector vector = ReplayInfo.getGroupList();
        for (int i = 0; i < vector.size(); ++i) {
            ReplayGroup replayGroup = (ReplayGroup)vector.elementAt(i);
            if (!replayGroup.group_name.equals(string)) continue;
            common.failure("Adding duplicate ReplayGroup: " + string);
        }
        this.group_name = string;
        vector.addElement(this);
    }

    public String getName() {
        return this.group_name;
    }

    public boolean isReportingOnly() {
        return this.reporting_only;
    }

    public static ReplayGroup getReportingOnlyGroup() {
        return reporting_group;
    }

    public ReplayGroup findGroup(String string) {
        Vector vector = ReplayInfo.getGroupList();
        for (int i = 0; i < vector.size(); ++i) {
            ReplayGroup replayGroup = (ReplayGroup)vector.elementAt(i);
            if (!replayGroup.group_name.equals(string)) continue;
            return replayGroup;
        }
        return null;
    }

    public Vector getDeviceList() {
        return this.device_list;
    }

    public Vector getSdList() {
        return this.sds_in_this_group;
    }

    public ReplayDevice addDevice(long l) {
        ReplayDevice replayDevice = new ReplayDevice(this, l);
        this.device_list.addElement(replayDevice);
        return replayDevice;
    }

    public void addSD(SD_entry sD_entry) {
        this.sds_in_this_group.addElement(sD_entry);
    }

    public static void addSDGroup(SD_entry sD_entry, String string) {
        Vector vector = ReplayInfo.getGroupList();
        for (int i = 0; i < vector.size(); ++i) {
            ReplayGroup replayGroup = (ReplayGroup)vector.elementAt(i);
            if (!replayGroup.group_name.equals(string)) continue;
            replayGroup.sds_in_this_group.addElement(sD_entry);
            return;
        }
        common.failure("addSD: no Replay Group found: " + string);
    }

    public static void calculateGroupSDSizes(Vector vector) {
        Vector vector2 = ReplayInfo.getGroupList();
        for (int i = 0; i < vector2.size(); ++i) {
            ReplayGroup replayGroup = (ReplayGroup)vector2.elementAt(i);
            if (replayGroup.sds_in_this_group.size() == 0) {
                common.ptod("No SDs found for replay group: " + replayGroup.group_name);
                common.ptod("Did you possibly use both replay groups and replay devices in the SD?");
                common.failure("No SDs found for replay group: " + replayGroup.group_name);
            }
            for (int j = 0; j < replayGroup.sds_in_this_group.size(); ++j) {
                SD_entry sD_entry = (SD_entry)replayGroup.sds_in_this_group.elementAt(j);
                replayGroup.total_group_bytes += (double)sD_entry.end_lba;
            }
        }
    }

    public static void calculateGroupSizes() {
        boolean bl = false;
        Vector vector = ReplayInfo.getGroupList();
        for (int i = 0; i < vector.size(); ++i) {
            ReplayGroup replayGroup = (ReplayGroup)vector.elementAt(i);
            if (replayGroup.sds_in_this_group.size() == 0) {
                common.failure("No SDs found for replay group: " + replayGroup.group_name);
            }
            replayGroup.bytes_needed = 0L;
            for (int j = 0; j < replayGroup.device_list.size(); ++j) {
                ReplayDevice replayDevice = (ReplayDevice)replayGroup.device_list.elementAt(j);
                replayGroup.bytes_needed += replayDevice.getMaxLba();
            }
            if (!((double)replayGroup.bytes_needed > replayGroup.total_group_bytes)) continue;
            printf printf2 = new printf("Replay Group %s needs a total of %7.3fg; only %7.3fg available");
            printf2.add(replayGroup.group_name);
            printf2.add((double)replayGroup.bytes_needed / GB);
            printf2.add(replayGroup.total_group_bytes / GB);
            common.ptod(printf2.print());
            bl = true;
        }
        if (bl && !common.get_debug(common.IGNORE_MISSING_REPLAY)) {
            common.failure("Not every replay group has enough lun space available");
        }
    }
}

