/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Vdb.MiscParms;
import Vdb.ReplayDevice;
import Vdb.common;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Vector;

public class ReplayInfo
implements Serializable {
    private static final String c = "Copyright (c) 2000, 2014, Oracle and/or its affiliates. All rights reserved.";
    private boolean replay = false;
    private int repeat = 1;
    private String replay_filename;
    private String split_directory;
    private double replay_adjust;
    private boolean duplication = false;
    private long stagger = 0L;
    private boolean compress = true;
    private long low_start_filter = 0L;
    private long high_start_filter = Long.MAX_VALUE;
    private long lba_fold_size = Long.MAX_VALUE;
    private HashMap<Long, ReplayDevice> device_map = new HashMap(64);
    private Vector group_list = new Vector(16, 0);
    private static ReplayInfo info = new ReplayInfo();

    public static ReplayInfo getInfo() {
        return info;
    }

    public static void setInfo(ReplayInfo replayInfo) {
        info = replayInfo;
    }

    public static void setReplay() {
        if (!ReplayInfo.info.replay) {
            ReplayInfo.info.replay = true;
            info.findFilter();
        }
    }

    public static boolean isReplay() {
        return ReplayInfo.info.replay;
    }

    public static int getRepeatCount() {
        return ReplayInfo.info.repeat;
    }

    public static HashMap getDeviceMap() {
        return ReplayInfo.info.device_map;
    }

    public static long getLowFilter() {
        return ReplayInfo.info.low_start_filter;
    }

    public static long getHighFilter() {
        return ReplayInfo.info.high_start_filter;
    }

    public static long getFoldSize() {
        return ReplayInfo.info.lba_fold_size;
    }

    public static Vector getGroupList() {
        return ReplayInfo.info.group_list;
    }

    public Vector<ReplayDevice> getDeviceList() {
        Object[] objectArray = this.device_map.keySet().toArray(new Long[0]);
        Arrays.sort(objectArray);
        Vector<ReplayDevice> vector = new Vector<ReplayDevice>(objectArray.length);
        for (int i = 0; i < objectArray.length; ++i) {
            vector.add(this.device_map.get(objectArray[i]));
        }
        return vector;
    }

    public static Vector<ReplayDevice> getNodupDevs() {
        Object[] objectArray = ReplayInfo.info.device_map.keySet().toArray(new Long[0]);
        Arrays.sort(objectArray);
        Vector<ReplayDevice> vector = new Vector<ReplayDevice>(objectArray.length);
        for (int i = 0; i < objectArray.length; ++i) {
            ReplayDevice replayDevice = ReplayInfo.info.device_map.get(objectArray[i]);
            if (replayDevice.getDuplicateNumber() != 0L) continue;
            vector.add(replayDevice);
        }
        return vector;
    }

    public static Vector<ReplayDevice> getDupDevs() {
        Object[] objectArray = ReplayInfo.info.device_map.keySet().toArray(new Long[0]);
        Arrays.sort(objectArray);
        Vector<ReplayDevice> vector = new Vector<ReplayDevice>(objectArray.length);
        for (int i = 0; i < objectArray.length; ++i) {
            ReplayDevice replayDevice = ReplayInfo.info.device_map.get(objectArray[i]);
            if (replayDevice.getDuplicateNumber() == 0L) continue;
            vector.add(replayDevice);
        }
        return vector;
    }

    public void parseParameters(String[] stringArray) {
        File file;
        this.replay_filename = stringArray[0];
        if (!new File(this.replay_filename).exists()) {
            common.failure("storeParameters(names): replay file name does not exist: " + this.replay_filename);
        }
        this.split_directory = new File(this.replay_filename).getAbsoluteFile().getParent();
        if (stringArray.length > 1) {
            for (int i = 1; i < stringArray.length; ++i) {
                String string = stringArray[i].trim();
                String[] stringArray2 = string.split("=");
                if (stringArray2.length != 2) {
                    common.failure("Invalid Replay parameter. Must be xx=yy: " + string);
                }
                if ("repeat".startsWith(stringArray2[0])) {
                    this.repeat = Integer.parseInt(stringArray2[1]);
                    continue;
                }
                if ("split".startsWith(stringArray2[0])) {
                    this.split_directory = stringArray2[1];
                    continue;
                }
                if ("duplication".startsWith(stringArray2[0])) {
                    this.duplication = stringArray2[1].toLowerCase().startsWith("y");
                    continue;
                }
                if ("stagger".startsWith(stringArray2[0])) {
                    this.stagger = Long.parseLong(stringArray2[1]) * 1000L;
                    continue;
                }
                if ("compress".startsWith(stringArray2[0])) {
                    this.compress = stringArray2[1].toLowerCase().startsWith("y");
                    continue;
                }
                common.failure("Unknown Replay parameter: " + string);
            }
        }
        if ((file = new File(this.split_directory)).exists() && !file.isDirectory()) {
            common.failure("Replay file target directory %s exists but is not a directory", this.split_directory);
        } else if (!file.exists() && !file.mkdir()) {
            common.failure("Replay file target directory %s can not be created", this.split_directory);
        }
    }

    public static String getReplayFile() {
        return ReplayInfo.info.replay_filename;
    }

    public static String getSplitDirectory() {
        return ReplayInfo.info.split_directory;
    }

    public static void setAdjustValue(double d) {
        ReplayInfo.info.replay_adjust = d;
    }

    public static double getAdjustValue() {
        return ReplayInfo.info.replay_adjust;
    }

    public static boolean duplicationNeeded() {
        return ReplayInfo.info.duplication;
    }

    public static long getStagger() {
        return ReplayInfo.info.stagger;
    }

    public static boolean compress() {
        return ReplayInfo.info.compress;
    }

    private void findFilter() {
        ArrayList<String[]> arrayList = MiscParms.getMiscellaneous();
        for (String[] stringArray : arrayList) {
            for (String string : stringArray) {
                String[] stringArray2 = string.trim().split("=");
                if (string.startsWith("low_start_filter") && stringArray2.length == 2) {
                    this.low_start_filter = Long.parseLong(stringArray2[1]) * 1000000L;
                } else if (string.startsWith("high_start_filter") && stringArray2.length == 2) {
                    this.high_start_filter = Long.parseLong(stringArray2[1]) * 1000000L;
                } else {
                    if (!string.startsWith("lba_fold_size_mb") || stringArray2.length != 2) continue;
                    this.lba_fold_size = Long.parseLong(stringArray2[1]) * 1024L * 1024L;
                }
                common.ptod("ReplayInfo.findFilter() 'misc=' input found: " + string);
            }
        }
    }
}

