/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Utils.Fget;
import Utils.Format;
import Vdb.RD_entry;
import Vdb.ReplayDevice;
import Vdb.ReplayExtent;
import Vdb.ReplayGroup;
import Vdb.ReplayInfo;
import Vdb.SD_entry;
import Vdb.SlaveList;
import Vdb.Vdb_scan;
import Vdb.Vdbmain;
import Vdb.WG_entry;
import Vdb.common;
import java.util.Vector;

public class ReplayRun {
    private static final String c = "Copyright (c) 2000, 2014, Oracle and/or its affiliates. All rights reserved.";

    static String readParms(String string) {
        String string2;
        block9: {
            string2 = string;
            ReplayGroup replayGroup = null;
            try {
                do {
                    if (string2 == null) continue;
                    Vdb_scan vdb_scan = Vdb_scan.parms_split(string2);
                    if (vdb_scan.keyword.equals("wd") || vdb_scan.keyword.equals("fwd") || vdb_scan.keyword.equals("sd") || vdb_scan.keyword.equals("fsd") || vdb_scan.keyword.equals("rd")) break block9;
                    if (vdb_scan.keyword.equals("rg")) {
                        ReplayInfo.setReplay();
                        replayGroup = new ReplayGroup(vdb_scan.alphas[0]);
                        continue;
                    }
                    if ("devices".startsWith(vdb_scan.keyword)) {
                        if (vdb_scan.getNumCount() == 0) {
                            common.failure("Expecting parameters for 'devices='");
                        }
                        for (int i = 0; i < vdb_scan.numerics.length; ++i) {
                            replayGroup.addDevice((long)vdb_scan.numerics[i]);
                        }
                    } else {
                        common.failure("Unknown keyword: " + vdb_scan.keyword);
                    }
                } while ((string2 = Vdb_scan.parms_get()) != null);
                return null;
            }
            catch (Exception exception) {
                common.ptod(exception);
                common.ptod("Exception during reading of input parameter file(s).");
                common.ptod("Look at the end of 'parmscan.html' to identify the last parameter scanned.");
                common.failure("Exception during reading of input parameter file(s).");
            }
        }
        return string2;
    }

    public static void setupTraceRun() {
        int n = 0;
        for (int i = 0; i < Vdbmain.rd_list.size(); ++i) {
            RD_entry rD_entry = Vdbmain.rd_list.elementAt(i);
            if (rD_entry.rd_name.startsWith(SD_entry.SD_FORMAT_NAME)) continue;
            ++n;
        }
        RD_entry rD_entry = Vdbmain.rd_list.lastElement();
        ReplayRun.roundLbas();
        ReplayDevice.reportNumbers();
        ReplayGroup.calculateGroupSizes();
        ReplayExtent.createExtents();
        WG_entry.setSequentialFileCount(ReplayDevice.countUsedDevices());
        ReplayRun.activateSDsForReplay(rD_entry);
        double d = (double)ReplayDevice.getAllDevicesLastTod() / 1000000.0;
        double d2 = (double)ReplayDevice.getTotalIoCount() / d;
        common.ptod("Replay selected i/o count: %,d; traced elapsed time %.2f seconds; traced i/o rate: %.6f", ReplayDevice.getTotalIoCount(), d, d2);
        if (rD_entry.iorate_req == 0.0) {
            rD_entry.iorate_req = d2;
        }
        ReplayInfo.setAdjustValue(d2 / rD_entry.iorate_req);
        common.ptod(Format.f("Replay arrival time adjustment: %.8f", ReplayInfo.getAdjustValue()));
    }

    private static void roundLbas() {
        long l = 0x100000L;
        long l2 = 0L;
        Vector<ReplayDevice> vector = ReplayInfo.getInfo().getDeviceList();
        for (int i = 0; i < vector.size(); ++i) {
            ReplayDevice replayDevice = vector.elementAt(i);
            if (replayDevice.isReportingOnly()) continue;
            l2 = Math.max(l2, (long)replayDevice.getMaxXfersize());
        }
        long l3 = l2;
        l2 += l - 1L;
        l2 = l2 / l * l;
        for (int i = 0; i < vector.size(); ++i) {
            ReplayDevice replayDevice = vector.elementAt(i);
            if (replayDevice.isReportingOnly()) continue;
            long l4 = replayDevice.getMaxLba();
            replayDevice.setMaxLba(l2 != 0L ? ((l4 += l2 - 1L) + l3) / l2 * l2 : 0L);
        }
        common.ptod("");
        common.ptod("The high lba for each device has been rounded upwards to the next " + l2 + " bytes,");
        common.ptod("which is the maximum xfersize (" + l3 + ") rounded upwards to the next megabyte.");
        common.ptod("");
    }

    private static void activateSDsForReplay(RD_entry rD_entry) {
        for (int i = 0; i < Vdbmain.sd_list.size(); ++i) {
            SD_entry sD_entry = Vdbmain.sd_list.elementAt(i);
            rD_entry.setThreadsUsedForSlave(sD_entry.sd_name, SlaveList.getSlaveList().firstElement(), sD_entry.threads);
            sD_entry.setOpenForWrite();
        }
    }

    public static void main2(String[] stringArray) {
        String[] stringArray2;
        int n = Integer.parseInt(stringArray[0]);
        for (String string : stringArray2 = Fget.readFileToArray(stringArray[1])) {
            if ((string = string.trim()).length() == 0 || !string.startsWith("sd=") || string.contains("default")) continue;
            string = string.substring(0, string.indexOf(" "));
            String[] stringArray3 = string.split(",+");
            for (int i = 0; i < n; ++i) {
                String string2 = String.format("%s_%02d,%s,%s%02d", stringArray3[0], i, stringArray3[1], stringArray3[2], i);
                System.out.println(string2);
            }
        }
    }

    public static void main3(String[] stringArray) {
        int n = Integer.parseInt(stringArray[0]);
        String[] stringArray2 = Fget.readFileToArray(stringArray[1]);
        int n2 = 0;
        for (String string : stringArray2) {
            if ((string = string.trim()).length() == 0 || !string.startsWith("sd=") || string.contains("default")) continue;
            string = string.substring(0, string.indexOf(" "));
            String[] stringArray3 = string.split(",+");
            for (int i = 0; i < n; ++i) {
                String string2 = String.format("%s_%02d,lun=/vm%02d/linux-flat.vmdk%d,%s%02d", stringArray3[0], i, i + 1, ++n2, stringArray3[2], i);
                System.out.println(string2);
                if (n2 % 100 != 0) continue;
                System.out.println();
            }
        }
    }

    public static void main4(String[] stringArray) {
        String[] stringArray2 = Fget.readFileToArray(stringArray[0]);
        int n = Integer.parseInt(stringArray[1]);
        int n2 = 1;
        int n3 = 1 + stringArray2.length * n;
        for (String string : stringArray2) {
            long l = Long.parseLong(string);
            String string2 = String.format("sd=sd%04d,lun=/vm%02d/linux0%d-flat.vmdk,replay=%d%02d", n2++, (n3 - 1) % 4 + 1, n3, l, n);
            ++n3;
            System.out.println(string2);
        }
        System.out.println();
    }

    public static void main5(String[] stringArray) {
        String[] stringArray2 = Fget.readFileToArray(stringArray[0]);
        int n = Integer.parseInt(stringArray[1]);
        int n2 = 1;
        int n3 = 1 + stringArray2.length * n;
        for (String string : stringArray2) {
            long l = Long.parseLong(string);
            String string2 = String.format("sd=sd%04d,lun=/clone%05d/original_boot,replay=%d%02d", n2++, n3, l, n);
            ++n3;
            System.out.println(string2);
        }
        System.out.println();
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = Fget.readFileToArray(stringArray[0]);
        int n = Integer.parseInt(stringArray[1]);
        int n2 = 1;
        int n3 = 1 + stringArray2.length * n / 4;
        for (int i = 0; i < stringArray2.length; ++i) {
            String string = stringArray2[i];
            long l = Long.parseLong(string);
            String string2 = String.format("fs%d", i % 4 + 1);
            long l2 = n3 + i / 4;
            long l3 = i % 4 + 1;
            String string3 = String.format("sd=sd%04d,lun=/%s/clone%05d/original_boot,replay=%d  ", n2++, string2, l2++, l);
            System.out.println(string3);
        }
        System.out.println();
    }
}

