/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Utils.Bin;
import Utils.Fget;
import Utils.Flat_record;
import Utils.Fput;
import Vdb.ReplayDevice;
import Vdb.ReplayInfo;
import Vdb.Signal;
import Vdb.SlaveJvm;
import Vdb.SocketMessage;
import Vdb.common;
import java.io.File;
import java.util.Vector;

public class ReplaySplit {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";

    public static void readAndSplitTraceFile() {
        long l = 0L;
        String string = ReplayInfo.getReplayFile();
        String string2 = ReplayInfo.getSplitDirectory();
        long l2 = ReplayInfo.getLowFilter();
        long l3 = ReplayInfo.getHighFilter();
        long l4 = ReplayInfo.getFoldSize();
        boolean bl = ReplaySplit.doWeNeedToReadReplayFile();
        common.ptod("doWeNeedToReadReplayFile: " + bl);
        if (!bl) {
            common.ptod("Reading replay file bypassed: " + string);
            return;
        }
        ReplaySplit.deleteFiles();
        ReplaySplit.resetCounters();
        common.ptod("+");
        common.ptod("+Reading replay file " + string);
        common.ptod("+");
        Bin bin = new Bin(string);
        bin.input();
        Flat_record flat_record = new Flat_record();
        Signal signal = new Signal(5);
        while (bin.read_record()) {
            if (++l % 100000L == 0L && signal.go()) {
                SlaveJvm.sendMessageToMaster(SocketMessage.HEARTBEAT_MESSAGE);
                SlaveJvm.getMasterSocket().setlastHeartBeat();
                SlaveJvm.sendMessageToConsole("Splitting replay file. %,d records processed.", l);
            }
            flat_record.emport(bin);
            if (flat_record.start < l2) continue;
            if (flat_record.start > l3) break;
            if (l4 != Long.MAX_VALUE) {
                flat_record.lba %= l4;
            }
            flat_record.xfersize = flat_record.xfersize + 511 & 0xFFFFFE00;
            ReplayDevice replayDevice = ReplayDevice.findDeviceAndCreate(flat_record.device);
            replayDevice.countRecords();
            replayDevice.setMinLba(flat_record.lba);
            replayDevice.setMaxLba(flat_record.lba + (long)flat_record.xfersize);
            replayDevice.setMaxXfersize(flat_record.xfersize);
            if (replayDevice.isReportingOnly()) continue;
            if (replayDevice.getFirstTod() == Long.MAX_VALUE) {
                replayDevice.setFirstTod(flat_record.start);
            }
            replayDevice.setLastTod(flat_record.start);
            replayDevice.writeSplitRecord(flat_record);
        }
        bin.close();
        ReplayDevice.closeSplitFiles();
        ReplaySplit.saveReplayFileInformation();
        common.ptod("Reading replay file completed: " + string);
    }

    private static void deleteFiles() {
        String string = ReplayInfo.getSplitDirectory();
        File[] fileArray = new File(string).listFiles();
        for (int i = 0; fileArray != null && i < fileArray.length; ++i) {
            if (!fileArray[i].getName().startsWith(ReplayDevice.getSplitFileNamePrefix())) continue;
            fileArray[i].delete();
        }
    }

    private static void resetCounters() {
        Vector<ReplayDevice> vector = ReplayInfo.getInfo().getDeviceList();
        for (int i = 0; i < vector.size(); ++i) {
            ReplayDevice replayDevice = vector.elementAt(i);
            replayDevice.erase();
        }
    }

    private static void saveReplayFileInformation() {
        Fput fput = new Fput(ReplayInfo.getSplitDirectory(), "replay_file_status.txt");
        long l = new File(ReplayInfo.getReplayFile()).length();
        fput.println("replay_file %s %d", ReplayInfo.getReplayFile(), l);
        fput.println("low_start_filter %d", ReplayInfo.getLowFilter());
        fput.println("high_start_filter %d", ReplayInfo.getHighFilter());
        fput.println("lba_fold_size_mb %d", ReplayInfo.getFoldSize());
        fput.println("compress %b", ReplayInfo.compress());
        Vector<ReplayDevice> vector = ReplayInfo.getInfo().getDeviceList();
        if (ReplayInfo.duplicationNeeded()) {
            vector = ReplayInfo.getNodupDevs();
        }
        for (int i = 0; i < vector.size(); ++i) {
            ReplayDevice replayDevice = vector.elementAt(i);
            if (replayDevice.getRecordCount() <= 0L) continue;
            fput.println("replay_device %12d rep %d fsize%12d minlba %12d maxlba %12d maxxfer %7d first %12d last %12d records %12d dup# %4d", replayDevice.getDeviceNumber(), replayDevice.isReportingOnly() ? 1 : 0, new File(replayDevice.getSplitFileName()).length(), replayDevice.getMinLba(), replayDevice.getMaxLba(), replayDevice.getMaxXfersize(), replayDevice.getFirstTod(), replayDevice.getLastTod(), replayDevice.getRecordCount(), replayDevice.getDuplicateNumber());
        }
        fput.close();
    }

    private static boolean doWeNeedToReadReplayFile() {
        Object object;
        if (common.get_debug(common.FORCE_REPLAY_SPLIT)) {
            common.plog("doWeNeedToReadReplayFile(): Forced by debug parameter");
            return true;
        }
        String string = ReplayInfo.getSplitDirectory();
        if (!new File(string, "replay_file_status.txt").exists()) {
            common.plog("doWeNeedToReadReplayFile(): no replay_file_status.txt file found");
            return true;
        }
        String[] stringArray = Fget.readFileToArray(string, "replay_file_status.txt");
        for (int i = 0; i < stringArray.length; ++i) {
            long l;
            long l2;
            long l3;
            String string2 = stringArray[i];
            object = string2.split(" +");
            if (string2.startsWith("replay_file")) {
                if (!object[1].equals(ReplayInfo.getReplayFile())) {
                    common.plog("doWeNeedToReadReplayFile(): mismatched replay file name.");
                    common.plog("Expected: " + ReplayInfo.getReplayFile());
                    common.plog("Received: " + (String)object[1]);
                    return true;
                }
                l3 = new File(ReplayInfo.getReplayFile()).length();
                if (l3 == Long.parseLong((String)object[2])) continue;
                common.plog("doWeNeedToReadReplayFile(): mismatched replay file size.");
                common.plog("Expected: " + l3);
                common.plog("Received: " + (String)object[2]);
                return true;
            }
            if (string2.startsWith("lba_fold_size_mb")) {
                if (Long.parseLong((String)object[1]) == ReplayInfo.getFoldSize()) continue;
                common.plog("doWeNeedToReadReplayFile(): mismatched fold size.");
                common.plog("Expected: " + ReplayInfo.getFoldSize());
                common.plog("Received: " + (String)object[1]);
                return true;
            }
            if (string2.startsWith("low_start_filter")) {
                if (Long.parseLong((String)object[1]) == ReplayInfo.getLowFilter()) continue;
                common.plog("doWeNeedToReadReplayFile(): mismatched low filter.");
                common.plog("Expected: " + ReplayInfo.getLowFilter());
                common.plog("Received: " + (String)object[1]);
                return true;
            }
            if (string2.startsWith("high_start_filter")) {
                if (Long.parseLong((String)object[1]) == ReplayInfo.getHighFilter()) continue;
                common.plog("doWeNeedToReadReplayFile(): mismatched high filter.");
                common.plog("Expected: " + ReplayInfo.getHighFilter());
                common.plog("Received: " + (String)object[1]);
                return true;
            }
            if (string2.startsWith("compress")) {
                if ((!((String)object[1]).equalsIgnoreCase("true") || ReplayInfo.compress()) && (!((String)object[1]).equalsIgnoreCase("false") || !ReplayInfo.compress())) continue;
                common.plog("doWeNeedToReadReplayFile(): mismatched in compress= parameter.");
                return true;
            }
            if (!string2.startsWith("replay_device")) {
                common.plog("doWeNeedToReadReplayFile(): Unknown input: " + string2);
                return true;
            }
            l3 = Long.parseLong((String)object[1]);
            boolean bl = ReplaySplit.findLabel((String[])object, "rep") == 1L;
            ReplayDevice replayDevice = ReplayDevice.findExistingDevice(l3);
            if (!ReplayInfo.duplicationNeeded() && !bl && replayDevice == null) {
                common.plog("doWeNeedToReadReplayFile(): device %d switched to 'reporting only'", l3);
                return true;
            }
            replayDevice = ReplayDevice.findDeviceAndCreate(l3);
            String string3 = replayDevice.getSplitFileName();
            if (!bl && !new File(string3).exists()) {
                common.plog("doWeNeedToReadReplayFile(): Replay split file does not exist: " + string3);
                return true;
            }
            if (!bl && (l2 = ReplaySplit.findLabel((String[])object, "fsize")) != (l = new File(string3).length())) {
                common.plog("doWeNeedToReadReplayFile(): Replay split file size for %s does not match: %d/%d", string3, l2, l);
                return true;
            }
            l2 = ReplaySplit.findLabel((String[])object, "minlba");
            l = ReplaySplit.findLabel((String[])object, "maxlba");
            long l4 = ReplaySplit.findLabel((String[])object, "maxxfer");
            long l5 = ReplaySplit.findLabel((String[])object, "first");
            long l6 = ReplaySplit.findLabel((String[])object, "last");
            long l7 = ReplaySplit.findLabel((String[])object, "records");
            long l8 = ReplaySplit.findLabel((String[])object, "fsize");
            replayDevice.setMinLba(l2);
            replayDevice.setMaxLba(l);
            replayDevice.setMaxXfersize((int)l4);
            replayDevice.setFirstTod(l5);
            replayDevice.setLastTod(l6);
            replayDevice.setRecordCount(l7);
        }
        Vector<ReplayDevice> vector = ReplayInfo.getInfo().getDeviceList();
        for (int i = 0; i < vector.size(); ++i) {
            object = vector.elementAt(i);
            if (((ReplayDevice)object).isReportingOnly() || new File(((ReplayDevice)object).getSplitFileName()).exists()) continue;
            common.plog("doWeNeedToReadReplayFile(): Replay split file for device %d does not exist: %s", ((ReplayDevice)object).getDeviceNumber(), ((ReplayDevice)object).getSplitFileName());
            return true;
        }
        return false;
    }

    private static long findLabel(String[] stringArray, String string) {
        int n = -1;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            n = i;
        }
        if (n < 0) {
            common.failure("failure scanning file 'replay_file_status.txt'");
        }
        if (n == stringArray.length) {
            common.failure("failure scanning file 'replay_file_status.txt'");
        }
        return Long.parseLong(stringArray[n + 1]);
    }
}

