/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Utils.Format;
import Utils.OS_cmd;
import Utils.printf;
import Vdb.AnchorReport;
import Vdb.AuxReport;
import Vdb.CpuStats;
import Vdb.FinalTotals;
import Vdb.Flat;
import Vdb.FsdEntry;
import Vdb.FwdEntry;
import Vdb.FwdReport;
import Vdb.Host;
import Vdb.InfoFromHost;
import Vdb.InstancePointer;
import Vdb.Kstat_cpu;
import Vdb.Kstat_data;
import Vdb.MiscParms;
import Vdb.NfsStats;
import Vdb.RD_entry;
import Vdb.ReplayInfo;
import Vdb.ReportData;
import Vdb.Reporter;
import Vdb.SdReport;
import Vdb.SdStats;
import Vdb.Slave;
import Vdb.SlaveList;
import Vdb.Validate;
import Vdb.Vdbmain;
import Vdb.WdReport;
import Vdb.Work;
import Vdb.common;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Vector;

public class Report {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";
    private String fname;
    private PrintWriter pw;
    private String kstat_headers = null;
    private ReportData data = null;
    protected static boolean slave_detail = false;
    protected static boolean host_detail = false;
    private static boolean sd_detail = true;
    private static HashMap report_map = new HashMap(8);
    private static Report logfile_report = null;
    private static Report summary_report = null;
    private static Report totals_report = null;
    private static Report kstat_summary = null;
    private static Report stdout_report = null;
    private static int interval_duration;
    private static int current_interval;
    private static int highest_interval;
    private static Vector<PrintWriter> all_writers;
    private static Vector writer_filenames;
    private static Vector all_reports;
    private static boolean binary_or_decimal;
    public static long KB;
    public static long MB;
    public static long GB;
    public static long TB;
    private static AuxReport aux_report;

    public Report() {
        common.failure("This instantiation only to prevent 'extends Report' compiler message");
    }

    public Report(Object object, String string, String string2, boolean bl) {
        this(Report.xlate(object) + "." + string, string2, bl);
    }

    public Report(Object object, String string, String string2) {
        this(Report.xlate(object) + "." + string, string2, true);
    }

    public Report(String string, String string2) {
        this(string, string2, true);
    }

    public Report(String string, String string2, boolean bl) {
        this.fname = string;
        if (this.fname.endsWith(".html")) {
            common.failure("At this point, file name may not include '.html' yet: " + this.fname);
        }
        if (bl) {
            this.pw = Report.createHmtlFile(this.fname, string2);
        }
        all_writers.add(this.pw);
        all_reports.add(this);
        writer_filenames.add(this.fname);
        this.data = new ReportData(this);
        this.addReport();
    }

    public Report(PrintWriter printWriter, String string, String string2) {
        this.pw = printWriter;
        this.fname = string;
        all_writers.add(this.pw);
        all_reports.add(this);
        writer_filenames.add("Directly assigned pw: " + string2);
        this.data = new ReportData(this);
    }

    private void addReport() {
        if (this.fname.indexOf(" ") != -1) {
            common.failure("Blank embedded Report name: " + this.fname);
        }
        if (report_map.put(this.fname, this) != null) {
            common.ptod("Trying to add report twice: " + this.fname);
            common.ptod("Are there duplicate names between HD/SD/WD/FSD/FWD/RD parameters?");
            Report.printMap();
            common.failure("Trying to add report name twice: " + this.fname);
        }
    }

    public ReportData getData() {
        return this.data;
    }

    public void println(Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            this.println((String)vector.elementAt(i));
        }
    }

    public void println(ArrayList arrayList) {
        for (int i = 0; i < arrayList.size(); ++i) {
            this.println((String)arrayList.get(i));
        }
    }

    public void println(String string, Object ... objectArray) {
        this.println(String.format(string, objectArray));
    }

    public void println(String string) {
        if (this.pw == null) {
            return;
        }
        if (this == Report.getStdoutReport() && common.get_debug(common.SHORT_FS_STDOUT) && Vdbmain.isFwdWorkload() && string.length() > 124) {
            int n = string.length();
            string = string.substring(0, 124) + " (" + n + ")";
        }
        this.pw.println(string);
        if (this.fname == null) {
            common.failure("null file name");
        }
        if (this.pw.equals(common.stdout) && string.toLowerCase().indexOf("href=") == -1 && string.trim().length() != 0) {
            common.log_html.println(string);
        }
    }

    public void print(String string) {
        if (this.pw == null) {
            return;
        }
        this.pw.print(string);
        if (this.pw.equals(common.stdout) && string.toLowerCase().indexOf("href=") == -1 && string.trim().length() != 0) {
            common.log_html.print(string);
        }
    }

    private void prtDebug(String string) {
        if (this.fname.equals("sd1")) {
            common.ptod("txt: " + this.fname + " " + string);
            common.where(5);
        }
    }

    public static void setupAuxReporting() {
        if (MiscParms.aux_parms == null) {
            return;
        }
        try {
            aux_report = (AuxReport)Class.forName(MiscParms.aux_parms[0]).newInstance();
            aux_report.parseParameters(MiscParms.aux_parms);
        }
        catch (Exception exception) {
            common.ptod("Error while setting up Aux Reporting");
            common.failure(exception);
        }
    }

    public static void setSummaryReport(Report report) {
        summary_report = report;
        report.addReport();
    }

    public static Report getSummaryReport() {
        return summary_report;
    }

    public static void setTotalReport(Report report) {
        totals_report = report;
    }

    public static Report getTotalReport() {
        return totals_report;
    }

    public static void setLogReport(Report report) {
        logfile_report = report;
        report.addReport();
    }

    public static Report getLogReport() {
        return logfile_report;
    }

    public static Report getStdoutReport() {
        return stdout_report;
    }

    public static void createHostSummaryFiles() {
        Report report = Report.getSummaryReport();
        Vector<Report> vector = new Vector<Report>(8);
        Vector<String> vector2 = new Vector<String>(8);
        Vector<Host> vector3 = Host.getDefinedHosts();
        report.println("");
        for (int i = 0; i < vector3.size(); ++i) {
            Host host = vector3.elementAt(i);
            Report report2 = new Report(host.getLabel(), "Host summary report(s) for host=" + host.getLabel());
            host.setSummaryReport(report2);
            vector.add(report2);
            vector2.add(host.getLabel());
            if (!host_detail) continue;
            Report report3 = new Report(host.getLabel(), "histogram", "Host response time histogram.", host_detail);
            report2.printHtmlLink("Link to response time histogram", report3.getFileName(), "histogram");
        }
        Report.getSummaryReport().printMultipleLinks(vector, vector2, "host");
        Report.createNamedReports(FsdEntry.getFsdNames(), "fsd", Report.sdDetailNeeded());
        Report.createNamedReports(FwdEntry.getFwdNames(), "fwd", true);
    }

    public static void createSlaveSummaryFiles() {
        Vector<Host> vector = Host.getDefinedHosts();
        for (int i = 0; i < vector.size(); ++i) {
            Host host = vector.elementAt(i);
            Vector<Slave> vector2 = host.getSlaves();
            for (int j = 0; j < vector2.size(); ++j) {
                Slave slave = vector2.elementAt(j);
                slave.createSummaryFile();
                if (!slave_detail) continue;
                Report report = new Report(slave.getLabel(), "histogram", "Slave response time histogram.", slave_detail);
                slave.getSummaryReport().printHtmlLink("Link to response time histogram", report.getFileName(), "histogram");
            }
        }
    }

    public static void createSlaveFsdFiles() {
        for (int i = 0; i < SlaveList.getSlaveList().size(); ++i) {
            Slave slave = SlaveList.getSlaveList().elementAt(i);
            for (int j = 0; j < FsdEntry.getFsdList().size(); ++j) {
                FsdEntry fsdEntry = FsdEntry.getFsdList().elementAt(j);
                Report report = new Report((Object)slave.getLabel(), fsdEntry.name, "abcxyz");
                slave.getSummaryReport().printHtmlLink("Links to FSD report", report.getFileName(), fsdEntry.name);
            }
        }
    }

    public static void createSummaryHistogramFile() {
        Report report = new Report("histogram", "Total response time histogram.");
        Report.getSummaryReport().printHtmlLink("Link to response time histogram", report.getFileName(), "histogram");
    }

    public static void createSkewFile() {
        Report report = new Report("skew", "Workload skew report");
        Report.getSummaryReport().printHtmlLink("Link to workload skew report", report.getFileName(), "skew");
        report.println("Skew information will only be generated if:");
        report.println(" - there is more than one Workload Definition (WD/FWD)");
        report.println(" - there is more than one Storage Definition (SD/FSD)");
        report.println(" - there is more than one Host");
        report.println(" - there is more than one Slave");
        report.println("(Though these rules may be ignored from time to time).");
        report.println("");
    }

    public static void tbd_createHostHistogramFiles() {
        for (int i = 0; i < Host.getDefinedHosts().size(); ++i) {
            Host host = Host.getDefinedHosts().elementAt(i);
            Report report = new Report(host, "histogram", "Host Performance histogram.");
            host.getSummaryReport().printHtmlLink("Link to response time histogram", report.getFileName(), "histogram");
        }
    }

    public static void tbd_createSlaveHistogramFiles() {
        for (int i = 0; i < SlaveList.getSlaveList().size(); ++i) {
            Slave slave = SlaveList.getSlaveList().elementAt(i);
            Report report = new Report(slave, "histogram", "Host Performance histogram.");
            slave.getSummaryReport().printHtmlLink("Link to response time histogram", report.getFileName(), "histogram");
        }
    }

    public static void createOtherReportFiles() {
        RD_entry rD_entry;
        stdout_report = new Report(common.stdout, "stdout", "common.stdout");
        RD_entry.next_rd = null;
        boolean bl = false;
        while ((rD_entry = RD_entry.getNextWorkload()) != null) {
            RD_entry.printWgInfo("First (reporting) pass through Work.prepareWorkForSlaves", new Object[0]);
            Work.prepareWorkForSlaves(rD_entry, false);
        }
        if (!InfoFromHost.anyKstatErrors()) {
            Report.createKstatReports();
        }
        if (Vdbmain.isFwdWorkload()) {
            AnchorReport.create();
        }
        if (Vdbmain.isWdWorkload()) {
            SdReport.createHostSdReports();
            SdReport.createRunSdReports();
            WdReport.createRunWdReports();
        } else {
            FwdReport.createHostFsdReports();
        }
        if (MiscParms.maintain_run_totals) {
            Report.getSummaryReport().printHtmlLink("Cumulative run totals", "totals_optional", "run totals");
        }
        Flat.define_column_headers_cpu();
        Report.printRdLinks();
        Report.chModAllReports();
        Report.showReports();
    }

    public static void createNamedReports(String[] stringArray, String string, boolean bl) {
        Arrays.sort(stringArray);
        Vector<Report> vector = new Vector<Report>(8);
        Vector<String> vector2 = new Vector<String>(8);
        for (int i = 0; i < stringArray.length; ++i) {
            Report report = new Report(stringArray[i], "Report for " + string + " " + stringArray[i], bl);
            vector.add(report);
            vector2.add(stringArray[i]);
            Report report2 = new Report(stringArray[i] + ".histogram", "Performance histogram for " + string.toUpperCase() + "=" + stringArray[i], bl);
            if (!bl) continue;
            report.printHtmlLink("Link to Performance histogram", report2.getFileName(), "histogram");
        }
        Report.getSummaryReport().printMultipleLinks(vector, vector2, string);
    }

    public void printMultipleLinks(Vector vector, Vector vector2, String string) {
        for (int i = 0; i < vector.size(); ++i) {
            Report report = (Report)vector.elementAt(i);
            String string2 = (String)vector2.elementAt(i);
            if (i == 0) {
                this.print(Format.f("%-32s", "Link to " + string.toUpperCase() + " reports:"));
            } else if (i % 8 == 0) {
                this.println("");
                this.print(Format.f("%-32s", ""));
            }
            String string3 = Format.f("%80s", " ");
            string3 = string2.length() < 8 ? string3.substring(0, 8 - string2.length()) : "";
            this.print(" <A HREF=\"" + report.getFileName() + ".html\">" + string2 + "</A>" + string3);
        }
        if (vector.size() > 0) {
            this.println("");
        }
    }

    private static void printRdLinks() {
        Report[] reportArray = Report.getReports();
        for (int i = 0; i < reportArray.length; ++i) {
            if (reportArray[i].fname.equals("stdout") || reportArray[i].fname.equals("status")) continue;
            reportArray[i].printRdLink();
        }
    }

    private void printRdLink() {
        String string = String.format("%256s", " ");
        this.println("");
        RD_entry.next_rd = null;
        RD_entry rD_entry = null;
        int n = 0;
        String[] stringArray = new String[]{};
        while ((rD_entry = RD_entry.getNextWorkload()) != null) {
            String string2;
            int n2;
            String string3 = rD_entry.rd_name + " " + rD_entry.current_override.getText();
            String[] stringArray2 = string3.split(" +");
            if (stringArray.length != stringArray2.length) {
                stringArray = new String[stringArray2.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = "x";
                }
            }
            String string4 = "";
            boolean bl = false;
            for (n2 = 0; n2 < stringArray2.length - 1; ++n2) {
                if (stringArray2[n2].equals(stringArray[n2])) continue;
                bl = true;
            }
            for (n2 = 0; n2 < stringArray2.length; ++n2) {
                if (!bl && stringArray2[n2].equals(stringArray[n2])) {
                    string4 = string4 + string.substring(0, stringArray2[n2].length() + 1);
                    continue;
                }
                bl = true;
                string4 = string4 + stringArray2[n2] + " ";
            }
            if (n++ == 0) {
                string2 = String.format("%-32s", "Link to Run Definitions:");
                this.println(string2 + " <A HREF=\"#_" + rD_entry.hashCode() + "\">" + string4.trim() + "</A>");
            } else {
                string2 = String.format("%-32s", " ");
                String string5 = string.substring(0, string3.length() - string4.trim().length());
                this.println("%s%s <A HREF=\"#_%d\">%s</A>", string2, string5, rD_entry.hashCode(), string4.trim());
            }
            stringArray = stringArray2;
        }
        this.println("");
    }

    private static void createKstatReports() {
        Serializable serializable;
        Cloneable cloneable;
        HashMap hashMap = new HashMap(6);
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>(6);
        Vector<Host> vector = Host.getDefinedHosts();
        for (int i = 0; i < vector.size(); ++i) {
            Host host = vector.elementAt(i);
            if (host.getHostInfo() == null || (cloneable = host.getHostInfo().getInstancePointers()) == null) continue;
            for (int j = 0; j < ((Vector)cloneable).size(); ++j) {
                serializable = (InstancePointer)((Vector)cloneable).elementAt(j);
                hashMap.put(host.getLabel(), null);
                hashMap2.put(host.getLabel() + " " + ((InstancePointer)serializable).getLun(), null);
            }
        }
        String[] stringArray = hashMap.keySet().toArray(new String[0]);
        if (stringArray.length == 0) {
            return;
        }
        kstat_summary = new Report("kstat", "Kstat summary report");
        Report.getSummaryReport().printHtmlLink("Link to Kstat summary report", kstat_summary.getFileName(), "Kstat");
        for (int i = 0; i < stringArray.length; ++i) {
            int n;
            Object[] objectArray;
            cloneable = Host.findHost(stringArray[i]);
            Report report = new Report(((Host)cloneable).getLabel() + ".kstat", "Host Kstat summary report for host=" + ((Host)cloneable).getLabel());
            ((Host)cloneable).setKstatReport(report);
            kstat_summary.printHtmlLink("Host Kstat summary report", report.getFileName(), stringArray[i]);
            ((Host)cloneable).addReport("kstat", report);
            serializable = ((Host)cloneable).getHostInfo().getLuns();
            for (int j = 0; j < ((ArrayList)serializable).size(); ++j) {
                objectArray = (Object[])((ArrayList)serializable).get(j);
                for (n = 0; n < objectArray.kstat_error_messages.size(); ++n) {
                    report.println("host=" + stringArray[i] + ",lun=" + objectArray.lun + ": " + (String)objectArray.kstat_error_messages.elementAt(n));
                    kstat_summary.println("host=" + stringArray[i] + ",lun=" + objectArray.lun + ": " + (String)objectArray.kstat_error_messages.elementAt(n));
                }
                if (objectArray.kstat_error_messages.size() <= 0) continue;
                report.println("");
            }
            Vector vector2 = ((Host)cloneable).getHostInfo().getInstancePointers();
            objectArray = vector2.toArray(new InstancePointer[0]);
            Arrays.sort(objectArray);
            for (n = 0; n < objectArray.length; ++n) {
                Object object = objectArray[n];
                report = new Report(cloneable, ((InstancePointer)object).getID(), "Host Kstat instance report for host=" + ((Host)cloneable).getLabel(), sd_detail);
                ((Host)cloneable).addReport(((InstancePointer)object).getID(), report);
                if (sd_detail) {
                    ((Host)cloneable).getKstatReport().printHtmlLink(((InstancePointer)object).getLun(), report.getFileName(), ((InstancePointer)object).getInstance());
                }
                if (((InstancePointer)object).getInstance().startsWith("nfs")) {
                    NfsStats.setNfsReportsNeeded(true);
                }
                report.println("Device:   " + ((InstancePointer)object).getLun());
                report.println("Instance: " + ((InstancePointer)object).getInstance());
            }
        }
        Flat.define_column_headers_kstat();
        if (NfsStats.areNfsReportsNeeded()) {
            NfsStats.createNfsReports();
        }
    }

    public void printHtmlLink(String string, String string2, String string3) {
        String string4 = string != null ? Format.f("%-32s", string + ":") : Format.f("%-32s", "");
        this.println(string4 + " <A HREF=\"" + string2 + ".html\">" + string3 + "</A>");
    }

    public static Report getHistReport(String string) {
        return Report.getReport(string + ".histogram");
    }

    public static Report getHistReport(Host host, String string) {
        return Report.getReport(host.getLabel() + "." + string + ".histogram");
    }

    public static Report getHistReport(Slave slave, String string) {
        return Report.getReport(slave.getLabel() + "." + string + ".histogram");
    }

    public static Report[] getReports() {
        return report_map.values().toArray(new Report[0]);
    }

    public static Report getReport(Object object) {
        return Report.getReport(Report.xlate(object));
    }

    public static Report getReport(Object object, Object object2) {
        return Report.getReport(Report.xlate(object, object2));
    }

    public static Report getReport(Object object, Object object2, Object object3) {
        return Report.getReport(Report.xlate(object, object2, object3));
    }

    private static String xlate(Object object) {
        return Report.xlate1(object);
    }

    private static String xlate(Object object, Object object2) {
        return Report.xlate1(object) + "." + Report.xlate1(object2);
    }

    private static String xlate(Object object, Object object2, Object object3) {
        return Report.xlate1(object) + "." + Report.xlate1(object2) + "." + Report.xlate1(object3);
    }

    private static String xlate1(Object object) {
        String string = null;
        if (object instanceof Host) {
            string = ((Host)object).getLabel();
        } else if (object instanceof Slave) {
            string = ((Slave)object).getLabel();
        } else if (object instanceof FwdEntry) {
            string = ((FwdEntry)object).fwd_name;
        } else if (object instanceof FsdEntry) {
            string = ((FsdEntry)object).name;
        } else if (object instanceof String) {
            string = (String)object;
        } else {
            common.failure("Invalid object: " + object.getClass().getName());
        }
        return string;
    }

    public static Report getReport(String string) {
        Report report = (Report)report_map.get(string);
        if (report == null) {
            Report.printMap();
            common.failure("Requesting an unknown report file: " + string);
        }
        return report;
    }

    private static void printMap() {
        Object[] objectArray = report_map.keySet().toArray(new String[0]);
        Arrays.sort(objectArray);
        for (int i = 0; i < objectArray.length; ++i) {
            common.ptod("getReport(): " + (String)objectArray[i]);
        }
    }

    public static String[] getReportedKstats() {
        return Report.filterSds(report_map, false);
    }

    public String getFileName() {
        return this.fname;
    }

    private String[] createHeaders(Kstat_cpu kstat_cpu) {
        String string = "%12s %10s %8s %7s %6s %8s %8s %8s %8s %8s %8s %6s ";
        String string2 = "%5s %5s";
        String string3 = String.format(string, "interval", "i/o", "MB/sec", "bytes", "read", "resp", "read", "write", "read", "write", "resp", "queue");
        if (kstat_cpu != null) {
            string3 = string3 + String.format(string2, "cpu%", "cpu%");
        }
        String string4 = String.format(string, "", "rate", binary_or_decimal ? "1024**2" : "1000**2", "i/o", "pct", "time", "resp", "resp", "max", "max", "stddev", "depth");
        if (kstat_cpu != null) {
            string4 = string4 + String.format(string2, "sys+u", "sys");
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMM dd, yyyy");
        String[] stringArray = new String[]{"\n" + simpleDateFormat.format(new Date()) + string3, "            " + string4};
        return stringArray;
    }

    protected void reportDetail(SdStats sdStats) {
        this.printHeaders(this.getWriter(), null, Report.getInterval());
        this.reportDetail(sdStats, null, "" + Report.getInterval());
    }

    protected void reportDetail(SdStats sdStats, Kstat_cpu kstat_cpu) {
        this.printHeaders(this.getWriter(), kstat_cpu, Report.getInterval());
        this.reportDetail(sdStats, kstat_cpu, "" + Report.getInterval());
    }

    protected void reportDetail(SdStats sdStats, Kstat_cpu kstat_cpu, String string) {
        boolean bl = common.get_debug(common.PRINT_IN_MICROSECONDS);
        int n = !bl ? 1 : 1000000;
        String string2 = !bl ? "%12s %10.1f %8.2f %7d %6.2f %8.3f %8.3f %8.3f %8.2f %8.2f %8.3f %6.1f " : "%12s %10.1f %8.2f %7d %6.2f %8.0f %8.0f %8.0f %8.0f %8.0f %8.3f %6.2f ";
        String string3 = "%5.1f %5.1f";
        String string4 = String.format(string2, string, sdStats.rate(), sdStats.megabytes(), sdStats.bytes(), sdStats.readpct(), sdStats.respTime() * (double)n, sdStats.readResp() * (double)n, sdStats.writeResp() * (double)n, sdStats.readMax() * (double)n, sdStats.writeMax() * (double)n, sdStats.resptime_std(), sdStats.qdepth());
        if (kstat_cpu != null) {
            string4 = string4 + String.format(string3, kstat_cpu.user_pct() + kstat_cpu.kernel_pct(), kstat_cpu.kernel_pct());
        }
        if (!(string.startsWith("avg") || aux_report == null || this != summary_report && this != stdout_report)) {
            this.println(common.tod() + string4 + " " + aux_report.getSummaryData());
        } else {
            this.println(common.tod() + string4);
        }
    }

    public static void displayRunStart(String string, RD_entry rD_entry) {
        Report[] reportArray = Report.getReports();
        for (int i = 0; i < reportArray.length; ++i) {
            if (reportArray[i].getFileName().equals("stdout") || reportArray[i].getFileName().equals("status")) continue;
            reportArray[i].printStart(string, rD_entry);
        }
    }

    private void printStart(String string, RD_entry rD_entry) {
        String string2 = rD_entry.rd_name + " " + rD_entry.current_override.getText();
        this.println("");
        this.printRdLink(common.tod() + " " + string, "<a name=\"_" + rD_entry.hashCode() + "\"></a><i><b>" + common.tod() + " " + string + "</b></i>");
        this.println("");
    }

    public void printRdLink(String string, String string2) {
        if (this.pw == null) {
            return;
        }
        this.pw.println(string2);
        if (this.pw.equals(common.summ_html)) {
            common.stdout.println(string);
        }
    }

    public void reportKstatDetail(Kstat_data kstat_data, Kstat_cpu kstat_cpu) {
        this.printKstatHeaders(this.pw, current_interval);
        this.reportKstatDetail(kstat_data, kstat_cpu, "" + current_interval);
    }

    public void reportKstatDetail(Kstat_data kstat_data, Kstat_cpu kstat_cpu, String string) {
        printf printf2 = new printf("%9s %10.2f %8.3f %8.3f %8.3f %7.2f %6.2f %5.1f %7.2f %7.2f %7d %7.1f %5.1f");
        printf2.add(string);
        printf2.add(kstat_data.kstat_rate());
        printf2.add(kstat_data.kstat_wait() + kstat_data.kstat_svctm());
        printf2.add(kstat_data.kstat_wait());
        printf2.add(kstat_data.kstat_svctm());
        printf2.add(kstat_data.kstat_megabytes());
        printf2.add(kstat_data.kstat_readpct());
        printf2.add(kstat_data.kstat_busy());
        printf2.add(kstat_data.kstat_ioswaiting());
        printf2.add(kstat_data.kstat_iosrunning());
        printf2.add((int)kstat_data.kstat_bytes());
        printf2.add(kstat_cpu.user_pct() + kstat_cpu.kernel_pct());
        printf2.add(kstat_cpu.kernel_pct());
        String string2 = common.tod() + " " + printf2.print();
        this.println(string2);
    }

    public String toString() {
        return "Report fname: " + this.fname;
    }

    public static synchronized void reportWdInterval() {
        SdReport.reportSdStats();
        WdReport.reportWdStats();
        if (Report.isKstatReporting()) {
            Report.reportKstat();
        } else if (!common.onSolaris() && CpuStats.isCpuReporting()) {
            Report.writeFlatCpu(Report.getSummaryReport().getData().getIntervalCpuStats());
        }
        if (MiscParms.maintain_run_totals) {
            FinalTotals.printTotals(highest_interval);
        }
        Flat.printInterval();
    }

    public static void reportKstat() {
        Object object;
        Vector<Host> vector = Host.getDefinedHosts();
        for (int i = 0; i < vector.size(); ++i) {
            object = vector.elementAt(i);
            if (!((Host)object).anyWork()) continue;
            Kstat_cpu kstat_cpu = ((Host)object).getSummaryReport().getData().getIntervalCpuStats();
            if (!((Host)object).getHostInfo().isSolaris()) continue;
            Vector vector2 = ((Host)object).getHostInfo().getInstancePointers();
            for (int j = 0; j < vector2.size(); ++j) {
                InstancePointer instancePointer = (InstancePointer)vector2.elementAt(j);
                Kstat_data kstat_data = ((Host)object).getReport(instancePointer.getID()).getData().getIntervalKstats();
                Report report = ((Host)object).getReport(instancePointer.getID());
                report.reportKstatDetail(kstat_data, kstat_cpu);
            }
            Kstat_data kstat_data = ((Host)object).getKstatReport().getData().getIntervalKstats();
            ((Host)object).getKstatReport().reportKstatDetail(kstat_data, kstat_cpu);
        }
        Kstat_cpu kstat_cpu = Report.getSummaryReport().getData().getIntervalCpuStats();
        object = kstat_summary.getData().getIntervalKstats();
        kstat_summary.reportKstatDetail((Kstat_data)object, kstat_cpu);
        FinalTotals.add((Kstat_data)object);
        if (Vdbmain.kstat_console) {
            Report.getStdoutReport().reportKstatDetail((Kstat_data)object, kstat_cpu);
        }
        if (CpuStats.isCpuReporting()) {
            Report.writeFlatCpu(kstat_cpu);
        }
        Report.writeFlatKstat((Kstat_data)object);
        if (NfsStats.areNfsReportsNeeded()) {
            NfsStats.PrintAllNfs("" + current_interval);
        }
    }

    public static void reportKstatTotals() {
        String string = Report.getAvgLabel();
        Kstat_cpu kstat_cpu = Report.getSummaryReport().getData().getTotalCpuStats();
        Vector<Host> vector = Host.getDefinedHosts();
        for (int i = 0; i < vector.size(); ++i) {
            Serializable serializable;
            Host host = vector.elementAt(i);
            if (!host.anyWork()) continue;
            Kstat_cpu kstat_cpu2 = host.getSummaryReport().getData().getTotalCpuStats();
            if (host.getHostInfo().isSolaris()) {
                serializable = host.getHostInfo().getInstancePointers();
                for (int j = 0; j < ((Vector)serializable).size(); ++j) {
                    InstancePointer instancePointer = (InstancePointer)((Vector)serializable).elementAt(j);
                    Report report = host.getReport(instancePointer.getID());
                    Kstat_data kstat_data = report.getData().getTotalKstats();
                    report.reportKstatDetail(kstat_data, kstat_cpu2, string);
                }
            }
            if (host.getKstatReport() == null) continue;
            serializable = host.getKstatReport().getData().getTotalKstats();
            host.getKstatReport().reportKstatDetail((Kstat_data)serializable, kstat_cpu2, string);
        }
        Kstat_data kstat_data = kstat_summary.getData().getTotalKstats();
        kstat_summary.reportKstatDetail(kstat_data, kstat_cpu, string);
        if (Vdbmain.kstat_console) {
            Report.getStdoutReport().reportKstatDetail(kstat_data, kstat_cpu, string);
        }
        Report.writeFlatKstat(kstat_data);
    }

    public void printHeaders(PrintWriter printWriter, Kstat_cpu kstat_cpu, int n) {
        int n2;
        int n3 = n2 = common.get_debug(common.FAST_HEADERS) ? 5 : 30;
        if (n % n2 == 1) {
            String[] stringArray = this.createHeaders(kstat_cpu);
            if (aux_report == null) {
                this.println(stringArray[0]);
                this.println(stringArray[1]);
            } else if (printWriter != Report.summary_report.pw && printWriter != Report.stdout_report.pw) {
                this.println(stringArray[0]);
                this.println(stringArray[1]);
            } else {
                String[] stringArray2 = aux_report.getSummaryHeaders();
                this.print(stringArray[0]);
                this.println(" " + stringArray2[0]);
                this.print(stringArray[1]);
                this.println(" " + stringArray2[1]);
            }
        }
    }

    public void printKstatHeaders(PrintWriter printWriter, int n) {
        int n2;
        if (Report.isKstatReporting()) {
            this.kstat_headers = this.createKstatHeaders();
        }
        int n3 = n2 = common.get_debug(common.FAST_HEADERS) ? 5 : 30;
        if (n % n2 == 1) {
            this.println(this.kstat_headers);
        }
    }

    private String createKstatHeaders() {
        printf printf2 = new printf(" %9s %10s %8s %8s %8s %7s %6s %5s %7s %7s %7s %7s %5s");
        printf2.add("interval");
        printf2.add("KSTAT_i/o");
        printf2.add("resp");
        printf2.add("wait");
        printf2.add("service");
        printf2.add("MB/sec");
        printf2.add("read");
        printf2.add("busy");
        printf2.add("avg_i/o");
        printf2.add("avg_i/o");
        printf2.add("bytes");
        printf2.add("cpu%");
        printf2.add("cpu%");
        printf printf3 = new printf(" %9s %10s %8s %8s %8s %7s %6s %5s %7s %7s %7s %7s %5s");
        printf3.add("");
        printf3.add("rate");
        printf3.add("time");
        printf3.add("time");
        printf3.add("time");
        printf3.add(binary_or_decimal ? "1024**2" : "1000**2");
        printf3.add("pct");
        printf3.add("pct");
        printf3.add("waiting");
        printf3.add("active");
        printf3.add("per_io");
        printf3.add("sys+usr");
        printf3.add("sys");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMM dd, yyyy");
        String string = "\n" + simpleDateFormat.format(new Date());
        String string2 = "\n            ";
        String string3 = string + printf2.print() + string2 + printf3.print();
        return string3;
    }

    public static void closeAllReports() {
        for (PrintWriter printWriter : all_writers) {
            if (printWriter == common.stdout || printWriter == null) continue;
            printWriter.close();
        }
    }

    public static void flushAllReports() {
        common.plog("Flushing all reports");
        for (PrintWriter printWriter : all_writers) {
            if (printWriter == null) continue;
            printWriter.flush();
        }
    }

    public static PrintWriter createHmtlFile(String string) {
        return Report.createHmtlFile(string, null);
    }

    public static PrintWriter createHmtlFile(String string, String string2) {
        Object object;
        Object object2;
        if (!string.endsWith(".html")) {
            string = string + ".html";
        }
        File file = null;
        PrintWriter printWriter = null;
        try {
            file = new File(Vdbmain.output_dir, string);
            object2 = new FileOutputStream(file);
            object = new BufferedOutputStream((OutputStream)object2);
            boolean bl = false;
            if ((string.startsWith("logfile") || string.startsWith("errorlog") || string.startsWith("parm") || string.startsWith("flatfile") || string.contains("stdout")) && !common.get_debug(common.NO_PRINT_FLUSH)) {
                bl = true;
            }
            printWriter = new PrintWriter((OutputStream)object, bl);
        }
        catch (Exception exception) {
            common.failure(exception);
        }
        if (string.indexOf(".html") != -1) {
            object = new File(Vdbmain.output_dir, string).getParentFile().getName();
            object2 = String.format("<title>Vdbench %s/%s</title><pre>", object, string);
            common.println((String)object2, printWriter);
            if (string2 != null && printWriter != null) {
                printWriter.println(string2);
                printWriter.println();
            }
        }
        if (!file.getName().contains("totals_optional")) {
            writer_filenames.add(file.getAbsolutePath());
            all_writers.add(printWriter);
        }
        return printWriter;
    }

    public static void chModAllReports() {
        if (!common.onWindows()) {
            OS_cmd.executeCmd("chmod -R 777 " + Vdbmain.output_dir);
        }
    }

    public PrintWriter getWriter() {
        return this.pw;
    }

    public static Vector getAllWriters() {
        return all_writers;
    }

    public static String getWriterName(PrintWriter printWriter) {
        int n = all_writers.indexOf(printWriter);
        if (n != -1) {
            return (String)writer_filenames.elementAt(n);
        }
        return "Unknown PrintWriter name";
    }

    public static void showReports() {
        if (!common.get_debug(common.SHOW_REPORTS)) {
            return;
        }
        for (int i = 0; i < all_reports.size(); ++i) {
            Report report = (Report)all_reports.elementAt(i);
            common.ptod("report: " + report);
        }
    }

    public static String[] filterSds(HashMap hashMap, boolean bl) {
        Vector vector = new Vector(hashMap.keySet());
        for (int i = 0; i < vector.size(); ++i) {
            String string = (String)vector.elementAt(i);
            if (bl) {
                if (!string.startsWith(InstancePointer.getKstatPrefix())) continue;
                vector.setElementAt(null, i);
                continue;
            }
            if (string.startsWith(InstancePointer.getKstatPrefix())) continue;
            vector.setElementAt(null, i);
        }
        while (vector.removeElement(null)) {
        }
        return vector.toArray(new String[0]);
    }

    public static boolean isKstatReporting() {
        return kstat_summary != null;
    }

    public static void setDecimal() {
        binary_or_decimal = false;
        KB = 1000L;
        MB = 1000000L;
        GB = 1000000000L;
        TB = -727379968L;
    }

    public static String getAvgLabel() {
        String string = ReplayInfo.isReplay() ? " avg_1-" + highest_interval : " avg_" + Reporter.first_elapsed_interval + "-" + highest_interval;
        return string;
    }

    public static int getInterval() {
        return current_interval;
    }

    public static void setIntervalDuration(int n) {
        interval_duration = n;
    }

    public static int getIntervalDuration() {
        return interval_duration;
    }

    public static void setInterval(int n) {
        current_interval = highest_interval = n;
    }

    public static void writeFlat(SdStats sdStats, String string) {
        double d = Validate.getCompressionRatio();
        Flat.put_col("interval", string);
        Flat.put_col("rate", sdStats.rate());
        Flat.put_col("mb/sec", sdStats.megabytes());
        Flat.put_col("bytes/io", sdStats.bytes());
        Flat.put_col("read%", sdStats.readpct());
        Flat.put_col("resp", sdStats.respTime());
        Flat.put_col("read_resp", sdStats.readResp());
        Flat.put_col("write_resp", sdStats.writeResp());
        Flat.put_col("resp_max", sdStats.respMax());
        Flat.put_col("read_max", sdStats.readMax());
        Flat.put_col("write_max", sdStats.writeMax());
        Flat.put_col("resp_std", sdStats.resptime_std());
        Flat.put_col("read_std", sdStats.readStd());
        Flat.put_col("write_std", sdStats.writeStd());
        Flat.put_col("queue_depth", sdStats.qdepth());
        if (d < 0.0) {
            Flat.put_col("compratio", "n/a");
        } else {
            Flat.put_col("compratio", d);
        }
    }

    protected static void writeFlatCpu(Kstat_cpu kstat_cpu) {
        double d = Math.max(0.0, (double)kstat_cpu.cpu_idle * 100.0 / (double)kstat_cpu.cpu_total);
        double d2 = Math.max(0.0, (double)kstat_cpu.cpu_user * 100.0 / (double)kstat_cpu.cpu_total);
        double d3 = Math.max(0.0, (double)kstat_cpu.cpu_kernel * 100.0 / (double)kstat_cpu.cpu_total);
        double d4 = Math.max(0.0, (double)kstat_cpu.cpu_wait * 100.0 / (double)kstat_cpu.cpu_total);
        double d5 = d2 + d3;
        Flat.put_col("cpu_idle", d);
        Flat.put_col("cpu_user", d2);
        Flat.put_col("cpu_kernel", d3);
        Flat.put_col("cpu_wait", d4);
        Flat.put_col("cpu_used", d5);
    }

    private static void writeFlatKstat(Kstat_data kstat_data) {
        Flat.put_col("ks_rate", kstat_data.kstat_rate());
        Flat.put_col("ks_resp", kstat_data.kstat_wait() + kstat_data.kstat_svctm());
        Flat.put_col("ks_wait", kstat_data.kstat_wait());
        Flat.put_col("ks_svct", kstat_data.kstat_svctm());
        Flat.put_col("ks_mb", kstat_data.kstat_megabytes());
        Flat.put_col("ks_read%", kstat_data.kstat_readpct());
        Flat.put_col("ks_busy%", kstat_data.kstat_busy());
        Flat.put_col("ks_avwait", kstat_data.kstat_ioswaiting());
        Flat.put_col("ks_avact", kstat_data.kstat_iosrunning());
        Flat.put_col("ks_bytes", (long)kstat_data.kstat_bytes());
    }

    public static void parseParameters(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if ("slave_detail".startsWith(stringArray[i])) {
                slave_detail = true;
                continue;
            }
            if ("host_detail".startsWith(stringArray[i])) {
                host_detail = true;
                continue;
            }
            if ("no_sd_detail".startsWith(stringArray[i])) {
                sd_detail = false;
                continue;
            }
            if ("no_fsd_detail".startsWith(stringArray[i])) {
                sd_detail = false;
                continue;
            }
            common.failure("Invalid 'reports=' parameter: " + stringArray[i]);
        }
    }

    public static AuxReport getAuxReport() {
        return aux_report;
    }

    public static boolean sdDetailNeeded() {
        return sd_detail;
    }

    static {
        all_writers = new Vector(64, 0);
        writer_filenames = new Vector(64, 0);
        all_reports = new Vector(64, 0);
        binary_or_decimal = true;
        KB = 1024L;
        MB = 0x100000L;
        GB = 0x40000000L;
        TB = 0L;
        aux_report = null;
    }
}

