/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Utils.Fget;
import Utils.Fput;
import Vdb.Blocked;
import Vdb.CollectSlaveStats;
import Vdb.CompareWorkInfo;
import Vdb.CpuStats;
import Vdb.DV_map;
import Vdb.Debug_cmds;
import Vdb.Dedup;
import Vdb.ErrorLog;
import Vdb.Flat;
import Vdb.FwdReport;
import Vdb.FwdStats;
import Vdb.GcTracker;
import Vdb.Host;
import Vdb.Interval;
import Vdb.MiscParms;
import Vdb.Native;
import Vdb.RD_entry;
import Vdb.ReplayInfo;
import Vdb.Report;
import Vdb.SdDedup;
import Vdb.SdReport;
import Vdb.SdStats;
import Vdb.SkewReport;
import Vdb.SlaveList;
import Vdb.Status;
import Vdb.SwatCharts;
import Vdb.ThreadMonitor;
import Vdb.Timeout;
import Vdb.Validate;
import Vdb.Vdbmain;
import Vdb.WdReport;
import Vdb.WhereWhatWork;
import Vdb.Work;
import Vdb.common;
import java.io.File;
import java.util.Date;

public class Reporter
extends Thread {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";
    public static Date interval_start_time;
    public static Date interval_end_time;
    public static Date run_start_time;
    public static Date run_end_time;
    private static long last_pause;
    private static int warmup_intervals;
    private static boolean warmup_done;
    public static int first_elapsed_interval;
    public static String monitor_file;
    public static boolean monitor_kill;
    public static boolean monitor_final;
    private static String tmpdir;
    private static int process_id;
    private static String tmp_shutdown;

    @Override
    public void run() {
        long l = System.currentTimeMillis();
        this.setName("Reporter");
        Reporter.clearShutdownFile(true);
        try {
            Thread.currentThread().setPriority(10);
            Debug_cmds.starting_command.run_command();
            Report.flushAllReports();
            RD_entry.next_rd = null;
            MiscParms.printLoopStart();
            while (!monitor_final) {
                RD_entry rD_entry = RD_entry.getNextWorkload();
                if (rD_entry == null) {
                    if (MiscParms.shutDownAfterLoops(l)) break;
                    RD_entry.next_rd = null;
                    if (Validate.isJournalRecovery()) {
                        Validate.setJournalRecovered(false);
                    }
                    MiscParms.printLoopStart();
                    continue;
                }
                if (Vdbmain.isWdWorkload()) {
                    RD_entry.createWgListForOneRd(rD_entry, true);
                    rD_entry.finalizeWgEntry();
                }
                if (rD_entry.start_cmd != null && rD_entry.start_cmd.masterOnly()) {
                    rD_entry.start_cmd.run_command();
                }
                Reporter.prepareNextRun(rD_entry);
                ErrorLog.clearCount();
                int n = 1;
                int n2 = (int)(rD_entry.getElapsed() / rD_entry.getInterval());
                int n3 = 0;
                if (rD_entry.getWarmup() == 0L && !ReplayInfo.isReplay()) {
                    --n2;
                }
                interval_start_time = interval_end_time = new Date();
                run_start_time = new Date();
                while (!Vdbmain.isWorkloadDone()) {
                    boolean bl;
                    DV_map.checkDVStatus();
                    Interval.wait_interval();
                    if (SlaveList.allSequentialDone()) {
                        Vdbmain.setWorkloadDone(true);
                    }
                    if (Reporter.isWarmupDone()) {
                        ++n3;
                    }
                    boolean bl2 = bl = n3 >= n2;
                    if (Vdbmain.isWorkloadDone()) {
                        bl = true;
                    }
                    if (Reporter.checkMonitorFile()) {
                        bl = true;
                    }
                    if (Report.getAuxReport() != null && Report.getAuxReport().isShutdown()) {
                        bl = true;
                    }
                    interval_start_time = interval_end_time;
                    if (n == Reporter.getWarmupIntervals()) {
                        run_start_time = new Date();
                    }
                    run_end_time = interval_end_time = new Date();
                    CollectSlaveStats collectSlaveStats = new CollectSlaveStats(n++, rD_entry.getInterval(), bl);
                    GcTracker.report();
                    if (bl) {
                        collectSlaveStats.waitForLast();
                        Reporter.reportEndOfRun(rD_entry);
                        if (rD_entry.doing_curve_point && !rD_entry.doing_curve_max && Vdbmain.observed_resp > rD_entry.curve_end) {
                            common.ptod("Vdbench terminating because of requested 'stopcurve=%.3f' with observed response time of %.3f ms", rD_entry.curve_end, Vdbmain.observed_resp);
                            monitor_final = true;
                        }
                        if (Report.getAuxReport() == null) break;
                        Report.getAuxReport().setShutdown(false);
                        break;
                    }
                    if (!common.get_debug(common.PRINT_MEMORY)) continue;
                    System.gc();
                    common.memory_usage();
                    Native.printMemoryUsage();
                }
                if (rD_entry.isThisFormatRun() && rD_entry.format.format_limited) {
                    common.pboth("Format run terminated because of 'format=(only,limited)' request", new Object[0]);
                }
                Vdbmain.setWorkloadDone(true);
                Status.printRdStatus("Workload done", new Object[0]);
                SlaveList.sendWorkloadDone();
                Timeout.reportLazyBums();
                SlaveList.waitForSlaveWorkCompletion();
                Status.printRdStatus("Slaves done", new Object[0]);
                Blocked.printAndResetCounters();
                if (ThreadMonitor.active()) {
                    Host.reportMonTotals();
                }
                last_pause = rD_entry.pause;
                Report.flushAllReports();
                common.memory_usage();
                System.gc();
                if (Validate.isRecoveryOnly()) {
                    common.ptod("");
                    common.ptod("'journal=(recover,only)' requested. Terminating execution.");
                    common.ptod("");
                    break;
                }
                if (rD_entry.end_cmd == null || !rD_entry.end_cmd.masterOnly()) continue;
                rD_entry.end_cmd.run_command();
            }
            Debug_cmds.ending_command.run_command();
            SwatCharts.createCharts();
            common.plog("Ending Reporter");
        }
        catch (Throwable throwable) {
            common.abnormal_term(throwable);
        }
    }

    private static void prepareNextRun(RD_entry rD_entry) {
        if (last_pause != 0L) {
            common.ptod("Waiting " + last_pause + " seconds; requested by 'pause' parameter");
            common.sleep_some(last_pause * 1000L);
        }
        rD_entry.set_iorate();
        Blocked.resetCounters();
        Reporter.initWarmupIntervals(rD_entry);
        Report.setIntervalDuration((int)rD_entry.getInterval());
        if (Dedup.isDedup() && Vdbmain.isWdWorkload()) {
            SdDedup.adjustSdDedupValues();
        }
        Work.prepareWorkForSlaves(rD_entry, true);
        SlaveList.sendWorkToSlaves(rD_entry);
        WhereWhatWork.printWorkForSlaves("prepareNextRun", rD_entry);
        if (common.get_debug(common.GENERATE_WORK_INFO)) {
            System.out.println();
            for (String string : CompareWorkInfo.generateDebugInfo(rD_entry)) {
                System.out.println(string);
            }
            System.out.println();
        }
        if (CompareWorkInfo.debugOutputNeeded()) {
            for (String string : CompareWorkInfo.generateDebugInfo(rD_entry)) {
                System.out.println(string);
            }
        }
        if (CompareWorkInfo.debugCompareNeeded()) {
            CompareWorkInfo.compareWorkInfo(rD_entry);
        }
        Vdbmain.setWorkloadDone(false);
        common.plog("Waiting for synchronization of all slaves");
        SlaveList.waitForSlavesReadyToGo();
        common.plog("Synchronization of all slaves complete");
        SlaveList.externalSynchronize();
        Interval.set_interval_start(rD_entry.getInterval());
        rD_entry.display_run();
        SlaveList.tellSlavesToGo();
    }

    public static void reportEndOfRun(RD_entry rD_entry) {
        Object var1_1 = null;
        SdStats sdStats = null;
        FwdStats fwdStats = null;
        if (Vdbmain.isWdWorkload()) {
            WdReport.reportWdTotalStats();
            sdStats = SdReport.reportSdTotalStats();
            SkewReport.reportRawEndOfRunSkew(rD_entry);
            SkewReport.endOfRawRunSkewCheck(rD_entry);
            Report.getReport("histogram").println(sdStats.printHistograms());
        } else {
            fwdStats = FwdReport.reportRunTotals();
            SkewReport.reportFileEndOfRunSkew(rD_entry);
        }
        if (Report.isKstatReporting()) {
            Report.reportKstatTotals();
        }
        Flat.printInterval();
        if (Vdbmain.isWdWorkload()) {
            Vdbmain.observed_iorate = Math.round(sdStats.rate());
            Vdbmain.observed_resp = sdStats.respTime();
            if (RD_entry.next_rd.doing_curve_max && (Vdbmain.last_curve_max = Vdbmain.observed_iorate) == 0.0) {
                common.ptod("iorate=curve. No i/o rate observed. Was run too short?");
                common.ptod("Setting to 10,000 iops.");
                Vdbmain.last_curve_max = 10000.0;
            }
            Report.writeFlat(sdStats, Report.getAvgLabel());
        } else {
            Vdbmain.observed_iorate = Math.round(fwdStats.getReqstdRate());
            Vdbmain.observed_resp = fwdStats.getReqstdlResp();
            if (RD_entry.next_rd.doing_curve_max) {
                Vdbmain.last_curve_max = Vdbmain.observed_iorate;
            }
        }
        if (ErrorLog.getErrorCount() > 0) {
            if (Vdbmain.isFwdWorkload()) {
                Blocked.printAndResetCounters();
            }
            common.ptod("*");
            common.ptod("Total Data Validation or I/O error count: " + ErrorLog.getErrorCount());
            common.ptod("*");
            ErrorLog.plog("*", new Object[0]);
            ErrorLog.plog("Total Data Validation or I/O error count: " + ErrorLog.getErrorCount(), new Object[0]);
            ErrorLog.plog("*", new Object[0]);
            if (!common.get_debug(common.NO_ERROR_ABORT)) {
                common.failure("Vdbench terminating due to Data Validation or I/O errors. See errorlog.html.");
            }
        }
        CpuStats.cpu_shortage(rD_entry);
    }

    private static void initWarmupIntervals(RD_entry rD_entry) {
        warmup_done = false;
        warmup_intervals = (int)(rD_entry.getWarmup() / rD_entry.getInterval());
        if (warmup_intervals == 0) {
            warmup_intervals = 1;
        }
        if (ReplayInfo.isReplay()) {
            warmup_done = true;
        }
    }

    public static int getWarmupIntervals() {
        return warmup_intervals;
    }

    public static boolean isWarmupDone() {
        return warmup_done;
    }

    public static void setWarmupDone(int n) {
        warmup_done = true;
        Status.printRdStatus("Warmup done", new Object[0]);
        first_elapsed_interval = n + 1;
    }

    public static boolean needHeaders() {
        return Report.getInterval() % 30 == 1;
    }

    private static void clearShutdownFile(boolean bl) {
        new File(tmp_shutdown).delete();
        if (monitor_file == null) {
            return;
        }
        Fput fput = new Fput(monitor_file);
        fput.close();
        if (bl) {
            common.pboth("User requesting monitoring of this run using file '%s'.", monitor_file);
        }
    }

    private static boolean checkMonitorFile() {
        if (Fget.file_exists(tmp_shutdown)) {
            for (String string : Fget.readFileToArray(tmp_shutdown)) {
                if (!string.equals("kill_vdbench")) continue;
                monitor_kill = true;
            }
            Reporter.clearShutdownFile(false);
            monitor_final = true;
            if (!monitor_kill) {
                common.pboth("User requested early Vdbench termination using file '%s'.", tmp_shutdown);
                Status.printStatus("User requested early Vdbench termination.", new Object[0]);
            } else {
                common.pboth("User requested 'kill' for Vdbench.", new Object[0]);
                common.pboth("Attempting clean shutdown.", new Object[0]);
                Status.printStatus("User requested 'kill' for Vdbench.", new Object[0]);
            }
            return true;
        }
        if (monitor_file == null) {
            return false;
        }
        String[] stringArray = Fget.readFileToArray(monitor_file);
        if (stringArray.length == 0) {
            return false;
        }
        String string = stringArray[0].trim().toLowerCase();
        if (string.equals("shutdown") || string.equals("end_rd")) {
            common.pboth("User requested early shutdown of this run.", new Object[0]);
            Status.printStatus("User requested early shutdown of this run.", new Object[0]);
            Reporter.clearShutdownFile(false);
            return true;
        }
        if (string.equals("terminate") || string.equals("end_vdbench")) {
            common.pboth("User requested early Vdbench termination.", new Object[0]);
            Status.printStatus("User requested early Vdbench termination.", new Object[0]);
            Reporter.clearShutdownFile(false);
            monitor_final = true;
            return true;
        }
        if (string.equals("kill_vdbench")) {
            common.pboth("User 'kill requested.", new Object[0]);
            Status.printStatus("User 'kill' requested.", new Object[0]);
            Reporter.clearShutdownFile(false);
            monitor_final = true;
            monitor_kill = true;
            return true;
        }
        return false;
    }

    public static void killVdbench() {
        Fput fput = new Fput(tmp_shutdown);
        fput.println("kill_vdbench");
        fput.close();
        Vdbmain.setWorkloadDone(true);
    }

    static {
        last_pause = 0L;
        warmup_intervals = 0;
        warmup_done = false;
        first_elapsed_interval = 1;
        monitor_file = null;
        monitor_kill = false;
        monitor_final = false;
        tmpdir = common.onWindows() ? Fput.getTmpDir() : "/tmp";
        process_id = common.getProcessId();
        tmp_shutdown = new File(tmpdir, "vdbench.shutdown." + process_id).getAbsolutePath();
    }
}

