/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Vdb.Signal;
import Vdb.Slave;
import Vdb.SlaveSocket;
import Vdb.SocketMessage;
import Vdb.common;
import java.io.IOException;
import java.net.ConnectException;
import java.net.UnknownHostException;

public class Rsh {
    private static final String c = "Copyright (c) 2000, 2013, Oracle and/or its affiliates. All rights reserved.";
    public SlaveSocket socket_to_remote;
    private String host;

    public Rsh(String string) {
        this.host = string;
    }

    public void connectToRemote() {
        Signal signal = new Signal(60);
        while (true) {
            try {
                this.socket_to_remote = new SlaveSocket(this.host, SlaveSocket.getRemotePort());
                this.socket_to_remote.setSlaveLabel("rsh_to_client");
                this.socket_to_remote.setSlaveName("rsh_to_client");
                this.socket_to_remote.getSocket().setSoTimeout(3600000);
                common.ptod("Successfully connected to the Vdbench rsh daemon on host " + this.host);
            }
            catch (ConnectException connectException) {
                if (signal.go()) {
                    common.failure("Vdbench rsh connection failure.");
                }
                common.ptod("");
                common.ptod("Trying to connect to the Vdbench rsh daemon on host " + this.host);
                common.ptod("The Vdbench rsh daemon must be started on each target host.");
                common.ptod("This requires a one-time start of './vdbench rsh' on the target host.");
                common.ptod("Trying this for %d seconds only.", signal.getDuration());
                common.sleep_some(5000L);
                continue;
            }
            catch (UnknownHostException unknownHostException) {
                common.failure(unknownHostException);
            }
            catch (IOException iOException) {
                common.failure(iOException);
            }
            break;
        }
        common.ptod("RSH Connection to " + this.host + " using port " + SlaveSocket.getRemotePort() + " successful");
    }

    private void getRemoteOutput(Slave slave) {
        String string = slave.getLabel();
        block2: while (true) {
            try {
                while (true) {
                    String string2;
                    SocketMessage socketMessage;
                    if ((socketMessage = this.socket_to_remote.getMessage()).getMessageNum() == SocketMessage.RSH_STDERR_OUTPUT) {
                        string2 = (String)socketMessage.getData();
                        slave.getConsoleLog().println(common.tod() + " stderr: " + string2);
                        continue;
                    }
                    if (socketMessage.getMessageNum() == SocketMessage.RSH_STDOUT_OUTPUT) {
                        string2 = (String)socketMessage.getData();
                        slave.getConsoleLog().println(common.tod() + " " + string2);
                        if (!common.isFatal(string2)) continue;
                        common.ptod("Fatal error message received from slave " + string);
                        common.psum("Fatal error message received from slave " + string);
                        common.notifySlaves();
                        continue;
                    }
                    if (socketMessage.getMessageNum() == SocketMessage.RSH_COMMAND) break block2;
                    common.failure("Unknown socket message: " + socketMessage.getMessageText());
                }
            }
            catch (Exception exception) {
                common.ptod("Exception in getRemoteOutput(): " + string);
                common.failure(exception);
                continue;
            }
            break;
        }
        this.socket_to_remote.close();
    }

    public void getRemoteSwatOutput() {
        String string = "swatlabel";
        block2: while (true) {
            try {
                while (true) {
                    String string2;
                    SocketMessage socketMessage;
                    if ((socketMessage = this.socket_to_remote.getMessage()).getMessageNum() == SocketMessage.RSH_STDERR_OUTPUT) {
                        string2 = (String)socketMessage.getData();
                        common.ptod(" stderr: " + string2);
                        continue;
                    }
                    if (socketMessage.getMessageNum() == SocketMessage.RSH_STDOUT_OUTPUT) {
                        string2 = (String)socketMessage.getData();
                        common.ptod(" stdout: " + string2);
                        continue;
                    }
                    if (socketMessage.getMessageNum() == SocketMessage.RSH_COMMAND) break block2;
                    common.failure("Unknown socket message: " + socketMessage.getMessageText());
                }
            }
            catch (Exception exception) {
                common.ptod("Exception in getRemoteOutput(): " + string);
                common.failure(exception);
                continue;
            }
            break;
        }
        this.socket_to_remote.close();
    }

    public static void issueCommand(Slave slave, String string) {
        Rsh rsh = new Rsh(slave.getSlaveIP());
        rsh.connectToRemote();
        SocketMessage socketMessage = new SocketMessage(SocketMessage.RSH_COMMAND);
        socketMessage.setData(string);
        rsh.socket_to_remote.putMessage(socketMessage);
        rsh.getRemoteOutput(slave);
        rsh.socket_to_remote.close();
    }

    public static void main(String[] stringArray) {
        String string = stringArray[0];
        String string2 = "";
        for (int i = 1; i < stringArray.length; ++i) {
            string2 = string2 + stringArray[i] + " ";
        }
        Rsh rsh = new Rsh(string);
        rsh.connectToRemote();
        SocketMessage socketMessage = new SocketMessage(SocketMessage.RSH_COMMAND);
        socketMessage.setData(string2);
        rsh.socket_to_remote.putMessage(socketMessage);
        rsh.getRemoteSwatOutput();
        rsh.socket_to_remote.close();
    }

    public static void mainold(String[] stringArray) throws Exception {
        Rsh rsh = new Rsh("sbm-thor-a");
        String string = "script                                                         \n                                                               \n  run('shares');                                               \n  projects = list();                                           \n                                                               \n  printf('%-40s %-10s %-10s\\n', 'SHARE', 'USED', 'AVAILABLE');\n                                                               \n                                                               \n                                                               \n  for (i = 0; i < projects.length; i++)                        \n  {                                                            \n    run('select ' + projects[i]);                              \n    shares = list();                                           \n                                                               \n    for (j = 0; j < shares.length; j++)                        \n    {                                                          \n      run('select ' + shares[j]);                              \n                                                               \n      share = projects[i] + '/' + shares[j];                   \n      used  = run('get space_data').split(/\\s+/)[3];          \n      avail = run('get space_available').split(/\\s+/)[3];     \n                                                               \n      printf('%-40s %-10s %-10s\\n', share, used, avail);      \n      run('cd ..');                                            \n    }                                                          \n                                                               \n  run('cd ..');                                                \n  }                                                            \n";
        string = "echo \"" + string + "\" > /var/tmp/henk ; chmod +x /var/tmp/henk ; /var/tmp/henk";
        common.ptod("cmd: " + string);
        rsh.connectToRemote();
        SocketMessage socketMessage = new SocketMessage(SocketMessage.RSH_COMMAND);
        socketMessage.setData(string);
        rsh.socket_to_remote.putMessage(socketMessage);
        rsh.testRemoteOutput("xx");
        rsh.socket_to_remote.close();
    }

    private void testRemoteOutput(String string) {
        block2: while (true) {
            try {
                while (true) {
                    String string2;
                    SocketMessage socketMessage;
                    if ((socketMessage = this.socket_to_remote.getMessage()).getMessageNum() == SocketMessage.RSH_STDERR_OUTPUT) {
                        string2 = (String)socketMessage.getData();
                        common.ptod("stderr: " + string2);
                        continue;
                    }
                    if (socketMessage.getMessageNum() == SocketMessage.RSH_STDOUT_OUTPUT) {
                        string2 = (String)socketMessage.getData();
                        common.ptod("stdout: " + string2);
                        if (!common.isFatal(string2)) continue;
                        common.ptod("Fatal error message received from slave " + string);
                        common.psum("Fatal error message received from slave " + string);
                        common.notifySlaves();
                        continue;
                    }
                    if (socketMessage.getMessageNum() == SocketMessage.RSH_COMMAND) break block2;
                    common.failure("Unknown socket message: " + socketMessage.getMessageText());
                }
            }
            catch (Exception exception) {
                common.ptod("Exception in getRemoteOutput(): " + string);
                common.failure(exception);
                continue;
            }
            break;
        }
        this.socket_to_remote.close();
    }
}

