/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Utils.ClassPath;
import Utils.Fget;
import Vdb.RshUser;
import Vdb.SlaveSocket;
import Vdb.common;
import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.SocketTimeoutException;
import java.util.Vector;

class RshDeamon {
    private static final String c = "Copyright (c) 2000, 2012, Oracle and/or its affiliates. All rights reserved.";

    RshDeamon() {
    }

    public static void waitForUsers() {
        long l = 0L;
        ServerSocket serverSocket = null;
        try {
            serverSocket = new ServerSocket(SlaveSocket.getRemotePort());
            serverSocket.setSoTimeout(900000);
        }
        catch (IOException iOException) {
            System.err.println("Could not listen on port: " + SlaveSocket.getRemotePort());
            common.failure(iOException);
        }
        common.ptod("Vdbench rsh daemon: waiting for new users");
        block5: while (true) {
            if ((l = common.signal_caller(l, 300000L)) == 0L) {
                common.ptod("Vdbench rsh daemon: waiting for new users");
            }
            try {
                SlaveSocket slaveSocket = new SlaveSocket(serverSocket);
                slaveSocket.setSlaveLabel("RshDeamon");
                RshUser rshUser = new RshUser();
                rshUser.setSocket(slaveSocket);
                slaveSocket.setRecovery(false);
                rshUser.start();
                continue;
            }
            catch (SocketTimeoutException socketTimeoutException) {
                if (RshUser.active_commands.size() <= 0) continue;
                common.ptod("waiting for new Rshdaemon request. Current active requests:");
                int n = 0;
                while (true) {
                    if (n >= RshUser.active_commands.size()) continue block5;
                    common.ptod((String)RshUser.active_commands.elementAt(n));
                    ++n;
                }
            }
            catch (IOException iOException) {
                common.failure(iOException);
                continue;
            }
            break;
        }
    }

    public static void readPortNumbers() {
        int n = 0;
        int n2 = 0;
        if (new File(ClassPath.classPath(), "portnumbers.txt").exists()) {
            Vector vector = Fget.read_file_to_vector(ClassPath.classPath(), "portnumbers.txt");
            for (int i = 0; i < vector.size(); ++i) {
                String string = (String)vector.elementAt(i);
                if ((string = string.trim().toLowerCase()).startsWith("rshdaemonport=")) {
                    try {
                        n = Integer.parseInt(string.substring(14));
                    }
                    catch (Exception exception) {
                        common.ptod("Error parsing 'rshdaemonport=': " + string);
                    }
                    continue;
                }
                if (!string.startsWith("masterslaveport=")) continue;
                try {
                    n2 = Integer.parseInt(string.substring(16));
                    continue;
                }
                catch (Exception exception) {
                    common.ptod("Error parsing 'masterslaveport=': " + string);
                }
            }
            if (n != 0) {
                SlaveSocket.setRemotePort(n);
            }
            if (n2 != 0) {
                SlaveSocket.setMasterPort(n2);
            }
        }
        if (SlaveSocket.getRemotePort() == SlaveSocket.getMasterPort()) {
            common.ptod("rshdaemonport: " + SlaveSocket.getRemotePort());
            common.ptod("masterslaveport: " + SlaveSocket.getMasterPort());
            common.failure("rshdaemonport and masterslaveport must have different port numbers");
        }
    }

    public static void main(String[] stringArray) {
        RshDeamon.readPortNumbers();
        RshDeamon.waitForUsers();
    }
}

