/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Vdb.CpuStats;
import Vdb.FinalTotals;
import Vdb.Host;
import Vdb.Kstat_cpu;
import Vdb.RD_entry;
import Vdb.Report;
import Vdb.ReportData;
import Vdb.Reporter;
import Vdb.SD_entry;
import Vdb.SdSort;
import Vdb.SdStats;
import Vdb.Slave;
import Vdb.Tnfe_data;
import Vdb.Vdbmain;
import Vdb.Work;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Vector;

public class SdReport
extends Report {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";
    private static int total_header_calls = 1;

    public static void createRunSdReports() {
        Vector<Report> vector = new Vector<Report>(8);
        Vector<String> vector2 = new Vector<String>(8);
        String[] stringArray = RD_entry.getSdNamesUsed();
        Arrays.sort(stringArray, new SdSort());
        for (String string : stringArray) {
            Report report = new Report(string, "SD report for sd=" + string, SdReport.sdDetailNeeded());
            vector.add(report);
            vector2.add(string);
            if (!SdReport.sdDetailNeeded()) continue;
            Report report2 = new Report((Object)string, "histogram", "SD response time histogram.");
            report.printHtmlLink("Link to response time histogram", report2.getFileName(), "histogram");
        }
        if (SdReport.sdDetailNeeded()) {
            SdReport.getSummaryReport().printMultipleLinks(vector, vector2, "sd");
        }
    }

    public static void createSlaveSdReports(Host host) {
        for (int i = 0; i < host.getSlaves().size(); ++i) {
            Slave slave = host.getSlaves().elementAt(i);
            String[] stringArray = RD_entry.getSdsUsedForHost(host);
            Arrays.sort(stringArray, new SdSort());
            for (int j = 0; j < stringArray.length; ++j) {
                String string = stringArray[j];
                Report report = new Report(slave, string, "Slave SD report for sd=" + string, slave_detail);
                slave.addReport(string, report);
                String string2 = "sd=" + string + ",host=" + host.getLabel() + ",lun=" + host.getLunNameForSd(SD_entry.findSD(string));
                if (!slave_detail) continue;
                if (j == 0) {
                    slave.getSummaryReport().printHtmlLink("Links to slave SD reports", report.getFileName(), string2);
                    continue;
                }
                slave.getSummaryReport().printHtmlLink(null, report.getFileName(), string2);
            }
        }
    }

    public static void createHostSdReports() {
        Vector<Host> vector = Host.getDefinedHosts();
        for (int i = 0; i < vector.size(); ++i) {
            Host host = vector.elementAt(i);
            String[] stringArray = RD_entry.getSdsUsedForHost(host);
            Arrays.sort(stringArray, new SdSort());
            if (host_detail) {
                for (int j = 0; j < stringArray.length; ++j) {
                    String string = stringArray[j];
                    String string2 = "Host SD report for sd=" + string + ",host=" + host.getLabel() + ",lun=" + host.getLunNameForSd(SD_entry.findSD(string));
                    Report report = new Report(host, string, string2);
                    host.addReport(string, report);
                    string2 = "sd=" + string + ",host=" + host.getLabel() + ",lun=" + host.getLunNameForSd(SD_entry.findSD(string));
                    if (j == 0) {
                        host.getSummaryReport().printHtmlLink("Link to host SD reports", report.getFileName(), string2);
                        continue;
                    }
                    host.getSummaryReport().printHtmlLink(null, report.getFileName(), string2);
                }
            }
            SdReport.createSlaveSdReports(host);
        }
    }

    public static void reportSdStats() {
        Object object;
        String[] stringArray;
        RD_entry rD_entry = RD_entry.next_rd;
        Tnfe_data.writeIntervalHeader(false, Reporter.interval_start_time, Reporter.interval_end_time);
        Vector<Host> vector = Host.getDefinedHosts();
        for (int i = 0; i < vector.size(); ++i) {
            Object object2;
            Object object3;
            stringArray = vector.elementAt(i);
            if (!stringArray.anyWork()) continue;
            Kstat_cpu kstat_cpu = stringArray.getSummaryReport().getData().getIntervalCpuStats();
            for (int j = 0; j < stringArray.getSlaves().size(); ++j) {
                Slave slave = stringArray.getSlaves().elementAt(j);
                object3 = slave.getCurrentWork();
                if (object3 == null) continue;
                if (slave_detail) {
                    object2 = slave.getCurrentWork().getSdList();
                    for (int k = 0; k < ((SD_entry[])object2).length; ++k) {
                        SdStats sdStats = slave.getReport(object2[k].sd_name).getData().getIntervalSdStats();
                        slave.getReport(object2[k].sd_name).reportDetail(sdStats, kstat_cpu);
                    }
                }
                object2 = slave.getSummaryReport().getData().getIntervalSdStats();
                slave.getSummaryReport().reportDetail((SdStats)object2, kstat_cpu);
            }
            if (host_detail) {
                String[] stringArray2 = rD_entry.getSdsUsedForHostThisRd((Host)stringArray);
                for (int j = 0; j < stringArray2.length; ++j) {
                    object3 = stringArray2[j];
                    object2 = stringArray.getReport((String)object3).getData().getIntervalSdStats();
                    stringArray.getReport((String)object3).reportDetail((SdStats)object2, kstat_cpu);
                }
            }
            object = stringArray.getSummaryReport().getData().getIntervalSdStats();
            stringArray.getSummaryReport().reportDetail((SdStats)object, kstat_cpu);
        }
        Kstat_cpu kstat_cpu = Report.getSummaryReport().getData().getIntervalCpuStats();
        stringArray = RD_entry.next_rd.getSdNamesUsed();
        for (int i = 0; i < stringArray.length; ++i) {
            object = stringArray[i];
            SdStats sdStats = Report.getReport((String)object).getData().getIntervalSdStats();
            SdReport.getReport((String)object).reportDetail(sdStats, kstat_cpu);
            Tnfe_data.writeOneSd(false, (String)object, sdStats);
        }
        SdStats sdStats = SdReport.getSummaryReport().getData().getIntervalSdStats();
        if (sdStats != null) {
            SdReport.getSummaryReport().reportDetail(sdStats, kstat_cpu);
            FinalTotals.add(sdStats);
            if (!Vdbmain.kstat_console) {
                SdReport.getStdoutReport().reportDetail(sdStats, kstat_cpu);
            }
        }
        SdReport.writeFlat(sdStats, "" + SdReport.getInterval());
    }

    public static SdStats reportSdTotalStats() {
        SdStats sdStats;
        Serializable serializable;
        String string = Report.getAvgLabel();
        SD_entry[] sD_entryArray = Work.getSdsForRun();
        Tnfe_data.writeIntervalHeader(true, Reporter.run_start_time, Reporter.run_end_time);
        Vector<Host> vector = Host.getDefinedHosts();
        for (int i = 0; i < vector.size(); ++i) {
            Serializable serializable2;
            Object object;
            int n;
            Host host = vector.elementAt(i);
            if (!host.anyWork()) continue;
            serializable = host.getSummaryReport().getData().getTotalCpuStats();
            for (n = 0; n < host.getSlaves().size(); ++n) {
                object = host.getSlaves().elementAt(n);
                serializable2 = ((Slave)object).getCurrentWork();
                if (serializable2 == null) continue;
                if (slave_detail) {
                    sD_entryArray = ((Slave)object).getCurrentWork().getSdList();
                    for (int j = 0; j < sD_entryArray.length; ++j) {
                        SdStats sdStats2 = ((Slave)object).getReport(sD_entryArray[j].sd_name).getData().getTotalSdStats();
                        ((Slave)object).getReport(sD_entryArray[j].sd_name).reportDetail(sdStats2, (Kstat_cpu)serializable, string);
                    }
                }
                SdStats sdStats3 = ((Slave)object).getSummaryReport().getData().getTotalSdStats();
                ((Slave)object).getSummaryReport().reportDetail(sdStats3, (Kstat_cpu)serializable, string);
                if (!slave_detail) continue;
                SdReport.getReport(((Slave)object).getLabel(), "histogram").println(sdStats3.printHistograms());
            }
            if (host_detail) {
                sD_entryArray = Work.getHostSdsForRun(host);
                for (n = 0; n < sD_entryArray.length; ++n) {
                    object = host.getReport(sD_entryArray[n].sd_name).getData();
                    serializable2 = ((ReportData)object).getTotalSdStats();
                    host.getReport(sD_entryArray[n].sd_name).reportDetail((SdStats)serializable2, (Kstat_cpu)serializable, string);
                }
            }
            sdStats = host.getSummaryReport().getData().getTotalSdStats();
            host.getSummaryReport().reportDetail(sdStats, (Kstat_cpu)serializable, string);
            if (!host_detail) continue;
            SdReport.getReport(host.getLabel(), "histogram").println(sdStats.printHistograms());
        }
        Kstat_cpu kstat_cpu = Report.getSummaryReport().getData().getTotalCpuStats();
        for (int i = 0; Report.sdDetailNeeded() && i < sD_entryArray.length; ++i) {
            serializable = sD_entryArray[i];
            sdStats = SdReport.getReport(((SD_entry)serializable).sd_name).getData().getTotalSdStats();
            SdReport.getReport(((SD_entry)serializable).sd_name).reportDetail(sdStats, kstat_cpu, string);
            SdReport.getReport(((SD_entry)serializable).sd_name, "histogram").println(sdStats.printHistograms());
            Tnfe_data.writeOneSd(true, ((SD_entry)serializable).sd_name, sdStats);
        }
        SdStats sdStats4 = SdReport.getSummaryReport().getData().getTotalSdStats();
        SdReport.getSummaryReport().reportDetail(sdStats4, kstat_cpu, string);
        SdReport.getTotalReport().printHeaders(SdReport.getTotalReport().getWriter(), kstat_cpu, total_header_calls);
        total_header_calls += 2;
        SdReport.getTotalReport().reportDetail(sdStats4, kstat_cpu, string);
        if (!Vdbmain.kstat_console) {
            SdReport.getStdoutReport().reportDetail(sdStats4, kstat_cpu, string);
        }
        Report.writeFlat(sdStats4, string);
        if (CpuStats.isCpuReporting()) {
            Report.writeFlatCpu(SdReport.getSummaryReport().getData().getTotalCpuStats());
        }
        return sdStats4;
    }
}

