/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Utils.Fget;
import Utils.Getopt;
import Vdb.RunData;
import Vdb.common;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

public class SdSingle {
    private static final String c = "Copyright (c) 2000, 2015, Oracle and/or its affiliates. All rights reserved.";

    private static void usage(String string) {
        common.ptod("");
        common.ptod("Usage: ./vdbench Vdb.SdSingle [-p nn] [-r nn] [-a] [-f] [-t type] vdbench_output_directory");
        common.ptod("       -r nn: Default 2. How many of the slowest devices to remove to calculate average.");
        common.ptod("       -p nn: Default 5. Any device not performing within 'nn' percent of the average will be reported");
        common.ptod("       -a:    Display all devices, including those devices not removed.");
        common.ptod("       -t     Type: allows 'resp', 'iops', and 'max'. Default 'iops'");
        common.ptod("       -f     Full reporting, sorted by SD");
        common.ptod("");
        common.ptod("Note that this program only works for Vdbench runs using 'sd=setsofN'");
        common.ptod("");
        common.failure(string);
    }

    public static void main(String[] stringArray) {
        double d;
        double d2;
        int n = 2;
        int n2 = 5;
        boolean bl = false;
        String string = "iops";
        Getopt getopt = new Getopt(stringArray, "far:p:d:t:", 1);
        if (!getopt.isOK() || getopt.get_positionals().size() == 0) {
            SdSingle.usage("Parameter scan error");
        }
        bl = getopt.check('a');
        if (getopt.check('r')) {
            n = (int)getopt.get_long();
        }
        if (getopt.check('p')) {
            n2 = (int)getopt.get_long();
        }
        if (getopt.check('t') && !(string = getopt.get_string()).equals("resp") && !string.equals("max") && !string.equals("iops")) {
            common.failure("'-t' only allows 'resp', 'iops', and 'max'. Default 'iops'");
        }
        String string2 = getopt.get_pos_string(0);
        HashMap<String, Object> hashMap = new HashMap<String, Object>(64);
        String[] stringArray2 = Fget.readFileToArray(string2, "logfile.html");
        block0: for (String string3 : stringArray2) {
            String[] stringArray3;
            String[] stringArray4;
            if (!string3.contains("sd=sd") || !string3.contains(",lun=") || !string3.contains("lun size") || (stringArray4 = string3.trim().split(" +")).length < 2) continue;
            stringArray4 = stringArray4[1].split(",+");
            Object object = new RunData();
            ((RunData)object).sd_name = stringArray4[0].substring(3);
            ((RunData)object).dev_name = stringArray4[1].substring(4);
            for (String object2 : stringArray3 = Fget.readFileToArray(string2, ((RunData)object).sd_name + ".html")) {
                if (!object2.contains("avg_")) continue;
                stringArray4 = object2.split(" +");
                ((RunData)object).iops = Double.parseDouble(stringArray4[2]);
                ((RunData)object).resp = Double.parseDouble(stringArray4[6]);
                ((RunData)object).max = Double.parseDouble(stringArray4[9]);
                hashMap.put(((RunData)object).sd_name, object);
                continue block0;
            }
        }
        Object[] objectArray = hashMap.values().toArray(new RunData[0]);
        ArrayList<Object> arrayList = new ArrayList<Object>(256);
        for (Object object : objectArray) {
            arrayList.add(object);
        }
        RunData.which_sort = string;
        Collections.sort(arrayList);
        common.ptod("");
        common.ptod("Removing the %d worst '%s' devices from calculated averages:", n, string);
        for (int i = 0; i < n; ++i) {
            RunData runData2 = (RunData)arrayList.get(i);
            common.ptod(runData2);
        }
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        int n3 = 0;
        for (int i = n; i < arrayList.size(); ++i) {
            RunData runData = (RunData)arrayList.get(i);
            d3 += runData.iops;
            d4 += runData.resp;
            d5 += runData.max;
            ++n3;
        }
        if (string.equals("iops")) {
            d2 = d3 / (double)n3;
            d = d2 * (double)(100 - n2) / 100.0;
        } else if (string.equals("resp")) {
            d2 = d4 / (double)n3;
            d = d2 * (double)(100 + n2) / 100.0;
        } else {
            d2 = d5 / (double)n3;
            d = d2 * (double)(100 + n2) / 100.0;
        }
        String string3 = string.equals("iops") ? "lowest" : "highest";
        common.ptod("");
        common.ptod("The average %s is %8.3f (the %d %s of %d ignored)", string, d2, n, string3, arrayList.size());
        int n4 = 0;
        if (n > 0) {
            common.ptod("");
            common.ptod("*******************************************************************************************");
            common.ptod("These are the devices that are %d%% different from the average '%s' of %.3f (cutoff is %.3f)", n2, string, d2, d);
            String n6 = RunData.which_sort;
            RunData.which_sort = string;
            Collections.sort(arrayList);
            for (RunData runData : arrayList) {
                if (string.equals("iops")) {
                    runData.value_used = runData.iops;
                    if (n2 <= 0 || !(runData.iops < d)) continue;
                    ++n4;
                    runData.dropped = true;
                    common.ptod(runData);
                    continue;
                }
                if (string.equals("resp")) {
                    runData.value_used = runData.resp;
                    if (n2 <= 0 || !(runData.resp > d)) continue;
                    ++n4;
                    runData.dropped = true;
                    common.ptod(runData);
                    continue;
                }
                runData.value_used = runData.max;
                if (n2 <= 0 || !(runData.max > d)) continue;
                ++n4;
                runData.dropped = true;
                common.ptod(runData);
            }
            if (n4 == 0) {
                common.ptod("No slow devices found");
            }
            common.ptod("*******************************************************************************************");
        }
        if (!bl) {
            common.ptod("");
            common.ptod("Remaining devices not displayed; add -a execution parameter to also display those.");
        } else {
            RunData.which_sort = string;
            Collections.sort(arrayList);
            common.ptod("");
            common.ptod("These are the remaining devices, sorted by '%s':", string);
            int n5 = 1;
            for (int i = 0; i < arrayList.size(); ++i) {
                RunData runData = (RunData)arrayList.get(i);
                if (runData.dropped) continue;
                common.ptod(String.format("(%3d) %s (%5.1f%% of average %.3f)", n5++, runData, runData.value_used * 100.0 / d2, d2));
            }
        }
        if (getopt.check('f')) {
            RunData.which_sort = "name";
            Collections.sort(arrayList);
            common.ptod("");
            common.ptod("These are the remaining devices, sorted by '%s':", string);
            int n6 = 1;
            for (int i = 0; i < arrayList.size(); ++i) {
                RunData runData = (RunData)arrayList.get(i);
                common.ptod(String.format("(%3d) %s (%5.1f%% of average %.3f)", n6++, runData, runData.value_used * 100.0 / d2, d2));
            }
        }
    }
}

