/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Utils.Format;
import Vdb.Histogram;
import Vdb.Report;
import Vdb.common;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.Vector;

public class SdStats
implements Serializable {
    private static final String c = "Copyright (c) 2000, 2015, Oracle and/or its affiliates. All rights reserved.";
    String sd_name;
    String wd_name;
    long elapsed;
    long reads;
    long r_resptime;
    long r_resptime2;
    long r_max;
    long r_bytes;
    long writes;
    long w_resptime;
    long w_resptime2;
    long w_max;
    long w_bytes;
    long val_count;
    long val_error;
    long r_errors;
    long w_errors;
    long rtime;
    long rlentime;
    boolean work_done;
    Histogram histogram = new Histogram("default");
    Histogram read_hist = new Histogram("default");
    Histogram write_hist = new Histogram("default");
    private static int negative_response_count = 0;

    public void clearHistograms() {
        this.histogram = null;
        this.read_hist = null;
        this.write_hist = null;
    }

    void stats_accum(SdStats sdStats, boolean bl) {
        this.reads += sdStats.reads;
        this.r_resptime += sdStats.r_resptime;
        this.r_resptime2 += sdStats.r_resptime2;
        this.r_max = Math.max(this.r_max, sdStats.r_max);
        this.r_bytes += sdStats.r_bytes;
        this.r_errors += sdStats.r_errors;
        this.writes += sdStats.writes;
        this.w_resptime += sdStats.w_resptime;
        this.w_resptime2 += sdStats.w_resptime2;
        this.w_max = Math.max(this.w_max, sdStats.w_max);
        this.w_bytes += sdStats.w_bytes;
        this.w_errors += sdStats.w_errors;
        this.val_count += sdStats.val_count;
        this.val_error += sdStats.val_error;
        this.rlentime += sdStats.rlentime;
        if (bl) {
            this.elapsed += sdStats.elapsed;
            this.rtime += sdStats.rtime;
        } else if (sdStats.elapsed != 0L) {
            this.elapsed = sdStats.elapsed;
            this.rtime = sdStats.rtime;
        }
        if (this.histogram != null) {
            this.histogram.accumBuckets(sdStats.histogram);
            this.read_hist.accumBuckets(sdStats.read_hist);
            this.write_hist.accumBuckets(sdStats.write_hist);
        }
    }

    void stats_copy(SdStats sdStats) {
        this.sd_name = sdStats.sd_name;
        this.elapsed = sdStats.elapsed;
        this.reads = sdStats.reads;
        this.r_resptime = sdStats.r_resptime;
        this.r_resptime2 = sdStats.r_resptime2;
        sdStats.r_max = 0L;
        this.r_max = 0L;
        this.r_bytes = sdStats.r_bytes;
        this.r_errors = sdStats.r_errors;
        this.writes = sdStats.writes;
        this.w_resptime = sdStats.w_resptime;
        this.w_resptime2 = sdStats.w_resptime2;
        sdStats.w_max = 0L;
        this.w_max = 0L;
        this.w_bytes = sdStats.w_bytes;
        this.w_errors = sdStats.w_errors;
        this.val_count = sdStats.val_count;
        this.val_error = sdStats.val_error;
        this.rtime = sdStats.rtime;
        this.rlentime = sdStats.rlentime;
        if (sdStats.histogram != null) {
            this.histogram = (Histogram)sdStats.histogram.clone();
            this.read_hist = (Histogram)sdStats.read_hist.clone();
            this.write_hist = (Histogram)sdStats.write_hist.clone();
        }
    }

    void stats_delta(SdStats sdStats, SdStats sdStats2) {
        this.reads = sdStats.reads - sdStats2.reads;
        this.r_resptime = sdStats.r_resptime - sdStats2.r_resptime;
        this.r_resptime2 = sdStats.r_resptime2 - sdStats2.r_resptime2;
        this.r_max = sdStats.r_max;
        this.r_bytes = sdStats.r_bytes - sdStats2.r_bytes;
        this.r_errors = sdStats.r_errors - sdStats2.r_errors;
        this.writes = sdStats.writes - sdStats2.writes;
        this.w_resptime = sdStats.w_resptime - sdStats2.w_resptime;
        this.w_resptime2 = sdStats.w_resptime2 - sdStats2.w_resptime2;
        this.w_max = sdStats.w_max;
        this.w_bytes = sdStats.w_bytes - sdStats2.w_bytes;
        this.w_errors = sdStats.w_errors - sdStats2.w_errors;
        this.val_count = sdStats.val_count - sdStats2.val_count;
        this.val_error = sdStats.val_error - sdStats2.val_error;
        this.rtime = sdStats.rtime - sdStats2.rtime;
        this.rlentime = sdStats.rlentime - sdStats2.rlentime;
        if (this.histogram != null && sdStats2.histogram != null && sdStats.histogram != null) {
            this.histogram.deltaBuckets(sdStats.histogram, sdStats2.histogram);
            this.read_hist.deltaBuckets(sdStats.read_hist, sdStats2.read_hist);
            this.write_hist.deltaBuckets(sdStats.write_hist, sdStats2.write_hist);
        }
        if (this.r_resptime < 0L) {
            if (negative_response_count == 0) {
                common.ptod("Negative response time. Usually caused by out of sync CPU clocks .");
                common.ptod("Will be reported a maximum of 100 times and then Vdbench will continue.");
            }
            if (negative_response_count++ < 100) {
                common.ptod("r_resptime (microseconds): " + this.r_resptime + " " + sdStats2.r_resptime + " " + sdStats.r_resptime);
            }
        }
        if (this.w_resptime < 0L) {
            if (negative_response_count == 0) {
                common.ptod("Negative response time. Usually caused by out of sync CPU clocks .");
                common.ptod("Will be reported a maximum of 100 times and then Vdbench will continue.");
            }
            if (negative_response_count++ < 100) {
                common.ptod("w_resptime (microseconds): " + this.w_resptime + " " + sdStats2.w_resptime + " " + sdStats.w_resptime);
            }
        }
    }

    synchronized void add_validation_count() {
        ++this.val_count;
    }

    synchronized void add_validation_error() {
        ++this.val_error;
    }

    public double rate() {
        return this.elapsed > 0L ? (double)(this.reads + this.writes) * 1000000.0 / (double)this.elapsed : 0.0;
    }

    public double megabytes() {
        long l = this.r_bytes + this.w_bytes;
        return this.elapsed > 0L ? (double)l / ((double)this.elapsed / 1000000.0) / (double)Report.MB : 0.0;
    }

    public long bytes() {
        long l = this.r_bytes + this.w_bytes;
        return this.reads + this.writes > 0L ? l / (this.reads + this.writes) : 0L;
    }

    public double readpct() {
        return this.reads + this.writes > 0L ? (double)this.reads / (double)(this.reads + this.writes) * 100.0 : 0.0;
    }

    public double readResp() {
        double d;
        double d2 = d = this.reads > 0L ? (double)this.r_resptime / (double)this.reads / 1000.0 : 0.0;
        if (d < 0.0) {
            common.where(8);
            common.ptod("readResp(): " + this.r_resptime + " " + this.reads);
        }
        return d;
    }

    public double writeResp() {
        double d;
        double d2 = d = this.writes > 0L ? (double)this.w_resptime / (double)this.writes / 1000.0 : 0.0;
        if (d < 0.0) {
            common.where(8);
            common.ptod("writeResp(): " + this.w_resptime + " " + this.writes);
        }
        return d;
    }

    public double respTime() {
        double d;
        long l = this.r_resptime + this.w_resptime;
        double d2 = d = this.reads + this.writes > 0L ? (double)l / (double)(this.reads + this.writes) / 1000.0 : 0.0;
        if (d < 0.0) {
            common.where(8);
            common.ptod("respTime(): " + this.r_resptime + " " + this.w_resptime + " " + this.reads + " " + this.writes);
        }
        return d;
    }

    public double respMax() {
        return (double)Math.max(this.r_max, this.w_max) / 1000.0;
    }

    public double readMax() {
        return (double)this.r_max / 1000.0;
    }

    public double writeMax() {
        return (double)this.w_max / 1000.0;
    }

    public double resptime_std() {
        double d = this.reads + this.writes;
        if (d <= 1.0 || this.r_resptime + this.w_resptime == 0L) {
            return 0.0;
        }
        long l = this.r_resptime + this.w_resptime;
        long l2 = this.r_resptime2 + this.w_resptime2;
        return Math.sqrt((d * (double)l2 - (double)l * (double)l) / (d * (d - 1.0))) / 1000.0;
    }

    public double readStd() {
        if (this.reads <= 1L || this.r_resptime == 0L) {
            return 0.0;
        }
        return Math.sqrt(((double)this.reads * (double)this.r_resptime2 - (double)this.r_resptime * (double)this.r_resptime) / (double)(this.reads * (this.reads - 1L))) / 1000.0;
    }

    public double writeStd() {
        if (this.writes <= 1L || this.w_resptime == 0L) {
            return 0.0;
        }
        return Math.sqrt(((double)this.writes * (double)this.w_resptime2 - (double)this.w_resptime * (double)this.w_resptime) / (double)(this.writes * (this.writes - 1L))) / 1000.0;
    }

    public double busypct() {
        double d = this.elapsed == 0L ? 0.0 : (double)this.rtime * 100.0 / (double)this.elapsed;
        return d;
    }

    public double qdepth() {
        double d = this.elapsed == 0L ? 0.0 : (double)this.rlentime / (double)this.elapsed;
        return d;
    }

    public String toString() {
        String string = "SdStats:";
        string = string + Format.f(" sd: %-8s", this.sd_name == null ? "null" : this.sd_name);
        string = string + Format.f(" rd: %4d", this.reads);
        string = string + Format.f(" wrt: %4d", this.writes);
        string = string + Format.f(" rb: %8d", this.r_bytes);
        string = string + Format.f(" wb: %8d", this.w_bytes);
        string = string + Format.f(" el: %8d", this.elapsed);
        return string;
    }

    public Vector printHistograms() {
        Vector<String> vector = new Vector<String>(64);
        if (this.histogram.getTotals() == 0L) {
            vector.add("No statistics generated for this run.");
        } else if (this.histogram.getTotals() == this.read_hist.getTotals()) {
            vector.addAll(this.histogram.printHistogram("Only reads done for this workload:"));
        } else if (this.histogram.getTotals() == this.write_hist.getTotals()) {
            vector.addAll(this.histogram.printHistogram("Only writes done for this workload:"));
        } else {
            vector.addAll(this.histogram.printHistogram("Reads and writes:"));
            vector.addAll(this.read_hist.printHistogram("Reads:"));
            vector.addAll(this.write_hist.printHistogram("Writes:"));
        }
        return vector;
    }

    public static void main(String[] stringArray) {
        long l = Long.parseLong(stringArray[0]);
        DecimalFormat decimalFormat = new DecimalFormat("#,###");
        common.ptod("xx: " + decimalFormat.format(l));
    }
}

