/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Utils.Fget;
import Utils.Fput;
import Utils.Getopt;
import Vdb.Cmd_entry;
import Vdb.Message;
import Vdb.SlaveJvm;
import Vdb.Tframe;
import Vdb.Validate;
import Vdb.common;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;

public class ShowLba
extends JPanel
implements ActionListener {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";
    private Tframe frame = new Tframe(String.format("%150s", "ShowLba"));
    private ArrayList<TodLba> data = new ArrayList(32768);
    private long reads = 0L;
    private long writes = 0L;
    private long seek_width;
    private long duration;
    private long min_tod = Long.MAX_VALUE;
    private long max_tod = 0L;
    private long min_lba = Long.MAX_VALUE;
    private long max_lba = 0L;
    JLabel legend = new JLabel();
    JLabel label = new JLabel();
    private ArrayList<String> sds_found = new ArrayList(8);
    public static Color[] colors = new Color[]{new Color(0, 0, 255), new Color(255, 0, 0), new Color(0, 255, 0), new Color(0, 255, 255), new Color(255, 200, 0), new Color(255, 175, 175), new Color(255, 255, 0), new Color(255, 0, 255), new Color(192, 192, 192), new Color(64, 64, 64), new Color(0, 0, 178), new Color(178, 0, 0), new Color(0, 178, 0), new Color(0, 178, 178), new Color(178, 140, 0), new Color(178, 122, 122), new Color(178, 178, 0), new Color(178, 0, 178), new Color(134, 134, 134), new Color(0, 0, 0)};
    private int dot_size = 1;
    private JButton exit = new JButton("Exit");
    private JButton refresh = new JButton("Refresh");
    private JButton bigdot = new JButton("Big dots");
    private JButton smalldot = new JButton("Small dots");
    private static Fput fake_trace = null;
    private static long trace_start = 0L;

    public void doit() {
        this.frame.setTitle("Vdb.ShowLba");
        this.frame.setSize(1200, 600);
        this.frame.setLayout(new GridBagLayout());
        this.exit.addActionListener(this);
        this.bigdot.addActionListener(this);
        this.smalldot.addActionListener(this);
        Container container = this.frame.getContentPane();
        container.add((Component)this.exit, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        container.add((Component)this.bigdot, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        container.add((Component)this.smalldot, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        container.add((Component)this.legend, new GridBagConstraints(0, 1, 3, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        container.add((Component)this, new GridBagConstraints(0, 2, 3, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        container.add((Component)this.label, new GridBagConstraints(0, 3, 3, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        Message.centerscreen(this.frame);
    }

    public boolean addLba(String string) {
        try {
            TodLba todLba = new TodLba();
            String[] stringArray = string.trim().split(" +");
            todLba.sd = stringArray[0];
            todLba.wd = stringArray[1];
            todLba.read_flag = stringArray[2].charAt(0) == '1';
            todLba.lba = Long.parseLong(stringArray[3]);
            todLba.tod = Long.parseLong(stringArray[4]);
            this.min_tod = Math.min(this.min_tod, todLba.tod);
            this.max_tod = Math.max(this.max_tod, todLba.tod);
            this.min_lba = Math.min(this.min_lba, todLba.lba);
            this.max_lba = Math.max(this.max_lba, todLba.lba);
            int n = this.sds_found.indexOf(todLba.sd);
            if (n < 0) {
                this.sds_found.add(todLba.sd);
            }
            n = this.sds_found.indexOf(todLba.sd);
            todLba.color = todLba.read_flag ? colors[n] : colors[(n + 1) % colors.length];
            this.data.add(todLba);
            if (todLba.read_flag) {
                ++this.reads;
            } else {
                ++this.writes;
            }
            return true;
        }
        catch (Exception exception) {
            common.ptod(exception);
            common.ptod("Error parsing input. Setting to EOF");
            return false;
        }
    }

    private static void usage() {
        common.ptod("Usage: ");
        common.ptod("./vdbench Vdb.ShowLba [-w wdname] [-s sdname] [-o out.jpg]");
        common.failure("parameter error");
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length - 1];
        System.arraycopy(stringArray, 1, stringArray2, 0, stringArray2.length);
        Getopt getopt = new Getopt(stringArray2, "w:s:d:o:", 99);
        getopt.print("ShowLba");
        if (!getopt.isOK() || getopt.get_positionals().size() == 0) {
            common.ptod("Usage: ./vdbench showlba [-w WDname] [-s SDname] [-o output.png] localhost-?.showlba.txt");
            common.ptod("Where: ");
            common.ptod("     -s SDname:       Filter looking for sd=SDname");
            common.ptod("     -w WDname:       Filter looking for wd=WDname");
            common.ptod("     -o output.png    Do not display, create PNG file instead.");
            common.ptod("     localhost-0.showlba.txt  . . . .  trace file created by showlba=yes");
            common.failure("parameter error");
        }
        String string = null;
        String string2 = null;
        String string3 = null;
        if (getopt.check('s')) {
            string2 = getopt.get_string();
        }
        if (getopt.check('w')) {
            string3 = getopt.get_string();
        }
        ShowLba showLba = new ShowLba();
        for (String string4 : getopt.get_positionals()) {
            string = new File(string4).getAbsolutePath();
            string = new File(string).getParentFile().getAbsolutePath();
            Fget fget = new Fget(string4);
            String string5 = null;
            try {
                while ((string5 = fget.get()) != null) {
                    String[] stringArray3 = string5.trim().split(" +");
                    String string6 = stringArray3[0];
                    String string7 = stringArray3[1];
                    if (string2 != null && !string6.equals(string2) || string3 != null && !string7.equals(string3) || showLba.addLba(string5)) continue;
                    break;
                }
                fget.close();
            }
            catch (Exception exception) {
                common.ptod("Exception reading ShowLba file, accepted");
                common.ptod(exception);
            }
        }
        showLba.doit();
        if (getopt.check('o')) {
            ShowLba.savePanel(showLba, getopt.get_string(), new Dimension(1200, 600));
        } else {
            showLba.frame.setVisible(true);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.exit) {
            System.exit(0);
        } else if (actionEvent.getSource() == this.smalldot) {
            this.dot_size = 1;
            this.repaint();
        } else if (actionEvent.getSource() == this.bigdot) {
            this.dot_size = 2;
            this.repaint();
        }
    }

    @Override
    public void paint(Graphics graphics) {
        boolean bl = false;
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.seek_width = this.max_lba - this.min_lba;
        if (bl) {
            common.ptod("seek_width: " + this.seek_width);
        }
        this.duration = this.max_tod - this.min_tod;
        if (bl) {
            common.ptod("duration: " + this.duration);
        }
        Dimension dimension = this.getSize();
        int n = (int)dimension.getWidth();
        int n2 = (int)dimension.getHeight();
        if (bl) {
            common.ptod("width: " + n);
        }
        if (bl) {
            common.ptod("height: " + n2);
        }
        long l = this.seek_width / (long)n;
        if (bl) {
            common.ptod("bytes_per_pixel: " + l);
        }
        long l2 = this.duration / (long)n2;
        if (bl) {
            common.ptod("usecs_per_pixel: " + l2);
        }
        String string = String.format("Lowest lba: %,d (%,dmb) (%,dgb); Highest lba: %,d (%,dmb) (%,dgb); number of ios: %,d; duration: %.2f seconds; reads: %,d; writes: %,d ", this.min_lba, this.min_lba / 0x100000L, this.min_lba / 0x40000000L, this.max_lba, this.max_lba / 0x100000L, this.max_lba / 0x40000000L, this.data.size(), (double)this.duration / 1000.0, this.reads, this.writes);
        this.label.setBorder(new EtchedBorder(0, Color.white, new Color(178, 178, 178)));
        this.label.setText(string);
        this.legend.setForeground(Color.RED);
        this.legend.setBorder(new EtchedBorder(0, Color.white, new Color(178, 178, 178)));
        Collections.sort(this.sds_found);
        String string2 = "  Legend: Vertical axis: time, Horizontal axis: lba;  Each SD has its own color for reads or writes; SDs found: ";
        for (String string3 : this.sds_found) {
            string2 = string2 + string3 + " ";
        }
        string2 = string2 + " for help, run ./vdbench showlba -h";
        this.legend.setText(string2);
        int n3 = 0;
        for (int i = 0; i < this.data.size(); ++i) {
            TodLba todLba = this.data.get(i);
            int n4 = (int)((todLba.tod - this.min_tod) / l2);
            int n5 = (int)((todLba.lba - this.min_lba) / l);
            graphics.setColor(todLba.color);
            graphics.fillRect(n5, n4, this.dot_size, this.dot_size);
            ++n3;
        }
        if (bl) {
            common.ptod("pixels: " + n3);
        }
    }

    public static synchronized void openTrace() {
        if (!Validate.showLba()) {
            return;
        }
        if (fake_trace == null) {
            fake_trace = new Fput(SlaveJvm.getSlaveLabel() + ".showlba.txt");
            trace_start = System.currentTimeMillis();
        }
    }

    public static synchronized void closeTrace() {
        if (fake_trace != null) {
            fake_trace.close();
            fake_trace = null;
        }
    }

    public static synchronized void writeRecord(Cmd_entry cmd_entry) {
        fake_trace.println("%s %s %d %d %d", !Validate.sdConcatenation() ? cmd_entry.sd_ptr.sd_name : cmd_entry.concat_sd.sd_name, cmd_entry.cmd_wg.wd_name, cmd_entry.cmd_read_flag ? 1 : 0, !Validate.sdConcatenation() ? cmd_entry.cmd_lba : cmd_entry.concat_lba, System.currentTimeMillis() - trace_start);
    }

    public static void savePanel(ShowLba showLba, String string, Dimension dimension) {
        if (string != null && !string.endsWith(".png")) {
            string = string + ".png";
        }
        try {
            showLba.setSize(dimension);
            showLba.validate();
            BufferedImage bufferedImage = new BufferedImage(showLba.getWidth(), showLba.getHeight(), 1);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            try {
                showLba.paint(graphics2D);
            }
            catch (Exception exception) {
                common.ptod(exception);
                common.failure(exception);
            }
            boolean bl = ImageIO.write((RenderedImage)bufferedImage, "png", new File(string));
        }
        catch (Exception exception) {
            common.failure(exception);
        }
    }

    class TodLba {
        Color color;
        String sd;
        String wd;
        boolean read_flag;
        long tod;
        long lba;

        TodLba() {
        }
    }
}

