/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Vdb.common;
import java.io.Serializable;

public class Signal
implements Serializable {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";
    private long base = 0L;
    private long msecs = 0L;
    private int secs = 0;
    private int signals_given = 0;
    private long signal_started = 0L;

    public Signal(int n) {
        this.secs = n;
        this.msecs = n * 1000;
        this.signal_started = System.currentTimeMillis();
    }

    public boolean go() {
        long l = System.currentTimeMillis();
        if (this.base == 0L) {
            this.base = l;
            return false;
        }
        if (this.base + this.msecs < l) {
            this.base = l;
            ++this.signals_given;
            return true;
        }
        return false;
    }

    public boolean anySignals() {
        return this.signals_given != 0;
    }

    public int getDuration() {
        return this.secs;
    }

    public int getAge() {
        return (int)(System.currentTimeMillis() - this.signal_started) / 1000;
    }

    public static void main(String[] stringArray) {
        Signal signal = new Signal(5);
        for (int i = 0; i < 20; ++i) {
            common.sleep_some_usecs(1000000L);
            if (!signal.go()) continue;
            common.where();
        }
    }
}

