/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import User.ControlUsers;
import User.UserData;
import Utils.Getopt;
import Utils.Semaphore;
import Vdb.Adm_msgs;
import Vdb.CollectSlaveStats;
import Vdb.CpuStats;
import Vdb.Fifo;
import Vdb.GcTracker;
import Vdb.HeartBeat;
import Vdb.InfoFromHost;
import Vdb.Jnl_entry;
import Vdb.MapFile;
import Vdb.Mount;
import Vdb.Native;
import Vdb.NfsStats;
import Vdb.NwStats;
import Vdb.Shutdown;
import Vdb.SlaveList;
import Vdb.SlaveSocket;
import Vdb.SlaveStats;
import Vdb.SlaveWorker;
import Vdb.SocketMessage;
import Vdb.ThreadMonitor;
import Vdb.Work;
import Vdb.common;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.Vector;

public class SlaveJvm {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";
    private static String master_ip = null;
    private static String slave_name = null;
    private static String slave_label = null;
    private static boolean first_slave_on_host = false;
    private static boolean master_aborting;
    private static Semaphore wait_to_run;
    private static SlaveSocket socket_to_master;
    private static Semaphore workload_done_semaphore;
    private static Semaphore master_done_semaphore;
    private static boolean workload_done;
    private static boolean stopping_work;
    private static boolean fwd_workload;
    private static boolean this_is_an_active_slave;
    private static boolean error_with_kstat;
    private static Mount rd_mount;
    private static String master_abort_msg;
    private static int owner_id;
    private static int master_pid;

    public static boolean isThisSlave() {
        return this_is_an_active_slave;
    }

    public static boolean isFirstSlaveOnHost() {
        return first_slave_on_host;
    }

    public static void setKstatError() {
        error_with_kstat = true;
    }

    public static boolean getKstatError() {
        return error_with_kstat;
    }

    private static void connectToMaster() {
        int n = 60;
        try {
            socket_to_master = new SlaveSocket(master_ip, SlaveSocket.getMasterPort());
            socket_to_master.setSlaveLabel(slave_label);
            socket_to_master.setSlaveName(slave_name);
            socket_to_master.getSocket().setSoTimeout(n * 1000);
            common.ptod("successfully connected to master " + master_ip);
        }
        catch (ConnectException connectException) {
            common.ptod(connectException);
            common.ptod("Slave ConnectException. ");
            common.failure("It took at least " + n + " seconds to connect. SlaveJvm terminated");
        }
        catch (UnknownHostException unknownHostException) {
            common.failure(unknownHostException);
        }
        catch (IOException iOException) {
            common.failure(iOException);
        }
        common.ptod("Connection to " + master_ip + " using port " + SlaveSocket.getMasterPort() + " successful");
    }

    public static SlaveSocket getMasterSocket() {
        return socket_to_master;
    }

    public static void sendMessageToConsole(String string, Object ... objectArray) {
        SlaveJvm.sendMessageToConsole(String.format(string, objectArray));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendMessageToConsole(Object object) {
        if (!(object instanceof String)) {
            Object object2 = common.ptod_lock;
            synchronized (object2) {
                Vector vector = (Vector)object;
                for (int i = 0; i < vector.size(); ++i) {
                    common.plog("sendMessageToConsole: " + vector.elementAt(i));
                }
            }
        }
        SlaveJvm.sendMessageToMaster(SocketMessage.CONSOLE_MESSAGE, object);
    }

    public static void sendMessageToSummary(String string, Object ... objectArray) {
        SocketMessage socketMessage = new SocketMessage(SocketMessage.SUMMARY_MESSAGE);
        socketMessage.setData(String.format(string, objectArray));
        socket_to_master.putMessage(socketMessage);
    }

    public static void sendMessageToMaster(int n) {
        SlaveJvm.sendMessageToMaster(n, null);
    }

    public static void sendMessageToMaster(int n, Object object) {
        SocketMessage socketMessage = new SocketMessage(n);
        socketMessage.setData(object);
        if (socket_to_master == null) {
            common.ptod("Trying to send message '%s' to master, but we have no socket yet: ", (String)object);
            common.failure("Missing socket");
        }
        socket_to_master.putMessage(socketMessage);
    }

    private static void getMessagesFromMaster() {
        while (true) {
            Object object;
            SocketMessage socketMessage = socket_to_master.getMessage();
            GcTracker.report();
            if (socketMessage.getMessageNum() == SocketMessage.WORK_TO_SLAVE) {
                new SlaveWorker((Work)socketMessage.getData()).start();
                continue;
            }
            if (socketMessage.getMessageNum() == SocketMessage.REQUEST_SLAVE_STATISTICS) {
                object = (long[])socketMessage.getData();
                long l = object[0];
                boolean bl = object[1] != 0L;
                boolean bl2 = object[2] != 0L;
                Fifo.printFifoStatuses();
                if (ThreadMonitor.active()) {
                    ThreadMonitor.reportAllDetail(ThreadMonitor.getAllData());
                    ThreadMonitor.saveAllPrevious();
                }
                Vector vector = ControlUsers.getIntervalDataForMaster();
                if (common.get_debug(common.HOLD_UP_STATISTICS) && l % 5L == 0L) {
                    common.sleep_some(3000L);
                }
                SlaveStats slaveStats = CollectSlaveStats.getStatsForMaster(l, bl, bl2);
                slaveStats.setUserData(vector);
                socketMessage = new SocketMessage(SocketMessage.SLAVE_STATISTICS, slaveStats);
                socket_to_master.putMessage(socketMessage);
                if (!common.get_debug(common.PRINT_MEMORY)) continue;
                common.memory_usage();
                Native.printMemoryUsage();
                continue;
            }
            if (socketMessage.getMessageNum() == SocketMessage.USER_DATA_TO_SLAVES) {
                ControlUsers.receivedIntervalDataFromMaster((UserData[])socketMessage.getData());
                continue;
            }
            if (socketMessage.getMessageNum() == SocketMessage.GET_LUN_INFO_FROM_SLAVE) {
                object = (InfoFromHost)socketMessage.getData();
                InfoFromHost.getInfoForMaster((InfoFromHost)object);
                if (!object.validate) continue;
                MapFile.cleanupOrphanMapFiles();
                continue;
            }
            if (socketMessage.getMessageNum() == SocketMessage.SLAVE_GO) {
                if (SlaveWorker.work == null) {
                    common.failure("Received 'SLAVE_GO' message without first receiving Work");
                }
                if (ThreadMonitor.active()) {
                    ThreadMonitor.getAllData();
                    ThreadMonitor.saveAllPrevious();
                }
                wait_to_run.release();
                if (!common.onSolaris() && !common.onWindows() || !SlaveJvm.isFirstSlaveOnHost()) continue;
                CpuStats.getNativeCpuStats();
                CollectSlaveStats.getAllKstatData();
                if (common.onSolaris()) {
                    NfsStats.getAllNfsDeltasFromKstat();
                }
                if (!SlaveWorker.work.nw_monitor_now) continue;
                NwStats.loadStatistics();
                continue;
            }
            if (socketMessage.getMessageNum() == SocketMessage.WORKLOAD_DONE) {
                SlaveJvm.setWorkloadDone(true);
                SlaveJvm.setMasterDone();
                Fifo.printQueues();
                continue;
            }
            if (socketMessage.getMessageNum() == SocketMessage.CLEAN_SHUTDOWN_SLAVE) break;
            if (socketMessage.getMessageNum() == SocketMessage.MASTER_ABORTING) {
                master_aborting = true;
                common.failure(master_abort_msg);
                continue;
            }
            if (socketMessage.getMessageNum() == SocketMessage.HEARTBEAT_MESSAGE) {
                SlaveJvm.sendMessageToMaster(SocketMessage.HEARTBEAT_MESSAGE);
                continue;
            }
            if (socketMessage.getMessageNum() == SocketMessage.STOP_NEW_IO) {
                SlaveJvm.stopWork();
                continue;
            }
            common.failure("Unknown socket message: " + socketMessage.getMessageText());
        }
        common.ptod("Master is requesting slave shutdown");
    }

    private static void scan_args(String[] stringArray) {
        Getopt getopt = new Getopt(stringArray, "p:m:l:d:n:", 1);
        if (!getopt.isOK()) {
            common.failure("Parameter scan error");
        }
        getopt.print("SlaveJvm");
        master_ip = getopt.get_string('m');
        slave_label = getopt.get_string('l');
        slave_name = getopt.get_string('n');
        first_slave_on_host = slave_label.endsWith("-0");
        SlaveSocket.setMasterPort(Integer.parseInt(getopt.get_string('p')));
        Thread.currentThread().setName(slave_label);
    }

    private static void signonToMaster() {
        SocketMessage socketMessage = socket_to_master.getMessage();
        if (socketMessage.getMessageNum() == SocketMessage.SEND_SIGNON_INFO_TO_MASTER) {
            String[] stringArray = new String[SocketMessage.SIGNON_INFO_SIZE];
            stringArray[0] = master_ip;
            stringArray[1] = slave_name;
            stringArray[2] = System.getProperty("os.name");
            stringArray[3] = System.getProperty("os.arch");
            stringArray[4] = "" + common.getProcessId();
            stringArray[5] = "" + System.currentTimeMillis();
            socketMessage.setData(stringArray);
            socket_to_master.putMessage(socketMessage);
        } else {
            common.failure("Unexpected message number during signon: " + socketMessage.getMessageNum());
        }
        socketMessage = socket_to_master.getMessage();
        if (socketMessage.getMessageNum() == SocketMessage.KILL_SLAVE_SIGNON_ERROR) {
            common.failure("Signon to master failed");
        }
        if (socketMessage.getMessageNum() != SocketMessage.SEND_SIGNON_SUCCESSFUL) {
            common.failure("Unexpected message number during signon: " + socketMessage.getMessageNum());
        }
        owner_id = master_pid = ((Integer)socketMessage.getData()).intValue();
        socket_to_master.putMessage(socketMessage);
    }

    public static void main(String[] stringArray) {
        Shutdown.activateShutdownHook();
        this_is_an_active_slave = true;
        for (String string : stringArray) {
            if (!string.equals("-d100")) continue;
            common.set_debug(common.USE_TMP_SHARED_LIBRARY);
        }
        try {
            Thread.currentThread().setPriority(10);
            SlaveJvm.scan_args(stringArray);
            Native.allocSharedMemory();
            if (SlaveList.getSlaveCount() == 0) {
                common.log_html = common.stdout = new PrintWriter(System.out, true);
            }
            SlaveJvm.connectToMaster();
            SlaveJvm.signonToMaster();
            new HeartBeat(false).start();
            SlaveJvm.getMessagesFromMaster();
            common.memory_usage();
            if (first_slave_on_host) {
                Adm_msgs.copy_varadmmsgs();
            }
        }
        catch (Throwable throwable) {
            common.abnormal_term(throwable);
        }
        Jnl_entry.closeAllMaps();
        SlaveJvm.sendMessageToMaster(SocketMessage.CLEAN_SHUTDOWN_COMPLETE);
        if (common.onWindows() && System.getProperty("os.name").contains("2008")) {
            common.ptod("This is Windows 2008. Sleeping five seconds before terminating slave.");
            common.sleep_some(5000L);
        } else {
            common.sleep_some(500L);
        }
        common.exit(0);
    }

    public static void waitToGo() {
        try {
            SlaveJvm.sendMessageToMaster(SocketMessage.SLAVE_READY_TO_GO);
            wait_to_run.acquire();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void waitForMasterDone() {
        try {
            master_done_semaphore.acquire();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void setMasterDone() {
        master_done_semaphore.release();
    }

    public static void setMount(Mount mount) {
        rd_mount = mount;
    }

    public static Mount getMount() {
        return rd_mount;
    }

    public static synchronized void setOwnerId(int n) {
        if (owner_id == master_pid) {
            owner_id = n;
            SlaveJvm.sendMessageToMaster(SocketMessage.ONE_TIME_STATUS, "Data Validation Owner ID found in journal: " + n);
            return;
        }
        if (n != owner_id) {
            common.ptod("Current master process id:      " + master_pid);
            common.ptod("Current owner id:               " + owner_id);
            common.ptod("Second request to set owner id: " + n);
            common.failure("Owner ID not in sync, are we mixing up journal files?");
        }
    }

    public static int getOwnerId() {
        return owner_id;
    }

    public static synchronized void stopWork() {
        if (!stopping_work) {
            stopping_work = true;
            SlaveJvm.sendMessageToMaster(SocketMessage.STOP_NEW_IO);
        }
    }

    public static boolean stoppingWork() {
        return stopping_work;
    }

    public static boolean isWorkloadDone() {
        return workload_done;
    }

    public static void setWorkloadDone(boolean bl) {
        workload_done = bl;
        if (workload_done) {
            workload_done_semaphore.release();
        } else {
            workload_done_semaphore = new Semaphore(0L);
        }
    }

    public static void waitForWorkloadDone() {
        try {
            workload_done_semaphore.acquire();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void setWdWorkload(boolean bl) {
        fwd_workload = bl;
    }

    public static boolean isWdWorkload() {
        if (!SlaveJvm.isThisSlave()) {
            common.failure("'isWdWorkload' for SlaveJvm requested on master");
        }
        return fwd_workload;
    }

    public static boolean isFwdWorkload() {
        if (!SlaveJvm.isThisSlave()) {
            common.failure("'isFwdWorkload' for SlaveJvm requested on master");
        }
        return !fwd_workload;
    }

    public static String getMasterAbortMessage() {
        return master_abort_msg;
    }

    public static String getSlaveLabel() {
        return slave_label;
    }

    public static String getSlaveName() {
        return slave_name;
    }

    static {
        wait_to_run = new Semaphore(0L);
        workload_done_semaphore = new Semaphore(0L);
        master_done_semaphore = new Semaphore(0L);
        stopping_work = false;
        fwd_workload = false;
        this_is_an_active_slave = false;
        error_with_kstat = false;
        master_abort_msg = "Master is aborting. Slave now also terminating";
        owner_id = 1297107268;
        master_pid = 1297107268;
    }
}

