/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Utils.NfsV3;
import Utils.NfsV4;
import Vdb.Blocked;
import Vdb.FwdStats;
import Vdb.Kstat_cpu;
import Vdb.NwAdapter;
import Vdb.SdStats;
import Vdb.Slave;
import Vdb.SlaveJvm;
import Vdb.ThreadMonList;
import Vdb.common;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;

public class SlaveStats
implements Serializable {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";
    private long stats_number = 0L;
    private SdStats[] sd_stats = null;
    private FwdStats tot_stats = null;
    private HashMap fsd_map = null;
    private HashMap fwg_map = null;
    private Kstat_cpu cpu_stats = null;
    private Vector user_data = null;
    public transient Slave owning_slave;
    private Vector kstat_data = null;
    private long[] block_counters = null;
    private NfsV3 nfs3_delta = null;
    private NfsV4 nfs4_delta = null;
    public ArrayList<NwAdapter> nw_stats = null;
    public ThreadMonList tmonitor_deltas = new ThreadMonList();
    public long permit_time = 0L;
    public long permit_threads = 0L;

    public SlaveStats(long l) {
        this.stats_number = l;
        this.block_counters = Blocked.getCounters();
        if (SlaveJvm.isThisSlave() && common.get_debug(common.PRINT_BLOCK_COUNTERS)) {
            Blocked.printCountersToLog();
        }
    }

    public void setCpuStats(Kstat_cpu kstat_cpu) {
        this.cpu_stats = kstat_cpu;
    }

    public Kstat_cpu getCpuStats() {
        return this.cpu_stats;
    }

    public void setSdStats(SdStats[] sdStatsArray) {
        this.sd_stats = sdStatsArray;
    }

    public SdStats[] getSdStats() {
        return this.sd_stats;
    }

    public long[] getBlockCounters() {
        return this.block_counters;
    }

    public long getNumber() {
        return this.stats_number;
    }

    public void setSlaveIntervalStats(FwdStats fwdStats, HashMap hashMap, HashMap hashMap2) {
        this.tot_stats = fwdStats;
        this.fsd_map = hashMap;
        this.fwg_map = hashMap2;
    }

    public FwdStats getSlaveIntervalStats() {
        return this.tot_stats;
    }

    public HashMap getFsdMap() {
        return this.fsd_map;
    }

    public HashMap<String, FwdStats> getFwdMap() {
        return this.fwg_map;
    }

    public void setKstatData(Vector vector) {
        this.kstat_data = vector;
    }

    public Vector getKstatData() {
        return this.kstat_data;
    }

    public void setNfsData(NfsV3 nfsV3, NfsV4 nfsV4) {
        this.nfs3_delta = nfsV3;
        this.nfs4_delta = nfsV4;
    }

    public NfsV3 getNfs3() {
        return this.nfs3_delta;
    }

    public NfsV4 getNfs4() {
        return this.nfs4_delta;
    }

    public void setUserData(Vector vector) {
        this.user_data = vector;
    }

    public Vector getUserData() {
        return this.user_data;
    }

    public void setThreadMonData(ThreadMonList threadMonList) {
        this.tmonitor_deltas = threadMonList;
    }

    public void printit() {
        common.ptod("stats_number: " + this.stats_number);
        common.ptod("sd_stats:     " + this.sd_stats);
        common.ptod("fwd_stats:    " + this.tot_stats);
        common.ptod("cpu_stats:    " + this.cpu_stats);
        common.ptod("kstat_data:   " + this.kstat_data);
        common.ptod("nfs3_delta:   " + this.nfs3_delta);
        common.ptod("nfs4_delta:   " + this.nfs4_delta);
    }
}

