/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import User.UserDeviceInfo;
import Utils.OS_cmd;
import Vdb.Adm_msgs;
import Vdb.Blocked;
import Vdb.BucketRanges;
import Vdb.Cmd_entry;
import Vdb.ControlFile;
import Vdb.DV_map;
import Vdb.Dedup;
import Vdb.ErrorLog;
import Vdb.FwgEntry;
import Vdb.FwgRun;
import Vdb.FwgWaiter;
import Vdb.IO_task;
import Vdb.InstancePointer;
import Vdb.JniIndex;
import Vdb.Jnl_entry;
import Vdb.MiscParms;
import Vdb.Native;
import Vdb.NwStats;
import Vdb.Operations;
import Vdb.Patterns;
import Vdb.ReplayInfo;
import Vdb.SD_entry;
import Vdb.ShowLba;
import Vdb.SlaveJvm;
import Vdb.SocketMessage;
import Vdb.Task_num;
import Vdb.ThreadControl;
import Vdb.ThreadMonitor;
import Vdb.Validate;
import Vdb.WG_context;
import Vdb.WG_entry;
import Vdb.WT_task;
import Vdb.Work;
import Vdb.common;
import java.util.Vector;

public class SlaveWorker
extends ThreadControl {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";
    public static Work work;
    public static Vector<SD_entry> sd_list;
    private static Adm_msgs adm_message_scanner;
    private static Vector<IO_task> list_of_io_tasks;
    public static long first_tod;

    public SlaveWorker(Work work) {
        SlaveWorker.work = work;
        BucketRanges.setBucketTypes(SlaveWorker.work.bucket_types);
        this.setName("SlaveWorker");
        ThreadMonitor.clear();
        SlaveJvm.setWdWorkload(SlaveWorker.work.wgs_for_slave != null);
        Validate.storeOptions(SlaveWorker.work.validate_options);
        Patterns.storeOptions(SlaveWorker.work.pattern_options);
        if (SlaveJvm.isWdWorkload()) {
            sd_list = SlaveWorker.work.convertWgListToSdList();
            ReplayInfo.setInfo(SlaveWorker.work.replay_info);
        }
        MiscParms.setMiscellaneous(SlaveWorker.work.miscellaneous);
        Adm_msgs.parseMessageOptions();
        if (Adm_msgs.scanMessages()) {
            if (SlaveJvm.isFirstSlaveOnHost() && common.onSolaris() && adm_message_scanner == null) {
                adm_message_scanner = new Adm_msgs();
                adm_message_scanner.start();
            } else if (SlaveJvm.isFirstSlaveOnHost() && common.onLinux() && adm_message_scanner == null) {
                adm_message_scanner = new Adm_msgs();
                adm_message_scanner.start();
            }
        }
    }

    public static boolean isAdmRunning() {
        return adm_message_scanner != null;
    }

    public static boolean sharedThreads() {
        return Validate.sdConcatenation() && SlaveWorker.work.threads_from_rd != 0;
    }

    @Override
    public void run() {
        common.ptod("Beginning of run setup");
        common.ptod("**********************\n\n");
        try {
            for (int i = 0; SlaveWorker.work.fwgs_for_slave != null && i < SlaveWorker.work.fwgs_for_slave.size(); ++i) {
                FwgEntry fwgEntry = SlaveWorker.work.fwgs_for_slave.elementAt(i);
            }
            this.setIndependent();
            Thread thread = Thread.currentThread();
            Thread.currentThread();
            thread.setPriority(1);
            SlaveJvm.setWorkloadDone(false);
            if (SlaveJvm.isFirstSlaveOnHost()) {
                SlaveWorker.work.rd_start_command.run_command();
            }
            if (SlaveJvm.isFirstSlaveOnHost() && SlaveWorker.work.nw_monitor_needed) {
                NwStats.getAdapters();
            }
            if (SlaveWorker.work.rd_mount != null && SlaveJvm.getMount() != null) {
                SlaveJvm.getMount().mountIfNeeded(SlaveWorker.work.rd_mount);
            }
            if (SlaveWorker.work.instance_pointers != null && !common.get_debug(common.NO_KSTAT)) {
                InstancePointer.rebuildNativePointers(SlaveWorker.work.instance_pointers);
            }
            if (SlaveWorker.work.wgs_for_slave != null) {
                this.doRegularWorkload();
            } else {
                this.doFileSystemWorkload();
            }
            common.memory_usage();
            Native.printMemoryUsage();
            SlaveJvm.sendMessageToMaster(SocketMessage.SLAVE_WORK_COMPLETED);
            SlaveJvm.waitForMasterDone();
            if (SlaveWorker.work.wgs_for_slave == null) {
                ControlFile.writeAllControlFiles();
            }
            if (SlaveJvm.isFirstSlaveOnHost()) {
                SlaveWorker.work.rd_end_command.run_command();
            }
            SlaveJvm.sendMessageToMaster(SocketMessage.READY_FOR_MORE_WORK);
            common.ptod("End of run");
            common.ptod("**********\n\n");
            this.removeIndependent();
        }
        catch (Throwable throwable) {
            common.abnormal_term(throwable);
        }
    }

    public void doRegularWorkload() {
        JniIndex.createIndexes(work);
        WG_entry.overrideOpenflags(SlaveWorker.work.wgs_for_slave);
        Cmd_entry.cmd_create_pool();
        if (Validate.isRealValidate()) {
            Jnl_entry.recoverSDJournalsIfNeeded(sd_list);
        }
        if (Validate.isValidate()) {
            DV_map.allocateSDMaps(sd_list);
            if (Validate.isDedup()) {
                Dedup.slaveLevelSetup(sd_list);
            }
        }
        WG_entry.alloc_fifos(work);
        SD_entry.openAllSds();
        if (!SlaveWorker.work.work_rd_name.startsWith(Jnl_entry.RECOVERY_RUN_NAME)) {
            Jnl_entry.dumpAllMaps(false);
        }
        WG_context.setup_jni_context(SlaveWorker.work.wgs_for_slave);
        UserDeviceInfo.clearDeviceList();
        WG_entry.wg_start_sun_tasks(SlaveWorker.work.wgs_for_slave);
        if (SlaveWorker.work.use_waiter) {
            new WT_task(new Task_num("WT_task")).start();
        }
        Patterns.createPattern(SlaveWorker.work.maximum_xfersize);
        SlaveWorker.StartIoThreads(work);
        Task_num.task_wait_start_complete();
        if (common.onSolaris()) {
            SlaveWorker.bindCpus();
        }
        SlaveJvm.waitToGo();
        if (Validate.showLba()) {
            ShowLba.openTrace();
        }
        Task_num.task_run_all();
        SlaveJvm.waitForWorkloadDone();
        Task_num.interrupt_tasks("WG_task");
        Task_num.interrupt_tasks("WT_task");
        SlaveWorker.sendInterrupts();
        int n = Task_num.task_wait_all();
        if (n > 0) {
            ErrorLog.countErrorsOnSlave(n > 1 ? n : 2);
            common.sleep_some(10000L);
            common.failure("Shutdown took more than " + n + " seconds; Run aborted");
        }
        Task_num.task_list_clear();
        SD_entry.closeAllSds();
        if (Validate.showLba()) {
            ShowLba.closeTrace();
        }
        if (Validate.isValidate()) {
            DV_map.dv_set_all_unbusy(sd_list);
        }
        if (Validate.isRealValidate()) {
            Jnl_entry.dumpAllMaps(true);
            DV_map.printCounters();
        }
        if (Dedup.isDedup()) {
            Dedup.reportAllSdCounters();
        }
        WG_entry.free_fifos(work);
    }

    public void doFileSystemWorkload() {
        Native.allocSharedMemory();
        Patterns.createPattern(SlaveWorker.work.maximum_xfersize);
        FwgRun.startFwg(work);
        Task_num.task_wait_start_complete();
        SlaveJvm.waitToGo();
        Task_num.task_run_all();
        SlaveJvm.waitForWorkloadDone();
        Task_num.interrupt_tasks("FwgWaiter");
        int n = Task_num.task_wait_all();
        if (n > 0) {
            ErrorLog.countErrorsOnSlave(n > 1 ? n : 2);
            common.sleep_some(10000L);
            common.failure("Shutdown took more than " + n + " seconds; Run aborted");
        }
        Task_num.task_list_clear();
        if (!DV_map.anyBadSectorsFound()) {
            Jnl_entry.dumpAllMaps(true);
        }
        Blocked.printCountersToLog();
        DV_map.printCounters();
        FwgWaiter.clearStuff();
        if (Dedup.isDedup()) {
            Dedup.reportAllFsdCounters();
        }
        FwgRun.endOfRun(work);
    }

    static void StartIoThreads(Work work) {
        if (SlaveWorker.sharedThreads()) {
            SlaveWorker.startSharedThreads(work);
        } else {
            SlaveWorker.startSdThreads(work);
        }
    }

    private static void startSdThreads(Work work) {
        list_of_io_tasks.removeAllElements();
        for (int i = 0; i < sd_list.size(); ++i) {
            SD_entry sD_entry = sd_list.elementAt(i);
            int n = 0;
            for (int j = 0; j < work.getThreadsForSlave(sD_entry.sd_name); ++j) {
                Task_num task_num = new Task_num("IO_task " + sD_entry.lun);
                IO_task iO_task = new IO_task(task_num, sD_entry);
                list_of_io_tasks.add(iO_task);
                iO_task.setStreamContext(work.getStreamForSlave(sD_entry.sd_name, j), j);
                iO_task.start();
                ++n;
                int n2 = 32;
                if (i % n2 != n2 - 1) continue;
                common.sleep_some(10L);
            }
            common.ptod("Started %2d i/o threads for %s", n, sD_entry.sd_name);
        }
        common.plog("Started a total of %2d i/o threads.", list_of_io_tasks.size());
    }

    private static void startSharedThreads(Work work) {
        list_of_io_tasks.removeAllElements();
        for (int i = 0; i < work.threads_from_rd; ++i) {
            Task_num task_num = new Task_num("IO_task shared thread " + i);
            IO_task iO_task = new IO_task(task_num, WG_entry.getSharedFifo(), work.maximum_xfersize);
            list_of_io_tasks.add(iO_task);
            iO_task.start();
            int n = 32;
            if (i % n != n - 1) continue;
            common.sleep_some(10L);
        }
        common.plog("Started a total of " + list_of_io_tasks.size() + " shared i/o threads");
    }

    private static void sendInterrupts() {
        int n = 0;
        for (int i = 0; i < list_of_io_tasks.size(); ++i) {
            IO_task iO_task = list_of_io_tasks.elementAt(i);
            if (iO_task.getActiveCount() != 0) continue;
            common.interruptThread(iO_task);
            ++n;
        }
        common.ptod("Sent %d interrupts to %d waiting IO_task threads", n, list_of_io_tasks.size());
    }

    public static int getSequentialCount() {
        return SlaveWorker.work.sequential_files;
    }

    public static void setSequentialCount(int n) {
        SlaveWorker.work.sequential_files = n;
    }

    public static SD_entry findSd(String string) {
        for (int i = 0; i < sd_list.size(); ++i) {
            SD_entry sD_entry = sd_list.elementAt(i);
            if (!sD_entry.sd_name.equals(string)) continue;
            return sD_entry;
        }
        common.failure("Unable to find sd=" + string);
        return null;
    }

    public static boolean canWeExpectFileDeletes() {
        if (SlaveWorker.work.format_run) {
            return false;
        }
        Vector<FwgEntry> vector = SlaveWorker.work.fwgs_for_slave;
        for (int i = 0; i < vector.size(); ++i) {
            FwgEntry fwgEntry = vector.elementAt(i);
            if (fwgEntry.getOperation() != Operations.DELETE) continue;
            return true;
        }
        return false;
    }

    public static boolean canWeExpectFileCreates() {
        Vector<FwgEntry> vector = SlaveWorker.work.fwgs_for_slave;
        for (int i = 0; i < vector.size(); ++i) {
            FwgEntry fwgEntry = vector.elementAt(i);
            if (fwgEntry.getOperation() != Operations.CREATE) continue;
            return true;
        }
        return false;
    }

    public static boolean canWeExpectDirectoryCreates() {
        Vector<FwgEntry> vector = SlaveWorker.work.fwgs_for_slave;
        for (int i = 0; i < vector.size(); ++i) {
            FwgEntry fwgEntry = vector.elementAt(i);
            if (fwgEntry.getOperation() != Operations.MKDIR && !SlaveWorker.work.format_run) continue;
            return true;
        }
        return false;
    }

    public static boolean canWeExpectDirectoryDeletes() {
        if (SlaveWorker.work.format_run) {
            return false;
        }
        Vector<FwgEntry> vector = SlaveWorker.work.fwgs_for_slave;
        for (int i = 0; i < vector.size(); ++i) {
            FwgEntry fwgEntry = vector.elementAt(i);
            if (fwgEntry.getOperation() != Operations.RMDIR || fwgEntry.getShutdown()) continue;
            return true;
        }
        return false;
    }

    public static int obsolete_getDataValidationXfersize() {
        Vector<FwgEntry> vector = SlaveWorker.work.fwgs_for_slave;
        for (int i = 0; i < vector.size(); ++i) {
            FwgEntry fwgEntry = vector.elementAt(i);
            if (fwgEntry.xfersizes.length == 1) continue;
            String string = "Data Validation allows only one fixed xfersize";
            SlaveJvm.sendMessageToConsole(string);
            common.failure(string);
        }
        double d = -1.0;
        for (int i = 0; i < vector.size(); ++i) {
            FwgEntry fwgEntry = vector.elementAt(i);
            if (d == -1.0) {
                d = fwgEntry.xfersizes[0];
                continue;
            }
            if (fwgEntry.xfersizes[0] == d) continue;
            String string = "Data Validation allows only one fixed xfersize";
            SlaveJvm.sendMessageToConsole(string);
            common.failure(string);
        }
        return (int)d;
    }

    private static void bindCpus() {
        int[] nArray = Validate.getPsrset();
        if (nArray.length == 0) {
            return;
        }
        for (int i = 1; i < 10; ++i) {
            OS_cmd oS_cmd = new OS_cmd();
            oS_cmd.addText(String.format("/usr/sbin/psrset -d %d", i));
            oS_cmd.execute();
            oS_cmd.printStdout();
        }
        String string = "";
        for (int i = 0; i < nArray.length; ++i) {
            string = string + nArray[i] + " ";
        }
        OS_cmd oS_cmd = new OS_cmd();
        oS_cmd.addText("/usr/sbin/psrset -c " + string);
        oS_cmd.execute();
        oS_cmd.printStderr();
        oS_cmd.printStdout();
        if (oS_cmd.getStderr().length > 0) {
            common.failure("'%s' failed", oS_cmd.getCmd());
        }
        String string2 = "";
        int n = 0;
        for (int i = 0; i < list_of_io_tasks.size(); ++i) {
            IO_task iO_task = list_of_io_tasks.elementAt(i);
            string2 = string2 + (int)iO_task.getPids() + ",";
            n = (int)(iO_task.getPids() >> 32);
        }
        oS_cmd = new OS_cmd();
        oS_cmd.addText("/usr/sbin/psrset -b 1 " + n + "/" + string2);
        oS_cmd.execute();
        oS_cmd.printStderr();
        oS_cmd.printStdout();
        if (oS_cmd.getStderr().length > 0) {
            common.failure("'%s' failed", oS_cmd.getCmd());
        }
    }

    static {
        adm_message_scanner = null;
        list_of_io_tasks = new Vector(63, 0);
    }
}

