/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Vdb.Cmd_entry;
import Vdb.FileAnchor;
import Vdb.SD_entry;
import Vdb.common;
import java.io.Serializable;

class StreamContext
implements Serializable {
    private static final String c = "Copyright (c) 2000, 2013, Oracle and/or its affiliates. All rights reserved.";
    private String sd_name = null;
    private long low_lba = 0L;
    private long next_lba = -1L;
    private long high_lba = 0L;
    private long stream_size = 0L;
    private int which_context = 0;

    public StreamContext(SD_entry sD_entry, int n, int n2) {
        this.stream_size = sD_entry.end_lba / (long)n;
        this.stream_size -= this.stream_size % (long)sD_entry.getMaxSdXfersize();
        int n3 = sD_entry.canWeUseBlockZero() ? 0 : sD_entry.getMaxSdXfersize();
        this.low_lba = this.stream_size * (long)n2 + (long)n3;
        this.high_lba = this.low_lba + this.stream_size - (long)n3;
        this.next_lba = -1L;
        this.which_context = n2;
        this.sd_name = sD_entry.sd_name;
        if (this.high_lba > sD_entry.end_lba) {
            common.ptod("stream_count: " + n);
            common.ptod("streamno:     " + n2);
            common.ptod("sd.end_lba:   " + sD_entry.end_lba);
            common.ptod("high_lba:     " + this.high_lba);
            common.failure("Invalid StreamContext values");
        }
    }

    public String toString() {
        String string = String.format("stream=%d: sd=%s; low: %8s; high: %8s size: %8s", this.which_context, this.sd_name, FileAnchor.whatSize(this.low_lba), FileAnchor.whatSize(this.high_lba), FileAnchor.whatSize(this.stream_size));
        return string;
    }

    public synchronized long getNextSequentialLba(Cmd_entry cmd_entry) {
        long l;
        if (this.next_lba < 0L) {
            this.next_lba = this.low_lba;
            if (!cmd_entry.cmd_wg.seek_start0) {
                l = (this.high_lba - this.low_lba) / cmd_entry.cmd_xfersize;
                double d = cmd_entry.cmd_wg.seek_randomizer.nextDouble();
                long l2 = (long)(d * (double)l);
                this.next_lba = l2 * cmd_entry.cmd_xfersize;
            }
        }
        if (this.next_lba + cmd_entry.cmd_xfersize > this.high_lba) {
            if (cmd_entry.cmd_wg.seekpct < 0.0) {
                return -1L;
            }
            this.next_lba = this.low_lba;
        }
        l = this.next_lba;
        this.next_lba += cmd_entry.cmd_xfersize;
        return l;
    }
}

