/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Utils.CommandOutput;
import Utils.Fget;
import Utils.Format;
import Utils.Fput;
import Utils.OS_cmd;
import Vdb.Report;
import Vdb.Tnfe_data;
import Vdb.Vdbmain;
import Vdb.common;
import Vdb.reporting;
import java.io.File;

public class SwatCharts {
    private static final String c = "Copyright (c) 2000, 2012, Oracle and/or its affiliates. All rights reserved.";
    private String where_is_swat;
    private String which_charts;
    private String chart_directory;
    private String index;
    private static SwatCharts charts = null;
    private static boolean debug = false;

    public SwatCharts(String string, String string2) {
        this.where_is_swat = string;
        this.which_charts = string2;
        charts = this;
        if (!new File(this.which_charts).exists()) {
            common.failure("SwatCharts: file does not exist: " + this.which_charts);
        }
        if (!debug) {
            this.chart_directory = reporting.rep_mkdir(Vdbmain.output_dir + File.separator + "charts");
            this.index = this.chart_directory + File.separator + "index.html";
            Report.getSummaryReport().println(Format.f("%-32s", "Link to Swat charts") + " <A HREF=\"" + "charts/index.html" + "\">charts</A>");
        }
    }

    public static SwatCharts getCharts() {
        return charts;
    }

    public static void createCharts() {
        int n;
        if (charts == null) {
            return;
        }
        Tnfe_data.close();
        OS_cmd oS_cmd = new OS_cmd();
        oS_cmd.addQuot(SwatCharts.charts.where_is_swat + File.separator + "swat");
        oS_cmd.addText("reporter");
        oS_cmd.addQuot("dir=" + Vdbmain.output_dir);
        oS_cmd.addQuot("target=" + Vdbmain.output_dir + File.separator + "charts");
        String[] stringArray = Fget.readFileToArray(SwatCharts.charts.which_charts);
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n].startsWith("*")) continue;
            oS_cmd.addText(stringArray[n]);
        }
        oS_cmd.setOutputMethod(new CommandOutput(){

            @Override
            public boolean newLine(String string, String string2, boolean bl) {
                if (debug) {
                    common.ptod(string2 + ": " + string);
                } else {
                    common.plog(string2 + ": " + string);
                }
                return true;
            }
        });
        common.ptod("Starting Swat chart creation.");
        n = oS_cmd.execute(false) ? 1 : 0;
        if (n != 0) {
            common.ptod("Completed Swat charts in directory " + Vdbmain.output_dir + File.separator + "charts");
            charts.createIndex();
        } else {
            common.ptod("Error while creating Swat charts. Please see messages in logfile.html");
        }
    }

    private void createIndex() {
        String[] stringArray = new File(this.chart_directory).list();
        Fput fput = new Fput(this.index);
        fput.println("List of file names containing Swat charts created by Swat:\n\n");
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (!string.endsWith(".jpg")) continue;
            fput.println("<A HREF=\"" + string + "\">" + string + "</A>");
        }
        fput.close();
    }

    public static void main(String[] stringArray) {
        debug = true;
        SwatCharts swatCharts = new SwatCharts("h:\\swat", "swatcharts.txt");
        swatCharts.createCharts();
    }
}

