/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Utils.Format;
import Utils.Semaphore;
import Vdb.common;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;

public abstract class ThreadControl
extends Thread {
    private static final String c = "Copyright (c) 2000, 2012, Oracle and/or its affiliates. All rights reserved.";
    private Semaphore work_sema = new Semaphore(0L);
    private String classname = null;
    private int threadno = 0;
    private int status = 0;
    private boolean ack_needed = false;
    private Semaphore ack_sema = new Semaphore(0L);
    private boolean independent = false;
    private boolean shutting_down = false;
    private static final int THREAD_CREATED = 0;
    public static final int THREAD_IDLE = 1;
    public static final int THREAD_ACTIVE = 2;
    private static final int THREAD_WORKDONE = 3;
    private static final int THREAD_SET_IDLE = 4;
    private static final int SHUTDOWN_REQSTD = 5;
    private static final int SHUTDOWN_COMPLETE = 6;
    private static String[] status_txt = new String[]{"THREAD_CREATED", "THREAD_IDLE", "THREAD_ACTIVE", "THREAD_WORKDONE", "THREAD_SET_IDLE", "SHUTDOWN_REQSTD", "SHUTDOWN_COMPLETE"};
    private static Vector idle_list = new Vector(128, 0);
    private static Vector active_list = new Vector(128, 0);
    private static Object thread_lock = new Object();
    private static String[] tracelog = new String[1024];
    private static int traceoffset = 0;
    DateFormat df = new SimpleDateFormat("HH:mm:ss.SSS");
    private static boolean dumped_once = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThreadControl() {
        Object object = thread_lock;
        synchronized (object) {
            this.status = 0;
            this.classname = this.getClass().getName();
            active_list.addElement(this);
            this.threadno = active_list.size();
            this.setName(this.classname + "_" + this.threadno);
            if (this.classname.equals("StreamStartList")) {
                common.ptod("new StreamStartList: " + this.classname + "_" + this.threadno);
                Thread.dumpStack();
            }
        }
    }

    public int getThreadno() {
        return this.threadno;
    }

    public synchronized boolean setStartCompleted() {
        this.setName(this.getClass().getName());
        try {
            this.trace("setStartCompleted()");
            this.setStatus(0, 1);
        }
        catch (InterruptedException interruptedException) {
            this.trace("setStartCompleted interrupt status");
            if (this.isShutdown()) {
                this.trace("setStartCompleted interrupted. Shutting down");
                return false;
            }
            return true;
        }
        return true;
    }

    public void setIndependent() {
        this.independent = true;
    }

    public void removeIndependent() {
        if (active_list.removeElement(this)) {
            return;
        }
        if (idle_list.removeElement(this)) {
            return;
        }
        common.failure("Current thread not in active or idle list");
    }

    public void addToList() {
        active_list.addElement(this);
        this.threadno = active_list.size();
        this.setName(this.classname + "_" + this.threadno);
    }

    public void setShutdownComplete() {
        try {
            this.setStatus(5, 6);
        }
        catch (InterruptedException interruptedException) {
            this.trace("setShutdownComplete(): Ignoring InterruptedException");
            common.ptod("ThreadControl.setShutdownComplete(): Ignoring InterruptedException");
        }
    }

    public void waitForWork() throws InterruptedException {
        this.trace("waitForWork()");
        this.work_sema.acquire();
        this.setStatus(1, 2);
        this.trace("waitForWork() return");
    }

    public void startWorking() {
        this.trace("startWorking");
        this.work_sema.release();
    }

    public synchronized void setWorkCompleted() throws InterruptedException {
        this.trace("setWorkCompleted()");
        this.setStatus(2, 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ThreadControl getIdleThread(String string) {
        ThreadControl threadControl = null;
        Object object = thread_lock;
        synchronized (object) {
            for (int i = 0; i < idle_list.size(); ++i) {
                ThreadControl threadControl2 = threadControl = (ThreadControl)idle_list.elementAt(i);
                synchronized (threadControl2) {
                    if (threadControl.classname.equals(string) && threadControl.status == 1) {
                        if (!idle_list.removeElement(threadControl)) {
                            common.failure("removeElement() failed");
                        }
                        if (active_list.contains(threadControl)) {
                            common.failure("thread list already contains thread");
                        }
                        active_list.addElement(threadControl);
                        threadControl.trace("getIdleThread() return");
                        return threadControl;
                    }
                    continue;
                }
            }
            try {
                Class<?> clazz = Class.forName(string);
                threadControl = (ThreadControl)clazz.newInstance();
                threadControl.trace("getIdleThread: created new thread: " + string + " " + active_list.size());
                threadControl.start();
                return threadControl;
            }
            catch (ClassNotFoundException classNotFoundException) {
                common.failure(classNotFoundException);
            }
            catch (InstantiationException instantiationException) {
                common.failure(instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                common.failure(illegalAccessException);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getIdleCount(String string) {
        ThreadControl threadControl = null;
        int n = 0;
        for (int i = 0; i < idle_list.size(); ++i) {
            ThreadControl threadControl2 = threadControl = (ThreadControl)idle_list.elementAt(i);
            synchronized (threadControl2) {
                if (threadControl.classname.equals(string) && threadControl.isIdle()) {
                    ++n;
                }
                continue;
            }
        }
        return n;
    }

    public static int getActiveCount(String string) {
        ThreadControl threadControl = null;
        int n = 0;
        for (int i = 0; i < active_list.size(); ++i) {
            threadControl = (ThreadControl)active_list.elementAt(i);
            if (!threadControl.classname.equals(string) || threadControl.status != 2) continue;
            ++n;
        }
        return n;
    }

    public static void printActiveThreads() {
        ThreadControl threadControl = null;
        for (int i = 0; i < active_list.size(); ++i) {
            threadControl = (ThreadControl)active_list.elementAt(i);
            common.ptod("printActiveThreads: " + threadControl.classname);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopAllActive(String string) {
        Object object = thread_lock;
        synchronized (object) {
            Vector vector = new Vector(active_list);
            for (int i = 0; i < vector.size(); ++i) {
                ThreadControl threadControl = (ThreadControl)vector.elementAt(i);
                if (!threadControl.classname.equals(string) || threadControl.status != 2) continue;
                threadControl.setThreadIdle();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdownAll(String string) {
        ThreadControl threadControl;
        int n;
        int n2;
        Object object = thread_lock;
        synchronized (object) {
            n2 = 0;
            for (n = 0; n < active_list.size(); ++n) {
                threadControl = (ThreadControl)active_list.elementAt(n);
                if (!string.equals("full_shutdown") && !threadControl.classname.equals(string)) continue;
                ++n2;
                threadControl.shutdown();
            }
        }
        object = thread_lock;
        synchronized (object) {
            n2 = 0;
            for (n = 0; n < idle_list.size(); ++n) {
                threadControl = (ThreadControl)idle_list.elementAt(n);
                if (!string.equals("full_shutdown") && !threadControl.classname.equals(string)) continue;
                ++n2;
                threadControl.shutdown();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void waitForShutdownAll() {
        var0 = 0L;
        block0: while (true) {
            var2_1 = false;
            for (var3_2 = 0; var3_2 < ThreadControl.active_list.size(); ++var3_2) {
                var4_3 = (ThreadControl)ThreadControl.active_list.elementAt(var3_2);
                if (var4_3.status == 6) continue;
                var4_3.trace("Waiting for SHUTDOWN_COMPLETE");
                var2_1 = true;
                common.sleep_some(100L);
                break;
            }
            if (!var2_1) break;
            if ((var0 = common.signal_caller(var0, 30000L)) != 0L) continue;
            var3_2 = 0;
            while (true) {
                if (var3_2 < ThreadControl.active_list.size()) ** break;
                continue block0;
                var4_3 = (ThreadControl)ThreadControl.active_list.elementAt(var3_2);
                if (var4_3.status != 6) {
                    common.ptod("waitForShutdownAll() active: " + var4_3.classname + "-" + var4_3.threadno + " " + ThreadControl.status_txt[var4_3.status]);
                }
                ++var3_2;
            }
            break;
        }
        block3: while (true) {
            var2_1 = false;
            for (var3_2 = 0; var3_2 < ThreadControl.idle_list.size(); ++var3_2) {
                var4_3 = (ThreadControl)ThreadControl.idle_list.elementAt(var3_2);
                if (var4_3.status == 6) continue;
                var4_3.trace("Waiting for SHUTDOWN_COMPLETE");
                var2_1 = true;
                common.sleep_some(100L);
                break;
            }
            if (!var2_1) {
                return;
            }
            if ((var0 = common.signal_caller(var0, 2000L)) != 0L) continue;
            var3_2 = 0;
            while (true) {
                if (var3_2 < ThreadControl.idle_list.size()) ** break;
                continue block3;
                var4_3 = (ThreadControl)ThreadControl.idle_list.elementAt(var3_2);
                if (var4_3.status != 6) {
                    common.plog("waitForShutdownAll() idle: " + var4_3.classname + "-" + var4_3.threadno + " " + ThreadControl.status_txt[var4_3.status]);
                }
                ++var3_2;
            }
            break;
        }
    }

    public static void waitForIdleAll(String string) {
        long l = System.currentTimeMillis();
        while (true) {
            boolean bl = false;
            for (int i = 0; i < idle_list.size(); ++i) {
                ThreadControl threadControl = (ThreadControl)idle_list.elementAt(i);
                if (!threadControl.classname.equals(string) || threadControl.status == 1) continue;
                threadControl.trace("Waiting for THREAD_IDLE");
                bl = true;
                common.sleep_some(10L);
                break;
            }
            if (!bl) {
                return;
            }
            common.sleep_some(1L);
        }
    }

    public void waitForActive() {
        this.trace("waitForActive");
        while (this.status != 2) {
            common.sleep_some(1L);
        }
        this.trace("waitForActive return");
    }

    private synchronized void setStatus(int n, int n2) throws InterruptedException {
        if (n2 == 5) {
            this.shutting_down = true;
        }
        while (this.status != n && !this.shutting_down) {
            common.sleep_some(500L);
            if (this.status == n) continue;
            Thread.dumpStack();
            ThreadControl.dumpTrace();
            common.ptod("ThreadControl.setStatus(): " + this.classname + " waiting for status change to " + status_txt[n2] + " is now: " + status_txt[this.status] + "; should be: " + status_txt[n]);
            this.trace("setStatus(): waiting for status change to: " + status_txt[n2] + " is now: " + status_txt[this.status]);
        }
        this.trace("setStatus: " + status_txt[n2]);
        this.status = n2;
    }

    public int getStatus() {
        return this.status;
    }

    private boolean isIdle() {
        this.trace("isIdle");
        return this.status == 1;
    }

    public boolean goIdle() {
        return this.status == 4;
    }

    public void markIdle() {
        try {
            this.setStatus(4, 1);
        }
        catch (InterruptedException interruptedException) {
            this.trace("markIdle(): interrupt ignored");
        }
    }

    public void shutdown() {
        try {
            this.sendSignal(1, 5);
        }
        catch (InterruptedException interruptedException) {
            this.trace("shutdown(): interrupt ignored");
        }
    }

    public boolean isShutdown() {
        this.trace("isShutdown");
        return this.status == 5;
    }

    public synchronized void setThreadIdle() {
        try {
            this.sendSignal(2, 4);
        }
        catch (InterruptedException interruptedException) {
            this.trace("stop(): interrupt ignored");
        }
        if (idle_list.contains(this)) {
            common.failure("Thread is already in the idle list: " + this);
        }
        idle_list.addElement(this);
        if (!active_list.remove(this)) {
            common.failure("remove(): not in list");
        }
        this.trace("Moved to idle list");
    }

    public void statusError() {
        this.trace("statusError");
        ThreadControl.dumpTrace();
        common.failure("ThreadControl.statusError");
    }

    private synchronized void sendSignal(int n, int n2) throws InterruptedException {
        this.trace("sendSignal: " + status_txt[n2]);
        this.setStatus(n, n2);
        this.trace("b4 interrupt: " + status_txt[n2]);
        common.interruptThread(this);
        this.trace("af interrupt: " + status_txt[n2]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trace(String string) {
        String[] stringArray = tracelog;
        synchronized (tracelog) {
            String string2 = this.df.format(new Date());
            String string3 = this.isInterrupted() ? "t" : "f";
            String string4 = string2 + Format.f(" %-12s", this.classname) + Format.f(" %2d", this.threadno) + Format.f(" %-18s", status_txt[this.status]) + " " + string3 + " " + string;
            if (common.get_debug(common.THREADCONTROL_LOG)) {
                common.ptod(string4);
            } else {
                ThreadControl.tracelog[ThreadControl.traceoffset++ % ThreadControl.tracelog.length] = string4;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpTrace() {
        if (!common.get_debug(common.DUMP_THREAD_TRACE)) {
            return;
        }
        if (dumped_once) {
            return;
        }
        dumped_once = true;
        String[] stringArray = tracelog;
        synchronized (tracelog) {
            for (int i = 0; i < tracelog.length; ++i) {
                String string;
                if ((string = tracelog[traceoffset++ % tracelog.length]) == null) continue;
                common.plog(string);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static void main(String[] stringArray) {
    }
}

