/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Vdb.Vdb_scan;
import Vdb.common;

class Var_parms {
    private static final String c = "Copyright (c) 2000, 2012, Oracle and/or its affiliates. All rights reserved.";
    static final int VAR_DASH_N = -101;
    static final String VAR_DASH_A = "-101a";
    static final int VAR_DOUBLE_N = -102;

    Var_parms() {
    }

    static void handle_var(Vdb_scan vdb_scan) {
        if (vdb_scan.getNumCount() > 0) {
            Var_parms.handle_num(vdb_scan);
        } else {
            Var_parms.handle_alpha(vdb_scan);
        }
    }

    private static void handle_num(Vdb_scan vdb_scan) {
        double d = 0.0;
        double[] dArray = new double[10240];
        double[] dArray2 = vdb_scan.numerics;
        int n = 0;
        for (int i = 0; i < vdb_scan.getNumCount(); ++i) {
            double d2 = dArray2[i];
            if (d2 == -101.0 || d2 == -102.0) {
                d = d2;
                continue;
            }
            if (d == -101.0) {
                double d3;
                if (dArray2[i + 1] == -102.0) {
                    if (dArray[n - 1] < d2) {
                        for (d3 = dArray[n - 1] * 2.0; d3 <= d2; d3 *= 2.0) {
                            dArray[n++] = d3;
                        }
                    } else {
                        for (d3 = dArray[n - 1] / 2.0; d3 >= d2; d3 /= 2.0) {
                            dArray[n++] = d3;
                        }
                    }
                } else {
                    for (d3 = dArray[n - 1] + dArray2[i + 1]; d3 <= d2; d3 += dArray2[i + 1]) {
                        dArray[n++] = d3;
                    }
                }
                ++i;
                d = 0.0;
                continue;
            }
            dArray[n++] = d2;
        }
        vdb_scan.numerics = dArray;
        vdb_scan.num_count = n;
    }

    private static void handle_alpha(Vdb_scan vdb_scan) {
        String string = "";
        String[] stringArray = new String[16384];
        String[] stringArray2 = vdb_scan.alphas;
        int n = 0;
        for (int i = 0; i < vdb_scan.alpha_count; ++i) {
            String string2 = stringArray2[i];
            if (string2 == VAR_DASH_A) {
                string = string2;
                continue;
            }
            if (string.compareTo(VAR_DASH_A) == 0) {
                int n2 = Var_parms.split_name(stringArray[n - 1]);
                int n3 = Var_parms.split_name(string2);
                String string3 = stringArray[n - 1].substring(0, n2);
                String string4 = string2.substring(0, n3);
                Integer n4 = Integer.valueOf(stringArray[n - 1].substring(n2));
                int n5 = n4;
                n4 = Integer.valueOf(string2.substring(n3));
                int n6 = n4;
                if (string3.compareTo(string4) != 0) {
                    common.failure("Alpha portions of alphanumeric range values must be equal: " + stringArray[n - 1] + "/" + string2);
                }
                if (n5 >= n6) {
                    common.failure("Numeric portions of alphanumeric re values must be incremental: " + stringArray[n - 1] + "/" + string2);
                }
                for (int j = n5 + 1; j <= n6; ++j) {
                    stringArray[n++] = string3 + j;
                }
                string = "";
                continue;
            }
            stringArray[n++] = string2;
        }
        vdb_scan.alphas = stringArray;
        vdb_scan.alpha_count = n;
    }

    public static int split_name(String string) {
        int n;
        String string2 = "0123456789";
        for (n = string.length() - 1; n > 0 && string2.indexOf(string.substring(n, n + 1)) != -1; --n) {
        }
        if (n < 0 || n == string.length() - 1) {
            common.ptod("Parameter range value '" + string + "' must be alphanumeric, " + "ending with a numeric value.");
            common.ptod("If this parameter however is not a range parameter, please enclose the parameter with double quotes.");
            common.ptod("");
            common.failure("Parameter range value '" + string + "' must be alphanumeric, " + "ending with a numeric value.");
        }
        return n + 1;
    }
}

