/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Utils.Fput;
import Utils.Getopt;
import Utils.OS_cmd;
import Vdb.common;
import java.io.File;
import java.util.ArrayList;

public class VdbenchKill {
    private static final String c = "Copyright (c) 2000, 2015, Oracle and/or its affiliates. All rights reserved.";
    private static String sep = File.separator;
    private static String tmpdir = common.onWindows() ? Fput.getTmpDir() : "/tmp";
    private static String tmp_shutdown = new File(tmpdir, "vdbench.shutdown.").getAbsolutePath();

    public static void main(String[] stringArray) {
        Object object;
        String string = common.getProcessIdString();
        File file = null;
        String string2 = System.getProperty("java.home");
        Getopt getopt = new Getopt(stringArray, "j:-d", 1);
        if (!getopt.isOK()) {
            common.failure("Parameter parsing failed");
        }
        if (getopt.check('j')) {
            string2 = getopt.get_string();
            file = new File(string2);
        } else if (common.onWindows()) {
            if (string2.endsWith("jre")) {
                string2 = string2.replace("\\jre", "");
            }
            if (!(file = new File(string2 + sep + "bin", "jps.exe")).exists()) {
                System.out.printf("Can not find file '%s'\n", file.getAbsolutePath());
                common.failure("VdbenchKill only works when run from a JDK");
            }
        } else {
            if (string2.endsWith("jre")) {
                string2 = string2.replace("/jre", "");
            }
            if (!(file = new File(string2 + sep + "bin", "jps")).exists()) {
                System.out.printf("Can not find file '%s'\n", file.getAbsolutePath());
                common.failure("VdbenchKill only works when run from a JDK");
            }
        }
        ArrayList<String> arrayList = new ArrayList<String>(8);
        ArrayList arrayList2 = new ArrayList(8);
        OS_cmd oS_cmd = new OS_cmd();
        oS_cmd.addQuot(file.getAbsolutePath());
        oS_cmd.execute(false);
        if (!oS_cmd.getRC()) {
            VdbenchKill.printOutput(oS_cmd);
            common.failure("'%s' command failed", string2);
        }
        for (String object22 : oS_cmd.getStdout()) {
            object = object22.trim().split(" +");
            if (((String[])object).length != 2) {
                VdbenchKill.printOutput(oS_cmd);
                common.failure("Expecting two data fields in the outout");
            }
            if (!object[1].equals("Vdbmain") || object[0].equals(string)) continue;
            arrayList.add(object[0]);
        }
        if (arrayList.size() == 0) {
            System.out.println("No Vdbench master JVMs found");
            return;
        }
        if (getopt.get_positionals().size() == 0) {
            System.out.println("\n");
            for (String string3 : arrayList) {
                System.out.printf("Vdbench Master JVM: %s\n", string3);
            }
            System.out.println("");
            for (String string4 : arrayList2) {
                System.out.printf("Vdbench Slave JVM:  %s (Do not use this pid to kill) \n", string4);
            }
            System.out.println("\n");
            return;
        }
        String string5 = getopt.get_positionals().get(0);
        if (!string5.equalsIgnoreCase("all")) {
            int n = 0;
            for (String string3 : arrayList) {
                if (!string3.equals(string5)) continue;
                n = 1;
            }
            if (n == 0) {
                System.out.printf("Can not find process-id %s to kill \n", string5);
                return;
            }
            String string6 = tmp_shutdown + (String)string5;
            Fput fput = new Fput(string6);
            fput.close();
            System.out.println("Sent 'shutdown' request to: " + (String)string6);
            return;
        }
        for (String string7 : arrayList) {
            String string4 = tmp_shutdown + string7;
            object = new Fput(string4);
            ((Fput)object).close();
            System.out.println("Sent 'shutdown' request to: " + string4);
        }
    }

    private static void printOutput(OS_cmd oS_cmd) {
        for (String string : oS_cmd.getStderr()) {
            System.out.println("stderr: " + string);
        }
        for (String string : oS_cmd.getStdout()) {
            System.out.println("stdout: " + string);
        }
    }
}

