/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Vdb.DV_map;
import Vdb.Elapsed;
import Vdb.ErrorLog;
import Vdb.FileAnchor;
import Vdb.FileEntry;
import Vdb.Validate;
import Vdb.common;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;

public class VerifyPending {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";

    public static void findPendingBlocks(DV_map dV_map, DV_map dV_map2, String string, String string2) {
        int n;
        Elapsed elapsed = new Elapsed("findPendingBlocks", 100000000L);
        ArrayList<Long> arrayList = new ArrayList<Long>(1024);
        ArrayList<Byte> arrayList2 = new ArrayList<Byte>(1024);
        int n2 = dV_map2.getKeyBlockSize();
        boolean bl = true;
        for (long i = 0L; i < dV_map2.key_blocks; ++i) {
            long l = i * (long)n2;
            int n3 = dV_map.dv_get_nolock(l);
            elapsed.track();
            if (n3 == 0) continue;
            if (bl) {
                bl = false;
                ErrorLog.plog("", new Object[0]);
                ErrorLog.plog("Note that i/o still pending at the end of the previous run's NORMAL completion may be included here.", new Object[0]);
                ErrorLog.plog("", new Object[0]);
            }
            if (n3 == 127) {
                ErrorLog.plog("Key block at lba 0x%08x. This Block was marked in error, either due to a write failure or due to a Data Validation error. Key block will not be touched again.", l);
                dV_map2.dv_set(l, 127);
                continue;
            }
            if (n3 == 128) {
                ErrorLog.plog("I/O pending for key block at lba 0x%08x flag 0x%02x key 0x%02x. This was the block's first write. Block marked 'unknown'.", l, n3, dV_map2.dv_get(l));
                dV_map2.dv_set(l, 0);
                continue;
            }
            ErrorLog.plog("I/O pending for key block at lba 0x%08x flag 0x%02x key 0x%02x", l, n3, dV_map2.dv_get(l));
            arrayList.add(l);
            arrayList2.add((byte)n3);
            if (arrayList.size() <= 0x7FFFFFFE) continue;
            common.failure("Too many (%,d) pending key blocks", arrayList.size());
        }
        ErrorLog.plog("%s=%s %,d pending writes found in this journal need to be checked.", string, string2, arrayList.size());
        if (string2 == null) {
            common.failure("Unknown SD or FSD name");
        }
        if (Validate.ignorePending()) {
            dV_map.pending_write_lbas = new long[0];
            dV_map.pending_write_flags = new byte[0];
            ErrorLog.plog("User opted to ignore all pending writes. Data contents set to 'unknown'", new Object[0]);
            for (int i = 0; i < arrayList.size(); ++i) {
                dV_map2.dv_set((Long)arrayList.get(i), 0);
            }
            elapsed.end(5);
            return;
        }
        dV_map.pending_write_lbas = new long[arrayList.size()];
        dV_map.pending_write_flags = new byte[arrayList.size()];
        for (n = 0; n < arrayList.size(); ++n) {
            dV_map.pending_write_lbas[n] = (Long)arrayList.get(n);
            dV_map.pending_write_flags[n] = (Byte)arrayList2.get(n);
        }
        dV_map.pending_map = new HashMap(dV_map.pending_write_lbas.length);
        for (n = 0; n < dV_map.pending_write_lbas.length; ++n) {
            dV_map.pending_map.put(dV_map.pending_write_lbas[n], dV_map.pending_write_flags[n]);
        }
        elapsed.end(5);
    }

    public static void checkFsdPendingBlocks(FileAnchor fileAnchor, DV_map dV_map) {
        if (dV_map.pending_write_lbas.length == 0) {
            return;
        }
        int n = 0;
        int n2 = 0;
        Vector<FileEntry> vector = fileAnchor.getFileList();
        for (n2 = 0; n2 < vector.size() && n < dV_map.pending_write_lbas.length; ++n2) {
            FileEntry fileEntry = vector.elementAt(n2);
            long l = fileEntry.getFileStartLba();
            long l2 = l + fileEntry.getCurrentSize();
            while (dV_map.pending_write_lbas[n] < fileEntry.getFileStartLba()) {
                ++n;
            }
            if (dV_map.pending_write_lbas[n] >= l2) continue;
            n = VerifyPending.checkKeyValuesForFile(dV_map, fileEntry, n);
        }
    }

    private static int checkKeyValuesForFile(DV_map dV_map, FileEntry fileEntry, int n) {
        long l;
        long l2;
        HashMap<Long, Long> hashMap;
        FileAnchor fileAnchor = fileEntry.getAnchor();
        if (fileAnchor.pending_file_lba_map == null) {
            fileAnchor.pending_file_lba_map = new HashMap(8);
            fileAnchor.pending_files = new ArrayList(8);
        }
        if (fileAnchor.pending_file_lba_map.put(fileEntry, hashMap = new HashMap<Long, Long>(8)) != null) {
            common.failure("Duplicate pending file name: " + fileEntry.getShortName());
        }
        fileAnchor.pending_files.add(fileEntry);
        while (n < dV_map.pending_write_lbas.length && (l2 = (l = dV_map.pending_write_lbas[n]) - fileEntry.getFileStartLba()) < fileEntry.getCurrentSize()) {
            if (hashMap.put(l2, l2) != null) {
                common.failure("Duplicate pending lba found: " + l2);
            }
            ErrorLog.plog("Pending write found to file %s, file lba 0x%08x", fileEntry.getFullName(), l2);
            ++n;
        }
        return n;
    }
}

