/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Vdb.BoxPrint;
import Vdb.ConcatSds;
import Vdb.Dedup;
import Vdb.Host;
import Vdb.OpenFlags;
import Vdb.RD_entry;
import Vdb.ReplayInfo;
import Vdb.SD_entry;
import Vdb.Validate;
import Vdb.Vdb_scan;
import Vdb.Vdbmain;
import Vdb.common;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Vector;

public class WD_entry
implements Cloneable,
Serializable {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";
    String wd_name = "default";
    String wd_sd_name;
    String[] sd_names = null;
    String[] host_names = new String[]{"*"};
    SD_entry concat_sd = null;
    int wd_threads = 0;
    int stream_count = 0;
    int priority = Integer.MAX_VALUE;
    double wd_iorate = 0.0;
    double skew;
    double skew_original = 0.0;
    double skew_observed;
    boolean valid_skew_obs = false;
    boolean hotband_used = false;
    double lowrange = -1.0;
    double highrange = -1.0;
    double poisson_midpoint = 0.0;
    double seekpct = 100.0;
    boolean seek_start0 = true;
    long stride_min = -1L;
    long stride_max = -1L;
    double rhpct = 0.0;
    double whpct = 0.0;
    double[] xf_table = new double[]{4096.0};
    double readpct = 100.0;
    long total_io_done;
    boolean one_slave_warning_given = false;
    boolean wd_is_used = false;
    OpenFlags open_flags = null;
    String[] user_class_parms = null;
    private static boolean any_hotbands_requested = false;
    static WD_entry dflt = new WD_entry();
    static int max_wd_name = 1;
    int starting_slave = 0;
    int sds_added = 0;

    public Object clone() {
        try {
            WD_entry wD_entry = (WD_entry)super.clone();
            if (this.sd_names != null) {
                wD_entry.sd_names = (String[])this.sd_names.clone();
            }
            if (this.host_names != null) {
                wD_entry.host_names = (String[])this.host_names.clone();
            }
            if (this.xf_table != null) {
                wD_entry.xf_table = (double[])this.xf_table.clone();
            }
            if (this.open_flags != null) {
                wD_entry.open_flags = (OpenFlags)this.open_flags.clone();
            }
            return wD_entry;
        }
        catch (Exception exception) {
            common.failure(exception);
            return null;
        }
    }

    public void setSkew(double d) {
        this.skew = d;
    }

    public double getSkew() {
        return this.skew;
    }

    static void wd_check_duplicate(Vector vector, String string) {
        for (int i = 0; i < vector.size(); ++i) {
            WD_entry wD_entry = (WD_entry)vector.elementAt(i);
            if (wD_entry.wd_name.compareTo(string) != 0) continue;
            common.failure("duplicate WD names not allowed: " + string);
        }
    }

    static String readParms(Vector vector, String string) {
        String string2 = string;
        WD_entry wD_entry = null;
        try {
            do {
                Vdb_scan vdb_scan = Vdb_scan.parms_split(string2);
                if (vdb_scan.keyword.equals("fwd") || vdb_scan.keyword.equals("rd")) break;
                if (vdb_scan.keyword.equals("wd")) {
                    if (vdb_scan.alphas[0].equals("default")) {
                        wD_entry = dflt;
                        continue;
                    }
                    wD_entry = (WD_entry)dflt.clone();
                    wD_entry.wd_name = vdb_scan.alphas[0];
                    WD_entry.wd_check_duplicate(vector, wD_entry.wd_name);
                    vector.addElement(wD_entry);
                    max_wd_name = Math.max(max_wd_name, wD_entry.wd_name.length());
                    if (ReplayInfo.isReplay()) {
                        wD_entry.user_class_parms = new String[]{"Vdb.ReplayGen"};
                    }
                    if (!Vdbmain.isFwdWorkload()) continue;
                    common.ptod("'fwd' and 'wd' parameters are mutually exclusive");
                    continue;
                }
                if (vdb_scan.keyword.equals("sd")) {
                    if (vdb_scan.alpha_count == 0) {
                        common.failure("No parameters defined for 'wd=%s,sd=: %s", wD_entry.wd_name, string2);
                    }
                    wD_entry.sd_names = vdb_scan.alphas;
                    wD_entry.wd_sd_name = wD_entry.sd_names[0];
                    continue;
                }
                if ("skew".startsWith(vdb_scan.keyword)) {
                    wD_entry.skew_original = vdb_scan.numerics[0];
                    continue;
                }
                if ("xfersize".startsWith(vdb_scan.keyword)) {
                    wD_entry.parseXfersize(vdb_scan);
                    continue;
                }
                if ("readpct".startsWith(vdb_scan.keyword) || "rdpct".startsWith(vdb_scan.keyword)) {
                    wD_entry.readpct = (int)vdb_scan.numerics[0];
                    continue;
                }
                if ("writepct".startsWith(vdb_scan.keyword) || "wrpct".startsWith(vdb_scan.keyword)) {
                    wD_entry.readpct = 100 - (int)vdb_scan.numerics[0];
                    continue;
                }
                if ("range".startsWith(vdb_scan.keyword)) {
                    wD_entry.lowrange = vdb_scan.numerics[0];
                    if (vdb_scan.getNumCount() > 1) {
                        wD_entry.highrange = vdb_scan.numerics[1];
                        continue;
                    }
                    common.failure("'range=' parameter must be specified with a beginning and ending range, e.g. 'range=(10,20)'");
                    continue;
                }
                if ("hotband".startsWith(vdb_scan.keyword)) {
                    any_hotbands_requested = true;
                    wD_entry.hotband_used = true;
                    wD_entry.lowrange = vdb_scan.numerics[0];
                    if (vdb_scan.getNumCount() > 1) {
                        wD_entry.highrange = vdb_scan.numerics[1];
                        continue;
                    }
                    common.failure("'hotband=' parameter must be specified with a beginning and ending range, e.g. 'hotband=(10,20)'");
                    continue;
                }
                if ("seekpct".startsWith(vdb_scan.keyword)) {
                    wD_entry.parseSeekpct(vdb_scan);
                    continue;
                }
                if ("stride".startsWith(vdb_scan.keyword)) {
                    wD_entry.parseStride(vdb_scan);
                    continue;
                }
                if ("priority".startsWith(vdb_scan.keyword)) {
                    wD_entry.priority = vdb_scan.getInt();
                    if (wD_entry.priority != 0) continue;
                    common.failure("Workload priority may not be zero");
                    continue;
                }
                if ("iorate".startsWith(vdb_scan.keyword)) {
                    wD_entry.wd_iorate = vdb_scan.getDouble();
                    if (vdb_scan.num_count <= 1) continue;
                    common.failure("The 'iorate' parameter for a Workload Definition (WD) may contain only one value");
                    continue;
                }
                if ("rhpct".startsWith(vdb_scan.keyword)) {
                    ConcatSds.abortIf("'rhpct=' parameter may not be used.");
                    wD_entry.rhpct = vdb_scan.numerics[0];
                    continue;
                }
                if ("whpct".startsWith(vdb_scan.keyword)) {
                    ConcatSds.abortIf("'whpct=' parameter may not be used.");
                    wD_entry.whpct = vdb_scan.numerics[0];
                    continue;
                }
                if ("host".startsWith(vdb_scan.keyword) || vdb_scan.keyword.equals("hd")) {
                    wD_entry.host_names = vdb_scan.alphas;
                    continue;
                }
                if ("openflags".startsWith(vdb_scan.keyword)) {
                    wD_entry.open_flags = new OpenFlags(vdb_scan.alphas, vdb_scan.numerics);
                    continue;
                }
                if (vdb_scan.keyword.equals("user")) {
                    wD_entry.user_class_parms = vdb_scan.alphas;
                    continue;
                }
                if ("threads".startsWith(vdb_scan.keyword)) {
                    wD_entry.wd_threads = (int)vdb_scan.numerics[0];
                    if (Validate.sdConcatenation()) continue;
                    common.failure("Workload Definition (WD) level thread= parameter may only be used together with 'concatenatesds=yes'");
                    continue;
                }
                if ("streams".startsWith(vdb_scan.keyword)) {
                    vdb_scan.mustBeNumeric();
                    wD_entry.stream_count = (int)vdb_scan.numerics[0];
                    if (wD_entry.stream_count >= 2) continue;
                    common.failure("'streams=' parameter must specific a minimum of two streams");
                    continue;
                }
                common.failure("Unknown keyword: " + vdb_scan.keyword);
            } while ((string2 = Vdb_scan.parms_get()) != null);
            WD_entry.checkParameters(vector);
        }
        catch (Exception exception) {
            common.ptod("Exception during reading of input parameter file(s).");
            common.ptod("Look at the end of 'parmscan.html' to identify the last parameter scanned.");
            common.ptod(exception);
            common.failure("Exception during reading of input parameter file(s).");
        }
        return string2;
    }

    private void parseXfersize(Vdb_scan vdb_scan) {
        this.xf_table = vdb_scan.numerics;
        double[] dArray = vdb_scan.numerics;
        if (dArray.length == 3) {
            if (dArray[0] >= dArray[1]) {
                common.failure("xfersize=(min,max,align): 'xfersize=(%d,%d,%d)' invalid contents", dArray[0], dArray[1], dArray[2]);
            }
            if (dArray[2] == 0.0 || dArray[2] % 512.0 != 0.0) {
                common.failure("xfersize=(min,max,align): 'align' must be non-zero and a multiple of 512: " + dArray[2]);
            }
        } else if (dArray.length > 1) {
            int n;
            if (dArray.length % 2 != 0) {
                common.failure("Xfersize distribution list must be in pairs, e.g. xfersize=(1k,25,2k,25,4k,50)");
            }
            double d = 0.0;
            for (n = 0; n < vdb_scan.numerics.length; ++n) {
                if (n % 2 == 1) {
                    d += dArray[n];
                }
                if (n % 2 != 0 || dArray[n] % 512.0 == 0.0) continue;
                common.failure("data transfer size not multiple of 512 bytes: " + (int)dArray[n]);
            }
            n = (int)Math.round(d);
            if (n != 100) {
                common.failure("Xfersize distribution does not add up to 100: " + n);
            }
        }
    }

    private void parseSeekpct(Vdb_scan vdb_scan) {
        for (String string : vdb_scan.raw_values) {
            if (string.startsWith("seq")) {
                this.seekpct = 0.0;
                if (!string.contains("nz")) continue;
                this.seek_start0 = false;
                continue;
            }
            if (string.equalsIgnoreCase("eof")) {
                this.seekpct = -1.0;
                continue;
            }
            if ("random".startsWith(string)) {
                this.seekpct = 100.0;
                continue;
            }
            if ("poisson".startsWith(string)) {
                this.seekpct = 100.0;
                this.poisson_midpoint = 3.0;
                continue;
            }
            if (common.isDouble(string)) {
                if (this.poisson_midpoint == 0.0) {
                    this.seekpct = Double.parseDouble(string);
                    continue;
                }
                this.poisson_midpoint = Double.parseDouble(string);
                continue;
            }
            common.failure("Invalid contents for 'seekpct=': " + string);
        }
    }

    private void parseStride(Vdb_scan vdb_scan) {
        if (vdb_scan.getAlphaCount() > 0) {
            common.failure("stride= allows only numeric values");
        }
        if (vdb_scan.getNumCount() != 2) {
            common.failure("stride= requires two parameters: 'stride=(min,max)'");
        }
        this.stride_min = (long)vdb_scan.numerics[0];
        this.stride_max = (long)vdb_scan.numerics[1];
        if (this.stride_max < this.stride_min) {
            common.failure("stride=(min,max) max must be larger than stride minimum");
        }
    }

    public ArrayList<Host> getSelectedHosts() {
        int n;
        ArrayList<Host> arrayList = new ArrayList<Host>(8);
        for (n = 0; n < this.host_names.length; ++n) {
            int n2 = 0;
            Vector<Host> vector = Host.getDefinedHosts();
            for (int i = 0; i < vector.size(); ++i) {
                Host host = vector.elementAt(i);
                if (!common.simple_wildcard(this.host_names[n], host.getLabel())) continue;
                ++n2;
                arrayList.add(host);
            }
            if (n2 != 0) continue;
            common.failure("Could not find host=" + this.host_names[n] + " for wd=" + this.wd_name);
        }
        if (arrayList.size() == 0) {
            for (n = 0; n < this.host_names.length; ++n) {
                common.ptod(this.host_names[n]);
                common.failure("Could not find correct host= for WD=" + this.wd_name);
            }
        }
        return arrayList;
    }

    public Vector getSdsForHost(Host host) {
        Vector<SD_entry> vector = new Vector<SD_entry>(64, 0);
        SD_entry.clearAllActive();
        for (String string : this.sd_names) {
            boolean bl = false;
            for (SD_entry sD_entry : Vdbmain.sd_list) {
                if (sD_entry.concatenated_sd || !common.simple_wildcard(string, sD_entry.sd_name)) continue;
                bl = true;
                if (!host.doesHostHaveSd(sD_entry)) continue;
                if (sD_entry.isActive()) {
                    common.failure("SD=" + sD_entry.sd_name + " is requested more than once " + "in wd=" + this.wd_name);
                }
                sD_entry.setActive();
                vector.addElement(sD_entry);
            }
            if (bl) continue;
            common.failure("Could not find sd=" + string + " for wd=" + this.wd_name + ",host=" + host.getLabel());
        }
        return vector;
    }

    private static void checkParameters(Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            WD_entry wD_entry = (WD_entry)vector.elementAt(i);
            if (wD_entry.skew_original == 0.0 || wD_entry.wd_iorate == 0.0) continue;
            common.failure("Workload Definition (WD): 'iorate=' and 'skew=' are mutually exclusive");
        }
        if (Dedup.any_hotsets_requested && !any_hotbands_requested) {
            BoxPrint.printOne("When requesting 'deduphotsets=' the use of 'hotbands=' is highly recommended", new Object[0]);
        }
    }

    public static void checkPriorities(Vector vector) {
        Cloneable cloneable;
        int n;
        HashMap hashMap = new HashMap(32);
        for (n = 0; n < vector.size(); ++n) {
            WD_entry wD_entry = (WD_entry)vector.elementAt(n);
            if (wD_entry.priority == Integer.MAX_VALUE) continue;
            hashMap.put(new Integer(wD_entry.priority), null);
        }
        n = 0;
        for (int i = 0; i < vector.size(); ++i) {
            WD_entry wD_entry = (WD_entry)vector.elementAt(i);
            if (wD_entry.priority != Integer.MAX_VALUE || wD_entry.wd_iorate != 0.0) {
                n = 1;
            }
            if (wD_entry.wd_iorate == 0.0 || wD_entry.priority != Integer.MAX_VALUE) continue;
            common.failure("A workload with iorate= also must have  priority= specified.");
        }
        if (n != 0 && vector.size() != hashMap.size()) {
            common.failure("When a workload priority= or iorate= parameter is used, ALL workloads must have a (different) priority defined");
        }
        HashMap hashMap2 = new HashMap(32);
        for (int i = 0; i < vector.size(); ++i) {
            cloneable = (WD_entry)vector.elementAt(i);
            if (((WD_entry)cloneable).wd_iorate == 0.0) continue;
            hashMap2.put(new Integer(((WD_entry)cloneable).priority), null);
        }
        Object[] objectArray = hashMap2.keySet().toArray(new Integer[0]);
        Arrays.sort(objectArray);
        cloneable = new HashMap(32);
        for (int i = 0; i < vector.size(); ++i) {
            WD_entry wD_entry = (WD_entry)vector.elementAt(i);
            if (wD_entry.wd_iorate != 0.0) continue;
            ((HashMap)cloneable).put(new Integer(wD_entry.priority), null);
        }
        Object[] objectArray2 = ((HashMap)cloneable).keySet().toArray(new Integer[0]);
        Arrays.sort(objectArray2);
        if (objectArray2.length > 0) {
            int n2 = (Integer)objectArray2[0];
            for (int i = 0; i < objectArray.length; ++i) {
                if ((Integer)objectArray[i] < n2) continue;
                common.failure("Workloads specifying iorate= must have a higher priority than workloads that do NOT specify iorate=");
            }
        }
    }

    public boolean isWdUsedThisRd() {
        for (WD_entry wD_entry : RD_entry.next_rd.wds_for_rd) {
            if (wD_entry != this) continue;
            return true;
        }
        return false;
    }
}

