/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import User.UserClass;
import Vdb.BoxPrint;
import Vdb.Bursts;
import Vdb.Cmd_entry;
import Vdb.ConcatLbaSearch;
import Vdb.Fifo;
import Vdb.FifoList;
import Vdb.FileAnchor;
import Vdb.For_loop;
import Vdb.Host;
import Vdb.HotBand;
import Vdb.JniIndex;
import Vdb.KeyMap;
import Vdb.MiscParms;
import Vdb.Native;
import Vdb.OpenFlags;
import Vdb.RD_entry;
import Vdb.ReplayDevice;
import Vdb.ReplayInfo;
import Vdb.SD_entry;
import Vdb.Signal;
import Vdb.Slave;
import Vdb.SlaveJvm;
import Vdb.SlaveList;
import Vdb.SlaveWorker;
import Vdb.SocketMessage;
import Vdb.Task_num;
import Vdb.Validate;
import Vdb.WD_entry;
import Vdb.WG_context;
import Vdb.WG_task;
import Vdb.Work;
import Vdb.common;
import Vdb.ownmath;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Random;
import java.util.Vector;

public class WG_entry
implements Serializable,
Cloneable,
Comparable {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";
    public String wd_name;
    private transient Slave slave;
    String wg_name;
    private int priority;
    public double wg_iorate = 0.0;
    public double poisson_midpoint = 0.0;
    public double seekpct;
    public boolean seek_start0 = true;
    public long stride_min = -1L;
    public long stride_max = -1L;
    public double rhpct;
    public double whpct;
    public double readpct;
    public double skew;
    public double arrival;
    long hitarea_used = -1L;
    long ts_offset;
    private double[] xf_table;
    public boolean hotband_used = false;
    public ArrayList<JniIndex> jni_index_list = null;
    public WD_entry wd_used;
    public SD_entry sd_used = null;
    public ArrayList<SD_entry> sds_in_concatenation = null;
    boolean access_block_zero = false;
    public transient Fifo fifo_to_wait;
    public boolean suspend_fifo_use = false;
    public Random seek_randomizer;
    public transient Cmd_entry pending_cmd;
    WG_context hcontext = new WG_context();
    WG_context mcontext = new WG_context();
    long ios_on_the_way = 0L;
    long ios_started = 0L;
    public boolean seq_eof = false;
    Bursts bursts = null;
    boolean fixed_seed = common.get_debug(common.FIXED_SEED);
    OpenFlags wd_open_flags = null;
    public String[] user_class_parms = null;
    public UserClass user_class = null;
    public SD_entry lba_search_key = null;
    public ConcatLbaSearch search_method = null;
    public KeyMap key_map;
    private Object on_the_way_lock;
    private static int sequential_files = 0;
    private static Object seq_lock = new Object();
    private int seqno = seq++;
    private static boolean print_seq_counts = common.get_debug(common.SEQUENTIAL_COUNTS);
    private static int seq = 1;
    private long blocks_returned = 0L;
    private Signal seek_eof_dv_read = new Signal(15);
    private static FifoList shared_fifo = null;
    private static String sort_by = null;
    private static long sorts = 0L;

    public Object clone() {
        try {
            WG_entry wG_entry = (WG_entry)super.clone();
            if (this.xf_table != null) {
                wG_entry.xf_table = (double[])this.xf_table.clone();
            }
            wG_entry.hcontext = (WG_context)this.hcontext.clone();
            wG_entry.mcontext = (WG_context)this.mcontext.clone();
            this.seqno = seq++;
            return wG_entry;
        }
        catch (Exception exception) {
            common.failure(exception);
            return null;
        }
    }

    public WG_entry initialize(RD_entry rD_entry, SD_entry sD_entry, WD_entry wD_entry, Host host) {
        this.sds_in_concatenation = sD_entry.sds_in_concatenation;
        this.sd_used = sD_entry;
        this.access_block_zero = sD_entry.canWeUseBlockZero();
        this.wd_used = wD_entry;
        this.wg_iorate = wD_entry.wd_iorate;
        this.wd_name = wD_entry.wd_name;
        this.wd_open_flags = wD_entry.open_flags;
        this.user_class_parms = wD_entry.user_class_parms;
        this.hotband_used = wD_entry.hotband_used;
        this.setPriority(wD_entry.priority == Integer.MAX_VALUE ? wD_entry.priority : wD_entry.priority - 1);
        this.storeWorkloadParameters(rD_entry);
        rD_entry.willWeUseWaiterForWG();
        sD_entry.trackSdXfersizes(this.getXfersizes());
        String string = host.getLunNameForSd(sD_entry);
        String string2 = rD_entry.current_override.getText();
        string2 = string2 != null ? " 'forxx: " + string2.trim() : "";
        this.wg_name = "rd=" + rD_entry.rd_name + ",wd=" + wD_entry.wd_name + ",sd=" + sD_entry.sd_name + ",lun=" + string + string2 + "' " + (this.seekpct <= 0.0 ? "seq" : "rnd");
        wD_entry.wd_is_used = wD_entry.wd_name.startsWith(SD_entry.SD_FORMAT_NAME) ? false : !wD_entry.wd_name.startsWith("rd=");
        return this;
    }

    public static int sequentials_count(Vector vector) {
        int n = 0;
        for (int i = 0; i < vector.size(); ++i) {
            WG_entry wG_entry = (WG_entry)vector.elementAt(i);
            wG_entry.seq_eof = false;
            if (!(wG_entry.seekpct < 0.0)) continue;
            ++n;
        }
        if (n == 0) {
            n = -1;
        }
        common.ptod("files: " + n);
        return n;
    }

    public static void setSequentialFileCount(int n) {
        sequential_files = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sequentials_lower() {
        Object object = seq_lock;
        synchronized (object) {
            if (SlaveJvm.isWorkloadDone()) {
                return;
            }
            int n = SlaveWorker.getSequentialCount();
            if (n == -1) {
                return;
            }
            if (--n == 0) {
                if (ReplayInfo.isReplay()) {
                    common.ptod("Trace replay reached EOF; Workload generation completed.");
                } else {
                    common.ptod("All sequential runs reached EOF; Workload generation completed.");
                }
                SlaveJvm.sendMessageToMaster(SocketMessage.SLAVE_REACHED_EOF);
            }
            SlaveWorker.setSequentialCount(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add_io(Cmd_entry cmd_entry) {
        if (this.seekpct >= 0.0) {
            return;
        }
        Object object = this.on_the_way_lock;
        synchronized (object) {
            ++this.ios_on_the_way;
            if (print_seq_counts) {
                common.ptod("ios_on_the_way++: %-8s %4d %12d %8d ", cmd_entry.sd_ptr.sd_name, this.ios_on_the_way, cmd_entry.cmd_lba, cmd_entry.delta_tod);
            }
            ++this.ios_started;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subtract_io(Cmd_entry cmd_entry) {
        if (this.seekpct >= 0.0) {
            return;
        }
        Object object = this.on_the_way_lock;
        synchronized (object) {
            if (print_seq_counts) {
                common.ptod("ios_on_the_way--: %-8s %4d %12d %8d ", cmd_entry.sd_ptr.sd_name, this.ios_on_the_way, cmd_entry.cmd_lba, cmd_entry.delta_tod);
            }
            --this.ios_on_the_way;
            if (this.ios_on_the_way < 0L) {
                common.ptod("ios_on_the_way-1: %-8s %4d %12d delta: %8d ", cmd_entry.sd_ptr.sd_name, this.ios_on_the_way, cmd_entry.cmd_lba, cmd_entry.delta_tod);
                common.failure("negative i/o count");
            }
            if (this.ios_on_the_way == 0L && print_seq_counts) {
                common.ptod("Reached zero " + this.seq_eof + " " + Validate.isValidate());
                common.ptod("SlaveJvm.isReplay():      " + ReplayInfo.isReplay());
                common.ptod("Validate.isValidate():    " + Validate.isValidate());
                common.ptod("Validate.isCompression(): " + Validate.isCompression());
                common.ptod("seq_eof:                  " + this.seq_eof);
            }
            if (this.ios_on_the_way == 0L && this.seq_eof) {
                if (print_seq_counts) {
                    common.ptod("calling seq lower for1: " + this.wg_name);
                }
                this.sequentials_lower();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print_sizes() {
        Object object = common.ptod_lock;
        synchronized (object) {
            common.ptod("wd=" + this.wd_used.wd_name);
            common.ptod("Byte addresses for hits: Low: %,16d; High: %,16d; Width: %,16d", this.hcontext.seek_low, this.hcontext.seek_high, this.hcontext.seek_width);
            common.ptod("Byte addresses for miss: Low: %,16d; High: %,16d; Width: %,16d", this.mcontext.seek_low, this.mcontext.seek_high, this.mcontext.seek_width);
            common.ptod("sd max xfersize=" + this.sd_used.getMaxSdXfersize());
            common.ptod("hitarea_used: " + this.hitarea_used);
            common.ptod("hitarea: " + this.sd_used.hitarea);
            common.ptod("");
        }
    }

    public void calculateContext(RD_entry rD_entry, WD_entry wD_entry, SD_entry sD_entry) {
        int n = sD_entry.getMaxSdXfersize();
        if (sD_entry.end_lba == 0L) {
            common.failure("Unknown lun size for sd=" + sD_entry.sd_name);
        }
        double d = sD_entry.lowrange;
        double d2 = sD_entry.highrange;
        if (wD_entry.lowrange >= 0.0) {
            d = wD_entry.lowrange;
            d2 = wD_entry.highrange;
        }
        if (d < 0.0) {
            d = 0.0;
        }
        if (d2 < 0.0) {
            d2 = 100.0;
        }
        if (d >= d2) {
            common.failure("'range=' parameter. Second value must be higher than first value");
        }
        if (d < 100.0 && d2 < 200.0 && d2 > 100.0 && d2 - d >= 100.0) {
            common.failure("range=(%.0f,%.0f) may not have a total range of 100%% or more", d, d2);
        }
        if (d <= 100.0) {
            this.mcontext.seek_low = (long)((double)sD_entry.end_lba * d / 100.0) + this.hitarea_used;
            if (this.hitarea_used > 0L) {
                this.hcontext.seek_low = (long)((double)sD_entry.end_lba * d / 100.0);
            }
        }
        if (d > 100.0) {
            this.mcontext.seek_low = (long)d + this.hitarea_used;
            if (this.hitarea_used > 0L) {
                this.hcontext.seek_low = (long)d;
            }
        }
        if (d2 <= 200.0) {
            if (d2 > 100.0) {
                if (this.seekpct < 0.0) {
                    common.ptod("Greater than 100 value in range=(%.0f,%.0f) ignored when using seekpct=eof", d, d2);
                    d2 = 100.0;
                    common.ptod("Reset to range=(%.0f,%.0f)", d, d2);
                } else {
                    this.mcontext.crossing_range_boundary = true;
                }
            }
            this.mcontext.seek_high = (long)((double)sD_entry.end_lba * d2 / 100.0);
            if (this.hitarea_used > 0L) {
                this.hcontext.seek_high = this.hcontext.seek_low + this.hitarea_used;
            }
        }
        if (d2 > 200.0) {
            if (d2 > (double)sD_entry.end_lba) {
                common.failure("Requesting high seek range greater than lun size");
            }
            this.mcontext.seek_high = (long)d2;
            if (this.hitarea_used > 0L) {
                this.hcontext.seek_high = this.hcontext.seek_low + this.hitarea_used;
            }
        }
        if (!sD_entry.canWeUseBlockZero()) {
            if (this.mcontext.seek_low == 0L) {
                this.mcontext.seek_low = n;
            }
            if (this.hitarea_used != 0L && this.hcontext.seek_low == 0L) {
                this.hcontext.seek_low = n;
            }
        }
        if (!MiscParms.format_sds && wD_entry.wd_name.startsWith(SD_entry.SD_FORMAT_NAME)) {
            long l = 0x100000L;
            if (sD_entry.psize > 0L) {
                this.mcontext.seek_low = sD_entry.psize / l * l;
            }
        }
        this.mcontext.seek_width = this.mcontext.seek_high - this.mcontext.seek_low;
        this.hcontext.seek_width = this.hcontext.seek_high - this.hcontext.seek_low;
        if (this.mcontext.seek_width < (long)n) {
            this.size_error(this.mcontext);
        }
        this.mcontext.seek_low = ownmath.round_lower(this.mcontext.seek_low, n);
        this.mcontext.seek_high = ownmath.round_lower(this.mcontext.seek_high, n);
        this.hcontext.seek_low = ownmath.round_lower(this.hcontext.seek_low, n);
        this.hcontext.seek_high = ownmath.round_lower(this.hcontext.seek_high, n);
        this.mcontext.seek_low += sD_entry.offset;
        this.hcontext.seek_low += sD_entry.offset;
        this.mcontext.seek_width = this.mcontext.seek_high - this.mcontext.seek_low;
        this.hcontext.seek_width = this.hcontext.seek_high - this.hcontext.seek_low;
        if (sD_entry.offset > 0L && this.mcontext.seek_width < 0L) {
            common.failure("SD offset larger than available SD bytes");
        }
        if (this.mcontext.seek_width < (long)(n * 2) && !wD_entry.wd_name.startsWith(SD_entry.SD_FORMAT_NAME)) {
            this.size_error(this.mcontext);
        }
        if (this.hitarea_used > 0L && this.hcontext.seek_width < (long)(n * 2)) {
            this.size_error(this.hcontext);
        }
        if (Validate.isRealValidate() && !this.wd_used.wd_name.startsWith(SD_entry.SD_FORMAT_NAME)) {
            BoxPrint boxPrint;
            int n2 = rD_entry.getThreadsFromSdOrRd(sD_entry);
            int n3 = Fifo.getSizeNeeded(0);
            double d3 = rD_entry.use_waiter ? 2.0 : 1.0;
            int n4 = 256;
            long l = (long)((double)n3 * d3);
            l += (long)n4;
            long l2 = this.hcontext.seek_width / (long)n;
            long l3 = this.mcontext.seek_width / (long)n;
            if (l3 < (l += (long)n2)) {
                this.print_sizes();
                boxPrint = new BoxPrint();
                boxPrint.add("", new Object[0]);
                boxPrint.add("rd=%s %s", rD_entry.rd_name, rD_entry.current_override.getText());
                boxPrint.add("Data Validation has some extra SD size requirements. ", new Object[0]);
                boxPrint.add("The internal queue depth of Vdbench is %d for an uncontrolled maximum i/o rate, ", n3);
                boxPrint.add("and twice that, %d, for all other workloads.", n3 * 2);
                boxPrint.add("To that is added the number of threads requested (%d), ", n2);
                boxPrint.add("plus a fudge factor of %d, all for a total of %d.", n4, l);
                boxPrint.add("", new Object[0]);
                boxPrint.add("The SD size (or range) must be large enough to accomodate %d times the maximum xfersize=%d value,", l, n);
                boxPrint.add("for a total of %,d bytes (%s), but we only have %,d bytes (%s).", l * (long)n, FileAnchor.whatSize(l * (long)n), this.mcontext.seek_width, FileAnchor.whatSize(this.mcontext.seek_width));
                boxPrint.add("", new Object[0]);
                boxPrint.add("", new Object[0]);
                boxPrint.add("Why all this? To ensure Data Validation integrity each xfersize= block may have only ONE ", new Object[0]);
                boxPrint.add("read or write outstanding at the same time. Each block internally is therefore", new Object[0]);
                boxPrint.add("marked 'busy' with a dead-lock possible if ALL blocks are busy", new Object[0]);
                boxPrint.add("", new Object[0]);
                boxPrint.add("You may override the internal queue depth with 'misc=(fifo=nnn)', ", new Object[0]);
                boxPrint.add("though lower queue depth may throttle throughput at high i/o rates.", new Object[0]);
                boxPrint.add("", new Object[0]);
                boxPrint.print();
                common.failure("SD size for cache misses not large enough.");
            }
            if (this.hcontext.seek_width > 0L && l2 < l) {
                this.print_sizes();
                boxPrint = new BoxPrint();
                boxPrint.add("", new Object[0]);
                boxPrint.add("Data Validation has some extra SD size requirements. ", new Object[0]);
                boxPrint.add("The internal queue depth of Vdbench is %d for an uncontrolled maximum i/o rate, ", n3);
                boxPrint.add("and twice that, %d, for all other workloads.", n3 * 2);
                boxPrint.add("To that is added the number of threads requested (%d), ", n2);
                boxPrint.add("plus a fudge factor of %d, all for a total of %d.", n4, l);
                boxPrint.add("", new Object[0]);
                boxPrint.add("The hitarea must be large enough to accomodate %d times the maximum xfersize=%d value,", l, n);
                boxPrint.add("for a total of %,d bytes (%s), but we only have %,d bytes (%s).", l * (long)n, FileAnchor.whatSize(l * (long)n), this.hcontext.seek_width, FileAnchor.whatSize(this.hcontext.seek_width));
                boxPrint.add("", new Object[0]);
                boxPrint.add("", new Object[0]);
                boxPrint.add("Why all this? To ensure Data Validation integrity each xfersize= block may have only ONE ", new Object[0]);
                boxPrint.add("read or write outstanding at the same time. Each block internally is therefore", new Object[0]);
                boxPrint.add("marked 'busy' with a dead-lock possible if ALL blocks are busy", new Object[0]);
                boxPrint.add("", new Object[0]);
                boxPrint.add("You may override the internal queue depth with 'misc=(fifo=nnn)', ", new Object[0]);
                boxPrint.add("though lower queue depth may throttle throughput at high i/o rates.", new Object[0]);
                boxPrint.add("", new Object[0]);
                boxPrint.print();
                common.failure("SD size for cache hits not large enough");
            }
        }
        this.mcontext.max_xfersize = this.hcontext.max_xfersize = (long)n;
        this.hcontext.last_lba = this.hcontext.max_xfersize;
        this.mcontext.last_lba = this.hcontext.max_xfersize;
        if (common.get_debug(common.PRINT_SIZES)) {
            this.print_sizes();
        }
        if (this.mcontext.seek_width == 0L) {
            this.print_sizes();
            common.failure("SD size is rounded downward to a multiple of data transfer size. After rounding and subtracting of hitarea there is NO space left.");
        }
        if (this.mcontext.seek_high < this.mcontext.seek_low) {
            this.print_sizes();
            common.ptod("*\n*\n*\n*\n*");
            common.ptod("Negative seek range. Likely caused when asking for ");
            common.ptod("'rhpct=' or 'whpct=' control. In that case, the size ");
            common.ptod("of the SD (or range used) must be larger than the 'hitarea=' ");
            common.ptod("parameter used. The default for hitarea is 1MB.");
            common.failure("Negative seek range. ");
        }
    }

    static void wg_set_interarrival(ArrayList<WG_entry> arrayList, RD_entry rD_entry) {
        int n;
        double d = rD_entry.iorate;
        double d2 = 0.0;
        for (n = 0; n < arrayList.size(); ++n) {
            d2 += arrayList.get((int)n).wg_iorate;
        }
        d -= d2;
        d = Math.max(0.0, d);
        for (n = 0; n < arrayList.size(); ++n) {
            WG_entry wG_entry = arrayList.get(n);
            double d3 = d * wG_entry.skew / 100.0;
            wG_entry.arrival = wG_entry.wg_iorate == 0.0 ? 1000000.0 / d3 : 1000000.0 / wG_entry.wg_iorate;
            FifoList.countPriorities(arrayList);
            wG_entry.ts_offset = 100 * (n + 1);
            long l = !wG_entry.fixed_seed ? Native.get_simple_tod() * wG_entry.ts_offset : wG_entry.ts_offset;
            wG_entry.seek_randomizer = new Random(l);
            if (rD_entry.bursts == null) continue;
            wG_entry.bursts = new Bursts(rD_entry.bursts.getList(), rD_entry.bursts.isSpread());
            wG_entry.bursts.createBurstList(wG_entry.skew, rD_entry);
        }
    }

    public boolean wg_read_or_write() {
        if (this.readpct == 100.0) {
            return true;
        }
        if (this.readpct == 0.0) {
            return false;
        }
        return ownmath.zero_to_one() * 100.0 < this.readpct;
    }

    public boolean wg_random_or_seq(Cmd_entry cmd_entry) {
        if (this.seekpct <= 0.0) {
            return false;
        }
        if (this.seekpct == 100.0) {
            return true;
        }
        return ownmath.zero_to_one() * 100.0 < this.seekpct;
    }

    public synchronized boolean wg_get_next_seq(Cmd_entry cmd_entry, WG_context wG_context) {
        long l;
        if (wG_context.next_seq < 0L) {
            if (!this.seek_start0) {
                this.blockBoundarySeek(wG_context, cmd_entry);
                wG_context.next_seq = cmd_entry.cmd_lba;
            } else {
                wG_context.next_seq = wG_context.seek_low;
            }
        }
        if (wG_context.next_seq + cmd_entry.cmd_xfersize > wG_context.seek_high && (l = wG_context.seek_high - wG_context.next_seq) != 0L) {
            cmd_entry.cmd_xfersize = l;
        }
        if (wG_context.next_seq + cmd_entry.cmd_xfersize > wG_context.seek_high) {
            if (this.seekpct < 0.0) {
                return true;
            }
            wG_context.next_seq = wG_context.seek_low;
        }
        cmd_entry.cmd_lba = wG_context.next_seq;
        wG_context.next_seq += cmd_entry.cmd_xfersize;
        return false;
    }

    public boolean calculateNextLba(Cmd_entry cmd_entry) {
        if (Validate.isJournalRecoveryActive() && Validate.skipRead() && this.blocks_returned > 0L) {
            Vector<String> vector = BoxPrint.getOne("Re-reading of sd=%s after journal recovery skipped upon user's request after the first block.", this.sd_used.sd_name);
            SlaveJvm.sendMessageToConsole(vector);
            return true;
        }
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        long l6 = 0L;
        while (true) {
            if (l++ > 100000L) {
                common.ptod("reason1 block0:         %,8d", l2);
                common.ptod("reason2 block in error: %,8d", l3);
                common.ptod("reason3 read skipped:   %,8d", l4);
                common.ptod("reason4 block in error: %,8d", l5);
                common.ptod("reason5 busy failed:    %,8d", l6);
                common.failure("Loop protection in code that prevents lba=0 from being accessed. ");
            }
            WG_context wG_context = cmd_entry.cmd_hit ? this.hcontext : this.mcontext;
            cmd_entry.sd_ptr = this.sd_used;
            if (this.sd_used.concatenated_sd) {
                cmd_entry.concat_sd = this.sd_used;
            }
            if (!cmd_entry.cmd_rand) {
                if (this.wg_get_next_seq(cmd_entry, wG_context)) {
                    return true;
                }
            } else if (wG_context.hotband != null) {
                this.hotBandSeek(wG_context, cmd_entry);
            } else if (this.sd_used.align == 0L) {
                this.blockBoundarySeek(wG_context, cmd_entry);
            } else {
                this.alignBoundarySeek(wG_context, cmd_entry);
            }
            if (wG_context.crossing_range_boundary && cmd_entry.cmd_lba + cmd_entry.cmd_xfersize > this.sd_used.end_lba) {
                long l7 = ownmath.round_lower(this.sd_used.end_lba, cmd_entry.sd_ptr.getMaxSdXfersize());
                cmd_entry.cmd_lba -= l7;
                if (cmd_entry.cmd_lba < 0L) {
                    cmd_entry.cmd_lba = 0L;
                }
            }
            if (!this.access_block_zero && cmd_entry.cmd_lba == 0L) {
                ++l2;
                continue;
            }
            if (Validate.isRealValidate() && this.seekpct < 0.0 && this.readpct == 100.0) {
                if (this.key_map.storeDataBlockInfo(cmd_entry.cmd_lba, cmd_entry.cmd_xfersize, cmd_entry.sd_ptr.dv_map)) {
                    ++l3;
                    continue;
                }
                if (this.blocks_returned != 0L && !this.key_map.anyDataToCompare()) {
                    if (l4++ % 10000L == 0L && this.seek_eof_dv_read.go()) {
                        SlaveJvm.sendMessageToSummary("100%% seekpct=eof Data Validation read: looking for modified blocks to read", new Object[0]);
                    }
                    l = 0L;
                    continue;
                }
            }
            if (!Validate.isRealValidate()) break;
            if (this.key_map.storeDataBlockInfo(cmd_entry.cmd_lba, cmd_entry.cmd_xfersize, cmd_entry.sd_ptr.dv_map)) {
                ++l5;
                continue;
            }
            if (this.key_map.getKeysFromMapAndSetBusy(cmd_entry.cmd_lba, cmd_entry.cmd_xfersize)) break;
            ++l6;
        }
        ++this.blocks_returned;
        return false;
    }

    private void blockBoundarySeek(WG_context wG_context, Cmd_entry cmd_entry) {
        if (this.stride_min < 0L) {
            long l = wG_context.seek_width / cmd_entry.cmd_xfersize;
            if (this.poisson_midpoint == 0.0) {
                double d = this.seek_randomizer.nextDouble();
                long l2 = (long)(d * (double)l);
                cmd_entry.cmd_lba = wG_context.seek_low + l2 * cmd_entry.cmd_xfersize;
            } else {
                long l3 = ownmath.distPoisson(l, this.poisson_midpoint);
                cmd_entry.cmd_lba = wG_context.seek_low + l3 * cmd_entry.cmd_xfersize;
            }
        } else {
            if (wG_context.next_seq < 0L) {
                cmd_entry.cmd_lba = wG_context.seek_low;
                wG_context.next_seq = cmd_entry.cmd_lba + cmd_entry.cmd_xfersize;
                return;
            }
            long l = (this.stride_max - this.stride_min) / cmd_entry.cmd_xfersize;
            double d = this.seek_randomizer.nextDouble();
            l = (long)(d * (double)l);
            long l4 = l * cmd_entry.cmd_xfersize;
            cmd_entry.cmd_lba = wG_context.next_seq + this.stride_min + l4;
            if (cmd_entry.cmd_lba + cmd_entry.cmd_xfersize > wG_context.seek_high) {
                cmd_entry.cmd_lba = wG_context.seek_low;
            }
        }
        wG_context.next_seq = cmd_entry.cmd_lba + cmd_entry.cmd_xfersize;
    }

    private void alignBoundarySeek(WG_context wG_context, Cmd_entry cmd_entry) {
        if (this.stride_min < 0L) {
            long l = this.sd_used.align;
            long l2 = (wG_context.seek_width - cmd_entry.cmd_xfersize) / l;
            double d = this.seek_randomizer.nextDouble();
            l2 = (long)(d * (double)l2);
            cmd_entry.cmd_lba = wG_context.seek_low + l2 * l;
        } else {
            if (wG_context.next_seq < 0L) {
                wG_context.next_seq = wG_context.seek_low;
            }
            long l = this.sd_used.align;
            long l3 = (this.stride_max - this.stride_min) / l;
            double d = this.seek_randomizer.nextDouble();
            l3 = (long)(d * (double)l3);
            long l4 = l3 * l;
            cmd_entry.cmd_lba = wG_context.next_seq + this.stride_min + l4;
            if (cmd_entry.cmd_lba + cmd_entry.cmd_xfersize > wG_context.seek_high) {
                cmd_entry.cmd_lba = wG_context.seek_low;
            }
        }
        wG_context.next_seq = cmd_entry.cmd_lba + cmd_entry.cmd_xfersize;
    }

    public boolean wg_hit_or_miss(Cmd_entry cmd_entry) {
        double d = cmd_entry.cmd_read_flag ? this.rhpct : this.whpct;
        if (d == 0.0) {
            return false;
        }
        if (d == 100.0) {
            return true;
        }
        return ownmath.zero_to_one() * 100.0 < d;
    }

    public static int wg_dist_xfersize(double[] dArray, String string) {
        if (dArray.length == 1) {
            return (int)dArray[0];
        }
        if (dArray.length != 3) {
            double d = ownmath.zero_to_one() * 100.0;
            double d2 = 0.0;
            for (int i = 0; i < dArray.length; i += 2) {
                if (!(d < (d2 += dArray[i + 1]))) continue;
                return (int)dArray[i];
            }
            return (int)dArray[dArray.length - 2];
        }
        long l = (long)dArray[0];
        long l2 = (long)dArray[1];
        long l3 = (long)dArray[2];
        long l4 = (l2 - l) / l3;
        long l5 = (long)(ownmath.zero_to_one() * (double)(l4 + 1L));
        long l6 = l5 * l3 + l;
        return (int)l6;
    }

    public static void wg_start_sun_tasks(ArrayList<WG_entry> arrayList) {
        int n = 0;
        for (int i = 0; i < arrayList.size(); ++i) {
            long[] lArray;
            WG_entry wG_entry = arrayList.get(i);
            wG_entry.on_the_way_lock = new Object();
            if (ReplayInfo.isReplay() && (lArray = ReplayDevice.getDeviceNumbersForSd(wG_entry.sd_used.sd_name)).length == 0) {
                common.ptod("Bypassed starting of WG_task for sd=" + wG_entry.sd_used.sd_name);
                continue;
            }
            new WG_task(new Task_num("WG_task"), wG_entry).start();
            ++n;
            if (!common.get_debug(common.PTOD_WG_STUFF)) continue;
            common.plog("Starting Workload Generator thread %3d for %s,sd=%s,skew=%.3f", n, wG_entry.wd_name, wG_entry.sd_used.sd_name, wG_entry.skew);
        }
        common.plog("Started %d Workload Generator threads.", n);
        if (n == 0) {
            common.failure("Started %d Workload Generator threads.", n);
        }
    }

    public static void alloc_fifos(Work work) {
        int n = FifoList.countPriorities(work.wgs_for_slave);
        int n2 = Fifo.getSizeNeeded(n);
        Fifo.clearFifoVector();
        shared_fifo = new FifoList("shared_fifo", n2, n);
        if (work.use_waiter) {
            for (WG_entry cloneable : work.wgs_for_slave) {
                cloneable.fifo_to_wait = new Fifo("to_waiter_" + cloneable.sd_used.sd_name + "_" + cloneable.wd_name, n2);
            }
        }
        for (SD_entry sD_entry : SlaveWorker.sd_list) {
            if (!SlaveWorker.sharedThreads()) {
                sD_entry.fifo_to_iot = new FifoList("to_iot_" + sD_entry.sd_name, n2, n);
                sD_entry.fifo_to_iot.setThreadCount(work.getThreadsForSlave(sD_entry.sd_name));
                continue;
            }
            sD_entry.fifo_to_iot = shared_fifo;
        }
    }

    public static FifoList getSharedFifo() {
        return shared_fifo;
    }

    public static void free_fifos(Work work) {
        for (SD_entry cloneable : SlaveWorker.sd_list) {
            cloneable.fifo_to_iot = null;
        }
        for (WG_entry wG_entry : work.wgs_for_slave) {
            wG_entry.fifo_to_wait = null;
        }
    }

    public String[] getRealSdNames() {
        HashMap hashMap = new HashMap(16);
        if (!Validate.sdConcatenation()) {
            hashMap.put(this.sd_used.sd_name, null);
        } else {
            for (int i = 0; i < this.sds_in_concatenation.size(); ++i) {
                hashMap.put(this.sds_in_concatenation.get((int)i).sd_name, null);
            }
        }
        return hashMap.keySet().toArray(new String[0]);
    }

    public SD_entry[] getRealSds() {
        HashMap<String, SD_entry> hashMap = this.getRealSdMap();
        return hashMap.values().toArray(new SD_entry[0]);
    }

    public HashMap<String, SD_entry> getRealSdMap() {
        HashMap<String, SD_entry> hashMap = new HashMap<String, SD_entry>(16);
        if (!Validate.sdConcatenation()) {
            hashMap.put(this.sd_used.sd_name, this.sd_used);
        } else {
            for (int i = 0; i < this.sds_in_concatenation.size(); ++i) {
                hashMap.put(this.sds_in_concatenation.get((int)i).sd_name, this.sds_in_concatenation.get(i));
            }
        }
        return hashMap;
    }

    public static void main2(String[] stringArray) {
        long l = 4096L;
        long l2 = 0x40000000L;
        Random random = new Random(0L);
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 20L;
        long l6 = 5550000L;
        long l7 = 200L * l2;
        for (int i = 0; i < 10; ++i) {
            l3 = 0L;
            l4 = 0L;
            random = new Random(l6);
            int n = 0;
            while ((long)n < l5) {
                float f = random.nextFloat();
                System.out.println("float " + f);
                long l8 = l7 / l;
                l8 = (long)(f * (float)l8);
                long l9 = l8 * l;
                l3 = Math.max(l3, l9);
                l4 += l9;
                ++n;
            }
            long l10 = l4 / (long)n;
            l3 = 0L;
            l4 = 0L;
            random = new Random(l6);
            n = 0;
            while ((long)n < l5) {
                double d = random.nextDouble();
                System.out.println("doubl " + d);
                long l11 = l7 / l;
                l11 = (long)(d * (double)l11);
                long l12 = l11 * l;
                l3 = Math.max(l3, l12);
                l4 += l12;
                ++n;
            }
            long l13 = l4 / (long)n;
            l7 += 50L * l2;
        }
    }

    private void size_error(WG_context wG_context) {
        this.print_sizes();
        common.ptod("wd=" + this.wd_name + ": Lun space specified for either cache hits or cache misses (" + wG_context.seek_width + " bytes) must be at least twice the xfersize (" + this.sd_used.getMaxSdXfersize() + ")");
        common.ptod("Remember that the first block in a lun is never accessed, this to protect sector zero.");
        common.ptod("Please check the 'sd=nnn,size=xx,hitarea=' and 'wd=nnn,range=' parameters.");
        common.failure("Insufficient amount of lun size specified");
    }

    public static void overrideOpenflags(ArrayList<WG_entry> arrayList) {
        for (WG_entry wG_entry : arrayList) {
            if (wG_entry.wd_open_flags == null) continue;
            wG_entry.sd_used.open_flags = wG_entry.wd_open_flags;
        }
    }

    public void storeWorkloadParameters(RD_entry rD_entry) {
        this.readpct = this.wd_used.readpct;
        this.seekpct = this.wd_used.seekpct;
        this.seek_start0 = this.wd_used.seek_start0;
        this.poisson_midpoint = this.wd_used.poisson_midpoint;
        this.stride_min = this.wd_used.stride_min;
        this.stride_max = this.wd_used.stride_max;
        this.wd_name = this.wd_used.wd_name;
        this.rhpct = this.wd_used.rhpct;
        this.whpct = this.wd_used.whpct;
        if (this.stride_min >= 0L && this.seekpct <= 0.0) {
            common.failure("stride=(min,max) not supported when doing pure sequential I/O (seek=eof or seek=seq). Specify seek=nn");
        }
        this.setXfersizes(this.wd_used.xf_table);
        if (rD_entry.current_override != null) {
            For_loop.useForOverrides(this, rD_entry, rD_entry.current_override, this.sd_used, false);
        }
        if (rD_entry.rd_name.startsWith(SD_entry.SD_FORMAT_NAME)) {
            return;
        }
        if (ReplayInfo.isReplay()) {
            this.seekpct = -1.0;
        }
    }

    public static void adjustJvmCount(RD_entry rD_entry) {
        if (rD_entry.rd_name.startsWith(SD_entry.SD_FORMAT_NAME)) {
            return;
        }
        int n = 0;
        ArrayList<WG_entry> arrayList = Host.getAllWorkloads();
        for (int i = 0; i < SlaveList.getSlaveCount(); ++i) {
            Slave slave = SlaveList.getSlaveList().elementAt(i);
            double d = 0.0;
            for (WG_entry wG_entry : arrayList) {
                if (!wG_entry.slave.getHost().getLabel().equals(slave.getHost().getLabel())) continue;
                d += wG_entry.skew;
            }
            double d2 = rD_entry.iorate_req * d / 100.0;
            if (!(d2 > (double)RD_entry.IOS_PER_JVM)) continue;
            int n2 = (int)Math.min((d2 + (double)RD_entry.IOS_PER_JVM - 1.0) / (double)RD_entry.IOS_PER_JVM, (double)RD_entry.DEFAULT_JVMS);
            if ((n2 = Math.min(n2, slave.getHost().getLunCount())) <= slave.getHost().getJvmCount()) continue;
            if (n++ == 0) {
                common.ptod("");
            }
            common.ptod("Adjusted default JVM count for host=%s from jvms=%d to jvms=%d because of iorate=%s and a total of %d sds.", slave.getHost().getLabel(), slave.getHost().getJvmCount(), n2, rD_entry.iorate_req == (double)RD_entry.MAX_RATE ? "max" : Integer.valueOf((int)d2), slave.getHost().getLunCount());
            slave.getHost().setJvmCount(n2);
            Host.createSlaves();
        }
        if (n > 0) {
            common.ptod("");
        }
    }

    private static void printWgList(String string, Vector vector) {
        common.ptod("");
        for (int i = 0; i < vector.size(); ++i) {
            WG_entry wG_entry = (WG_entry)vector.elementAt(i);
            common.ptod(wG_entry);
        }
    }

    public String report(RD_entry rD_entry) {
        String string = String.format("slv=%%-%ds ", Slave.max_slave_name);
        String string2 = String.format("wd=%%-%ds ", WD_entry.max_wd_name);
        String string3 = String.format("sd=%%-%ds ", SD_entry.max_sd_name);
        if (!rD_entry.areWeSharingThreads()) {
            return String.format("   " + string + string2 + string3 + "rdpct=%3d " + "seek=%3d " + "rh=%3d " + "skew=%7.3f " + "th=%d ", this.slave.getLabel(), this.wd_name, this.sd_used.sd_name, (int)this.readpct, (int)this.seekpct, (int)this.rhpct, this.skew, rD_entry.getSdThreadsUsedForSlave(this.sd_used.sd_name, this.slave));
        }
        return String.format("   " + string + string2 + string3 + "rdpct=%3d " + "seek=%3d " + "skew=%7.3f ", this.slave.getLabel(), this.wd_name, this.sd_used.sd_name, (int)this.readpct, (int)this.seekpct, this.skew);
    }

    public static void main(String[] stringArray) {
        int n;
        double[] dArray = new double[]{4096.0, 32768.0, 4096.0};
        int[] nArray = new int[9];
        for (n = 0; n < Integer.parseInt(stringArray[0]); ++n) {
            int n2;
            int n3 = WG_entry.wg_dist_xfersize(dArray, "xxx");
            int n4 = n2 = n3 / 4096;
            nArray[n4] = nArray[n4] + 1;
        }
        for (n = 0; n < nArray.length; ++n) {
            common.ptod("xfersize: %5d, count: %5d", n * 4096, nArray[n]);
        }
    }

    public boolean hasPriority() {
        return this.priority != Integer.MAX_VALUE;
    }

    public void setPriority(int n) {
        this.priority = n;
    }

    public int getpriority() {
        return this.priority;
    }

    public void setSlave(Slave slave) {
        this.slave = slave;
    }

    public Slave getSlave() {
        return this.slave;
    }

    public void setupHotBand() {
        this.mcontext.hotband = new HotBand(this.mcontext.seek_width);
    }

    private void hotBandSeek(WG_context wG_context, Cmd_entry cmd_entry) {
        long l = wG_context.hotband.get_rec_index((int)cmd_entry.cmd_xfersize, cmd_entry.cmd_read_flag);
        long l2 = l * cmd_entry.cmd_xfersize;
        cmd_entry.cmd_lba = wG_context.seek_low + l2;
        if (cmd_entry.cmd_lba + cmd_entry.cmd_xfersize > wG_context.seek_high) {
            common.ptod("sd:     " + this.sd_used.sd_name);
            common.ptod("block:  " + l);
            common.ptod("offset: " + l2);
            cmd_entry.cmd_print("hotband seek");
            this.print_sizes();
            common.failure("Invalid HotBand seek address");
        }
        wG_context.next_seq = cmd_entry.cmd_lba + cmd_entry.cmd_xfersize;
    }

    public void setXfersizes(double[] dArray) {
        this.xf_table = dArray;
    }

    public double[] getXfersizes() {
        return this.xf_table;
    }

    public boolean obsolete_mustRunOnSingleSlave() {
        if (this.wd_used.stream_count != 0) {
            return false;
        }
        if (common.get_debug(common.PLOG_WG_STUFF)) {
            common.ptod("mustRunOnSingleSlave: dv=%b seek=%d", Validate.isValidate(), (int)this.seekpct);
        }
        return Validate.isRealValidate() || this.seekpct <= 0.0 || ReplayInfo.isReplay();
    }

    public boolean obsolete_mustStayOnSingleSlave() {
        if (common.get_debug(common.PLOG_WG_STUFF)) {
            common.ptod("mustStayOnSingleSlave: dv=%b ", Validate.isRealValidate());
        }
        return Validate.isRealValidate();
    }

    public static ArrayList<WG_entry> sortWorkloads(ArrayList<WG_entry> arrayList, String string) {
        sort_by = string;
        Collections.sort(arrayList);
        return arrayList;
    }

    public int compareTo(Object object) {
        int n = 0;
        WG_entry wG_entry = (WG_entry)object;
        if (sort_by.equals("slave") && this.slave != null && wG_entry.slave != null) {
            n = this.slave.getHost().relative_hostno - wG_entry.slave.getHost().relative_hostno;
            if (n != 0) {
                return n;
            }
            n = this.slave.getLabel().compareTo(wG_entry.slave.getLabel());
            if (n != 0) {
                return n;
            }
            n = this.wd_name.compareTo(wG_entry.wd_name);
            if (n != 0) {
                return n;
            }
            n = this.sd_used.sd_name.compareTo(wG_entry.sd_used.sd_name);
            if (n != 0) {
                return n;
            }
            return 0;
        }
        if (sort_by.equals("wd")) {
            n = this.wd_name.compareTo(wG_entry.wd_name);
            if (n != 0) {
                return n;
            }
            n = this.sd_used.sd_name.compareTo(wG_entry.sd_used.sd_name);
            if (n != 0) {
                return n;
            }
            n = this.slave.getHost().relative_hostno - wG_entry.slave.getHost().relative_hostno;
            if (n != 0) {
                return n;
            }
            n = this.slave.getLabel().compareTo(wG_entry.slave.getLabel());
            if (n != 0) {
                return n;
            }
            return 0;
        }
        if (sort_by.equals("sd")) {
            n = this.sd_used.sd_name.compareTo(wG_entry.sd_used.sd_name);
            if (n != 0) {
                return n;
            }
            n = this.wd_name.compareTo(wG_entry.wd_name);
            if (n != 0) {
                return n;
            }
            n = this.slave.getHost().relative_hostno - wG_entry.slave.getHost().relative_hostno;
            if (n != 0) {
                return n;
            }
            n = this.slave.getLabel().compareTo(wG_entry.slave.getLabel());
            if (n != 0) {
                return n;
            }
            return 0;
        }
        common.failure("Invalid sort key: " + sort_by);
        return 0;
    }
}

