/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import User.ControlUsers;
import User.WorkloadInfo;
import Vdb.Cmd_entry;
import Vdb.ConcatLbaSearch;
import Vdb.DV_map;
import Vdb.ErrorLog;
import Vdb.FifoList;
import Vdb.KeyMap;
import Vdb.ReplayInfo;
import Vdb.SD_entry;
import Vdb.SlaveWorker;
import Vdb.Task_num;
import Vdb.ThreadMonitor;
import Vdb.Validate;
import Vdb.WG_entry;
import Vdb.common;
import Vdb.ownmath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

public class WG_task
extends Thread {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";
    private WG_entry wg;
    private int distribution;
    private Task_num tn;
    private Cmd_entry cmd;
    private double start_ts;
    private boolean read_only;
    private boolean use_waiter;
    private boolean sd_concatenation;
    private boolean user_generate_needed = false;
    private boolean shared_threads = false;
    private ThreadMonitor tmonitor = null;
    private DV_map dv_map = null;
    private HashMap<Long, Byte> pending_data_map = null;
    private ArrayList<Long> pending_lbas = null;

    public WG_task(Task_num task_num, WG_entry wG_entry) {
        this.wg = wG_entry;
        this.distribution = SlaveWorker.work.distribution;
        this.tn = task_num;
        this.tn.task_set_start_pending();
        this.read_only = this.wg.readpct == 100.0;
        this.use_waiter = SlaveWorker.work.use_waiter;
        this.wg.lba_search_key = new SD_entry();
        this.wg.search_method = new ConcatLbaSearch();
        this.shared_threads = SlaveWorker.sharedThreads();
        this.setName("WG_task " + this.wg.wg_name);
        this.wg.access_block_zero = this.wg.sd_used.canWeUseBlockZero();
        if (common.get_debug(common.FAST_JOURNAL_CHECK)) {
            common.failure("debug=110 no longer supported");
        }
        if (Validate.isRealValidate()) {
            this.dv_map = this.wg.sd_used.dv_map;
            this.wg.key_map = new KeyMap(0L, this.wg.sd_used.getKeyBlockSize(), this.wg.sd_used.getMaxSdXfersize());
        }
        if (this.wg.user_class_parms != null) {
            this.setupUserClass();
        }
        if (this.wg.hotband_used) {
            this.wg.setupHotBand();
        }
        if (Validate.isJournalRecoveryActive() && this.dv_map.journal.before_map.pending_map != null) {
            this.pending_data_map = this.dv_map.journal.before_map.pending_map;
            this.pending_lbas = new ArrayList<Long>(this.pending_data_map.keySet());
            Collections.sort(this.pending_lbas);
        }
    }

    @Override
    public void run() {
        int n = FifoList.countPriorities(SlaveWorker.work.wgs_for_slave);
        this.sd_concatenation = Validate.sdConcatenation();
        try {
            Thread.currentThread().setPriority(10);
            this.tmonitor = new ThreadMonitor("WG_task", this.wg.wd_name, this.wg.sd_used.sd_name);
            this.tn.task_set_start_complete();
            this.tn.waitForMasterGo();
            this.start_ts = this.calculateFirstStartTime();
            if (this.user_generate_needed) {
                if (this.wg.user_class.generate()) {
                    this.sendEOF();
                }
                this.tn.task_set_terminating(0.0);
                return;
            }
            if (this.wg.bursts != null) {
                this.start_ts = this.wg.bursts.getArrivalTime(this.start_ts, this.distribution);
            }
            this.cmd = new Cmd_entry();
            while (true) {
                if (this.pending_lbas != null && this.pending_lbas.size() > 0) {
                    this.createPendingRead();
                } else if (!this.createNormalIO()) {
                    this.sendEOF();
                    break;
                }
                this.wg.add_io(this.cmd);
                try {
                    if (this.use_waiter) {
                        this.wg.fifo_to_wait.waitAndPut(this.cmd);
                    } else {
                        this.cmd.sd_ptr.fifo_to_iot.waitAndPut(this.cmd, this.wg.getpriority());
                    }
                    this.tmonitor.add1();
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
                this.start_ts = this.calculateNextStartTime(this.start_ts);
                this.cmd = new Cmd_entry();
            }
            this.sendEOF();
        }
        catch (Throwable throwable) {
            common.abnormal_term(throwable);
        }
        this.tn.task_set_terminating(0.0);
    }

    private double calculateFirstStartTime() {
        double d = this.distribution == 0 ? ownmath.exponential(this.wg.arrival) : (this.distribution == 1 ? ownmath.uniform(0.0, this.wg.arrival * 2.0) : (double)(this.wg.ts_offset + 100000L));
        return d;
    }

    private double calculateNextStartTime(double d) {
        if (this.wg.bursts != null) {
            d = this.wg.bursts.getArrivalTime(this.start_ts, this.distribution);
            return d;
        }
        if (this.distribution == 0) {
            double d2 = ownmath.exponential(this.wg.arrival);
            if (d2 > 1.8E8) {
                d2 = 1.8E8;
            }
            d += d2;
        } else if (this.distribution == 1) {
            double d3 = ownmath.uniform(0.0, this.wg.arrival * 2.0);
            d += d3;
            if (d3 > 1000000.0) {
                d3 = 1000000.0;
            }
        } else {
            d += this.wg.arrival;
        }
        return d;
    }

    private boolean createNormalIO() {
        this.cmd.cmd_wg = this.wg;
        this.cmd.jni_index = this.wg.jni_index_list.get((int)0).jni_index;
        this.cmd.cmd_read_flag = this.read_only ? true : this.wg.wg_read_or_write();
        this.cmd.delta_tod = (long)this.start_ts;
        this.cmd.cmd_xfersize = WG_entry.wg_dist_xfersize(this.wg.getXfersizes(), this.wg.wd_name);
        this.cmd.cmd_hit = this.wg.wg_hit_or_miss(this.cmd);
        this.cmd.cmd_rand = this.wg.wg_random_or_seq(this.cmd);
        if (this.wg.calculateNextLba(this.cmd)) {
            this.wg.seq_eof = true;
            common.ptod("Reached eof in wg_task");
            if (this.wg.ios_on_the_way == 0L && (ReplayInfo.isReplay() || Validate.isValidate())) {
                common.ptod("calling seq lower for2: " + this.wg.wg_name);
                this.wg.sequentials_lower();
            }
            return false;
        }
        return !Thread.interrupted();
    }

    private void createPendingRead() {
        this.cmd.cmd_wg = this.wg;
        this.cmd.jni_index = this.wg.jni_index_list.get((int)0).jni_index;
        this.cmd.cmd_read_flag = true;
        this.cmd.cmd_hit = false;
        this.cmd.delta_tod = (long)this.start_ts;
        this.cmd.cmd_rand = true;
        this.cmd.sd_ptr = this.wg.sd_used;
        this.cmd.type_of_dv_read = Validate.FLAG_PENDING_READ;
        this.cmd.cmd_xfersize = this.dv_map.getKeyBlockSize();
        this.cmd.cmd_lba = this.pending_lbas.get(0);
        this.pending_lbas.remove(0);
        if (this.dv_map.getKeyAndSetBusy(this.cmd.cmd_lba) == 127) {
            common.failure("Invalid journal recovery pending status");
        }
        ErrorLog.plog("Requesting read of pending key block at lba 0x%08x key 0x%02x flag 0x%02x", this.cmd.cmd_lba, this.dv_map.dv_get(this.cmd.cmd_lba) & 0x7F, this.pending_data_map.get(this.cmd.cmd_lba));
        common.ptod("Requesting read of pending key block at lba 0x%08x key 0x%02x flag 0x%02x", this.cmd.cmd_lba, this.dv_map.dv_get(this.cmd.cmd_lba) & 0x7F, this.pending_data_map.get(this.cmd.cmd_lba));
    }

    private void sendEOF() {
        try {
            Cmd_entry cmd_entry = new Cmd_entry();
            cmd_entry.sd_ptr = this.wg.sd_used;
            cmd_entry.delta_tod = Long.MAX_VALUE;
            if (this.use_waiter) {
                if (this.wg.fifo_to_wait.getPutCount() == 0L) {
                    common.failure("Sending EOF to work fifo for sd=%s without any work ever having been scheduled", this.wg.sd_used.sd_name);
                }
                this.wg.fifo_to_wait.waitAndPut(cmd_entry);
            } else {
                cmd_entry.sd_ptr.fifo_to_iot.waitAndPut(cmd_entry, this.wg.getpriority());
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void setupUserClass() {
        WorkloadInfo workloadInfo = new WorkloadInfo(this.wg);
        workloadInfo.setFirstStartDelta((long)this.calculateFirstStartTime());
        this.wg.user_class = ControlUsers.createInstance(this.wg);
        this.wg.user_class.setWorkloadInfo(workloadInfo);
        workloadInfo.setDeviceInfo(this.wg.user_class.initialize(workloadInfo));
        this.user_generate_needed = this.wg.user_class.isGenerateNeeded();
    }
}

