/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Vdb.BucketRanges;
import Vdb.DV_map;
import Vdb.Debug_cmds;
import Vdb.Dedup;
import Vdb.FileAnchor;
import Vdb.For_loop;
import Vdb.FormatFlags;
import Vdb.FsdEntry;
import Vdb.FwgEntry;
import Vdb.HandleSkew;
import Vdb.Host;
import Vdb.MiscParms;
import Vdb.OpenFlags;
import Vdb.Patterns;
import Vdb.RD_entry;
import Vdb.ReplayInfo;
import Vdb.SD_entry;
import Vdb.Slave;
import Vdb.SlaveJvm;
import Vdb.SlaveList;
import Vdb.StreamContext;
import Vdb.Validate;
import Vdb.Vdbmain;
import Vdb.WG_entry;
import Vdb.common;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;

public class Work
implements Serializable {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";
    public transient RD_entry rd;
    public String work_rd_name;
    public String rd_mount;
    public String slave_label;
    public int slave_count;
    public int slave_number;
    public String host_label;
    private HashMap<String, String> luns_on_host = null;
    public boolean use_waiter;
    public ArrayList<WG_entry> wgs_for_slave;
    public int sequential_files;
    public int distribution;
    public OpenFlags rd_open_flags;
    public Vector instance_pointers;
    public Vector<FwgEntry> fwgs_for_slave;
    public boolean format_run;
    public FormatFlags format_flags;
    public double fwd_rate;
    public int maximum_xfersize;
    public ReplayInfo replay_info;
    public Validate validate_options;
    public Patterns pattern_options;
    public boolean journal;
    public boolean only_eof_writes;
    public boolean nw_monitor_needed;
    public boolean nw_monitor_now;
    public boolean force_fsd_cleanup = false;
    public Debug_cmds rd_start_command;
    public Debug_cmds rd_end_command;
    public ArrayList<String[]> miscellaneous;
    public boolean keep_controlfile = false;
    private HashMap<String, ArrayList<StreamContext>> threads_for_slave_map;
    public int threads_from_rd = 0;
    public HashMap bucket_types;

    public Vector convertWgListToSdList() {
        HashMap<String, SD_entry> hashMap = new HashMap<String, SD_entry>(8);
        for (int i = 0; i < this.wgs_for_slave.size(); ++i) {
            WG_entry wG_entry = this.wgs_for_slave.get(i);
            SD_entry sD_entry = wG_entry.sd_used;
            hashMap.put(sD_entry.sd_name, sD_entry);
            sD_entry.lun = this.getLunNameForSd(sD_entry);
            if (!sD_entry.concatenated_sd && sD_entry.lun == null) {
                common.failure("convertWgListToSdList: null lun");
            }
            if (sD_entry.concatenated_sd) {
                for (SD_entry sD_entry2 : sD_entry.sds_in_concatenation) {
                    sD_entry2.lun = this.getLunNameForSd(sD_entry2);
                    if (sD_entry2.lun != null) continue;
                    common.ptod("convertWgListToSdList: null lun");
                }
            }
            sD_entry.wg_for_sd = wG_entry;
        }
        return new Vector(hashMap.values());
    }

    public String getLunNameForSd(SD_entry sD_entry) {
        String string = this.luns_on_host.get(sD_entry.sd_name);
        if (string == null) {
            if (!sD_entry.concatenated_sd && sD_entry.lun == null) {
                common.failure("getLunNameForSd: null sd.lun");
            }
            return sD_entry.lun;
        }
        return string;
    }

    public static void prepareWorkForSlaves(RD_entry rD_entry, boolean bl) {
        if (Vdbmain.isWdWorkload()) {
            HandleSkew.spreadWdSkew(rD_entry);
            HandleSkew.spreadWgSkew(rD_entry);
            HandleSkew.calcLeftoverWgSkew(rD_entry);
            Work.prepareWgWork(rD_entry, bl);
            if (bl) {
                rD_entry.spreadStreamsAcrossSlaves(true);
            }
        } else {
            Work.prepareFwgWork(rD_entry, bl);
        }
    }

    private static void reportStuff(RD_entry rD_entry) {
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        HashMap<SD_entry, Long> hashMap = new HashMap<SD_entry, Long>(8);
        for (Slave object : SlaveList.getSlaveList()) {
            Work work = object.getCurrentWork();
            SD_entry[] sD_entryArray = work.getSdsForRun();
            int n = sD_entryArray.length;
            for (int i = 0; i < n; ++i) {
                SD_entry sD_entry = sD_entryArray[i];
                long l5 = sD_entry.getMaxSdXfersize();
                if (Validate.sdConcatenation() && work.threads_from_rd != 0) {
                    l5 = work.maximum_xfersize;
                }
                hashMap.put(sD_entry, l5);
            }
        }
        for (SD_entry sD_entry : hashMap.keySet()) {
            long l6 = (Long)hashMap.get(sD_entry);
            l += sD_entry.end_lba;
            l3 += sD_entry.end_lba / l6;
        }
        for (Slave slave : SlaveList.getSlaveList()) {
            slave.getCurrentWork();
            for (SD_entry sD_entry : Work.getSdsForRun()) {
                int n = rD_entry.getSdThreadsUsedForSlave(sD_entry.sd_name, slave);
                l2 += (long)n;
                l4 += (Long)hashMap.get(sD_entry) * (long)n * 2L;
            }
        }
        common.ptod("total_size:    %,12d ", l);
        common.ptod("total_threads: %,12d ", l2);
        common.ptod("key_blocks:    %,12d ", l3);
        common.ptod("buffers:       %,12d ", l4);
        long l7 = l3 / 8L;
        if (!Validate.isValidate()) {
            common.ptod("Estimated non-java memory needs for rd=%s: %,d bytes or %.3f mb", rD_entry.rd_name, l4, (double)l4 / 1048576.0);
        } else {
            common.ptod("Estimated non-java memory needs for rd=%s: %,d bytes or %.3f mb", rD_entry.rd_name, l3 + l4, (double)l3 + (double)l4 / 1048576.0);
        }
    }

    private static void prepareWgWork(RD_entry rD_entry, boolean bl) {
        int n = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        HashMap hashMap = new HashMap(16);
        SD_entry.clearAllActive();
        for (SD_entry iterator : Vdbmain.sd_list) {
            iterator.format_inserted = false;
            iterator.pure_rand_seq = false;
            iterator.work_done = false;
            HashMap<Slave, Object> hashMap2 = new HashMap<Slave, Object>(32);
            for (WG_entry wG_entry : Host.getAllWorkloads()) {
                if (wG_entry.sd_used != iterator) continue;
                hashMap2.put(wG_entry.getSlave(), null);
                if (wG_entry.seekpct == 100.0 || wG_entry.seekpct <= 0.0) {
                    iterator.pure_rand_seq = true;
                }
                if (iterator.concatenated_sd) {
                    bl3 = true;
                }
                if (rD_entry.rd_stream_count == 0) continue;
                bl2 = true;
            }
        }
        if (bl2 && bl3 && rD_entry.current_override.getThreads() != For_loop.NOVALUE && !bl) {
            common.ptod("Shared threads requested with SD concatenation SHARES all threads.");
            common.ptod("The 'streams=' parameter DEDICATES threads.");
            common.ptod("To resolve this contradiction threads will not be shared but will be dedicated to each stream.");
        }
        WG_entry.wg_set_interarrival(Host.getAllWorkloads(), rD_entry);
        for (Slave slave : SlaveList.getSlaveList()) {
            slave.setCurrentWork(null);
            slave.writes = 0L;
            slave.reads = 0L;
        }
        int n2 = 0;
        for (Slave slave : SlaveList.getSlaveList()) {
            for (WG_entry wG_entry : Host.getAllWorkloads()) {
                if (wG_entry.getSlave() != slave) continue;
                wG_entry.wd_used.total_io_done = 0L;
                ++n2;
                if (wG_entry.sd_used.concatenated_sd) {
                    for (SD_entry sD_entry : wG_entry.sd_used.sds_in_concatenation) {
                        sD_entry.lun = wG_entry.getSlave().getHost().getLunNameForSd(sD_entry);
                        hashMap.put(sD_entry, null);
                    }
                } else {
                    wG_entry.sd_used.setActive();
                    hashMap.put(wG_entry.sd_used, null);
                }
                if (!rD_entry.rd_name.startsWith(SD_entry.SD_FORMAT_NAME)) continue;
                wG_entry.sd_used.format_inserted = true;
            }
        }
        if (Dedup.isDedup() && hashMap.size() != SD_entry.getRealSds(Vdbmain.sd_list).length) {
            common.failure("rd=%s: All SDs must be used when dedup is active. %d/%d", rD_entry.rd_name, hashMap.size(), Vdbmain.sd_list.size());
        }
        if (Host.getAllWorkloads().size() != n2) {
            common.failure("Unmatched WG_entry count: " + Host.getAllWorkloads().size() + "/" + n2);
        }
        boolean bl4 = false;
        for (Slave slave : SlaveList.getSlaveList()) {
            slave.setSequentialDone(true);
            if (slave.getWorkloads().size() <= 0) continue;
            Work work = new Work();
            work.slave_label = slave.getLabel();
            work.host_label = slave.getHost().getLabel();
            work.luns_on_host = slave.getHost().getHostLunMap();
            work.rd = rD_entry;
            work.work_rd_name = rD_entry.rd_name;
            work.rd_mount = rD_entry.rd_mount;
            work.use_waiter = rD_entry.use_waiter;
            work.threads_for_slave_map = rD_entry.getThreadsPerSlaveMap();
            work.threads_from_rd = 0;
            if (bl3 && !bl2 && rD_entry.current_override.getThreads() != For_loop.NOVALUE) {
                boolean bl5;
                work.threads_from_rd = (int)rD_entry.current_override.getThreads() / SlaveList.getSlaveList().size();
                if (!bl5 && bl) {
                    bl5 = true;
                    common.ptod("SD Concatenation: rd=%s,threads=%d: each slave gets %d threads", rD_entry.rd_name, (int)rD_entry.current_override.getThreads(), work.threads_from_rd);
                }
            }
            work.bucket_types = BucketRanges.getBucketTypes();
            work.distribution = rD_entry.distribution;
            work.rd_open_flags = rD_entry.open_flags;
            work.wgs_for_slave = slave.getWorkloads();
            work.validate_options = Validate.getOptions();
            work.pattern_options = Patterns.getOptions();
            Validate.setCompressionRatio(rD_entry.compression_ratio_to_use);
            work.maximum_xfersize = SD_entry.getAllSdMaxXfersize();
            Validate.setCompSeed(DV_map.compression_seed);
            work.sequential_files = slave.sequentialFilesOnSlave();
            work.only_eof_writes = rD_entry.checkForSequentialWritesOnly();
            work.rd_start_command = rD_entry.start_cmd;
            work.rd_end_command = rD_entry.end_cmd;
            work.miscellaneous = MiscParms.getMiscellaneous();
            work.replay_info = ReplayInfo.getInfo();
            if (ReplayInfo.isReplay()) {
                slave.setSequentialDone(false);
            } else {
                slave.setSequentialDone(work.sequential_files < 0);
            }
            if (slave.equals(slave.getHost().getFirstSlave()) && slave.getHost().getHostInfo().isSolaris()) {
                work.instance_pointers = slave.getHost().getHostInfo().getInstancePointers();
            }
            slave.setCurrentWork(work);
            ++n;
        }
        if (n == 0) {
            common.failure("prepareWgWork(): no work created for any slave");
        }
        if (bl2 && rD_entry.iorate_req != (double)RD_entry.MAX_RATE) {
            common.failure("Use of the streams= parameter requires iorate=max");
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void prepareFwgWork(RD_entry rD_entry, boolean bl) {
        void var7_12;
        Object object;
        Object object2;
        Vector<Slave> vector = SlaveList.getSlaveList();
        int[] nArray = new int[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            object2 = vector.elementAt(i);
            ((Slave)object2).setCurrentWork(null);
        }
        Vector<FileAnchor> vector2 = FileAnchor.getAnchorList();
        object2 = new HashMap(32);
        for (FwgEntry object3 : rD_entry.fwgs_for_rd) {
            object = (String)((HashMap)object2).get(object3.anchor.getAnchorName());
            if (object == null) {
                ((HashMap)object2).put(object3.anchor.getAnchorName(), object3.fsd_name);
                continue;
            }
            if (((String)object).equals(object3.fsd_name)) continue;
            common.failure("Concurrent use of anchor=%s using multiple FSDs (%s/%s) in one RD is not allowed.", object3.anchor.getAnchorName(), object, object3.fsd_name);
        }
        for (FsdEntry fsdEntry : FsdEntry.getFsdList()) {
            fsdEntry.in_use = false;
        }
        vector2 = FileAnchor.getAnchorList();
        HashMap hashMap = new HashMap(32);
        boolean bl2 = false;
        while (var7_12 < vector2.size()) {
            object = vector2.elementAt((int)var7_12);
            for (int i = 99990; i < rD_entry.fwgs_for_rd.size(); ++i) {
                FwgEntry fwgEntry = rD_entry.fwgs_for_rd.elementAt(i);
                common.ptod("===fwg: " + fwgEntry.getName() + " " + fwgEntry.fsd_name + " " + fwgEntry.anchor.getAnchorName());
            }
            Vector<FwgEntry> vector3 = new Vector<FwgEntry>(8, 0);
            for (int i = 0; i < rD_entry.fwgs_for_rd.size(); ++i) {
                FwgEntry fwgEntry = rD_entry.fwgs_for_rd.elementAt(i);
                hashMap.put(fwgEntry.anchor, null);
                fwgEntry.work_done = false;
                FsdEntry.findFsd((String)fwgEntry.fsd_name).in_use = true;
                if (fwgEntry.anchor == object) {
                    vector3.add(fwgEntry);
                }
                fwgEntry.anchor.filesizes = fwgEntry.filesizes;
                if (fwgEntry.target_anchor == null) continue;
                fwgEntry.target_anchor.depth = ((FileAnchor)object).depth;
                fwgEntry.target_anchor.width = ((FileAnchor)object).width;
                fwgEntry.target_anchor.files = ((FileAnchor)object).files;
                fwgEntry.target_anchor.total_size = ((FileAnchor)object).total_size;
                fwgEntry.target_anchor.filesizes = ((FileAnchor)object).filesizes;
            }
            if (vector3.size() != 0) {
                String[] stringArray = Work.getHostsUsingAnchor(vector3);
                for (int i = 0; i < stringArray.length; ++i) {
                    String string = stringArray[i];
                    Vector<Slave> vector4 = new Vector<Slave>(8, 0);
                    for (int j = 0; j < vector.size(); ++j) {
                        Slave slave = vector.elementAt(j);
                        if (!slave.getHost().getLabel().equalsIgnoreCase(string)) continue;
                        vector4.add(slave);
                    }
                    Slave slave = (Slave)vector4.firstElement();
                    for (int j = 0; j < vector4.size(); ++j) {
                        Slave slave2 = (Slave)vector4.elementAt(j);
                        if (slave2.getCurrentFwgWorkSize() >= slave.getCurrentFwgWorkSize()) continue;
                        slave = slave2;
                    }
                    if (Validate.isRealValidate()) {
                        for (Slave slave3 : vector4) {
                            for (String string2 : slave3.getAnchorsUsed()) {
                                if (!((FileAnchor)object).getAnchorName().equals(string2)) continue;
                                slave = slave3;
                            }
                        }
                    }
                    for (FwgEntry fwgEntry : vector3) {
                        slave.addAnchorName(fwgEntry.anchor.getAnchorName());
                    }
                    SlaveList.AddFwgsToSlave(slave, vector3, rD_entry, bl);
                }
            }
            ++var7_12;
        }
        SlaveList.adjustSkew();
        if (Dedup.isDedup() && hashMap.size() != vector2.size()) {
            common.failure("All anchors must be used when dedup is active.");
        }
        if (Dedup.isDedup()) {
            Dedup.adjustFsdDedupValues(rD_entry.fwgs_for_rd);
        }
    }

    private static String[] getHostsUsingAnchor(Vector vector) {
        HashMap<String, String> hashMap = new HashMap<String, String>(16);
        for (int i = 0; i < vector.size(); ++i) {
            FwgEntry fwgEntry = (FwgEntry)vector.elementAt(i);
            hashMap.put(fwgEntry.host_name, fwgEntry.host_name);
        }
        return hashMap.keySet().toArray(new String[0]);
    }

    public SD_entry[] getSdList() {
        return this.getSdMap().values().toArray(new SD_entry[0]);
    }

    private HashMap<String, SD_entry> getSdMap() {
        HashMap<String, SD_entry> hashMap = new HashMap<String, SD_entry>(32);
        for (int i = 0; i < this.wgs_for_slave.size(); ++i) {
            WG_entry wG_entry = this.wgs_for_slave.get(i);
            hashMap.putAll(wG_entry.getRealSdMap());
        }
        return hashMap;
    }

    private HashMap<String, SD_entry> getSlaveSdMap(Slave slave) {
        HashMap<String, SD_entry> hashMap = new HashMap<String, SD_entry>(32);
        for (int i = 0; i < this.wgs_for_slave.size(); ++i) {
            WG_entry wG_entry = this.wgs_for_slave.get(i);
            if (!wG_entry.getSlave().getLabel().equals(slave.getLabel())) continue;
            hashMap.putAll(wG_entry.getRealSdMap());
        }
        return hashMap;
    }

    public static SD_entry[] getSdsForRun() {
        HashMap<String, SD_entry> hashMap = new HashMap<String, SD_entry>(32);
        for (int i = 0; i < SlaveList.getSlaveList().size(); ++i) {
            Slave slave = SlaveList.getSlaveList().elementAt(i);
            Work work = slave.getCurrentWork();
            if (work == null) continue;
            hashMap.putAll(work.getSlaveSdMap(slave));
        }
        SD_entry[] sD_entryArray = hashMap.values().toArray(new SD_entry[0]);
        return sD_entryArray;
    }

    public static SD_entry[] getHostSdsForRun(Host host) {
        HashMap<String, SD_entry> hashMap = new HashMap<String, SD_entry>(32);
        for (int i = 0; i < host.getSlaves().size(); ++i) {
            Slave slave = host.getSlaves().elementAt(i);
            Work work = slave.getCurrentWork();
            if (work == null) continue;
            hashMap.putAll(work.getSlaveSdMap(slave));
        }
        return hashMap.values().toArray(new SD_entry[0]);
    }

    public static String unix2Windows(Host host, String string) {
        String[] stringArray = MiscParms.unix2windows;
        if (host != null && !host.onWindows()) {
            return string;
        }
        if (stringArray == null) {
            return string;
        }
        if (!string.startsWith(stringArray[0])) {
            return string;
        }
        String string2 = common.replace_string(string, stringArray[0], stringArray[1]);
        return string2;
    }

    public int getThreadsForSlave(String string) {
        String string2 = string + "/" + SlaveJvm.getSlaveLabel();
        ArrayList<StreamContext> arrayList = this.threads_for_slave_map.get(string2);
        if (arrayList == null) {
            common.ptod("Requesting unknown thread count for '%s'", string2);
            return 0;
        }
        return arrayList.size();
    }

    public StreamContext getStreamForSlave(String string, int n) {
        String string2 = string + "/" + SlaveJvm.getSlaveLabel();
        ArrayList<StreamContext> arrayList = this.threads_for_slave_map.get(string2);
        if (arrayList == null) {
            common.failure("Requesting unknown thread count for '%'", string2);
        }
        return arrayList.get(n);
    }
}

