/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Utils.ClassPath;
import Utils.CopyFile;
import Utils.Fget;
import Utils.Fput;
import Utils.OS_cmd;
import Vdb.Adm_msgs;
import Vdb.Ctrl_c;
import Vdb.FileAnchor;
import Vdb.FileEntry;
import Vdb.Host;
import Vdb.Jmap;
import Vdb.Native;
import Vdb.Report;
import Vdb.SD_entry;
import Vdb.SlaveJvm;
import Vdb.SlaveList;
import Vdb.SocketMessage;
import Vdb.Status;
import Vdb.Vdbmain;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.StreamCorruptedException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.Vector;

public class common {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";
    static PrintWriter stdout;
    static PrintWriter log_html;
    static PrintWriter summ_html;
    static Object failure_lock;
    static Object ptod_lock;
    static PrintWriter common_pw;
    static boolean out_of_memory;
    static Object out_of_memory_lock;
    static long last_interval_tod;
    public static int NEVER_OPEN_FOR_WRITE;
    public static int PRINT_MEMORY;
    public static int NO_PRINT_FLUSH;
    public static int DEVXLATE;
    public static int PRINT_BLOCK_COUNTERS;
    public static int FIXED_SEED;
    public static int REUSE_IOSTAT;
    public static int PRINT_SIZES;
    public static int FAST_HEADERS;
    public static int TIMERS;
    public static int PRINT_OPEN_FLAGS;
    public static int PRINT_IO_COMP;
    public static int EXTERNAL_SYNCH;
    public static int NO_KSTAT;
    public static int NO_CONFIG_SCRIPT;
    public static int NO_CPU_STATS;
    public static int SPIN;
    public static int PTOD_TO_DISK;
    public static int PRINT_IN_MICROSECONDS;
    public static int IGNORE_MISSING_REPLAY;
    public static int LONGER_HEARTBEAT;
    public static int SHORTER_HEARTBEAT;
    public static int FILEENTRY_SET_BUSY;
    public static int DEBUG_COMPRESSION;
    public static int DIRECTORY_SET_BUSY;
    public static int DIRECTORY_CREATED;
    public static int REPORT_CREATES;
    public static int FAST_SYNCTIME;
    public static int FAST_BLOCK_KILL;
    public static int USE_FORMAT_RATE;
    public static int FORCE_REPLAY_SPLIT;
    public static int FORCE_KSTAT_ERROR;
    public static int SCSI_RESET_AT_START;
    public static int SCSI_RESET_ALL_START;
    public static int SOCKET_TRAFFIC;
    public static int SLAVE_LOG_ON_CONSOLE;
    public static int THREADCONTROL_LOG;
    public static int DUMP_THREAD_TRACE;
    public static int SHOW_REPORTS;
    public static int SHOW_SOCKET_MESSAGES;
    public static int SMALL_FILE_COUNT;
    public static int PRINT_FS_COUNTERS;
    public static int FAKE_LIBDEV;
    public static int CONCAT_ALLOW_WRITE;
    public static int NO_CONTROLFILE_DETAIL;
    public static int SEQUENTIAL_COUNTS;
    public static int RESTART_FILLING;
    public static int FORCE_SHUTDOWN;
    public static int LONG_SHUTDOWN;
    public static int ANCHOR_FIXED_SEED;
    public static int FIFO_STATS;
    public static int ALLOW_BLOCK0_ACCESS;
    public static int NO_BLOCK0_ACCESS;
    public static int cant_use_64;
    public static int HOLD_UP_STATISTICS;
    public static int DV_ALLOW_PATTERN;
    public static int SIMULATE;
    public static int ASSUME_FILE_EXISTS;
    public static int SKEW_ON_CONSOLE;
    public static int DETAIL_SLV_REPORT;
    public static int GENERATE_WORK_INFO;
    public static int USE_PSRSET;
    public static int USE_TVDBENCH;
    public static int USE_ANY_JAVA;
    public static int DEBUG_SPREAD;
    public static int NATIVE_SLEEP;
    public static int PRINT_SPREAD;
    public static int PTOD_WG_STUFF;
    public static int PLOG_WG_STUFF;
    public static int RUN_JMAP;
    public static int SHORT_FS_STDOUT;
    public static int TIMEBEGINPERIOD;
    public static int DEBUG_AUX_REPORT;
    public static int FILE_FORMAT_TRUNCATE;
    public static int WT_TASK_LIST_SORT;
    public static int REPORT_MESSAGE_SIZE;
    public static int GCTRACKER;
    public static int NO_ERROR_ABORT;
    public static int ALWAYS_ERASE_MAPS;
    public static int NO_MISSING_SUB_CHECK;
    public static int IGNORE_PARM_COMMENT;
    public static int USE_TMP_SHARED_LIBRARY;
    public static int OPREAD_SLEEP;
    public static int DONT_DUMP_MAPS;
    public static int NO_RESPONSE_TIMES;
    public static int CREATE_FILE_LIST;
    public static int FIXED_HOTBAND_SEED;
    public static int CREATE_READ_WRITE_LOG;
    public static int PRINT_WIDE_WHERE;
    public static int FAST_JOURNAL_CHECK;
    public static int JOURNAL_ADD_TIMESTAMP;
    public static int THREAD_MONITOR_ALL;
    public static int THREAD_MONITOR_TOP10;
    public static int THREAD_MONITOR_CONSOLE;
    public static int FAKE_RSH;
    public static int FAKE_TRACE_BEFORE;
    public static int FSYNC_AFTER_WRITE;
    public static int IGNORE_CHECKSUM;
    public static int BYPASS_FWGWAITER;
    public static int REPORT_FWG_PERMITS;
    public static int DV_PRINT_SECTOR_IMMED;
    public static int DONT_ZIP_SOCKET_MSGS;
    public static int PRINT_FILE_IO;
    private static String shared_library_dir;
    private static boolean arch_64_bit;
    private static boolean solaris;
    private static boolean windows;
    private static boolean zlinux;
    private static boolean aix;
    private static boolean hp;
    private static boolean linux;
    private static boolean mac;
    static byte[] spare_memory;
    private static Fput fp;
    private static boolean ignore_plog;
    private static DateFormat locked_df;
    private static boolean more_detail;
    private static String fatal_marker;

    public common() {
        Utils.common.ptod_lock = ptod_lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void failure(Exception exception) {
        Ctrl_c.removeShutdownHook();
        Object object = ptod_lock;
        synchronized (object) {
            Object object2 = failure_lock;
            synchronized (object2) {
                if (spare_memory != null) {
                    spare_memory = null;
                } else {
                    common.ptod("common.failure(): System.exit(-99)");
                    common.where(8);
                    common.exit(-99);
                }
                if (!SlaveJvm.isThisSlave()) {
                    SlaveList.sendWorkloadDone();
                    common.sleep_some(500L);
                    SlaveList.shutdownAllSlaves();
                    Status.printStatus("Abort requested: '%s'", exception.getMessage());
                }
                FileAnchor.closeAllLogs();
                SD_entry.closeAllLogs();
                OS_cmd.killAll();
                if (SlaveJvm.isThisSlave()) {
                    SlaveJvm.setWorkloadDone(true);
                }
                common.ptod("");
                common.ptod("common.failure(): \n\t\t" + exception);
                exception.printStackTrace();
                if (log_html != null) {
                    exception.printStackTrace(log_html);
                }
                if (SlaveJvm.isFirstSlaveOnHost()) {
                    Adm_msgs.copy_varadmmsgs();
                }
                if (SlaveJvm.isThisSlave()) {
                    SlaveJvm.sendMessageToMaster(SocketMessage.SLAVE_ABORTING, exception.getMessage());
                }
            }
            common.exit(-99);
        }
    }

    public static void failure(String string, Object ... objectArray) {
        common.failure(String.format(string, objectArray));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void failure(String string) {
        Ctrl_c.removeShutdownHook();
        Object object = ptod_lock;
        synchronized (object) {
            Object object2 = failure_lock;
            synchronized (object2) {
                Object object3;
                if (spare_memory != null) {
                    spare_memory = null;
                } else {
                    common.ptod("common.failure(): System.exit(-99)");
                    common.exit(-99);
                }
                if (!SlaveJvm.isThisSlave()) {
                    SlaveList.sendWorkloadDone();
                    common.sleep_some(500L);
                    SlaveList.shutdownAllSlaves();
                    Status.printStatus("Abort requested: %s", string);
                }
                OS_cmd.killAll();
                if (SlaveJvm.isThisSlave() && !string.equals(SlaveJvm.getMasterAbortMessage())) {
                    SlaveJvm.setWorkloadDone(true);
                }
                if (string.indexOf("\n") == -1) {
                    common.ptod("");
                    common.ptod(string);
                    common.ptod("");
                } else {
                    common.ptod("");
                    object3 = new StringTokenizer(string, "\n");
                    while (((StringTokenizer)object3).hasMoreTokens()) {
                        common.ptod(((StringTokenizer)object3).nextToken());
                    }
                    common.ptod("");
                }
                if (common.get_debug(DIRECTORY_CREATED)) {
                    FileAnchor.printAnchorStatus();
                }
                object3 = new RuntimeException(string);
                ((Throwable)object3).printStackTrace(SlaveJvm.isThisSlave() ? System.out : System.err);
                if (log_html != null && log_html != stdout) {
                    ((Throwable)object3).printStackTrace(log_html);
                }
                if (SlaveJvm.isFirstSlaveOnHost()) {
                    Adm_msgs.copy_varadmmsgs();
                }
                if (SlaveJvm.isThisSlave() && !string.equals(SlaveJvm.getMasterAbortMessage())) {
                    SlaveJvm.sendMessageToMaster(SocketMessage.SLAVE_ABORTING, string);
                }
                common.sleep_some(1000L);
            }
            common.exit(-99);
        }
    }

    public static void exit(int n) {
        Ctrl_c.removeShutdownHook();
        OS_cmd.killAll();
        FileAnchor.closeAllLogs();
        SD_entry.closeAllLogs();
        System.exit(n);
    }

    public static void sleep_some(long l) {
        if (l == 0L) {
            return;
        }
        common.sleep_some_usecs(l * 1000L);
    }

    public static void sleep_some_usecs(long l) {
        try {
            Thread.sleep(l / 1000L, (int)(l % 1000L) * 1000);
        }
        catch (InterruptedException interruptedException) {
            common.interruptThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ptod(String string, PrintWriter printWriter) {
        String string2 = common.tod();
        Object object = ptod_lock;
        synchronized (object) {
            common.ptodFileIfNeeded(string);
            if (printWriter != stdout || !Ctrl_c.active()) {
                if (string != null) {
                    printWriter.println(string2 + " " + string);
                } else {
                    printWriter.print(string2);
                }
            }
            if (SlaveJvm.isThisSlave() && printWriter == stdout) {
                return;
            }
            if (printWriter == stdout && log_html != null) {
                if (string != null) {
                    log_html.println(string2 + " " + string);
                } else {
                    log_html.print(string2);
                }
            }
        }
    }

    private static void ptodFileIfNeeded(String string) {
        if (!common.get_debug(PTOD_TO_DISK)) {
            return;
        }
        if (fp == null) {
            for (int i = 0; i < 999; ++i) {
                if (new File("ptoddebug" + i).exists()) continue;
                fp = new Fput("ptoddebug" + i);
                System.out.println("Created debug file: " + fp.getName());
                break;
            }
        }
        fp.println(common.tod() + " " + string);
        fp.flush();
    }

    public static synchronized void ptod(Exception exception) {
        common.ptod(exception.getClass().getName());
        if (log_html != null) {
            exception.printStackTrace(log_html);
        }
        exception.printStackTrace(System.out);
    }

    public static void ptod(String string, Object ... objectArray) {
        common.ptod(String.format(string, objectArray));
    }

    public static void pboth(String string, Object ... objectArray) {
        if (objectArray.length == 0) {
            common.psum(string);
            common.ptod(string);
        } else {
            common.psum(String.format(string, objectArray));
            common.ptod(String.format(string, objectArray));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ptod(String string) {
        Object object = ptod_lock;
        synchronized (object) {
            if (string.startsWith("+") && SlaveJvm.isThisSlave()) {
                if (!Thread.currentThread().isInterrupted()) {
                    SlaveJvm.sendMessageToConsole(string);
                    return;
                }
                string = "sendMessageToConsole() bypassed due to interrupt: " + string;
            }
            if (stdout == null) {
                if (common_pw == null) {
                    common_pw = new PrintWriter(System.out, true);
                }
                common.ptod(string, common_pw);
            } else {
                common.ptod(string, stdout);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ptod(ArrayList<String> arrayList) {
        Object object = ptod_lock;
        synchronized (object) {
            for (String string : arrayList) {
                common.ptod(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ptod(Vector<String> vector) {
        Object object = ptod_lock;
        synchronized (object) {
            for (String string : vector) {
                common.ptod(string);
            }
        }
    }

    public static void ptod(Object object) {
        common.ptod("" + object);
    }

    public static void plog(Object object) {
        common.plog("" + object);
    }

    public static void psum(String string, Object ... objectArray) {
        common.psum(String.format(string, objectArray));
    }

    public static void psum(String string) {
        if (summ_html != null) {
            common.ptod(string, summ_html);
        }
    }

    public static void plog(String string, Object ... objectArray) {
        common.plog(String.format(string, objectArray));
    }

    public static void plog(String string) {
        if (log_html != null) {
            common.ptod(string, log_html);
        } else if (!ignore_plog) {
            common.ptod("(plog) " + string);
        }
    }

    public static void ignoreIfNoPlog() {
        ignore_plog = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String tod() {
        DateFormat dateFormat = locked_df;
        synchronized (dateFormat) {
            String string = locked_df.format(new Date());
            if (more_detail) {
                long l = Native.get_simple_tod();
                long l2 = l % 86400000000L;
                long l3 = l2 / 3600000000L;
                long l4 = l2 / 60000000L % 60L;
                long l5 = l2 / 1000000L % 60L;
                long l6 = l2 % 1000000L;
                string = string + " " + String.format("%02d:%02d:%02d.%06d", l3, l4, l5, l6);
            }
            return string;
        }
    }

    public static void println(String string, PrintWriter printWriter) {
        printWriter.println(string);
        if (printWriter == stdout) {
            log_html.println(string);
        }
    }

    public static void print(String string, PrintWriter printWriter) {
        printWriter.print(string);
        if (printWriter == stdout) {
            log_html.print(string);
        }
    }

    public static boolean simple_wildcard(String string, String string2) {
        if (string.charAt(string.length() - 1) == '*') {
            String string3 = string.substring(0, string.length() - 1);
            if (string2.length() < string.length() - 1) {
                return false;
            }
            String string4 = string2.substring(0, string.length() - 1);
            return string3.compareTo(string4) == 0;
        }
        return string.compareTo(string2) == 0;
    }

    public static String remove_comma(String string) {
        if (string.indexOf(",") == -1) {
            return string;
        }
        return string.substring(0, string.indexOf(",")) + string.substring(string.indexOf(",") + 1);
    }

    public static long signal_caller(long l, long l2) {
        long l3 = Native.get_simple_tod();
        if (l == 0L) {
            return l3;
        }
        if (l + l2 * 1000L < l3) {
            return 0L;
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void abnormal_term(Throwable throwable) {
        String string = throwable.getClass().getName();
        Object object = out_of_memory_lock;
        synchronized (object) {
            if (out_of_memory) {
                return;
            }
            spare_memory = null;
            if (string.compareTo("java.lang.OutOfMemoryError") == 0) {
                common.displayOutOfMemory();
            }
            if (string.compareTo("java.lang.UnsatisfiedLinkError") == 0) {
                common.ptod("Missing or incorrect shared library file. \n\n");
            }
            if (log_html != null) {
                throwable.printStackTrace(log_html);
            }
            throwable.printStackTrace();
            common.failure("Abormal task completion");
        }
    }

    private static void displayOutOfMemory() {
        common.ptod("Out of memory: \n\n\t\t modify the vdbench script and increase the '-Xmx512m' value where 512m equals the java heap size requested. ");
        common.ptod("If the error message says 'unable to create new native thread' modify the vdbench script adding '-Xss256k' or lower value for the java thread stack size. \n\n");
        common.ptod("Examples are for Solaris. For other platforms see the Java provider's documentation");
        common.memory_usage();
        out_of_memory = true;
        if (common.get_debug(RUN_JMAP)) {
            spare_memory = null;
            common.runJmap();
        }
    }

    public static int getProcessId() {
        return Integer.parseInt(ManagementFactory.getRuntimeMXBean().getName().split("@")[0]);
    }

    public static String getProcessIdString() {
        return "" + common.getProcessId();
    }

    public static void runJmap() {
        String[] stringArray = new String[]{"xx", common.getProcessIdString()};
        Jmap.main(stringArray);
    }

    public static void memory_usage() {
        double d = (double)Runtime.getRuntime().freeMemory() / 1048576.0;
        double d2 = (double)Runtime.getRuntime().totalMemory() / 1048576.0;
        double d3 = (double)Runtime.getRuntime().maxMemory() / 1048576.0;
        double d4 = d2 - d;
        if (common.get_debug(PRINT_MEMORY)) {
            common.ptod("Java Heap in MB. max: %8.3f; current: %8.3f; used: %8.3f; free: %8.3f", d3, d2, d4, d);
        } else {
            common.plog("Java Heap in MB. max: %8.3f; current: %8.3f; used: %8.3f; free: %8.3f", d3, d2, d4, d);
        }
    }

    public static void set_debug(int n) {
        Utils.common.set_debug(n);
    }

    public static boolean get_debug(int n) {
        if (n == 0) {
            return true;
        }
        return Utils.common.get_debug(n);
    }

    public static String get_debug_string() {
        return Utils.common.get_debug_string();
    }

    static boolean onAix() {
        return aix;
    }

    static boolean onHp() {
        return hp;
    }

    public static boolean onLinux() {
        return linux;
    }

    public static boolean onZLinux() {
        return zlinux;
    }

    public static boolean onWindows() {
        return windows;
    }

    public static boolean onSolaris() {
        return solaris;
    }

    static boolean onMac() {
        return mac;
    }

    static boolean running64Bit() {
        common.get_shared_lib();
        return arch_64_bit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String get_shared_lib() {
        Object object;
        if (shared_library_dir != null) {
            return shared_library_dir;
        }
        String string = null;
        String string2 = System.getProperty("file.separator");
        String string3 = System.getProperty("sun.arch.data.model");
        String string4 = System.getProperty("os.arch");
        String string5 = ClassPath.classPath();
        String string6 = null;
        if (common.onWindows()) {
            if (string3.equals("64")) {
                if (Fget.file_exists(string5 + "windows", "vdbench64.dll")) {
                    string6 = "windows" + string2 + "vdbench64.dll";
                } else {
                    object = "\n\n";
                    object = (String)object + "Vdbench does not support 64-bit java on Windows.";
                    object = (String)object + "\n\tPlease install 32-bit java and change file vdbench.bat ";
                    object = (String)object + "\n\tto use that new 32-bit version.";
                    object = (String)object + "\n\n";
                    common.failure((String)object);
                }
            } else {
                string6 = "windows" + string2 + "vdbench32.dll";
            }
        } else if (common.onSolaris()) {
            if (string4.equals("amd64")) {
                string6 = "solx86" + string2 + "solx86-64.so";
                arch_64_bit = true;
            } else if (string4.equals("x86")) {
                string6 = "solx86" + string2 + "solx86-32.so";
            } else if (string4.equals("sparc")) {
                string6 = "solaris" + string2 + "sparc32.so";
            } else if (string4.equals("sparcv9")) {
                string6 = "solaris" + string2 + "sparc64.so";
                arch_64_bit = true;
            } else {
                common.failure("Unknown system architecture for solaris:  " + string4);
            }
        } else if (common.onAix()) {
            if (string3 != null && string3.equals("64")) {
                string6 = "aix" + string2 + "aix-64.so";
                arch_64_bit = true;
            } else if (string4.indexOf("64") != -1) {
                string6 = "aix" + string2 + "aix-64.so";
                arch_64_bit = true;
            } else {
                string6 = "aix" + string2 + "aix-32.so";
            }
        } else if (common.onMac()) {
            string6 = "mac" + string2 + "libvdbench.dylib";
        } else if (common.onHp()) {
            string6 = "hp" + string2 + "libvdbench.sl";
        } else if (common.onZLinux()) {
            if (string4.equals("s390")) {
                string6 = "linux" + string2 + "zlinux32.so";
            } else {
                string6 = "linux" + string2 + "zlinux64.so";
                arch_64_bit = true;
            }
        } else if (common.onLinux()) {
            if (string4.equals("sparcv9")) {
                string6 = "linux" + string2 + "sparc64.so";
                arch_64_bit = true;
            } else if (string4.equals("arm")) {
                string6 = "linux" + string2 + "arm32.so";
                arch_64_bit = false;
            } else if (string4.equals("aarch64")) {
                string6 = "linux" + string2 + "aarch64.so";
                arch_64_bit = true;
            } else if (string4.equals("sparc")) {
                string6 = "linux" + string2 + "sparc32.so";
            } else if (string4.startsWith("ppc64")) {
                string6 = "linux" + string2 + "ppc64.so";
                arch_64_bit = true;
            } else if (string4.equals("ppc32")) {
                string6 = "linux" + string2 + "ppc32.so";
            } else if (string4.indexOf("64") != -1) {
                string6 = "linux" + string2 + "linux64.so";
                arch_64_bit = true;
            } else if (string3 != null && string3.equalsIgnoreCase("64")) {
                string6 = "linux" + string2 + "linux64.so";
                arch_64_bit = true;
            } else {
                string6 = "linux" + string2 + "linux32.so";
            }
        } else {
            common.failure("Undefined support requested for platform: " + System.getProperty("os.arch") + "; contact me at the Oracle Vdbench Forum for support");
        }
        object = new File(string5 + string6);
        try {
            string = ((File)object).getCanonicalPath();
            shared_library_dir = ((File)object).getParent() + File.separator;
            if (common.get_debug(USE_TMP_SHARED_LIBRARY)) {
                String string7 = CopyFile.copyToTemp(string);
                System.load(string7);
            } else {
                System.load(string);
            }
        }
        catch (Throwable throwable) {
            Object object2 = ptod_lock;
            synchronized (object2) {
                if (!((File)object).exists()) {
                    common.ptod("");
                    common.ptod("File " + string + " does not exist.");
                    common.ptod("This may be an OS that a shared library currently ");
                    common.ptod("is not available for. You may have to do your own compile.");
                }
                common.ptod("t: " + throwable);
                common.ptod("");
                common.ptod("Loading of shared library " + string + " failed.");
                common.ptod("There may be issues related to a cpu type not being ");
                common.ptod("acceptable to Vdbench, e.g. MAC PPC vs. X86");
                common.ptod("Contact me at the Oracle Vdbench Forum for support.");
                common.ptod("");
                common.failure("Failure loading shared library");
            }
        }
        return shared_library_dir;
    }

    public static String replace_string(String string, String string2, String string3) {
        if (string.indexOf(string2) != -1) {
            String string4 = string.substring(0, string.indexOf(string2));
            String string5 = string.substring(string.indexOf(string2) + string2.length());
            return string4 + string3 + string5;
        }
        return string;
    }

    public static void run_config_scripts() {
        long l;
        Object object;
        if (Fget.file_exists(ClassPath.classPath("noconfig"))) {
            return;
        }
        if (common.get_debug(NO_CONFIG_SCRIPT)) {
            return;
        }
        long l2 = System.currentTimeMillis();
        PrintWriter printWriter = null;
        String string = common.onWindows() ? ".bat" : ".sh";
        String string2 = common.findscript("config" + string);
        String string3 = common.findscript("my_config" + string);
        if (string2 == null && string3 == null) {
            return;
        }
        printWriter = Report.createHmtlFile("config.html");
        Report.getSummaryReport().printHtmlLink("Link to config output", "config", "config");
        if (string2 != null) {
            object = new Native();
            String[] stringArray = new OS_cmd();
            stringArray.addText(string2);
            stringArray.addText("-o");
            stringArray.addText(Vdbmain.output_dir);
            for (String string4 : Host.getHostNames()) {
                stringArray.addText(string4);
            }
            stringArray.execute(false);
            printWriter.printf("Output from script %s: \n\n", string2);
            for (String string4 : stringArray.getStderr()) {
                printWriter.println("stderr: " + string4);
            }
            String[] stringArray2 = stringArray.getStdout();
            int n = stringArray2.length;
            for (int i = 0; i < n; ++i) {
                String string4;
                string4 = stringArray2[i];
                printWriter.println(string4);
            }
            printWriter.println();
        }
        if (string3 != null) {
            object = new OS_cmd();
            ((OS_cmd)object).addText(string3);
            ((OS_cmd)object).addText("-o");
            ((OS_cmd)object).addText(Vdbmain.output_dir);
            for (String string5 : Host.getHostNames()) {
                ((OS_cmd)object).addText(string5);
            }
            ((OS_cmd)object).execute(false);
            printWriter.printf("Output from script %s: \n\n", string3);
            for (String string6 : ((OS_cmd)object).getStderr()) {
                printWriter.println("stderr: " + string6);
            }
            for (String string7 : ((OS_cmd)object).getStdout()) {
                printWriter.println(string7);
            }
            printWriter.println();
        }
        if (printWriter != null) {
            printWriter.close();
        }
        if ((l = System.currentTimeMillis() - l2) > 5000L) {
            common.ptod("Running 'config.sh' took more than 5 seconds: " + l + "ms.");
        }
    }

    public static String findscript(String string) {
        String string2 = ClassPath.classPath();
        String string3 = new File(string2).getParentFile().getAbsolutePath();
        String string4 = string3 + File.separator + "vdbscripts";
        if (Fget.file_exists(string4, string)) {
            return new File(string4, string).getAbsolutePath();
        }
        String string5 = common.get_shared_lib();
        if (Fget.file_exists(string5, string)) {
            return new File(string5, string).getAbsolutePath();
        }
        return null;
    }

    public static String replace(String string, String string2, String string3) {
        while (string.indexOf(string2) != -1) {
            int n = string.indexOf(string2);
            string = string.substring(0, n) + string3 + string.substring(n + string2.length());
        }
        return string;
    }

    public static void serial_out(String string, Object object) {
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(string));
            objectOutputStream.writeObject(object);
            objectOutputStream.close();
        }
        catch (Exception exception) {
            common.failure(exception);
        }
    }

    public static Object serial_in(String string) {
        if (!Fget.file_exists(string)) {
            common.failure("unknown serial_in file: " + string);
        }
        Object object = null;
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(string));
            object = objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (StreamCorruptedException streamCorruptedException) {
            return null;
        }
        catch (Exception exception) {
            exception.printStackTrace(log_html);
            exception.printStackTrace();
            return null;
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doWhere(int n, String string) {
        Object object = ptod_lock;
        synchronized (object) {
            int n2 = 0;
            StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
            if (!common.get_debug(PRINT_WIDE_WHERE)) {
                if (string != null) {
                    common.ptod("==> where: " + string);
                }
                for (int i = 2; i < stackTraceElementArray.length && n2++ < n; ++i) {
                    String string2 = string == null && n2 == 1 ? "==> where: " : "           ";
                    string2 = string2 + stackTraceElementArray[i].toString();
                    common.ptod(string2);
                }
            } else {
                StringBuffer stringBuffer = new StringBuffer(1024);
                if (string != null) {
                    stringBuffer.append("==> where: " + string);
                }
                for (int i = 2; i < stackTraceElementArray.length && n2++ < n; ++i) {
                    if (string == null && n2 == 1) {
                        stringBuffer.append(" ==> where: ");
                    } else {
                        stringBuffer.append(" ");
                    }
                    stringBuffer.append(stackTraceElementArray[i].toString());
                }
                common.ptod(stringBuffer.toString());
            }
        }
    }

    public static void where(int n, String string) {
        common.doWhere(n, string);
    }

    public static void where() {
        common.doWhere(1, null);
    }

    public static void where(int n) {
        common.doWhere(n, null);
    }

    public static void where(String string) {
        common.doWhere(1, string);
    }

    public static void printStacktrace() {
        StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
        String string = "\n\t\tStack Trace: ";
        for (int i = 0; stackTraceElementArray != null && i < stackTraceElementArray.length; ++i) {
            string = string + "\n\t\t at " + stackTraceElementArray[i].toString();
        }
        common.ptod(string);
    }

    public static String getStacktrace() {
        StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
        String string = "\n\t\tStack Trace: ";
        for (int i = 0; stackTraceElementArray != null && i < stackTraceElementArray.length; ++i) {
            string = string + "\n\t\t at " + stackTraceElementArray[i].toString();
        }
        return string;
    }

    public static void main(String[] stringArray) {
        String string = common.findscript("config.sh");
        common.ptod("fname: " + string);
    }

    public static void main1(String[] stringArray) {
        int n = 255;
        int n2 = 7;
        int n3 = -1985229329;
        long l = common.make64(n2, n3);
        common.ptod("long_value: %016x", l);
        common.ptod("long_value: %016x", common.addKey(n, l));
        common.ptod("long_value: %016x", common.make64Key(n, n2, n3));
        l = common.make64Key(n, n2, n3);
        common.ptod("key: " + common.getKey(l));
        common.ptod("left32:  %08x ", common.left32(l));
        common.ptod("right32: %08x ", common.right32(l));
    }

    private static int left32(long l) {
        return (int)(l >>> 32);
    }

    private static int right32(long l) {
        return (int)l;
    }

    private static long make64Key(long l, int n, int n2) {
        return common.make64(n, n2) | l << 56;
    }

    private static long make64(int n, int n2) {
        long l = (long)n << 32;
        return l |= (long)n2 & 0xFFFFFFFFL;
    }

    public static int getKey(long l) {
        return (int)(l >> 56 & 0xFFL);
    }

    public static long addKey(long l, long l2) {
        return l << 56 | l2;
    }

    public static long toUnsignedLong(int n) {
        return (long)n & 0xFFFFFFFFL;
    }

    public static void main3(String[] stringArray) throws Exception {
        long l = 0x100000L;
        long l2 = 0x40000000L;
        long l3 = 0x10000000000L;
        long l4 = 4096L;
        long l5 = 100L * l / l4;
        long l6 = 10000L;
        long l7 = 0L;
        long l8 = l5 / l6;
        common.ptod("blocks:         " + l5);
        common.ptod("uniques_needed: " + l6);
        common.ptod("modulo:         " + l8);
        for (long i = 0L; i < l5; ++i) {
            if (i % l8 != 0L) continue;
            if (i < 20L) {
                common.ptod("block: " + i);
            }
            ++l7;
        }
        common.ptod("blocks:         " + l5);
        common.ptod("uniques_needed: " + l6);
        common.ptod("uniques_found:  " + l7);
    }

    public static void sizeof(String[] stringArray) throws Exception {
        int n = 1000000;
        if (stringArray.length > 0) {
            n = Integer.parseInt(stringArray[0]);
        }
        Object[] objectArray = new Object[n];
        System.gc();
        System.gc();
        double d = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        for (int i = 0; i < n; ++i) {
            objectArray[i] = new FileEntry();
        }
        System.gc();
        System.gc();
        double d2 = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        common.ptod("used_at_start: " + d / 1048576.0);
        common.ptod("used_at_end:   " + d2 / 1048576.0);
        common.ptod("used_at_end:   " + (d2 - d));
        common.ptod("estimated size per instance: " + (int)((d2 - d) / (double)n));
        long l = 0L;
        for (int i = 0; i < n; ++i) {
            l += (long)objectArray[i].hashCode();
        }
    }

    public static String getCurrentIP() {
        String string = null;
        try {
            string = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            try {
                common.ptod("Can not determine current network IP address: " + InetAddress.getLocalHost());
                common.ptod("Returning instead the host name: " + InetAddress.getLocalHost().getHostName());
                return InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException unknownHostException2) {
                common.where();
                common.failure(unknownHostException2);
            }
        }
        return string;
    }

    public static boolean isFatal(String string) {
        if (string == null) {
            return false;
        }
        return string.indexOf(fatal_marker) != -1;
    }

    public static void notifySlaves() {
        SlaveList.killSlaves();
        common.ptod("Debugging message: " + common.get_stacktrace());
        common.sleep_some(1000L);
    }

    public static String get_stacktrace() {
        StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
        String string = "\nStack Trace: ";
        for (int i = 0; stackTraceElementArray != null && i < stackTraceElementArray.length; ++i) {
            string = string + "\n at " + stackTraceElementArray[i].toString();
        }
        return string;
    }

    public static String get_stacktrace(Exception exception) {
        StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
        String string = "\nStack Trace: ";
        for (int i = 0; stackTraceElementArray != null && i < stackTraceElementArray.length; ++i) {
            string = string + "\n at " + stackTraceElementArray[i].toString();
        }
        return string;
    }

    public static void main2(String[] stringArray) throws Exception {
        OS_cmd oS_cmd = new OS_cmd();
        oS_cmd.addText("/usr/bin/ls -alF " + stringArray[0]);
        oS_cmd.execute();
        String[] stringArray2 = oS_cmd.getStdout();
        if (stringArray2.length != 1) {
            for (int i = 0; i < stringArray2.length; ++i) {
                common.ptod("stdout: " + stringArray2[i]);
            }
            common.ptod("Unexpected length from 'ls' command");
            return;
        }
        String string = stringArray2[0];
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (stringTokenizer.countTokens() != 11) {
            common.ptod("line: " + string);
            common.ptod("Unexpected contents from 'ls' command");
            return;
        }
        String string2 = string.substring(string.lastIndexOf(" ") + 1);
        common.ptod("device_name: " + string2);
        if (!string2.startsWith("../../devices")) {
            common.ptod("device_name: " + string2);
            common.ptod("Device name does not start with ../../devices");
            return;
        }
        string2 = string2.substring(13);
        common.ptod("device_name: " + string2);
        if (!string2.endsWith(":")) {
            common.ptod("device_name: " + string2);
            common.ptod("Device name does not end with ':'");
            return;
        }
        string2 = string2.substring(0, string2.length() - 1);
        common.ptod("device_name: " + string2);
        Vector vector = Fget.read_file_to_vector("/etc/path_to_inst");
        for (int i = 0; i < vector.size(); ++i) {
            string = (String)vector.elementAt(i);
            if (string.startsWith("#") || (stringTokenizer = new StringTokenizer(string)).countTokens() != 3) continue;
            String string3 = common.replace(stringTokenizer.nextToken(), "\"", "");
            String string4 = stringTokenizer.nextToken();
            String string5 = common.replace(stringTokenizer.nextToken(), "\"", "");
            if (!string2.equals(string3)) continue;
            common.ptod("path:   " + string3);
            common.ptod("number: " + string4);
            common.ptod("driver: " + string5);
        }
    }

    public static void dumpAllStacks() {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        common.ptod("tg: " + threadGroup);
        common.ptod("tg.get_name: " + threadGroup.getName());
        common.ptod("tg.activeCount: " + threadGroup.activeCount());
        threadGroup.list();
        Thread.currentThread();
        Thread[] threadArray = new Thread[Thread.activeCount() + 5];
        Thread.currentThread();
        int n = Thread.enumerate(threadArray);
        for (int i = 0; i < n; ++i) {
            common.ptod("tl            " + threadArray);
            common.ptod("tl[]:         " + threadArray[i]);
            common.ptod("tl[].isalive: " + threadArray[i].isAlive());
            common.ptod("Threadname:   " + threadArray[i].getName());
            common.dumpOneStack(threadArray[i]);
        }
    }

    public static void dumpOneStack(Thread thread) {
        StackTraceElement[] stackTraceElementArray = thread.getStackTrace();
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            common.ptod("dumpOneStack: " + stackTraceElementArray[i].getClassName() + " " + stackTraceElementArray[i].getLineNumber());
        }
    }

    public static long parseSize(String string) {
        if (string.startsWith("0x")) {
            return Long.parseLong(string.substring(2), 16);
        }
        String string2 = string;
        long l = 1L;
        if (string2.endsWith("k")) {
            l = 1024L;
        } else if (string2.endsWith("m")) {
            l = 0x100000L;
        } else if (string2.endsWith("g")) {
            l = 0x40000000L;
        } else if (string2.endsWith("t")) {
            l = 0x10000000000L;
        }
        if (l != 1L) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        try {
            return Long.parseLong(string2) * l;
        }
        catch (Exception exception) {
            common.ptod("Numeric value parsing; invalid value: %s", string);
            common.failure(exception);
            return 0L;
        }
    }

    public static String whatSize(double d) {
        return common.whatSizeX(d, 3);
    }

    public static String whatSizeX(double d, int n) {
        double d2 = 1024.0;
        double d3 = 1048576.0;
        double d4 = 1.073741824E9;
        double d5 = 1.099511627776E12;
        double d6 = 1.125899906842624E15;
        String string = String.format("%%.%df%%s", n);
        String string2 = ".000000000000000".substring(0, 1 + n);
        String string3 = d < 100000.0 ? "" + (int)d : (d < d3 ? String.format(string, d / d2, "k") : (d < d4 ? String.format(string, d / d3, "m") : (d < d5 ? String.format(string, d / d4, "g") : (d < d6 ? String.format(string, d / d5, "t") : String.format(string, d / d6, "p")))));
        return string3;
    }

    public static boolean isNumeric(String string) {
        try {
            long l = Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    public static boolean isDouble(String string) {
        try {
            double d = Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    public static void interruptThread() {
        common.interruptThread(Thread.currentThread());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void interruptThread(Thread thread) {
        Object object = ptod_lock;
        synchronized (object) {
            thread.interrupt();
        }
    }

    static {
        failure_lock = new Object();
        ptod_lock = new Object();
        common_pw = null;
        out_of_memory = false;
        out_of_memory_lock = new Object();
        last_interval_tod = 0L;
        NEVER_OPEN_FOR_WRITE = 1;
        PRINT_MEMORY = 3;
        NO_PRINT_FLUSH = 4;
        DEVXLATE = 6;
        PRINT_BLOCK_COUNTERS = 7;
        FIXED_SEED = 8;
        REUSE_IOSTAT = 9;
        PRINT_SIZES = 10;
        FAST_HEADERS = 11;
        TIMERS = 13;
        PRINT_OPEN_FLAGS = 14;
        PRINT_IO_COMP = 15;
        EXTERNAL_SYNCH = 16;
        NO_KSTAT = 17;
        NO_CONFIG_SCRIPT = 18;
        NO_CPU_STATS = 19;
        SPIN = 20;
        PTOD_TO_DISK = 21;
        PRINT_IN_MICROSECONDS = 23;
        IGNORE_MISSING_REPLAY = 24;
        LONGER_HEARTBEAT = 27;
        SHORTER_HEARTBEAT = 28;
        FILEENTRY_SET_BUSY = 29;
        DEBUG_COMPRESSION = 31;
        DIRECTORY_SET_BUSY = 32;
        DIRECTORY_CREATED = 33;
        REPORT_CREATES = 35;
        FAST_SYNCTIME = 36;
        FAST_BLOCK_KILL = 37;
        USE_FORMAT_RATE = 38;
        FORCE_REPLAY_SPLIT = 39;
        FORCE_KSTAT_ERROR = 40;
        SCSI_RESET_AT_START = 41;
        SCSI_RESET_ALL_START = 42;
        SOCKET_TRAFFIC = 43;
        SLAVE_LOG_ON_CONSOLE = 44;
        THREADCONTROL_LOG = 45;
        DUMP_THREAD_TRACE = 46;
        SHOW_REPORTS = 47;
        SHOW_SOCKET_MESSAGES = 48;
        SMALL_FILE_COUNT = 49;
        PRINT_FS_COUNTERS = 50;
        FAKE_LIBDEV = 51;
        CONCAT_ALLOW_WRITE = 52;
        NO_CONTROLFILE_DETAIL = 53;
        SEQUENTIAL_COUNTS = 54;
        RESTART_FILLING = 56;
        FORCE_SHUTDOWN = 57;
        LONG_SHUTDOWN = 58;
        ANCHOR_FIXED_SEED = 59;
        FIFO_STATS = 60;
        ALLOW_BLOCK0_ACCESS = 62;
        NO_BLOCK0_ACCESS = 63;
        cant_use_64 = 64;
        HOLD_UP_STATISTICS = 65;
        DV_ALLOW_PATTERN = 67;
        SIMULATE = 68;
        ASSUME_FILE_EXISTS = 69;
        SKEW_ON_CONSOLE = 70;
        DETAIL_SLV_REPORT = 71;
        GENERATE_WORK_INFO = 72;
        USE_PSRSET = 73;
        USE_TVDBENCH = 75;
        USE_ANY_JAVA = 76;
        DEBUG_SPREAD = 77;
        NATIVE_SLEEP = 78;
        PRINT_SPREAD = 79;
        PTOD_WG_STUFF = 80;
        PLOG_WG_STUFF = 81;
        RUN_JMAP = 82;
        SHORT_FS_STDOUT = 83;
        TIMEBEGINPERIOD = 84;
        DEBUG_AUX_REPORT = 85;
        FILE_FORMAT_TRUNCATE = 86;
        WT_TASK_LIST_SORT = 87;
        REPORT_MESSAGE_SIZE = 89;
        GCTRACKER = 90;
        NO_ERROR_ABORT = 96;
        ALWAYS_ERASE_MAPS = 97;
        NO_MISSING_SUB_CHECK = 98;
        IGNORE_PARM_COMMENT = 99;
        USE_TMP_SHARED_LIBRARY = 100;
        OPREAD_SLEEP = 101;
        DONT_DUMP_MAPS = 102;
        NO_RESPONSE_TIMES = 103;
        CREATE_FILE_LIST = 106;
        FIXED_HOTBAND_SEED = 107;
        CREATE_READ_WRITE_LOG = 108;
        PRINT_WIDE_WHERE = 109;
        FAST_JOURNAL_CHECK = 110;
        JOURNAL_ADD_TIMESTAMP = 111;
        THREAD_MONITOR_ALL = 120;
        THREAD_MONITOR_TOP10 = 121;
        THREAD_MONITOR_CONSOLE = 122;
        FAKE_RSH = 124;
        FAKE_TRACE_BEFORE = 125;
        FSYNC_AFTER_WRITE = 126;
        IGNORE_CHECKSUM = 127;
        BYPASS_FWGWAITER = 128;
        REPORT_FWG_PERMITS = 129;
        DV_PRINT_SECTOR_IMMED = 131;
        DONT_ZIP_SOCKET_MSGS = 132;
        PRINT_FILE_IO = 133;
        shared_library_dir = null;
        arch_64_bit = false;
        solaris = System.getProperty("os.name").toLowerCase().startsWith("sunos") || System.getProperty("os.name").toLowerCase().startsWith("solaris");
        windows = System.getProperty("os.name").toLowerCase().startsWith("windows");
        zlinux = System.getProperty("os.name").toLowerCase().startsWith("linux") && System.getProperty("os.arch").startsWith("s390");
        aix = System.getProperty("os.name").toLowerCase().startsWith("aix");
        hp = System.getProperty("os.name").toLowerCase().startsWith("hp-ux");
        linux = System.getProperty("os.name").toLowerCase().startsWith("linux") || System.getProperty("os.name").toLowerCase().startsWith("freebsd");
        mac = System.getProperty("os.name").toLowerCase().startsWith("mac");
        spare_memory = new byte[0x800000];
        fp = null;
        ignore_plog = false;
        locked_df = new SimpleDateFormat("HH:mm:ss.SSS");
        more_detail = false;
        fatal_marker = "*Fatal error*";
    }
}

